/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BezierCurve;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.instances.BlockRoad;
import minecrafttransportsimulator.blocks.tileentities.components.RoadLaneConnection;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketTileEntityRoadConnectionUpdate;

public class RoadLane {
    public final TileEntityRoad road;
    public final int sectorNumber;
    public final int sectorLaneNumber;
    public final int laneNumber;
    public final List<BezierCurve> curves;
    public final List<List<RoadLaneConnection>> priorConnections;
    public final List<List<RoadLaneConnection>> nextConnections;
    private static final double CURVE_CONNECTION_MAX_DISTANCE = 0.2;

    public RoadLane(TileEntityRoad road, int sectorNumber, int laneNumber, int sectorLaneNumber, IWrapperNBT data) {
        int i;
        this.road = road;
        this.sectorNumber = sectorNumber;
        this.sectorLaneNumber = sectorLaneNumber;
        this.laneNumber = laneNumber;
        this.curves = new ArrayList<BezierCurve>();
        this.generateCurves();
        this.priorConnections = new ArrayList<List<RoadLaneConnection>>();
        this.nextConnections = new ArrayList<List<RoadLaneConnection>>();
        for (i = 0; i < this.curves.size(); ++i) {
            this.priorConnections.add(new ArrayList());
            this.nextConnections.add(new ArrayList());
        }
        if (data != null) {
            for (i = 0; i < this.curves.size(); ++i) {
                IWrapperNBT connectionData;
                int j;
                int numberPriorConnections = data.getInteger("numberPriorConnections" + i);
                int numberNextConnections = data.getInteger("numberNextConnections" + i);
                for (j = 0; j < numberPriorConnections; ++j) {
                    connectionData = data.getData("priorConnection" + i + "_" + j);
                    this.priorConnections.get(i).add(new RoadLaneConnection(connectionData));
                }
                for (j = 0; j < numberNextConnections; ++j) {
                    connectionData = data.getData("nextConnection" + i + "_" + j);
                    this.nextConnections.get(i).add(new RoadLaneConnection(connectionData));
                }
            }
        }
    }

    private void generateCurves() {
        if (this.road.dynamicCurve != null) {
            BezierCurve dynamicCurve = this.road.dynamicCurve.generateOffsetCurve(new Point3D(((JSONRoadComponent)this.road.definition).road.laneOffsets[this.laneNumber], (double)((JSONRoadComponent)this.road.definition).road.collisionHeight / 16.0, 0.0));
            this.curves.add(dynamicCurve);
        } else {
            JSONRoadComponent.JSONLaneSector sector = ((JSONRoadComponent)this.road.definition).road.sectors.get(this.sectorNumber);
            JSONRoadComponent.JSONLaneSectorPointSet points = sector.lanes.get(this.sectorLaneNumber);
            for (JSONRoadComponent.JSONLaneSectorEndPoint endPoint : points.endPoints) {
                Point3D start = points.startPoint.copy().rotate(this.road.orientation).add(this.road.position);
                Point3D end = endPoint.pos.copy().rotate(this.road.orientation).add(this.road.position);
                RotationMatrix startRotation = new RotationMatrix().set(this.road.orientation).multiply(sector.sectorStartAngles);
                RotationMatrix endRotation = new RotationMatrix().set(this.road.orientation).multiply(endPoint.angles);
                this.curves.add(new BezierCurve(start, end, startRotation, endRotation));
            }
        }
    }

    public void generateConnections() {
        for (BezierCurve curve : this.curves) {
            this.checkAndAddConnections(curve, true);
            this.checkAndAddConnections(curve, false);
        }
    }

    private void checkAndAddConnections(BezierCurve curve, boolean checkingStart) {
        int curveNumber = this.curves.indexOf(curve);
        for (int j = -1; j >= -2; --j) {
            boolean foundRoadsThisCheck = false;
            Point3D offsetPoint = checkingStart ? new Point3D(0.0, 0.0, j).rotate(curve.startRotation).add(curve.startPos) : new Point3D(0.0, 0.0, j).rotate(curve.endRotation).add(curve.endPos);
            ABlockBase block = this.road.world.getBlock(offsetPoint);
            if (block instanceof BlockCollision || block instanceof BlockRoad) {
                TileEntityRoad otherRoad;
                TileEntityRoad tileEntityRoad = otherRoad = block instanceof BlockRoad ? (TileEntityRoad)this.road.world.getTileEntity(offsetPoint) : ((BlockCollision)block).getMasterRoad(this.road.world, offsetPoint);
                if (!otherRoad.equals(this.road)) {
                    foundRoadsThisCheck = true;
                    for (RoadLane otherRoadLane : otherRoad.lanes) {
                        for (BezierCurve otherRoadCurve : otherRoadLane.curves) {
                            RoadLaneConnection ourConnection;
                            boolean disableSameSideConnections;
                            int otherCurveNumber = otherRoadLane.curves.indexOf(otherRoadCurve);
                            boolean bl = disableSameSideConnections = ((JSONRoadComponent)this.road.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_STATIC) && ((JSONRoadComponent)otherRoad.definition).road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_STATIC);
                            if (checkingStart) {
                                if (!disableSameSideConnections && curve.startPos.isDistanceToCloserThan(otherRoadCurve.startPos, 0.2)) {
                                    this.priorConnections.get(curveNumber).add(new RoadLaneConnection(otherRoadLane, otherRoadCurve, true));
                                    ourConnection = new RoadLaneConnection(this, curve, true);
                                    otherRoadLane.priorConnections.get(otherCurveNumber).add(ourConnection);
                                    InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherRoadLane, otherCurveNumber, true, ourConnection));
                                    continue;
                                }
                                if (!curve.startPos.isDistanceToCloserThan(otherRoadCurve.endPos, 0.2)) continue;
                                this.priorConnections.get(curveNumber).add(new RoadLaneConnection(otherRoadLane, otherRoadCurve, false));
                                ourConnection = new RoadLaneConnection(this, curve, true);
                                otherRoadLane.nextConnections.get(otherCurveNumber).add(ourConnection);
                                InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherRoadLane, otherCurveNumber, false, ourConnection));
                                continue;
                            }
                            if (curve.endPos.isDistanceToCloserThan(otherRoadCurve.startPos, 0.2)) {
                                this.nextConnections.get(curveNumber).add(new RoadLaneConnection(otherRoadLane, otherRoadCurve, true));
                                ourConnection = new RoadLaneConnection(this, curve, false);
                                otherRoadLane.priorConnections.get(otherCurveNumber).add(ourConnection);
                                InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherRoadLane, otherCurveNumber, true, ourConnection));
                                continue;
                            }
                            if (disableSameSideConnections || !curve.endPos.isDistanceToCloserThan(otherRoadCurve.endPos, 0.2)) continue;
                            this.nextConnections.get(curveNumber).add(new RoadLaneConnection(otherRoadLane, otherRoadCurve, false));
                            ourConnection = new RoadLaneConnection(this, curve, false);
                            otherRoadLane.nextConnections.get(otherCurveNumber).add(ourConnection);
                            InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherRoadLane, otherCurveNumber, false, ourConnection));
                        }
                    }
                }
            }
            if (foundRoadsThisCheck) break;
        }
    }

    public void removeConnections() {
        RoadLane otherLane;
        TileEntityRoad otherRoad;
        for (List<RoadLaneConnection> curvePriorConnections : this.priorConnections) {
            for (RoadLaneConnection curvePriorConnection : curvePriorConnections) {
                try {
                    otherRoad = (TileEntityRoad)this.road.world.getTileEntity(curvePriorConnection.tileLocation);
                    otherLane = otherRoad.lanes.get(curvePriorConnection.laneNumber);
                    if (curvePriorConnection.connectedToStart) {
                        otherLane.priorConnections.get(curvePriorConnection.curveNumber).clear();
                        InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherLane, curvePriorConnection.curveNumber, true, null));
                        continue;
                    }
                    otherLane.nextConnections.get(curvePriorConnection.curveNumber).clear();
                    InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherLane, curvePriorConnection.curveNumber, false, null));
                }
                catch (Exception e) {
                    InterfaceManager.coreInterface.logError("Couldn't get TE at position " + curvePriorConnection.tileLocation + " to break prior road connection.  Was it changed?");
                }
            }
        }
        for (List<RoadLaneConnection> curveNextConnections : this.nextConnections) {
            for (RoadLaneConnection curveNextConnection : curveNextConnections) {
                try {
                    otherRoad = (TileEntityRoad)this.road.world.getTileEntity(curveNextConnection.tileLocation);
                    otherLane = otherRoad.lanes.get(curveNextConnection.laneNumber);
                    if (curveNextConnection.connectedToStart) {
                        otherLane.priorConnections.get(curveNextConnection.curveNumber).clear();
                        InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherLane, curveNextConnection.curveNumber, true, null));
                        continue;
                    }
                    otherLane.nextConnections.get(curveNextConnection.curveNumber).clear();
                    InterfaceManager.packetInterface.sendToAllClients(new PacketTileEntityRoadConnectionUpdate(otherLane, curveNextConnection.curveNumber, false, null));
                }
                catch (Exception e) {
                    InterfaceManager.coreInterface.logError("Couldn't get TE at position " + curveNextConnection.tileLocation + " to break next road connection.  Was it changed?");
                }
            }
        }
    }

    public RoadLaneConnection getConnection(BezierCurve curve, LaneSelectionRequest requestedNextCurve, boolean nextCurve) {
        List<RoadLaneConnection> connections;
        List<RoadLaneConnection> list = connections = nextCurve ? this.nextConnections.get(this.curves.indexOf(curve)) : this.priorConnections.get(this.curves.indexOf(curve));
        if (!connections.isEmpty()) {
            connections.sort((arg0, arg1) -> Double.compare(arg0.curveNetAngle, arg1.curveNetAngle));
            switch (requestedNextCurve) {
                case LEFT: {
                    return connections.get(connections.size() - 1);
                }
                case RIGHT: {
                    return connections.get(0);
                }
                case NONE: {
                    return connections.get(connections.size() / 2);
                }
            }
        }
        return null;
    }

    public IWrapperNBT getData() {
        IWrapperNBT data = InterfaceManager.coreInterface.getNewNBTWrapper();
        data.setInteger("sectorNumber", this.sectorNumber);
        data.setInteger("laneNumber", this.laneNumber);
        for (int i = 0; i < this.curves.size(); ++i) {
            IWrapperNBT connectionData;
            int j;
            List<RoadLaneConnection> priorCurveConnections = this.priorConnections.get(i);
            List<RoadLaneConnection> nextCurveConnections = this.nextConnections.get(i);
            for (j = 0; j < priorCurveConnections.size(); ++j) {
                connectionData = InterfaceManager.coreInterface.getNewNBTWrapper();
                priorCurveConnections.get(j).save(connectionData);
                data.setData("priorConnection" + i + "_" + j, connectionData);
            }
            data.setInteger("numberPriorConnections" + i, priorCurveConnections.size());
            for (j = 0; j < nextCurveConnections.size(); ++j) {
                connectionData = InterfaceManager.coreInterface.getNewNBTWrapper();
                nextCurveConnections.get(j).save(connectionData);
                data.setData("nextConnection" + i + "_" + j, connectionData);
            }
            data.setInteger("numberNextConnections" + i, nextCurveConnections.size());
        }
        return data;
    }

    public static enum LaneSelectionRequest {
        LEFT,
        RIGHT,
        NONE;

    }
}

