/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.components;

import java.util.Locale;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.ConfigSystem;

public abstract class ATileEntityPole_Component
extends AEntityD_Definable<JSONPoleComponent> {
    public final TileEntityPole core;
    public final ABlockBase.Axis axis;

    public ATileEntityPole_Component(TileEntityPole core, IWrapperPlayer placingPlayer, ABlockBase.Axis axis, ItemPoleComponent item, IWrapperNBT data) {
        super(core.world, placingPlayer, item, data);
        this.core = core;
        this.axis = axis;
    }

    @Override
    public AEntityA_Base.EntityAutoUpdateTime getUpdateTime() {
        return AEntityA_Base.EntityAutoUpdateTime.NEVER;
    }

    @Override
    public boolean shouldLinkBoundsToPosition() {
        return false;
    }

    @Override
    public boolean shouldRenderBeams() {
        return (Boolean)ConfigSystem.client.renderingSettings.blockBeams.value;
    }

    @Override
    public double getRawVariableValue(String variable, float partialTicks) {
        double value = super.getRawVariableValue(variable, partialTicks);
        if (!Double.isNaN(value)) {
            return value;
        }
        if (variable.startsWith("neighbor_present_")) {
            ABlockBase.Axis connectionAxis = ABlockBase.Axis.valueOf(variable.substring("neighbor_present_".length()).toUpperCase(Locale.ROOT));
            Object otherTile = this.world.getTileEntity(connectionAxis.getOffsetPoint(this.position));
            return otherTile instanceof TileEntityPole ? 1.0 : 0.0;
        }
        if (variable.startsWith("matching_present_")) {
            ABlockBase.Axis connectionAxis = ABlockBase.Axis.valueOf(variable.substring("matching_present_".length()).toUpperCase(Locale.ROOT));
            Object otherTile = this.world.getTileEntity(connectionAxis.getOffsetPoint(this.position));
            return otherTile != null && ((JSONPoleComponent)this.core.definition).systemName.equals(((ATileEntityBase)otherTile).definition.systemName) ? 1.0 : 0.0;
        }
        if (variable.startsWith("solid_present_")) {
            ABlockBase.Axis connectionAxis = ABlockBase.Axis.valueOf(variable.substring("solid_present_".length()).toUpperCase(Locale.ROOT));
            return this.world.isBlockSolid(connectionAxis.getOffsetPoint(this.position), connectionAxis.getOpposite()) ? 1.0 : 0.0;
        }
        switch (variable) {
            case "slab_present_up": {
                return this.world.isBlockAboveTopSlab(this.position) ? 1.0 : 0.0;
            }
            case "slab_present_down": {
                return this.world.isBlockBelowBottomSlab(this.position) ? 1.0 : 0.0;
            }
        }
        return Double.NaN;
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        if (this.axis.equals((Object)ABlockBase.Axis.NONE)) {
            this.core.renderBoundingBoxes(transform);
        }
    }
}

