/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.baseclasses.VehicleGroundDeviceBox;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.systems.ConfigSystem;

public class VehicleGroundDeviceCollection {
    private final EntityVehicleF_Physics vehicle;
    private final VehicleGroundDeviceBox frontLeftGDB;
    private final VehicleGroundDeviceBox frontRightGDB;
    private final VehicleGroundDeviceBox rearLeftGDB;
    private final VehicleGroundDeviceBox rearRightGDB;
    private final Point3D hookupRelativePosition = new Point3D();
    private final Point3D translationApplied = new Point3D();
    private final RotationMatrix rotationApplied = new RotationMatrix();
    private final TransformationMatrix transformApplied = new TransformationMatrix();
    public final Set<PartGroundDevice> groundedGroundDevices = new HashSet<PartGroundDevice>();

    public VehicleGroundDeviceCollection(EntityVehicleF_Physics vehicle) {
        this.vehicle = vehicle;
        this.frontLeftGDB = new VehicleGroundDeviceBox(vehicle, true, true);
        this.frontRightGDB = new VehicleGroundDeviceBox(vehicle, true, false);
        this.rearLeftGDB = new VehicleGroundDeviceBox(vehicle, false, true);
        this.rearRightGDB = new VehicleGroundDeviceBox(vehicle, false, false);
    }

    public void updateMembers() {
        this.frontLeftGDB.updateMembers();
        this.frontRightGDB.updateMembers();
        this.rearLeftGDB.updateMembers();
        this.rearRightGDB.updateMembers();
    }

    public void updateBounds() {
        this.frontLeftGDB.updateBounds();
        this.frontRightGDB.updateBounds();
        this.rearLeftGDB.updateBounds();
        this.rearRightGDB.updateBounds();
    }

    public void updateCollisions(boolean updateGroundDeviceTreadPosition) {
        this.groundedGroundDevices.clear();
        this.frontLeftGDB.updateCollisionStatuses(this.groundedGroundDevices, updateGroundDeviceTreadPosition);
        this.frontRightGDB.updateCollisionStatuses(this.groundedGroundDevices, updateGroundDeviceTreadPosition);
        this.rearLeftGDB.updateCollisionStatuses(this.groundedGroundDevices, updateGroundDeviceTreadPosition);
        this.rearRightGDB.updateCollisionStatuses(this.groundedGroundDevices, updateGroundDeviceTreadPosition);
    }

    public double getMaxCollisionDepth() {
        double maxDepth = 0.0;
        if (!this.frontLeftGDB.isBlockedVertically && this.frontLeftGDB.collisionDepth > maxDepth) {
            maxDepth = this.frontLeftGDB.collisionDepth;
        }
        if (!this.frontRightGDB.isBlockedVertically && this.frontRightGDB.collisionDepth > maxDepth) {
            maxDepth = this.frontRightGDB.collisionDepth;
        }
        if (!this.rearLeftGDB.isBlockedVertically && this.rearLeftGDB.collisionDepth > maxDepth) {
            maxDepth = this.rearLeftGDB.collisionDepth;
        }
        if (!this.rearRightGDB.isBlockedVertically && this.rearRightGDB.collisionDepth > maxDepth) {
            maxDepth = this.rearRightGDB.collisionDepth;
        }
        return maxDepth;
    }

    public int getNumberBoxesInLiquid() {
        int count = 0;
        if (this.frontLeftGDB.isUsingLiquidBoxes && (this.frontLeftGDB.isCollided || this.frontLeftGDB.isGrounded)) {
            ++count;
        }
        if (this.frontRightGDB.isUsingLiquidBoxes && (this.frontRightGDB.isCollided || this.frontRightGDB.isGrounded)) {
            ++count;
        }
        if (this.rearLeftGDB.isUsingLiquidBoxes && (this.rearLeftGDB.isCollided || this.rearLeftGDB.isGrounded)) {
            ++count;
        }
        if (this.rearRightGDB.isUsingLiquidBoxes && (this.rearRightGDB.isCollided || this.rearRightGDB.isGrounded)) {
            ++count;
        }
        return count;
    }

    public double getTurningWheelbase() {
        double furthestFrontPoint = 0.0;
        double furthestRearPoint = 0.0;
        double turningDistance = 0.0;
        boolean foundTurningDevice = false;
        for (PartGroundDevice groundDevice : this.groundedGroundDevices) {
            if (groundDevice.wheelbasePoint.z > furthestFrontPoint) {
                furthestFrontPoint = groundDevice.wheelbasePoint.z;
            }
            if (groundDevice.wheelbasePoint.z < furthestRearPoint) {
                furthestRearPoint = groundDevice.wheelbasePoint.z;
            }
            if (!groundDevice.placementDefinition.turnsWithSteer) continue;
            foundTurningDevice = true;
        }
        turningDistance = furthestFrontPoint - furthestRearPoint;
        if (turningDistance == 0.0) {
            for (APart part : this.vehicle.allParts) {
                if (part instanceof PartPropeller) {
                    if (!part.isInLiquid()) continue;
                    foundTurningDevice = true;
                    continue;
                }
                if (!(part instanceof PartGroundDevice)) continue;
                PartGroundDevice groundDevice = (PartGroundDevice)part;
                if (groundDevice.wheelbasePoint.z > furthestFrontPoint) {
                    furthestFrontPoint = groundDevice.wheelbasePoint.z;
                }
                if (!(groundDevice.wheelbasePoint.z < furthestRearPoint)) continue;
                furthestRearPoint = groundDevice.wheelbasePoint.z;
            }
        }
        return foundTurningDevice ? furthestFrontPoint - furthestRearPoint : 0.0;
    }

    public List<BoundingBox> getGroundBounds() {
        ArrayList<BoundingBox> groundBoxes = new ArrayList<BoundingBox>();
        groundBoxes.add(this.frontLeftGDB.getBoundingBox());
        groundBoxes.add(this.frontRightGDB.getBoundingBox());
        groundBoxes.add(this.rearLeftGDB.getBoundingBox());
        groundBoxes.add(this.rearRightGDB.getBoundingBox());
        return groundBoxes;
    }

    public Point3D getContactPoint(boolean front) {
        if (front) {
            if (this.frontLeftGDB.contactPoint.isZero()) {
                if (this.frontRightGDB.contactPoint.isZero()) {
                    return null;
                }
                return this.frontRightGDB.contactPoint.copy();
            }
            if (this.frontRightGDB.contactPoint.isZero()) {
                return this.frontLeftGDB.contactPoint.copy();
            }
            return this.frontRightGDB.contactPoint.copy().subtract(this.frontLeftGDB.contactPoint).scale(0.5).add(this.frontLeftGDB.contactPoint);
        }
        if (this.rearLeftGDB.contactPoint.isZero()) {
            if (this.rearRightGDB.contactPoint.isZero()) {
                return null;
            }
            return this.rearRightGDB.contactPoint.copy().add(PartGroundDevice.groundDetectionOffset);
        }
        if (this.rearRightGDB.contactPoint.isZero()) {
            return this.rearLeftGDB.contactPoint.copy();
        }
        return this.rearRightGDB.contactPoint.copy().subtract(this.rearLeftGDB.contactPoint).scale(0.5).add(this.rearLeftGDB.contactPoint);
    }

    public boolean isReady() {
        boolean haveLeftPoint = false;
        boolean haveRightPoint = false;
        boolean haveCenterPoint = false;
        boolean haveFrontPoint = false;
        boolean haveRearPoint = false;
        if (this.frontLeftGDB.isReady()) {
            haveLeftPoint = true;
            haveFrontPoint = true;
            boolean bl = haveCenterPoint = this.frontLeftGDB.contactPoint.x == 0.0;
        }
        if (this.frontRightGDB.isReady()) {
            haveRightPoint = true;
            haveFrontPoint = true;
            if (!haveCenterPoint) {
                boolean bl = haveCenterPoint = this.frontRightGDB.contactPoint.x == 0.0;
            }
        }
        if (this.rearLeftGDB.isReady()) {
            haveLeftPoint = true;
            haveRearPoint = true;
            if (!haveCenterPoint) {
                boolean bl = haveCenterPoint = this.rearLeftGDB.contactPoint.x == 0.0;
            }
        }
        if (this.rearRightGDB.isReady()) {
            haveRightPoint = true;
            haveRearPoint = true;
            if (!haveCenterPoint) {
                haveCenterPoint = this.rearRightGDB.contactPoint.x == 0.0;
            }
        }
        return haveLeftPoint && haveRightPoint || haveFrontPoint && haveRearPoint && haveCenterPoint;
    }

    public boolean isBlockedVertically() {
        return this.frontLeftGDB.isBlockedVertically || this.frontRightGDB.isBlockedVertically || this.rearLeftGDB.isBlockedVertically || this.rearRightGDB.isBlockedVertically;
    }

    public boolean isAnythingOnGround() {
        return !this.frontLeftGDB.isGrounded && !this.frontRightGDB.isGrounded && !this.rearLeftGDB.isGrounded && !this.rearRightGDB.isGrounded;
    }

    public boolean isActuallyOnGround(PartGroundDevice groundDevice) {
        if (this.frontLeftGDB.isPartofBox(groundDevice)) {
            return this.frontLeftGDB.isGrounded;
        }
        if (this.frontRightGDB.isPartofBox(groundDevice)) {
            return this.frontRightGDB.isGrounded;
        }
        if (this.rearLeftGDB.isPartofBox(groundDevice)) {
            return this.rearLeftGDB.isGrounded;
        }
        if (this.rearRightGDB.isPartofBox(groundDevice)) {
            return this.rearRightGDB.isGrounded;
        }
        return false;
    }

    public boolean canDoRollChecks() {
        double xAxisPoint = 0.0;
        if (this.frontLeftGDB != null) {
            xAxisPoint = this.frontLeftGDB.contactPoint.x;
        }
        if (this.frontRightGDB != null && xAxisPoint == 0.0) {
            xAxisPoint = this.frontRightGDB.contactPoint.x;
        }
        if (this.rearLeftGDB != null && xAxisPoint == 0.0) {
            xAxisPoint = this.rearLeftGDB.contactPoint.x;
        }
        if (this.rearRightGDB != null && xAxisPoint == 0.0) {
            xAxisPoint = this.rearRightGDB.contactPoint.x;
        }
        return xAxisPoint != 0.0;
    }

    public void performPitchCorrection(Point3D groundMotion) {
        if (this.vehicle.towedByConnection == null) {
            if (this.rearLeftGDB.isAirborne && this.rearLeftGDB.isReady() && this.rearRightGDB.isAirborne && this.rearRightGDB.isReady()) {
                if (!this.frontLeftGDB.isAirborne) {
                    if (!this.frontRightGDB.isAirborne) {
                        this.adjustAnglesMatrix(this.frontLeftGDB.contactPoint.z > this.frontRightGDB.contactPoint.z ? this.frontLeftGDB.contactPoint : this.frontRightGDB.contactPoint, this.rearLeftGDB, this.rearRightGDB, false, true, true, groundMotion);
                    } else {
                        this.adjustAnglesMatrix(this.frontLeftGDB.contactPoint, this.rearLeftGDB, this.rearRightGDB, false, true, true, groundMotion);
                    }
                    return;
                }
                if (!this.frontRightGDB.isAirborne) {
                    this.adjustAnglesMatrix(this.frontRightGDB.contactPoint, this.rearLeftGDB, this.rearRightGDB, false, true, true, groundMotion);
                    return;
                }
            }
            if (this.frontLeftGDB.isAirborne && this.frontLeftGDB.isReady() && this.frontRightGDB.isAirborne && this.frontRightGDB.isReady()) {
                if (!this.rearLeftGDB.isAirborne) {
                    if (!this.rearRightGDB.isAirborne) {
                        this.adjustAnglesMatrix(this.rearLeftGDB.contactPoint.z < this.rearRightGDB.contactPoint.z ? this.rearLeftGDB.contactPoint : this.rearRightGDB.contactPoint, this.frontLeftGDB, this.frontRightGDB, true, true, true, groundMotion);
                    } else {
                        this.adjustAnglesMatrix(this.rearLeftGDB.contactPoint, this.frontLeftGDB, this.frontRightGDB, true, true, true, groundMotion);
                    }
                    return;
                }
                if (!this.rearRightGDB.isAirborne) {
                    this.adjustAnglesMatrix(this.rearRightGDB.contactPoint, this.frontLeftGDB, this.frontRightGDB, true, true, true, groundMotion);
                    return;
                }
            }
            if ((this.frontLeftGDB.isCollided || this.frontRightGDB.isCollided) && (!this.vehicle.world.isClient() || this.frontLeftGDB.collisionDepth > 0.1 || this.frontRightGDB.collisionDepth > 0.1) && this.rearLeftGDB.isGrounded && !this.rearLeftGDB.isCollided && this.rearRightGDB.isGrounded && !this.rearRightGDB.isCollided) {
                this.adjustAnglesMatrix(this.rearLeftGDB.contactPoint.z < this.rearRightGDB.contactPoint.z ? this.rearLeftGDB.contactPoint : this.rearRightGDB.contactPoint, this.frontLeftGDB, this.frontRightGDB, false, true, true, groundMotion);
                return;
            }
            if ((this.rearLeftGDB.isCollided || this.rearRightGDB.isCollided) && (!this.vehicle.world.isClient() || this.rearLeftGDB.collisionDepth > 0.1) && this.frontLeftGDB.isGrounded && !this.frontLeftGDB.isCollided && this.frontRightGDB.isGrounded && !this.frontRightGDB.isCollided) {
                this.adjustAnglesMatrix(this.frontLeftGDB.contactPoint.z > this.frontRightGDB.contactPoint.z ? this.frontLeftGDB.contactPoint : this.frontRightGDB.contactPoint, this.rearLeftGDB, this.rearRightGDB, true, true, true, groundMotion);
            }
        } else {
            this.hookupRelativePosition.set(this.vehicle.towedByConnection.hookupCurrentPosition).subtract(this.vehicle.position).reOrigin(this.vehicle.orientation);
            if (this.hookupRelativePosition.z > 0.0) {
                if (!(!this.rearLeftGDB.isAirborne && this.rearLeftGDB.isReady() || !this.rearRightGDB.isAirborne && this.rearRightGDB.isReady() || !this.rearLeftGDB.isAirborne && this.rearLeftGDB.isReady() || !this.rearRightGDB.isAirborne && this.rearRightGDB.isReady())) {
                    if (this.rearLeftGDB.isReady() && this.rearRightGDB.isReady()) {
                        this.adjustAnglesMatrix(this.hookupRelativePosition, this.rearLeftGDB, this.rearRightGDB, false, true, true, groundMotion);
                    } else if (this.frontLeftGDB.isReady() && this.frontRightGDB.isReady()) {
                        this.adjustAnglesMatrix(this.hookupRelativePosition, this.frontLeftGDB, this.frontRightGDB, false, true, true, groundMotion);
                    }
                } else if ((this.rearLeftGDB.isCollided || this.rearRightGDB.isCollided) && this.rearLeftGDB.isReady() && this.rearRightGDB.isReady()) {
                    this.adjustAnglesMatrix(this.hookupRelativePosition, this.rearLeftGDB, this.rearRightGDB, true, true, false, groundMotion);
                } else if ((this.frontLeftGDB.isCollided || this.frontRightGDB.isCollided) && this.frontLeftGDB.isReady() && this.frontRightGDB.isReady()) {
                    this.adjustAnglesMatrix(this.hookupRelativePosition, this.frontLeftGDB, this.frontRightGDB, true, true, false, groundMotion);
                }
            } else if (!(!this.rearLeftGDB.isAirborne && this.rearLeftGDB.isReady() || !this.rearRightGDB.isAirborne && this.rearRightGDB.isReady() || !this.rearLeftGDB.isAirborne && this.rearLeftGDB.isReady() || !this.rearRightGDB.isAirborne && this.rearRightGDB.isReady())) {
                if (this.frontLeftGDB.isReady() && this.frontRightGDB.isReady()) {
                    this.adjustAnglesMatrix(this.hookupRelativePosition, this.frontLeftGDB, this.frontRightGDB, true, true, true, groundMotion);
                } else if (this.rearLeftGDB.isReady() && this.rearRightGDB.isReady()) {
                    this.adjustAnglesMatrix(this.hookupRelativePosition, this.rearLeftGDB, this.rearRightGDB, true, true, true, groundMotion);
                }
            } else if ((this.frontLeftGDB.isCollided || this.frontRightGDB.isCollided) && this.frontLeftGDB.isReady() && this.frontRightGDB.isReady()) {
                this.adjustAnglesMatrix(this.hookupRelativePosition, this.frontLeftGDB, this.frontRightGDB, false, true, false, groundMotion);
            } else if ((this.rearLeftGDB.isCollided || this.rearRightGDB.isCollided) && this.rearLeftGDB.isReady() && this.rearRightGDB.isReady()) {
                this.adjustAnglesMatrix(this.hookupRelativePosition, this.rearLeftGDB, this.rearRightGDB, false, true, false, groundMotion);
            }
        }
    }

    public void performRollCorrection(Point3D groundMotion) {
        if (!this.frontLeftGDB.isCollided && !this.frontLeftGDB.isGrounded && this.frontLeftGDB.isReady() && !this.rearLeftGDB.isCollided && !this.rearLeftGDB.isGrounded && this.rearLeftGDB.isReady()) {
            if (this.frontRightGDB.isCollided || this.frontRightGDB.isGrounded) {
                if (this.rearRightGDB.isCollided || this.rearRightGDB.isGrounded) {
                    this.adjustAnglesMatrix(this.frontRightGDB.contactPoint.x < this.rearRightGDB.contactPoint.x ? this.frontRightGDB.contactPoint : this.rearRightGDB.contactPoint, this.frontLeftGDB, this.rearLeftGDB, false, false, true, groundMotion);
                } else {
                    this.adjustAnglesMatrix(this.frontRightGDB.contactPoint, this.frontLeftGDB, this.rearLeftGDB, false, false, true, groundMotion);
                }
            } else if (this.rearRightGDB.isCollided || this.rearRightGDB.isGrounded) {
                this.adjustAnglesMatrix(this.rearRightGDB.contactPoint, this.frontLeftGDB, this.rearLeftGDB, false, false, true, groundMotion);
            }
        }
        if (!this.frontRightGDB.isCollided && !this.frontRightGDB.isGrounded && this.frontRightGDB.isReady() && !this.rearRightGDB.isCollided && !this.rearRightGDB.isGrounded && this.rearRightGDB.isReady()) {
            if (this.frontLeftGDB.isCollided || this.frontLeftGDB.isGrounded) {
                if (this.rearLeftGDB.isCollided || this.rearLeftGDB.isGrounded) {
                    this.adjustAnglesMatrix(this.frontLeftGDB.contactPoint.x < this.rearLeftGDB.contactPoint.x ? this.frontLeftGDB.contactPoint : this.rearLeftGDB.contactPoint, this.frontRightGDB, this.rearRightGDB, true, false, true, groundMotion);
                } else {
                    this.adjustAnglesMatrix(this.frontLeftGDB.contactPoint, this.frontRightGDB, this.rearRightGDB, true, false, true, groundMotion);
                }
            } else if (this.rearLeftGDB.isCollided || this.rearLeftGDB.isGrounded) {
                this.adjustAnglesMatrix(this.rearLeftGDB.contactPoint, this.frontRightGDB, this.rearRightGDB, true, false, true, groundMotion);
            }
        }
        if (this.frontLeftGDB.contactPoint.x == 0.0 && this.frontRightGDB.contactPoint.x == 0.0 && this.rearLeftGDB.isReady() && this.rearRightGDB.isReady()) {
            if (!this.rearLeftGDB.isCollided && !this.rearLeftGDB.isGrounded && (this.rearRightGDB.isCollided || this.rearRightGDB.isGrounded)) {
                this.adjustAnglesMatrix(this.rearRightGDB.contactPoint, this.rearLeftGDB, this.rearLeftGDB, false, false, true, groundMotion);
            } else if (!this.rearRightGDB.isCollided && !this.rearRightGDB.isGrounded && (this.rearLeftGDB.isCollided || this.rearLeftGDB.isGrounded)) {
                this.adjustAnglesMatrix(this.rearLeftGDB.contactPoint, this.rearRightGDB, this.rearRightGDB, true, false, true, groundMotion);
            }
        } else if (this.rearLeftGDB.contactPoint.x == 0.0 && this.rearRightGDB.contactPoint.x == 0.0 && this.frontLeftGDB.isReady() && this.frontRightGDB.isReady()) {
            if (!this.frontLeftGDB.isCollided && !this.frontLeftGDB.isGrounded && (this.frontRightGDB.isCollided || this.frontRightGDB.isGrounded)) {
                this.adjustAnglesMatrix(this.frontRightGDB.contactPoint, this.frontLeftGDB, this.frontLeftGDB, false, false, true, groundMotion);
            } else if (!this.frontRightGDB.isCollided && !this.frontRightGDB.isGrounded && (this.frontLeftGDB.isCollided || this.frontLeftGDB.isGrounded)) {
                this.adjustAnglesMatrix(this.frontLeftGDB.contactPoint, this.frontRightGDB, this.frontRightGDB, true, false, true, groundMotion);
            }
        }
    }

    private void adjustAnglesMatrix(Point3D originPoint, VehicleGroundDeviceBox testBox1, VehicleGroundDeviceBox testBox2, boolean clockwiseRotation, boolean pitch, boolean checkCollisions, Point3D groundMotion) {
        double heightDeltaAttempted;
        double box2Delta;
        double box1Delta;
        if (pitch) {
            box1Delta = Math.hypot(originPoint.z - testBox1.contactPoint.z, originPoint.y - testBox1.contactPoint.y);
            box2Delta = Math.hypot(originPoint.z - testBox2.contactPoint.z, originPoint.y - testBox2.contactPoint.y);
        } else {
            box1Delta = Math.hypot(originPoint.x - testBox1.contactPoint.x, originPoint.y - testBox1.contactPoint.y);
            box2Delta = Math.hypot(originPoint.x - testBox2.contactPoint.x, originPoint.y - testBox2.contactPoint.y);
        }
        double furthestDelta = Math.max(box1Delta, box2Delta);
        if (furthestDelta < (Double)ConfigSystem.settings.general.climbSpeed.value) {
            return;
        }
        double angleApplied = 0.0;
        for (heightDeltaAttempted = ((Double)ConfigSystem.settings.general.climbSpeed.value).doubleValue(); heightDeltaAttempted > PartGroundDevice.groundDetectionOffset.y; heightDeltaAttempted -= (Double)ConfigSystem.settings.general.climbSpeed.value / 4.0) {
            angleApplied = Math.toDegrees(Math.asin(heightDeltaAttempted / furthestDelta));
            if (!clockwiseRotation) {
                angleApplied = -angleApplied;
            }
            this.transformApplied.resetTransforms();
            this.transformApplied.setTranslation(originPoint);
            if (pitch) {
                this.rotationApplied.setToZero().rotateX(angleApplied);
            } else {
                this.rotationApplied.setToZero().rotateZ(angleApplied);
            }
            this.transformApplied.multiply(this.rotationApplied);
            this.transformApplied.applyInvertedTranslation(originPoint);
            if (!checkCollisions || testBox1.collidedWithTransform(this.transformApplied, groundMotion) && testBox2.collidedWithTransform(this.transformApplied, groundMotion)) break;
        }
        if (heightDeltaAttempted != 0.0) {
            if (pitch) {
                this.vehicle.rotation.angles.x += angleApplied;
            } else {
                this.vehicle.rotation.angles.z += angleApplied;
            }
            this.translationApplied.set(0.0, 0.0, 0.0).transform(this.transformApplied).rotate(this.vehicle.orientation);
            groundMotion.add(this.translationApplied);
        }
    }
}

