/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;

public class BoundingBox {
    private static final double HITBOX_CLAMP = 0.015625;
    public final Point3D localCenter;
    public final Point3D globalCenter;
    public final Point3D currentCollisionDepth;
    public final List<Point3D> collidingBlockPositions = new ArrayList<Point3D>();
    private RenderableData wireframeRenderable;
    private RenderableData holographicRenderable;
    private final Point3D tempGlobalCenter;
    public double widthRadius;
    public double heightRadius;
    public double depthRadius;
    public final boolean collidesWithLiquids;
    public final JSONCollisionGroup groupDef;
    public final JSONCollisionBox definition;
    public final Set<JSONCollisionGroup.CollisionType> collisionTypes;
    private static final Point3D helperPoint = new Point3D();

    public BoundingBox(Point3D center, double radius) {
        this(new Point3D(), center, radius, radius, radius, false, null, null, null);
    }

    public BoundingBox(Point3D center, double widthRadius, double heightRadius, double depthRadius) {
        this(new Point3D(), center, widthRadius, heightRadius, depthRadius, false, null, null, null);
    }

    public BoundingBox(Point3D center, double widthRadius, double heightRadius, double depthRadius, Set<JSONCollisionGroup.CollisionType> collisionTypes) {
        this(new Point3D(), center, widthRadius, heightRadius, depthRadius, false, null, null, collisionTypes);
    }

    public BoundingBox(Point3D localCenter, Point3D globalCenter, double widthRadius, double heightRadius, double depthRadius, boolean collidesWithLiquids, Set<JSONCollisionGroup.CollisionType> collisionTypes) {
        this(localCenter, globalCenter, widthRadius, heightRadius, depthRadius, collidesWithLiquids, null, null, collisionTypes);
    }

    public BoundingBox(JSONCollisionBox definition, JSONCollisionGroup groupDef) {
        this(definition.pos, definition.pos.copy(), (double)definition.width / 2.0, (double)definition.height / 2.0, (double)definition.width / 2.0, definition.collidesWithLiquids, definition, groupDef, groupDef.collisionTypes);
    }

    public BoundingBox(Point3D start, Point3D end) {
        this(new Point3D(), 0.0, 0.0, 0.0);
        this.globalCenter.set(end).subtract(start).scale(0.5);
        this.widthRadius = Math.abs(this.globalCenter.x);
        this.heightRadius = Math.abs(this.globalCenter.y);
        this.depthRadius = Math.abs(this.globalCenter.z);
        this.globalCenter.add(start);
    }

    private BoundingBox(Point3D localCenter, Point3D globalCenter, double widthRadius, double heightRadius, double depthRadius, boolean collidesWithLiquids, JSONCollisionBox definition, JSONCollisionGroup groupDef, Set<JSONCollisionGroup.CollisionType> collisionTypes) {
        this.localCenter = localCenter;
        this.globalCenter = globalCenter;
        this.tempGlobalCenter = globalCenter.copy();
        this.currentCollisionDepth = new Point3D();
        this.widthRadius = widthRadius;
        this.heightRadius = heightRadius;
        this.depthRadius = depthRadius;
        this.collidesWithLiquids = collidesWithLiquids;
        this.groupDef = groupDef;
        this.definition = definition;
        this.collisionTypes = collisionTypes;
    }

    public String toString() {
        return "LocalCenter:" + this.localCenter.toString() + " GlobalCenter:" + this.globalCenter.toString() + " Width:" + this.widthRadius + " Height:" + this.heightRadius + " Depth:" + this.depthRadius;
    }

    public boolean updateCollisions(AWrapperWorld world, Point3D offset, boolean ignoreIfGreater) {
        this.tempGlobalCenter.set(this.globalCenter);
        this.globalCenter.add(offset);
        world.updateBoundingBoxCollisions(this, offset, ignoreIfGreater);
        this.globalCenter.set(this.tempGlobalCenter);
        return !this.collidingBlockPositions.isEmpty();
    }

    public void updateToEntity(AEntityD_Definable<?> entity, Point3D optionalOffset) {
        if (optionalOffset != null) {
            this.globalCenter.set(optionalOffset);
        } else {
            this.globalCenter.set(this.localCenter);
        }
        this.globalCenter.multiply(entity.scale).rotate(entity.orientation).add(entity.position);
        if (this.definition != null) {
            this.globalCenter.x = (double)((int)(this.globalCenter.x / 0.015625)) * 0.015625;
            this.globalCenter.y = (double)((int)(this.globalCenter.y / 0.015625)) * 0.015625;
            this.globalCenter.z = (double)((int)(this.globalCenter.z / 0.015625)) * 0.015625;
        }
        if (this.definition != null) {
            this.widthRadius = entity.scale.x * (double)this.definition.width / 2.0;
            this.heightRadius = entity.scale.y * (double)this.definition.height / 2.0;
            this.depthRadius = entity.scale.z * (double)this.definition.width / 2.0;
        }
    }

    public boolean isPointInside(Point3D point, Point3D growthOffset) {
        if (growthOffset != null) {
            return this.globalCenter.x - this.widthRadius - growthOffset.x <= point.x && this.globalCenter.x + this.widthRadius + growthOffset.x >= point.x && this.globalCenter.y - this.heightRadius - growthOffset.y <= point.y && this.globalCenter.y + this.heightRadius + growthOffset.y >= point.y && this.globalCenter.z - this.depthRadius - growthOffset.z <= point.z && this.globalCenter.z + this.depthRadius + growthOffset.z >= point.z;
        }
        return this.globalCenter.x - this.widthRadius <= point.x && this.globalCenter.x + this.widthRadius >= point.x && this.globalCenter.y - this.heightRadius <= point.y && this.globalCenter.y + this.heightRadius >= point.y && this.globalCenter.z - this.depthRadius <= point.z && this.globalCenter.z + this.depthRadius >= point.z;
    }

    public boolean isPointInsideAndBelow(Point3D point) {
        return this.globalCenter.x - this.widthRadius <= point.x && this.globalCenter.x + this.widthRadius >= point.x && this.globalCenter.y + this.heightRadius > point.y && this.globalCenter.z - this.depthRadius <= point.z && this.globalCenter.z + this.depthRadius >= point.z;
    }

    public boolean intersects(BoundingBox box) {
        return this.globalCenter.x - this.widthRadius < box.globalCenter.x + box.widthRadius && this.globalCenter.x + this.widthRadius > box.globalCenter.x - box.widthRadius && this.globalCenter.y - this.heightRadius < box.globalCenter.y + box.heightRadius && this.globalCenter.y + this.heightRadius > box.globalCenter.y - box.heightRadius && this.globalCenter.z - this.depthRadius < box.globalCenter.z + box.depthRadius && this.globalCenter.z + this.depthRadius > box.globalCenter.z - box.depthRadius;
    }

    private boolean intersectsWithYZ(Point3D point) {
        return point.y >= this.globalCenter.y - this.heightRadius && point.y <= this.globalCenter.y + this.heightRadius && point.z >= this.globalCenter.z - this.depthRadius && point.z <= this.globalCenter.z + this.depthRadius;
    }

    private boolean intersectsWithXZ(Point3D point) {
        return point.x >= this.globalCenter.x - this.widthRadius && point.x <= this.globalCenter.x + this.widthRadius && point.z >= this.globalCenter.z - this.depthRadius && point.z <= this.globalCenter.z + this.depthRadius;
    }

    private boolean intersectsWithXY(Point3D point) {
        return point.x >= this.globalCenter.x - this.widthRadius && point.x <= this.globalCenter.x + this.widthRadius && point.y >= this.globalCenter.y - this.heightRadius && point.y <= this.globalCenter.y + this.heightRadius;
    }

    private Point3D getXPlaneCollision(Point3D start, Point3D end, double xPoint) {
        Point3D collisionPoint = start.getIntermediateWithXValue(end, xPoint);
        return collisionPoint != null && this.intersectsWithYZ(collisionPoint) ? collisionPoint : null;
    }

    private Point3D getYPlaneCollision(Point3D start, Point3D end, double yPoint) {
        Point3D collisionPoint = start.getIntermediateWithYValue(end, yPoint);
        return collisionPoint != null && this.intersectsWithXZ(collisionPoint) ? collisionPoint : null;
    }

    private Point3D getZPlaneCollision(Point3D start, Point3D end, double zPoint) {
        Point3D collisionPoint = start.getIntermediateWithZValue(end, zPoint);
        return collisionPoint != null && this.intersectsWithXY(collisionPoint) ? collisionPoint : null;
    }

    public BoundingBoxHitResult getIntersection(Point3D start, Point3D end) {
        Point3D intersection = this.getXPlaneCollision(start, end, this.globalCenter.x - this.widthRadius);
        ABlockBase.Axis hitSide = ABlockBase.Axis.WEST;
        Point3D secondIntersection = this.getXPlaneCollision(start, end, this.globalCenter.x + this.widthRadius);
        if (secondIntersection != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
            hitSide = ABlockBase.Axis.EAST;
        }
        if ((secondIntersection = this.getYPlaneCollision(start, end, this.globalCenter.y - this.heightRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
            hitSide = ABlockBase.Axis.DOWN;
        }
        if ((secondIntersection = this.getYPlaneCollision(start, end, this.globalCenter.y + this.heightRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
            hitSide = ABlockBase.Axis.UP;
        }
        if ((secondIntersection = this.getZPlaneCollision(start, end, this.globalCenter.z - this.depthRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
            hitSide = ABlockBase.Axis.NORTH;
        }
        if ((secondIntersection = this.getZPlaneCollision(start, end, this.globalCenter.z + this.depthRadius)) != null && (intersection == null || start.distanceTo(secondIntersection) < start.distanceTo(intersection))) {
            intersection = secondIntersection;
            hitSide = ABlockBase.Axis.SOUTH;
        }
        return intersection != null ? new BoundingBoxHitResult(this, intersection, hitSide) : null;
    }

    public void renderWireframe(AEntityC_Renderable entity, TransformationMatrix transform, Point3D offset, ColorRGB color) {
        if (this.wireframeRenderable == null) {
            this.wireframeRenderable = new RenderableData(new RenderableVertices(false));
            if (this.definition != null) {
                if (this.definition.variableName != null) {
                    this.wireframeRenderable.setColor(ColorRGB.GREEN);
                } else if (this.groupDef != null && this.groupDef.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.BULLET)) {
                    this.wireframeRenderable.setColor(ColorRGB.ORANGE);
                } else if (this.groupDef != null && this.groupDef.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.BLOCK)) {
                    this.wireframeRenderable.setColor(ColorRGB.RED);
                } else {
                    this.wireframeRenderable.setColor(ColorRGB.BLACK);
                }
            } else {
                this.wireframeRenderable.setColor(ColorRGB.YELLOW);
            }
        }
        this.wireframeRenderable.transform.set(transform);
        helperPoint.set(this.globalCenter);
        if (offset != null) {
            helperPoint.add(offset);
        } else {
            helperPoint.subtract(entity.position);
        }
        this.wireframeRenderable.transform.applyTranslation(helperPoint);
        if (color != null) {
            this.wireframeRenderable.setColor(color);
        }
        this.wireframeRenderable.setBoxBounds(this, true);
        this.wireframeRenderable.render();
    }

    public void renderHolographic(TransformationMatrix transform, Point3D offset, ColorRGB color) {
        if (this.holographicRenderable == null) {
            this.holographicRenderable = new RenderableData(new RenderableVertices(true), "mts:textures/rendering/holobox.png");
            this.holographicRenderable.setLightMode(RenderableData.LightingMode.IGNORE_ALL_LIGHTING);
        }
        this.holographicRenderable.transform.set(transform);
        if (offset != null) {
            this.holographicRenderable.transform.applyTranslation(offset);
        }
        this.holographicRenderable.setColor(color);
        this.holographicRenderable.setBoxBounds(this, false);
        this.holographicRenderable.render();
    }
}

