/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165.mixin.common;

import mcinterface1165.BuilderEntityExisting;
import mcinterface1165.BuilderEntityLinkedSeat;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Inject(method={"getEyePosition(F)Lnet/minecraft/util/math/vector/Vector3d;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getEyePosition(float pPartialTicks, CallbackInfoReturnable<Vector3d> ci) {
        Entity entity = (Entity)this;
        Entity riding = entity.func_184187_bx();
        if (riding instanceof BuilderEntityLinkedSeat) {
            BuilderEntityLinkedSeat builder = (BuilderEntityLinkedSeat)riding;
            if (builder.entity != null) {
                ci.setReturnValue((Object)new Vector3d(builder.entity.riderHeadPosition.x, builder.entity.riderHeadPosition.y, builder.entity.riderHeadPosition.z));
            }
        }
    }

    @Inject(method={"collide(Lnet/minecraft/util/math/vector/Vector3d;)Lnet/minecraft/util/math/vector/Vector3d;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_collide(Vector3d movement, CallbackInfoReturnable<Vector3d> ci) {
        Entity entity = (Entity)this;
        AxisAlignedBB box = entity.func_174813_aQ();
        boolean collidedWithVehicle = false;
        for (BuilderEntityExisting builder : entity.field_70170_p.func_217357_a(BuilderEntityExisting.class, box.func_216361_a(movement))) {
            if (builder.collisionBoxes == null) continue;
            movement = builder.collisionBoxes.getCollision(movement, box);
            collidedWithVehicle = true;
        }
        if (collidedWithVehicle) {
            ci.setReturnValue((Object)movement);
        }
    }
}

