/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165.mixin.client;

import mcinterface1165.WrapperEntity;
import mcinterface1165.WrapperPlayer;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BipedModel.class})
public abstract class BipedModelMixin<T extends LivingEntity> {
    private static final float yArmAngleRad = (float)Math.toRadians(10.0);

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    public void inject_setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (((Boolean)ConfigSystem.client.renderingSettings.playerTweaks.value).booleanValue()) {
            EntityPlayerGun gunEntity;
            BipedModel model = (BipedModel)this;
            WrapperEntity entityWrapper = WrapperEntity.getWrapperFor(entity);
            AEntityB_Existing ridingEntity = entityWrapper.getEntityRiding();
            if (ridingEntity != null) {
                boolean renderCurrentRiderStanding = false;
                if (ridingEntity instanceof PartSeat) {
                    PartSeat seat = (PartSeat)ridingEntity;
                    renderCurrentRiderStanding = ((JSONPart)seat.definition).seat.standing;
                    if (seat.vehicleOn != null && seat.placementDefinition.isController) {
                        double turningAngle = seat.vehicleOn.rudderInput / 2.0;
                        model.field_178723_h.field_78795_f = (float)Math.toRadians(-75.0 + turningAngle);
                        model.field_178723_h.field_78796_g = -yArmAngleRad;
                        model.field_178723_h.field_78808_h = 0.0f;
                        model.field_178724_i.field_78795_f = (float)Math.toRadians(-75.0 - turningAngle);
                        model.field_178724_i.field_78796_g = yArmAngleRad;
                        model.field_178724_i.field_78808_h = 0.0f;
                    }
                }
                if (renderCurrentRiderStanding) {
                    model.field_178722_k.field_78795_f = 0.0f;
                    model.field_178722_k.field_78796_g = 0.0f;
                    model.field_178722_k.field_78808_h = 0.0f;
                    model.field_178721_j.field_78795_f = 0.0f;
                    model.field_178721_j.field_78796_g = 0.0f;
                    model.field_178721_j.field_78808_h = 0.0f;
                } else {
                    model.field_178722_k.field_78795_f = (float)Math.toRadians(-90.0);
                    model.field_178722_k.field_78796_g = 0.0f;
                    model.field_178722_k.field_78808_h = 0.0f;
                    model.field_178721_j.field_78795_f = (float)Math.toRadians(-90.0);
                    model.field_178721_j.field_78796_g = 0.0f;
                    model.field_178721_j.field_78808_h = 0.0f;
                }
            }
            if (entity instanceof PlayerEntity && (gunEntity = EntityPlayerGun.playerClientGuns.get(entity.func_110124_au())) != null && gunEntity.activeGun != null) {
                Point3D heldVector = gunEntity.activeGun.isHandHeldGunAimed ? ((JSONPart)gunEntity.activeGun.definition).gun.handHeldAimedOffset : ((JSONPart)gunEntity.activeGun.definition).gun.handHeldNormalOffset;
                double heldVectorLength = heldVector.length();
                double armPitchOffset = Math.toRadians(-90.0f + ((LivingEntity)entity).field_70125_A) - Math.asin(heldVector.y / heldVectorLength);
                double armYawOffset = -Math.atan2(heldVector.x / heldVectorLength, heldVector.z / heldVectorLength);
                WrapperPlayer playerWrapper = WrapperPlayer.getWrapperFor((PlayerEntity)entity);
                if (playerWrapper.isRightHanded()) {
                    model.field_178723_h.field_78795_f = (float)armPitchOffset;
                    model.field_178723_h.field_78796_g = (float)(armYawOffset + Math.toRadians(((LivingEntity)entity).field_70759_as - ((LivingEntity)entity).field_70761_aq));
                    model.field_178723_h.field_78808_h = 0.0f;
                } else {
                    model.field_178724_i.field_78795_f = (float)armPitchOffset;
                    model.field_178724_i.field_78796_g = (float)(-armYawOffset + Math.toRadians(((LivingEntity)entity).field_70759_as - ((LivingEntity)entity).field_70761_aq));
                    model.field_178724_i.field_78808_h = 0.0f;
                }
                if (gunEntity.activeGun.isHandHeldGunAimed || gunEntity.activeGun.currentIsTwoHandedness != 0.0f) {
                    heldVector = heldVector.copy();
                    heldVector.x = 0.625 - heldVector.x;
                    heldVectorLength = heldVector.length();
                    armPitchOffset = Math.toRadians(-90.0f + ((LivingEntity)entity).field_70125_A) - Math.asin(heldVector.y / heldVectorLength);
                    armYawOffset = -Math.atan2(heldVector.x / heldVectorLength, heldVector.z / heldVectorLength);
                    if (playerWrapper.isRightHanded()) {
                        model.field_178724_i.field_78795_f = (float)armPitchOffset;
                        model.field_178724_i.field_78796_g = (float)(-armYawOffset + Math.toRadians(((LivingEntity)entity).field_70759_as - ((LivingEntity)entity).field_70761_aq));
                        model.field_178724_i.field_78808_h = 0.0f;
                    } else {
                        model.field_178723_h.field_78795_f = (float)armPitchOffset;
                        model.field_178723_h.field_78796_g = (float)(armYawOffset + Math.toRadians(((LivingEntity)entity).field_70759_as - ((LivingEntity)entity).field_70761_aq));
                        model.field_178723_h.field_78808_h = 0.0f;
                    }
                }
            }
        }
    }
}

