/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mcinterface1165.ABuilderEntityBase;
import mcinterface1165.BuilderBlock;
import mcinterface1165.BuilderEntityExisting;
import mcinterface1165.BuilderEntityLinkedSeat;
import mcinterface1165.BuilderEntityRenderForwarder;
import mcinterface1165.BuilderTileEntity;
import mcinterface1165.WrapperEntity;
import mcinterface1165.WrapperItemStack;
import mcinterface1165.WrapperNBT;
import mcinterface1165.WrapperPlayer;
import mcinterface1165.mixin.common.ConcretePowderBlockMixin;
import minecrafttransportsimulator.baseclasses.BlockHitResult;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataRequest;
import minecrafttransportsimulator.packets.instances.PacketWorldSavedDataUpdate;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.state.Property;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WrapperWorld
extends AWrapperWorld {
    private static final Map<World, WrapperWorld> worldWrappers = new HashMap<World, WrapperWorld>();
    private final Map<UUID, BuilderEntityExisting> playerServerGunBuilders = new HashMap<UUID, BuilderEntityExisting>();
    private final Map<UUID, Integer> ticksSincePlayerJoin = new HashMap<UUID, Integer>();
    private static Map<UUID, BuilderEntityRenderForwarder> playerFollowers = new HashMap<UUID, BuilderEntityRenderForwarder>();
    private final List<AxisAlignedBB> mutableCollidingAABBs = new ArrayList<AxisAlignedBB>();
    private final Set<BlockPos> knownAirBlocks = new HashSet<BlockPos>();
    protected final World world;
    private final IWrapperNBT savedData;
    private static HashMap<Material, ABlockBase.BlockMaterial> materialMap = new HashMap();

    public static WrapperWorld getWrapperFor(World world) {
        if (world != null) {
            WrapperWorld wrapper = worldWrappers.get(world);
            if (wrapper == null || world != wrapper.world) {
                wrapper = new WrapperWorld(world);
                worldWrappers.put(world, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    private WrapperWorld(World world) {
        this.world = world;
        if (world.field_72995_K) {
            this.savedData = InterfaceManager.coreInterface.getNewNBTWrapper();
            InterfaceManager.packetInterface.sendToServer(new PacketWorldSavedDataRequest(InterfaceManager.clientInterface.getClientPlayer()));
        } else {
            try {
                this.savedData = this.getDataFile().exists() ? new WrapperNBT(CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(this.getDataFile().toPath(), new OpenOption[0]))) : InterfaceManager.coreInterface.getNewNBTWrapper();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not load saved data from disk!  This will result in data loss if we continue!");
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public AWrapperWorld getWorld() {
        return this;
    }

    @Override
    public boolean isClient() {
        return this.world.field_72995_K;
    }

    @Override
    public long getTime() {
        return this.world.func_72820_D() % 24000L;
    }

    @Override
    public String getName() {
        return this.world.func_234923_W_().getRegistryName().func_110623_a();
    }

    @Override
    public long getMaxHeight() {
        return this.world.func_234938_ad_();
    }

    @Override
    public void beginProfiling(String name, boolean subProfile) {
        if (subProfile) {
            this.world.func_217381_Z().func_76320_a(name);
        } else {
            this.world.func_217381_Z().func_219895_b(name);
        }
    }

    @Override
    public void endProfiling() {
        this.world.func_217381_Z().func_76319_b();
    }

    @Override
    public IWrapperNBT getData(String name) {
        if (name.isEmpty()) {
            return this.savedData;
        }
        return this.savedData.getData(name);
    }

    @Override
    public void setData(String name, IWrapperNBT value) {
        this.savedData.setData(name, value);
        if (!this.isClient()) {
            try {
                CompressedStreamTools.func_74799_a((CompoundNBT)((WrapperNBT)this.savedData).tag, (OutputStream)Files.newOutputStream(this.getDataFile().toPath(), new OpenOption[0]));
                InterfaceManager.packetInterface.sendToAllClients(new PacketWorldSavedDataUpdate(name, value));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Could not save data to disk!  This will result in data loss if we continue!");
            }
        }
    }

    @Override
    public File getDataFile() {
        for (Field field : DimensionSavedDataManager.class.getDeclaredFields()) {
            if (!field.getName().equals("dataFolder") && !field.getName().equals("field_215759_d")) continue;
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                File dataFolder = (File)field.get(((ServerWorld)this.world).func_217481_x());
                return new File(dataFolder, "mtsdata.dat");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public WrapperEntity getExternalEntity(UUID entityID) {
        if (this.world instanceof ServerWorld) {
            return WrapperEntity.getWrapperFor(((ServerWorld)this.world).func_217461_a(entityID));
        }
        for (Entity entity : ((ClientWorld)this.world).func_217416_b()) {
            if (!entity.func_110124_au().equals(entityID)) continue;
            return WrapperEntity.getWrapperFor(entity);
        }
        return null;
    }

    @Override
    public List<IWrapperEntity> getEntitiesWithin(BoundingBox box) {
        ArrayList<IWrapperEntity> entities = new ArrayList<IWrapperEntity>();
        for (LivingEntity entity : this.world.func_217357_a(LivingEntity.class, WrapperWorld.convert(box))) {
            entities.add(WrapperEntity.getWrapperFor((Entity)entity));
        }
        return entities;
    }

    @Override
    public List<IWrapperPlayer> getPlayersWithin(BoundingBox box) {
        ArrayList<IWrapperPlayer> players = new ArrayList<IWrapperPlayer>();
        for (PlayerEntity player : this.world.func_217357_a(PlayerEntity.class, WrapperWorld.convert(box))) {
            players.add(WrapperPlayer.getWrapperFor(player));
        }
        return players;
    }

    @Override
    public List<IWrapperEntity> getEntitiesHostile(IWrapperEntity lookingEntity, double radius) {
        ArrayList<IWrapperEntity> entities = new ArrayList<IWrapperEntity>();
        Entity mcLooker = ((WrapperEntity)lookingEntity).entity;
        for (Entity entity : this.world.func_72839_b(mcLooker, mcLooker.func_174813_aQ().func_186662_g(radius))) {
            if (!(entity instanceof IMob) || !entity.func_70089_S() || entity instanceof LivingEntity && ((LivingEntity)entity).field_70725_aQ != 0) continue;
            entities.add(WrapperEntity.getWrapperFor(entity));
        }
        return entities;
    }

    @Override
    public void spawnEntity(AEntityB_Existing entity) {
        this.spawnEntityInternal(entity);
    }

    protected BuilderEntityExisting spawnEntityInternal(AEntityB_Existing entity) {
        BuilderEntityExisting builder = new BuilderEntityExisting((EntityType<? extends BuilderEntityExisting>)((EntityType)BuilderEntityExisting.E_TYPE2.get()), ((WrapperWorld)entity.world).world);
        builder.loadedFromSavedNBT = true;
        builder.func_70107_b(entity.position.x, entity.position.y, entity.position.z);
        builder.entity = entity;
        this.world.func_217376_c((Entity)builder);
        this.addEntity(entity);
        return builder;
    }

    @Override
    public List<IWrapperEntity> attackEntities(Damage damage, Point3D motion, boolean generateList) {
        AxisAlignedBB mcBox = WrapperWorld.convert(damage.box);
        if (motion != null) {
            mcBox = mcBox.func_72314_b(motion.x, motion.y, motion.z);
        }
        List collidedEntities = this.world.func_217357_a(Entity.class, mcBox);
        Vector3d start = null;
        Vector3d end = null;
        ArrayList<IWrapperEntity> hitEntities = new ArrayList<IWrapperEntity>();
        if (motion != null) {
            Point3D startPoint = damage.box.globalCenter;
            Point3D endPoint = damage.box.globalCenter.copy().add(motion);
            start = new Vector3d(startPoint.x, startPoint.y, startPoint.z);
            end = new Vector3d(endPoint.x, endPoint.y, endPoint.z);
        }
        for (Entity mcEntityCollided : collidedEntities) {
            Entity mcRidingEntity;
            if (mcEntityCollided instanceof ABuilderEntityBase) continue;
            if (damage.damgeSource != null && (mcRidingEntity = mcEntityCollided.func_184187_bx()) instanceof BuilderEntityLinkedSeat) {
                AEntityB_Existing internalRidingEntity = ((BuilderEntityLinkedSeat)mcRidingEntity).entity;
                if (damage.damgeSource == internalRidingEntity) continue;
                if (internalRidingEntity instanceof APart) {
                    APart ridingPart = (APart)internalRidingEntity;
                    if (ridingPart.masterEntity.allParts.contains(damage.damgeSource)) continue;
                }
            }
            if (motion != null && !mcEntityCollided.func_174813_aQ().func_216365_b(start, end).isPresent()) continue;
            hitEntities.add(WrapperEntity.getWrapperFor(mcEntityCollided));
        }
        if (generateList) {
            return hitEntities;
        }
        for (IWrapperEntity entity : hitEntities) {
            entity.attack(damage);
        }
        return null;
    }

    @Override
    public void loadEntities(BoundingBox box, AEntityE_Interactable<?> entityToLoad) {
        block0: for (LivingEntity entity : this.world.func_217357_a(LivingEntity.class, WrapperWorld.convert(box))) {
            if (entity.func_184187_bx() != null || entity instanceof MonsterEntity || entity instanceof PlayerEntity) continue;
            if (entityToLoad instanceof EntityVehicleF_Physics) {
                for (APart part : ((EntityVehicleF_Physics)entityToLoad).allParts) {
                    if (!(part instanceof PartSeat) || part.rider != null || part.placementDefinition.isController) continue;
                    part.setRider(new WrapperEntity((Entity)entity), true);
                    continue block0;
                }
                continue;
            }
            if (entityToLoad.rider != null) continue;
            entityToLoad.setRider(new WrapperEntity((Entity)entity), true);
            break;
        }
    }

    @Override
    public void populateItemStackEntities(Map<IWrapperEntity, IWrapperItemStack> map, BoundingBox box) {
        for (ItemEntity mcEntity : this.world.func_217357_a(ItemEntity.class, WrapperWorld.convert(box))) {
            WrapperEntity entity = WrapperEntity.getWrapperFor((Entity)mcEntity);
            if (map.containsKey(entity)) continue;
            map.put(entity, new WrapperItemStack(mcEntity.func_92059_d()));
        }
    }

    @Override
    public void removeItemStackEntity(IWrapperEntity entity) {
        ((WrapperEntity)entity).entity.func_174812_G();
    }

    @Override
    public boolean chunkLoaded(Point3D position) {
        return this.world.func_195588_v(new BlockPos(position.x, position.y, position.z));
    }

    @Override
    public ABlockBase getBlock(Point3D position) {
        Block block = this.world.func_180495_p(new BlockPos(position.x, position.y, position.z)).func_177230_c();
        return block instanceof BuilderBlock ? ((BuilderBlock)block).block : null;
    }

    @Override
    public float getBlockHardness(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        float hardness = this.world.func_180495_p(pos).func_185887_b((IBlockReader)this.world, pos);
        if (hardness < 0.0f) {
            hardness = Float.MAX_VALUE;
        }
        return hardness;
    }

    @Override
    public float getBlockSlipperiness(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        return this.world.func_180495_p(pos).getSlipperiness((IWorldReader)this.world, pos, null);
    }

    @Override
    public ABlockBase.BlockMaterial getBlockMaterial(Point3D position) {
        BlockPos pos;
        if (materialMap.isEmpty()) {
            materialMap.put(Material.field_151571_B, ABlockBase.BlockMaterial.CLAY);
            materialMap.put(Material.field_151578_c, ABlockBase.BlockMaterial.DIRT);
            materialMap.put(Material.field_151592_s, ABlockBase.BlockMaterial.GLASS);
            materialMap.put(Material.field_151577_b, ABlockBase.BlockMaterial.GRASS);
            materialMap.put(Material.field_151588_w, ABlockBase.BlockMaterial.ICE);
            materialMap.put(Material.field_151598_x, ABlockBase.BlockMaterial.ICE);
            materialMap.put(Material.field_151587_i, ABlockBase.BlockMaterial.LAVA);
            materialMap.put(Material.field_151584_j, ABlockBase.BlockMaterial.LEAVES);
            materialMap.put(Material.field_151573_f, ABlockBase.BlockMaterial.METAL);
            materialMap.put(Material.field_151595_p, ABlockBase.BlockMaterial.SAND);
            materialMap.put(Material.field_151596_z, ABlockBase.BlockMaterial.SNOW);
            materialMap.put(Material.field_151597_y, ABlockBase.BlockMaterial.SNOW);
            materialMap.put(Material.field_151576_e, ABlockBase.BlockMaterial.STONE);
            materialMap.put(Material.field_151586_h, ABlockBase.BlockMaterial.WATER);
            materialMap.put(Material.field_151575_d, ABlockBase.BlockMaterial.WOOD);
            materialMap.put(Material.field_151580_n, ABlockBase.BlockMaterial.WOOL);
        }
        if (this.world.func_175623_d(pos = new BlockPos(position.x, position.y, position.z))) {
            return null;
        }
        ABlockBase.BlockMaterial material = materialMap.get(this.world.func_180495_p(pos).func_185904_a());
        if (material == null) {
            return ABlockBase.BlockMaterial.NORMAL;
        }
        if (material == ABlockBase.BlockMaterial.SAND && this.world.func_180495_p(pos).func_177230_c() == Blocks.field_150351_n) {
            return ABlockBase.BlockMaterial.GRAVEL;
        }
        return material;
    }

    @Override
    public ColorRGB getBlockColor(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        BlockState state = this.world.func_180495_p(pos);
        MaterialColor mcColor = state.func_185909_g((IBlockReader)this.world, pos);
        return new ColorRGB(mcColor.field_76291_p);
    }

    @Override
    public List<IWrapperItemStack> getBlockDrops(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        BlockState state = this.world.func_180495_p(pos);
        List drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)this.world), (BlockPos)pos, (TileEntity)this.world.func_175625_s(pos));
        ArrayList<IWrapperItemStack> convertedList = new ArrayList<IWrapperItemStack>();
        for (ItemStack stack : drops) {
            convertedList.add(new WrapperItemStack(stack.func_77946_l()));
        }
        return convertedList;
    }

    @Override
    public BlockHitResult getBlockHit(Point3D position, Point3D delta) {
        BlockPos blockPos;
        Vector3d start = new Vector3d(position.x, position.y, position.z);
        BlockRayTraceResult trace = this.world.func_217299_a(new RayTraceContext(start, start.func_72441_c(delta.x, delta.y, delta.z), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        if (trace.func_216346_c() != RayTraceResult.Type.MISS && (blockPos = trace.func_216350_a()) != null) {
            Vector3d pos = trace.func_216347_e();
            return new BlockHitResult(new Point3D(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), new Point3D(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c), ABlockBase.Axis.valueOf(trace.func_216354_b().name()));
        }
        return null;
    }

    @Override
    public boolean isBlockSolid(Point3D position, ABlockBase.Axis axis) {
        if (axis.blockBased) {
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            BlockState state = this.world.func_180495_p(pos);
            Block offsetMCBlock = state.func_177230_c();
            Direction facing = Direction.valueOf((String)axis.name());
            return offsetMCBlock != null && !offsetMCBlock.equals(Blocks.field_180401_cv) && state.func_224755_d((IBlockReader)this.world, pos, facing);
        }
        return false;
    }

    @Override
    public boolean isBlockLiquid(Point3D position) {
        return this.world.func_180495_p(new BlockPos(position.x, position.y, position.z)).func_185904_a().func_76224_d();
    }

    @Override
    public boolean isBlockBelowBottomSlab(Point3D position) {
        BlockState state = this.world.func_180495_p(new BlockPos(position.x, position.y - 1.0, position.z));
        return state.func_177230_c() instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.BOTTOM;
    }

    @Override
    public boolean isBlockAboveTopSlab(Point3D position) {
        BlockState state = this.world.func_180495_p(new BlockPos(position.x, position.y + 1.0, position.z));
        return state.func_177230_c() instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.TOP;
    }

    @Override
    public double getHeight(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        boolean bottomSlab = false;
        while (pos.func_177956_o() > 0) {
            if (!this.world.func_175623_d(pos)) {
                BlockState state = this.world.func_180495_p(pos);
                bottomSlab = state.func_177230_c() instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.BOTTOM;
                pos = pos.func_177984_a();
                break;
            }
            pos = pos.func_177977_b();
        }
        return bottomSlab ? position.y - ((double)pos.func_177956_o() - 0.5) : position.y - (double)pos.func_177956_o();
    }

    @Override
    public void updateBoundingBoxCollisions(BoundingBox box, Point3D collisionMotion, boolean ignoreIfGreater) {
        AxisAlignedBB mcBox = WrapperWorld.convert(box);
        VoxelShape mcShape = VoxelShapes.func_197881_a((AxisAlignedBB)mcBox);
        box.collidingBlockPositions.clear();
        this.mutableCollidingAABBs.clear();
        int i = (int)Math.floor(mcBox.field_72340_a);
        while ((double)i < Math.ceil(mcBox.field_72336_d)) {
            int j = (int)Math.floor(mcBox.field_72338_b);
            while ((double)j < Math.ceil(mcBox.field_72337_e)) {
                int k = (int)Math.floor(mcBox.field_72339_c);
                while ((double)k < Math.ceil(mcBox.field_72334_f)) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (!this.world.func_175623_d(pos)) {
                        BlockState state = this.world.func_180495_p(pos);
                        VoxelShape collisionShape = state.func_196952_d((IBlockReader)this.world, pos).func_197751_a((double)i, (double)j, (double)k);
                        if (!collisionShape.func_197766_b() && VoxelShapes.func_197879_c((VoxelShape)mcShape, (VoxelShape)collisionShape, (IBooleanFunction)IBooleanFunction.field_223238_i_) && state.func_185904_a() != Material.field_151584_j) {
                            this.mutableCollidingAABBs.addAll(collisionShape.func_197756_d());
                            box.collidingBlockPositions.add(new Point3D(i, j, k));
                        }
                        if (box.collidesWithLiquids && state.func_185904_a().func_76224_d()) {
                            this.mutableCollidingAABBs.add(VoxelShapes.func_197868_b().func_197752_a().func_186670_a(pos));
                            box.collidingBlockPositions.add(new Point3D(i, j, k));
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        box.currentCollisionDepth.set(0.0, 0.0, 0.0);
        for (AxisAlignedBB colBox : this.mutableCollidingAABBs) {
            double boxCollisionDepth;
            if (collisionMotion.x > 0.0) {
                double boxCollisionDepth2 = mcBox.field_72336_d - colBox.field_72340_a;
                if (box.currentCollisionDepth.x < boxCollisionDepth2) {
                    box.currentCollisionDepth.x = boxCollisionDepth2;
                }
            } else if (collisionMotion.x < 0.0 && box.currentCollisionDepth.x > (boxCollisionDepth = -(colBox.field_72336_d - mcBox.field_72340_a))) {
                box.currentCollisionDepth.x = boxCollisionDepth;
            }
            if (collisionMotion.y > 0.0) {
                boxCollisionDepth = mcBox.field_72337_e - colBox.field_72338_b;
                if (box.currentCollisionDepth.y < boxCollisionDepth) {
                    box.currentCollisionDepth.y = boxCollisionDepth;
                }
            } else if (collisionMotion.y < 0.0 && box.currentCollisionDepth.y > (boxCollisionDepth = -(colBox.field_72337_e - mcBox.field_72338_b))) {
                box.currentCollisionDepth.y = boxCollisionDepth;
            }
            if (collisionMotion.z > 0.0) {
                boxCollisionDepth = mcBox.field_72334_f - colBox.field_72339_c;
                if (!(box.currentCollisionDepth.z < boxCollisionDepth)) continue;
                box.currentCollisionDepth.z = boxCollisionDepth;
                continue;
            }
            if (!(collisionMotion.z < 0.0) || !(box.currentCollisionDepth.z > (boxCollisionDepth = -(colBox.field_72334_f - mcBox.field_72339_c)))) continue;
            box.currentCollisionDepth.z = boxCollisionDepth;
        }
        if (ignoreIfGreater) {
            if (collisionMotion.x > 0.0 && box.currentCollisionDepth.x > collisionMotion.x) {
                box.currentCollisionDepth.x = collisionMotion.x;
            } else if (collisionMotion.x < 0.0 && box.currentCollisionDepth.x < collisionMotion.x) {
                box.currentCollisionDepth.x = collisionMotion.x;
            }
            if (collisionMotion.y > 0.0 && box.currentCollisionDepth.y > collisionMotion.y) {
                box.currentCollisionDepth.y = collisionMotion.y;
            } else if (collisionMotion.y < 0.0 && box.currentCollisionDepth.y < collisionMotion.y) {
                box.currentCollisionDepth.y = collisionMotion.y;
            }
            if (collisionMotion.z > 0.0 && box.currentCollisionDepth.z > collisionMotion.z) {
                box.currentCollisionDepth.z = collisionMotion.z;
            } else if (collisionMotion.z < 0.0 && box.currentCollisionDepth.z < collisionMotion.z) {
                box.currentCollisionDepth.z = collisionMotion.z;
            }
        }
        if (box.currentCollisionDepth.isZero()) {
            box.collidingBlockPositions.clear();
        }
    }

    @Override
    public boolean checkForCollisions(BoundingBox box, Point3D offset, boolean clearCache, boolean breakLeaves) {
        if (clearCache) {
            this.knownAirBlocks.clear();
        }
        this.mutableCollidingAABBs.clear();
        AxisAlignedBB mcBox = WrapperWorld.convertWithOffset(box, offset.x, offset.y, offset.z);
        VoxelShape mcShape = VoxelShapes.func_197881_a((AxisAlignedBB)mcBox);
        int i = (int)Math.floor(mcBox.field_72340_a);
        while ((double)i < Math.ceil(mcBox.field_72336_d)) {
            int j = (int)Math.floor(mcBox.field_72338_b);
            while ((double)j < Math.ceil(mcBox.field_72337_e)) {
                int k = (int)Math.floor(mcBox.field_72339_c);
                while ((double)k < Math.ceil(mcBox.field_72334_f)) {
                    BlockPos pos = new BlockPos(i, j, k);
                    if (!this.knownAirBlocks.contains(pos) && this.world.func_195588_v(pos)) {
                        BlockState state = this.world.func_180495_p(pos);
                        VoxelShape collisionShape = state.func_196952_d((IBlockReader)this.world, pos).func_197751_a((double)i, (double)j, (double)k);
                        if (state.func_185904_a() != Material.field_151584_j) {
                            if (collisionShape != null && !collisionShape.func_197766_b() && VoxelShapes.func_197879_c((VoxelShape)mcShape, (VoxelShape)collisionShape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
                                return true;
                            }
                            this.knownAirBlocks.add(pos);
                            if (box.collidesWithLiquids && state.func_185904_a().func_76224_d() && mcBox.func_72326_a(VoxelShapes.func_197868_b().func_197752_a().func_186670_a(pos))) {
                                return true;
                            }
                        } else if (breakLeaves) {
                            this.world.func_175655_b(pos, false);
                        } else {
                            this.knownAirBlocks.add(pos);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getRedstonePower(Point3D position) {
        return this.world.func_175687_A(new BlockPos(position.x, position.y, position.z));
    }

    @Override
    public float getRainStrength(Point3D position) {
        return this.world.func_175727_C(new BlockPos(position.x, position.y + 1.0, position.z)) ? this.world.func_72867_j(1.0f) + this.world.func_72819_i(1.0f) : 0.0f;
    }

    @Override
    public float getTemperature(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        return this.world.func_226691_t_(pos).func_225486_c(pos);
    }

    @Override
    public <TileEntityType extends ATileEntityBase<JSONDefinition>, JSONDefinition extends AJSONMultiModelProvider> boolean setBlock(ABlockBase block, Point3D position, IWrapperPlayer playerWrapper, ABlockBase.Axis axis) {
        if (!this.world.field_72995_K) {
            BuilderBlock wrapper = BuilderBlock.blockMap.get(block);
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            if (playerWrapper != null) {
                BlockState newState;
                PlayerEntity mcPlayer = ((WrapperPlayer)playerWrapper).player;
                WrapperItemStack stack = (WrapperItemStack)playerWrapper.getHeldStack();
                AItemBase item = stack.getItem();
                Direction facing = Direction.valueOf((String)axis.name());
                if (!this.world.func_175623_d(pos)) {
                    pos = pos.func_177972_a(facing);
                    position.add(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e());
                }
                if (item != null && this.world.func_175660_a(mcPlayer, pos) && this.world.func_175623_d(pos) && this.world.func_180501_a(pos, newState = wrapper.func_176223_P(), 11)) {
                    if (block instanceof ABlockBaseTileEntity) {
                        BuilderTileEntity builderTile = (BuilderTileEntity)this.world.func_175625_s(pos);
                        IWrapperNBT data = stack.getData();
                        if (data != null) {
                            data.deleteAllUUIDTags();
                        }
                        builderTile.setTileEntity(((ABlockBaseTileEntity)block).createTileEntity(this, position, playerWrapper, (AItemSubTyped)item, data));
                        this.addEntity(builderTile.tileEntity);
                    }
                    stack.add(-1);
                    return true;
                }
            } else {
                BlockState newState = wrapper.func_176223_P();
                return this.world.func_180501_a(pos, newState, 11);
            }
        }
        return false;
    }

    @Override
    public <TileEntityType extends ATileEntityBase<?>> TileEntityType getTileEntity(Point3D position) {
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z));
        return (TileEntityType)(tile instanceof BuilderTileEntity ? ((BuilderTileEntity)tile).tileEntity : null);
    }

    @Override
    public void markTileEntityChanged(Point3D position) {
        this.world.func_175625_s(new BlockPos(position.x, position.y, position.z)).func_70296_d();
    }

    @Override
    public float getLightBrightness(Point3D position, boolean calculateBlock) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        float darkenFactor = (float)(15 * this.world.func_175657_ab()) / 11.0f;
        float sunLight = ((float)this.world.func_226658_a_(LightType.SKY, pos) - darkenFactor) / 15.0f;
        float blockLight = calculateBlock ? (float)this.world.func_226658_a_(LightType.BLOCK, pos) / 15.0f : 0.0f;
        return Math.max(sunLight, blockLight);
    }

    @Override
    public void updateLightBrightness(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        this.world.func_225524_e_().func_215568_a(pos);
    }

    @Override
    public void destroyBlock(Point3D position, boolean spawnDrops) {
        this.world.func_175655_b(new BlockPos(position.x, position.y, position.z), spawnDrops);
    }

    @Override
    public boolean isAir(Point3D position) {
        return this.world.func_175623_d(new BlockPos(position.x, position.y, position.z));
    }

    @Override
    public boolean isFire(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        BlockState state = this.world.func_180495_p(pos);
        return state.func_185904_a().equals(Material.field_151581_o);
    }

    @Override
    public void setToFire(Point3D position, ABlockBase.Axis side) {
        BlockPos blockpos = new BlockPos(position.x, position.y, position.z).func_177972_a(Direction.valueOf((String)side.name()));
        if (this.world.func_175623_d(blockpos)) {
            this.world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    @Override
    public void extinguish(Point3D position, ABlockBase.Axis side) {
        BlockPos blockpos = new BlockPos(position.x, position.y, position.z).func_177972_a(Direction.valueOf((String)side.name()));
        if (this.world.func_180495_p(blockpos).func_235714_a_((ITag)BlockTags.field_232872_am_)) {
            this.world.func_217377_a(blockpos, false);
        }
    }

    @Override
    public boolean placeBlock(Point3D position, IWrapperItemStack stack) {
        ItemStack mcStack;
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        return this.world.func_175623_d(pos) && (mcStack = ((WrapperItemStack)stack).stack).func_196084_a(new ItemUseContext(this.world, null, Hand.MAIN_HAND, mcStack, new BlockRayTraceResult(new Vector3d(position.x, position.y, position.z), Direction.DOWN, pos, true))) == ActionResultType.CONSUME;
    }

    @Override
    public boolean fertilizeBlock(Point3D position, IWrapperItemStack stack) {
        IGrowable growable;
        BlockPos cropPos;
        BlockState cropState;
        Block cropBlock;
        ItemStack mcStack = ((WrapperItemStack)stack).stack;
        if (mcStack.func_77973_b() == Items.field_196106_bc && !this.world.field_72995_K && (cropBlock = (cropState = this.world.func_180495_p(cropPos = new BlockPos(position.x, position.y, position.z))).func_177230_c()) instanceof IGrowable && (growable = (IGrowable)cropState.func_177230_c()).func_176473_a((IBlockReader)this.world, cropPos, cropState, this.world.field_72995_K)) {
            growable.func_225535_a_((ServerWorld)this.world, this.world.field_73012_v, cropPos, cropState);
            return true;
        }
        return false;
    }

    @Override
    public List<IWrapperItemStack> harvestBlock(Point3D position) {
        ArrayList<IWrapperItemStack> cropDrops;
        block5: {
            BlockPos pos = new BlockPos(position.x, position.y, position.z);
            BlockState state = this.world.func_180495_p(pos);
            cropDrops = new ArrayList<IWrapperItemStack>();
            if ((!(state.func_177230_c() instanceof CropsBlock) || !((CropsBlock)state.func_177230_c()).func_185525_y(state)) && !(state.func_177230_c() instanceof BushBlock)) break block5;
            Block harvestedBlock = state.func_177230_c();
            this.world.func_184133_a(null, pos, harvestedBlock.getSoundType(state, (IWorldReader)this.world, pos, null).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!this.world.field_72995_K) {
                List drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)this.world), (BlockPos)pos, (TileEntity)this.world.func_175625_s(pos));
                this.world.func_217377_a(pos, false);
                if (harvestedBlock instanceof CropsBlock) {
                    for (ItemStack drop : drops) {
                        cropDrops.add(new WrapperItemStack(drop.func_77946_l()));
                    }
                } else {
                    for (ItemStack stack : drops) {
                        if (stack.func_190916_E() <= 0) continue;
                        this.world.func_217376_c((Entity)new ItemEntity(this.world, position.x, position.y, position.z, stack));
                    }
                }
            }
        }
        return cropDrops;
    }

    @Override
    public boolean plantBlock(Point3D position, IWrapperItemStack stack) {
        Block block;
        Item item = ((WrapperItemStack)stack).stack.func_77973_b();
        if (item instanceof BlockItem && (block = ((BlockItem)item).func_179223_d()) instanceof IPlantable) {
            BlockPos cropPos;
            IPlantable plantable = (IPlantable)block;
            BlockPos farmlandPos = new BlockPos(position.x, position.y, position.z);
            BlockState farmlandState = this.world.func_180495_p(farmlandPos);
            Block farmlandBlock = farmlandState.func_177230_c();
            if (farmlandBlock instanceof FarmlandBlock && this.world.func_175623_d(cropPos = farmlandPos.func_177984_a())) {
                BlockState plantState = plantable.getPlant((IBlockReader)this.world, cropPos);
                if (farmlandBlock.canSustainPlant(farmlandState, (IBlockReader)this.world, farmlandPos, Direction.UP, plantable)) {
                    this.world.func_180501_a(cropPos, plantState, 11);
                    this.world.func_184133_a(null, farmlandPos, plantState.func_177230_c().getSoundType(plantState, (IWorldReader)this.world, farmlandPos, null).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean plowBlock(Point3D position) {
        BlockState newState;
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        BlockState oldState = this.world.func_180495_p(pos);
        Block block = oldState.func_177230_c();
        if (block == Blocks.field_196658_i || block == Blocks.field_185774_da || block == Blocks.field_150346_d) {
            newState = Blocks.field_150458_ak.func_176223_P();
        } else if (block.equals(Blocks.field_196660_k)) {
            newState = Blocks.field_150346_d.func_176223_P();
        } else {
            return false;
        }
        this.world.func_180501_a(pos, newState, 11);
        this.world.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    @Override
    public boolean removeSnow(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        BlockState state = this.world.func_180495_p(pos);
        if (state.func_185904_a().equals(Material.field_151596_z) || state.func_185904_a().equals(Material.field_151597_y)) {
            this.world.func_217377_a(pos, false);
            this.world.func_184133_a(null, pos, SoundEvents.field_187807_fF, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean hydrateBlock(Point3D position) {
        int moisture;
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        BlockState state = this.world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150353_l) {
            if (this.world.func_204610_c(pos).func_206889_d()) {
                this.world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
                return true;
            }
            this.world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
            return true;
        }
        if (block instanceof ConcretePowderBlock) {
            this.world.func_175656_a(pos, ((ConcretePowderBlockMixin)block).getConcrete());
            return true;
        }
        if (block == Blocks.field_150458_ak && (moisture = ((Integer)state.func_177229_b((Property)FarmlandBlock.field_176531_a)).intValue()) < 7) {
            this.world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(7)));
            return true;
        }
        return false;
    }

    @Override
    public boolean insertStack(Point3D position, ABlockBase.Axis axis, IWrapperItemStack stack) {
        IItemHandler itemHandler;
        Direction facing = Direction.valueOf((String)axis.name());
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z).func_177972_a(facing));
        if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).orElse(null)) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack remainingStack = itemHandler.insertItem(i, ((WrapperItemStack)stack).stack, true);
                if (remainingStack.func_190916_E() >= stack.getSize()) continue;
                IWrapperItemStack stackToInsert = stack.split(1);
                itemHandler.insertItem(i, ((WrapperItemStack)stackToInsert).stack, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public WrapperItemStack extractStack(Point3D position, ABlockBase.Axis axis) {
        IItemHandler itemHandler;
        Direction facing = Direction.valueOf((String)axis.name());
        TileEntity tile = this.world.func_175625_s(new BlockPos(position.x, position.y, position.z).func_177972_a(facing));
        if (tile != null && (itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).orElse(null)) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack extractedStack = itemHandler.extractItem(i, 1, false);
                if (extractedStack.func_190926_b()) continue;
                return new WrapperItemStack(extractedStack);
            }
        }
        return null;
    }

    @Override
    public void spawnItemStack(IWrapperItemStack stack, Point3D point, Point3D optionalMotion) {
        ItemEntity item;
        if (optionalMotion != null) {
            item = new ItemEntity(this.world, point.x, point.y, point.z, ((WrapperItemStack)stack).stack);
            item.func_213317_d(new Vector3d(optionalMotion.x, optionalMotion.y, optionalMotion.z));
        } else {
            item = new ItemEntity(this.world, point.x, point.y + 1.0, point.z, ((WrapperItemStack)stack).stack);
        }
        this.world.func_217376_c((Entity)item);
    }

    @Override
    public void spawnExplosion(Point3D location, double strength, boolean flames) {
        this.world.func_217398_a(null, location.x, location.y, location.z, (float)strength, flames, Explosion.Mode.DESTROY);
    }

    public static AxisAlignedBB convert(BoundingBox box) {
        return new AxisAlignedBB(box.globalCenter.x - box.widthRadius, box.globalCenter.y - box.heightRadius, box.globalCenter.z - box.depthRadius, box.globalCenter.x + box.widthRadius, box.globalCenter.y + box.heightRadius, box.globalCenter.z + box.depthRadius);
    }

    public static AxisAlignedBB convertWithOffset(BoundingBox box, double x, double y, double z) {
        return new AxisAlignedBB(x + box.globalCenter.x - box.widthRadius, y + box.globalCenter.y - box.heightRadius, z + box.globalCenter.z - box.depthRadius, x + box.globalCenter.x + box.widthRadius, y + box.globalCenter.y + box.heightRadius, z + box.globalCenter.z + box.depthRadius);
    }

    @SubscribeEvent
    public void onIVWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.world.equals(this.world)) {
            if (event.phase.equals((Object)TickEvent.Phase.START)) {
                this.tickAll(true);
                for (PlayerEntity mcPlayer : event.world.func_217369_A()) {
                    BuilderEntityRenderForwarder followerBuilder;
                    UUID playerUUID = mcPlayer.func_110124_au();
                    BuilderEntityExisting gunBuilder = this.playerServerGunBuilders.get(playerUUID);
                    if (gunBuilder != null) {
                        if (gunBuilder.field_70170_p != mcPlayer.field_70170_p || !mcPlayer.func_70089_S() || !gunBuilder.entity.isValid || gunBuilder.idleTickCounter == 20) {
                            gunBuilder.func_70106_y();
                            this.playerServerGunBuilders.remove(playerUUID);
                            this.ticksSincePlayerJoin.remove(playerUUID);
                        } else {
                            ++gunBuilder.idleTickCounter;
                        }
                    }
                    if ((followerBuilder = playerFollowers.get(playerUUID)) != null) {
                        if (followerBuilder.field_70170_p != mcPlayer.field_70170_p || followerBuilder.playerFollowing != mcPlayer || !mcPlayer.func_70089_S() || !followerBuilder.func_70089_S() || followerBuilder.idleTickCounter == 20) {
                            followerBuilder.func_70106_y();
                            playerFollowers.remove(playerUUID);
                            this.ticksSincePlayerJoin.remove(playerUUID);
                            followerBuilder = null;
                        } else {
                            ++followerBuilder.idleTickCounter;
                        }
                    }
                    if (!mcPlayer.func_70089_S() || gunBuilder != null && followerBuilder != null) continue;
                    int totalTicksWaited = 0;
                    if (this.ticksSincePlayerJoin.containsKey(playerUUID)) {
                        totalTicksWaited = this.ticksSincePlayerJoin.get(playerUUID);
                    }
                    if (++totalTicksWaited == 60) {
                        WrapperPlayer playerWrapper = WrapperPlayer.getWrapperFor(mcPlayer);
                        if (gunBuilder == null) {
                            EntityPlayerGun entity = new EntityPlayerGun(this, playerWrapper, null);
                            this.playerServerGunBuilders.put(playerUUID, this.spawnEntityInternal(entity));
                        }
                        if (followerBuilder == null) {
                            followerBuilder = new BuilderEntityRenderForwarder(mcPlayer);
                            followerBuilder.loadedFromSavedNBT = true;
                            playerFollowers.put(playerUUID, followerBuilder);
                            this.world.func_217376_c((Entity)followerBuilder);
                        }
                        if (!((Boolean)ConfigSystem.settings.general.giveManualsOnJoin.value).booleanValue() || ((List)ConfigSystem.settings.general.joinedPlayers.value).contains(playerUUID)) continue;
                        playerWrapper.getInventory().addStack(((AItemBase)PackParser.getItem("mts", "handbook_car")).getNewStack(null));
                        playerWrapper.getInventory().addStack(((AItemBase)PackParser.getItem("mts", "handbook_plane")).getNewStack(null));
                        ((List)ConfigSystem.settings.general.joinedPlayers.value).add(playerUUID);
                        ConfigSystem.saveToDisk();
                        continue;
                    }
                    this.ticksSincePlayerJoin.put(playerUUID, totalTicksWaited);
                }
            } else {
                this.tickAll(false);
            }
        }
    }

    @SubscribeEvent
    public void onIVWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() == this.world) {
            for (AEntityA_Base entity : this.allEntities) {
                entity.remove();
            }
            worldWrappers.remove(this.world);
        }
    }
}

