/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.util.List;
import mcinterface1165.IBuilderItemInterface;
import mcinterface1165.WrapperNBT;
import mcinterface1165.WrapperWorld;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class WrapperItemStack
implements IWrapperItemStack {
    protected final ItemStack stack;

    protected WrapperItemStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean isCompleteMatch(IWrapperItemStack other) {
        ItemStack otherStack = ((WrapperItemStack)other).stack;
        return otherStack.func_77969_a(this.stack) && (otherStack.func_77942_o() ? otherStack.func_77978_p().equals((Object)this.stack.func_77978_p()) : !this.stack.func_77942_o());
    }

    @Override
    public int getFuelValue() {
        return ForgeHooks.getBurnTime((ItemStack)this.stack, null);
    }

    @Override
    public IWrapperItemStack getSmeltedItem(AWrapperWorld world) {
        World mcWorld = ((WrapperWorld)world).world;
        List results = mcWorld.func_199532_z().func_241447_a_(IRecipeType.field_222150_b);
        return new WrapperItemStack(results.isEmpty() ? ItemStack.field_190927_a : ((FurnaceRecipe)results.get(0)).func_77571_b());
    }

    @Override
    public int getSmeltingTime(AWrapperWorld world) {
        World mcWorld = ((WrapperWorld)world).world;
        return ((FurnaceRecipe)mcWorld.func_199532_z().func_241447_a_(IRecipeType.field_222150_b).get(0)).func_222137_e();
    }

    @Override
    public AItemBase getItem() {
        Item item = this.stack.func_77973_b();
        return item instanceof IBuilderItemInterface ? ((IBuilderItemInterface)item).getWrappedItem() : null;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.func_190926_b();
    }

    @Override
    public int getSize() {
        return this.stack.func_190916_E();
    }

    @Override
    public int getMaxSize() {
        return this.stack.func_77976_d();
    }

    @Override
    public int add(int qty) {
        if (qty < 0) {
            int amountToRemove = -qty;
            if (amountToRemove > this.getSize()) {
                amountToRemove = this.getSize();
            }
            this.stack.func_190920_e(this.stack.func_190916_E() - amountToRemove);
            return qty + amountToRemove;
        }
        int amountToAdd = qty;
        if (amountToAdd + this.getSize() > this.getMaxSize()) {
            amountToAdd = this.getMaxSize() - this.getSize();
        }
        this.stack.func_190920_e(this.stack.func_190916_E() + amountToAdd);
        return qty - amountToAdd;
    }

    @Override
    public IWrapperItemStack copy() {
        return new WrapperItemStack(this.stack.func_77946_l());
    }

    @Override
    public IWrapperItemStack split(int qty) {
        return new WrapperItemStack(this.stack.func_77979_a(qty));
    }

    @Override
    public boolean interactWith(EntityFluidTank tank, IWrapperPlayer player) {
        IFluidHandlerItem handler = (IFluidHandlerItem)this.stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
        if (handler != null) {
            if (!player.isSneaking()) {
                int amountToDrain;
                FluidStack drainedStack = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (drainedStack != null && (drainedStack = handler.drain(amountToDrain = (int)tank.fill(drainedStack.getFluid().getRegistryName().func_110623_a(), drainedStack.getAmount(), false), player.isCreative() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)) != null) {
                    tank.fill(drainedStack.getFluid().getRegistryName().func_110623_a(), drainedStack.getAmount(), true);
                    player.setHeldStack(new WrapperItemStack(handler.getContainer()));
                }
            } else {
                FluidStack containedStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tank.getFluid())), (int)tank.getFluidLevel());
                int amountFilled = handler.fill(containedStack, player.isCreative() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                if (amountFilled > 0) {
                    tank.drain(tank.getFluid(), amountFilled, true);
                    player.setHeldStack(new WrapperItemStack(handler.getContainer()));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public IWrapperNBT getData() {
        return this.stack.func_77942_o() ? new WrapperNBT(this.stack.func_77978_p().func_74737_b()) : null;
    }

    @Override
    public void setData(IWrapperNBT data) {
        this.stack.func_77982_d(data != null ? ((WrapperNBT)data).tag : null);
    }
}

