/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mcinterface1165.BuilderEntityLinkedSeat;
import mcinterface1165.WrapperNBT;
import mcinterface1165.WrapperPlayer;
import mcinterface1165.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.LeadItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WrapperEntity
implements IWrapperEntity {
    private static final Map<Entity, WrapperEntity> entityClientWrappers = new HashMap<Entity, WrapperEntity>();
    private static final Map<Entity, WrapperEntity> entityServerWrappers = new HashMap<Entity, WrapperEntity>();
    protected final Entity entity;
    private AEntityB_Existing cachedEntityRiding;
    private final Point3D mutablePosition = new Point3D();
    private final Point3D mutableVelocity = new Point3D();
    private final RotationMatrix mutableOrientation = new RotationMatrix();
    private float lastPitchChecked;
    private float lastYawChecked;
    private float lastYawApplied;
    private float lastPitch;
    private float lastYaw;
    private final Point3D mutableSight = new Point3D();
    private final BoundingBox mutableBounds = new BoundingBox(new Point3D(), 0.0, 0.0, 0.0);

    public static WrapperEntity getWrapperFor(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return WrapperPlayer.getWrapperFor((PlayerEntity)entity);
        }
        if (entity != null) {
            Map<Entity, WrapperEntity> entityWrappers = entity.field_70170_p.field_72995_K ? entityClientWrappers : entityServerWrappers;
            WrapperEntity wrapper = entityWrappers.get(entity);
            if (wrapper == null || !wrapper.isValid() || entity != wrapper.entity) {
                wrapper = new WrapperEntity(entity);
                entityWrappers.put(entity, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    protected WrapperEntity(Entity entity) {
        this.entity = entity;
    }

    public boolean equals(Object obj) {
        return this.entity.equals(obj instanceof WrapperEntity ? ((WrapperEntity)obj).entity : obj);
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    @Override
    public boolean isValid() {
        return this.entity != null && this.entity.func_70089_S();
    }

    @Override
    public UUID getID() {
        return this.entity.func_110124_au();
    }

    @Override
    public String getName() {
        return this.entity.func_200200_C_().getString();
    }

    @Override
    public AWrapperWorld getWorld() {
        return WrapperWorld.getWrapperFor(this.entity.field_70170_p);
    }

    @Override
    public AEntityB_Existing getEntityRiding() {
        AEntityB_Existing entityRiding;
        if (this.cachedEntityRiding != null) {
            return this.cachedEntityRiding;
        }
        Entity mcEntityRiding = this.entity.func_184187_bx();
        if (mcEntityRiding instanceof BuilderEntityLinkedSeat && (entityRiding = ((BuilderEntityLinkedSeat)mcEntityRiding).entity) != null && this.equals(entityRiding.rider)) {
            return entityRiding;
        }
        return null;
    }

    @Override
    public void setRiding(AEntityB_Existing entityToRide) {
        if (entityToRide != null) {
            AEntityB_Existing entityRiding = this.getEntityRiding();
            if (entityRiding == null) {
                if (!this.entity.field_70170_p.field_72995_K) {
                    BuilderEntityLinkedSeat seat = new BuilderEntityLinkedSeat((EntityType<? extends BuilderEntityLinkedSeat>)((EntityType)BuilderEntityLinkedSeat.E_TYPE3.get()), ((WrapperWorld)entityToRide.world).world);
                    seat.loadedFromSavedNBT = true;
                    seat.func_70107_b(entityToRide.position.x, entityToRide.position.y, entityToRide.position.z);
                    seat.entity = entityToRide;
                    this.entity.field_70170_p.func_217376_c((Entity)seat);
                    this.entity.func_184205_a((Entity)seat, true);
                }
            } else {
                ((BuilderEntityLinkedSeat)this.entity.func_184187_bx()).entity = entityToRide;
            }
            this.cachedEntityRiding = entityToRide;
        } else {
            this.entity.func_184210_p();
            this.cachedEntityRiding = null;
        }
    }

    @Override
    public double getVerticalScale() {
        PartSeat seat;
        AEntityB_Existing riding = this.getEntityRiding();
        if (riding instanceof PartSeat && (seat = (PartSeat)riding) != null) {
            if (seat.placementDefinition.playerScale != null) {
                if (((JSONPart)seat.definition).seat.playerScale != null) {
                    return seat.scale.y * seat.placementDefinition.playerScale.y * ((JSONPart)seat.definition).seat.playerScale.y;
                }
                return seat.scale.y * seat.placementDefinition.playerScale.y;
            }
            if (((JSONPart)seat.definition).seat.playerScale != null) {
                return seat.scale.y * ((JSONPart)seat.definition).seat.playerScale.y;
            }
            return seat.scale.y;
        }
        return 1.0;
    }

    @Override
    public double getSeatOffset() {
        AEntityB_Existing riding = this.getEntityRiding();
        if (riding instanceof PartSeat && !((JSONPart)((PartSeat)riding).definition).seat.standing) {
            if (this.entity instanceof AnimalEntity) {
                return this.entity.func_70033_W() - 0.14;
            }
            if (this.entity instanceof VillagerEntity) {
                return -0.703125;
            }
            ResourceLocation registration = this.entity.func_200600_R().getRegistryName();
            if (registration != null && registration.func_110624_b().equals("customnpcs")) {
                return -0.2;
            }
            return this.entity.func_70033_W();
        }
        return 0.0;
    }

    @Override
    public double getEyeHeight() {
        return this.entity.func_70047_e();
    }

    @Override
    public Point3D getPosition() {
        this.mutablePosition.set(this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_());
        return this.mutablePosition;
    }

    @Override
    public Point3D getEyePosition() {
        AEntityB_Existing riding = this.getEntityRiding();
        return riding != null ? riding.riderEyePosition : this.getPosition().add(0.0, this.getEyeHeight() + this.getSeatOffset(), 0.0);
    }

    @Override
    public Point3D getHeadPosition() {
        AEntityB_Existing riding = this.getEntityRiding();
        return riding != null ? riding.riderHeadPosition : this.getPosition().add(0.0, this.getEyeHeight() + this.getSeatOffset(), 0.0);
    }

    @Override
    public void setPosition(Point3D position, boolean onGround) {
        if (this.cachedEntityRiding != null) {
            this.entity.func_70107_b(position.x, position.y + this.getSeatOffset(), position.z);
        } else {
            this.entity.func_70107_b(position.x, position.y, position.z);
        }
        this.entity.field_70143_R = 0.0f;
        this.entity.func_230245_c_(onGround);
    }

    @Override
    public void applyMotion(Point3D motion) {
        this.entity.func_213317_d(this.entity.func_213322_ci().func_72441_c(motion.x, motion.y, motion.z));
    }

    @Override
    public Point3D getVelocity() {
        this.mutableVelocity.set(this.entity.func_213322_ci().field_72450_a, this.entity.func_233570_aj_() ? 0.0 : this.entity.func_213322_ci().field_72448_b, this.entity.func_213322_ci().field_72449_c);
        return this.mutableVelocity;
    }

    @Override
    public void setVelocity(Point3D motion) {
        this.entity.func_213293_j(motion.x, motion.y, motion.z);
    }

    @Override
    public RotationMatrix getOrientation() {
        if (this.lastPitchChecked != this.entity.field_70125_A || this.lastYawChecked != this.entity.field_70177_z) {
            this.lastPitchChecked = this.entity.field_70125_A;
            this.lastYawChecked = this.entity.field_70177_z;
            this.mutableOrientation.angles.set(this.entity.field_70125_A, -this.entity.field_70177_z, 0.0);
            this.mutableOrientation.setToAngles(this.mutableOrientation.angles);
        }
        return this.mutableOrientation;
    }

    @Override
    public void setOrientation(RotationMatrix rotation) {
        if (this.entity.field_70170_p.field_72995_K) {
            float yawDelta = ((float)(-rotation.angles.y) - this.lastYawApplied) % 360.0f;
            if (yawDelta > 180.0f) {
                yawDelta -= 360.0f;
            } else if (yawDelta < -180.0f) {
                yawDelta -= 360.0f;
            }
            this.lastYawApplied = this.entity.field_70177_z = this.lastYawApplied + yawDelta;
        } else {
            this.entity.field_70177_z = (float)(-rotation.angles.y);
        }
        this.entity.field_70125_A = (float)rotation.angles.x;
    }

    @Override
    public float getPitch() {
        return this.entity.field_70125_A;
    }

    @Override
    public float getPitchDelta() {
        float value = this.entity.field_70125_A - this.lastPitch;
        this.lastPitch = this.entity.field_70125_A;
        return value;
    }

    @Override
    public float getYaw() {
        return -this.entity.field_70177_z;
    }

    @Override
    public float getYawDelta() {
        float value = this.entity.field_70177_z - this.lastYaw;
        this.lastYaw = this.entity.field_70177_z;
        return -value;
    }

    @Override
    public float getBodyYaw() {
        return this.entity instanceof LivingEntity ? -((LivingEntity)this.entity).field_70761_aq : 0.0f;
    }

    @Override
    public Point3D getLineOfSight(double distance) {
        this.mutableSight.set(0.0, 0.0, distance).rotate(this.getOrientation());
        return this.mutableSight;
    }

    @Override
    public void setYaw(double yaw) {
        this.entity.field_70177_z = (float)(-yaw);
    }

    @Override
    public void setBodyYaw(double yaw) {
        if (this.entity instanceof LivingEntity) {
            this.entity.func_181013_g((float)(-yaw));
        }
    }

    @Override
    public void setPitch(double pitch) {
        this.entity.field_70125_A = (float)pitch;
    }

    @Override
    public BoundingBox getBounds() {
        this.mutableBounds.widthRadius = this.entity.func_213311_cf() / 2.0f;
        this.mutableBounds.heightRadius = this.entity.func_213302_cg() / 2.0f;
        this.mutableBounds.depthRadius = this.entity.func_213311_cf() / 2.0f;
        this.mutableBounds.globalCenter.set(this.entity.func_226277_ct_(), this.entity.func_226278_cu_() + this.mutableBounds.heightRadius, this.entity.func_226281_cx_());
        return this.mutableBounds;
    }

    @Override
    public IWrapperNBT getData() {
        CompoundNBT tag = new CompoundNBT();
        this.entity.func_70039_c(tag);
        return new WrapperNBT(tag);
    }

    @Override
    public void setData(IWrapperNBT data) {
        this.entity.func_70020_e(((WrapperNBT)data).tag);
    }

    @Override
    public boolean leashTo(IWrapperPlayer player) {
        PlayerEntity mcPlayer = ((WrapperPlayer)player).player;
        if (this.entity instanceof MobEntity) {
            ItemStack heldStack = mcPlayer.func_184614_ca();
            if (((MobEntity)this.entity).func_184652_a(mcPlayer) && heldStack.func_77973_b() instanceof LeadItem) {
                ((MobEntity)this.entity).func_110162_b((Entity)mcPlayer, true);
                if (!mcPlayer.func_184812_l_()) {
                    heldStack.func_190918_g(1);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void attack(final Damage damage) {
        if (damage.language == null) {
            throw new IllegalArgumentException("ERROR: Cannot attack an entity with a damage of no type and language component!");
        }
        EntityDamageSource newSource = new EntityDamageSource(damage.language.getCurrentValue(), damage.entityResponsible != null ? ((WrapperEntity)damage.entityResponsible).entity : null){

            public ITextComponent func_151519_b(LivingEntity player) {
                if (damage.entityResponsible != null) {
                    return new StringTextComponent(String.format(damage.language.getCurrentValue(), player.func_145748_c_().getString(), ((WrapperEntity)damage.entityResponsible).entity.func_145748_c_().getString()));
                }
                return new StringTextComponent(String.format(damage.language.getCurrentValue(), player.func_145748_c_().getString()));
            }
        };
        if (damage.isFire) {
            newSource.func_76361_j();
            this.entity.func_241209_g_(5);
        }
        if (damage.knockback != null) {
            this.applyMotion(damage.knockback);
        }
        if (damage.isWater) {
            this.entity.func_70066_B();
            return;
        }
        if (damage.isExplosion) {
            newSource.func_94540_d();
        }
        if (damage.ignoreArmor) {
            newSource.func_76348_h();
        }
        if (damage.ignoreCooldown && this.entity instanceof LivingEntity) {
            this.entity.field_70172_ad = 0;
        }
        if (((Boolean)ConfigSystem.settings.damage.creativePlayerDamage.value).booleanValue()) {
            newSource.func_76359_i();
        }
        this.entity.func_70097_a((DamageSource)newSource, (float)damage.amount);
        if (damage.effects != null) {
            damage.effects.forEach(effect -> this.addPotionEffect((JSONPotionEffect)effect));
        }
    }

    @Override
    public void addPotionEffect(JSONPotionEffect effect) {
        if (this.entity instanceof LivingEntity) {
            Potion potion = Potion.func_185168_a((String)effect.name);
            if (potion != null) {
                potion.func_185170_a().forEach(mcEffect -> ((LivingEntity)this.entity).func_195064_c(new EffectInstance(mcEffect.func_188419_a(), effect.duration, effect.amplifier, false, false)));
            } else {
                throw new NullPointerException("Potion " + effect.name + " does not exist.");
            }
        }
    }

    @Override
    public void removePotionEffect(JSONPotionEffect effect) {
        if (this.entity instanceof LivingEntity) {
            Potion potion = Potion.func_185168_a((String)effect.name);
            if (potion != null) {
                potion.func_185170_a().forEach(mcEffect -> ((LivingEntity)this.entity).func_195063_d(mcEffect.func_188419_a()));
            } else {
                throw new NullPointerException("Potion " + effect.name + " does not exist.");
            }
        }
    }

    @SubscribeEvent
    public static void onIVWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            entityClientWrappers.keySet().removeIf(entity1 -> event.getWorld() == entity1.field_70170_p);
        } else {
            entityServerWrappers.keySet().removeIf(entity1 -> event.getWorld() == entity1.field_70170_p);
        }
    }
}

