/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class WrapperAABBCollective
extends AxisAlignedBB {
    private final AEntityE_Interactable<?> interactable;
    private final boolean collision;
    private final Set<BoundingBox> boxes = new HashSet<BoundingBox>();

    public WrapperAABBCollective(AEntityE_Interactable<?> interactable, boolean collision) {
        super(interactable.encompassingBox.globalCenter.x - interactable.encompassingBox.widthRadius, interactable.encompassingBox.globalCenter.y - interactable.encompassingBox.heightRadius, interactable.encompassingBox.globalCenter.z - interactable.encompassingBox.depthRadius, interactable.encompassingBox.globalCenter.x + interactable.encompassingBox.widthRadius, interactable.encompassingBox.globalCenter.y + interactable.encompassingBox.heightRadius, interactable.encompassingBox.globalCenter.z + interactable.encompassingBox.depthRadius);
        this.interactable = interactable;
        this.collision = collision;
    }

    public synchronized Set<BoundingBox> getBoxes() {
        if (this.boxes.isEmpty()) {
            (this.interactable instanceof AEntityF_Multipart ? ((AEntityF_Multipart)this.interactable).allCollisionBoxes : this.interactable.collisionBoxes).forEach(box -> {
                if (this.collision) {
                    if (box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.ENTITY)) {
                        this.boxes.add((BoundingBox)box);
                    }
                } else if (box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.ATTACK) || box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.CLICK)) {
                    this.boxes.add((BoundingBox)box);
                }
            });
        }
        return this.boxes;
    }

    public WrapperAABBCollective inflate(double value) {
        return this;
    }

    public boolean func_186668_a(double otherMinX, double otherMinY, double otherMinZ, double otherMaxX, double otherMaxY, double otherMaxZ) {
        if (super.func_186668_a(otherMinX, otherMinY, otherMinZ, otherMaxX, otherMaxY, otherMaxZ)) {
            for (BoundingBox testBox : this.getBoxes()) {
                if (!(otherMaxX > testBox.globalCenter.x - testBox.widthRadius) || !(otherMinX < testBox.globalCenter.x + testBox.widthRadius) || !(otherMaxY > testBox.globalCenter.y - testBox.heightRadius) || !(otherMinY < testBox.globalCenter.y + testBox.heightRadius) || !(otherMaxZ > testBox.globalCenter.z - testBox.depthRadius) || !(otherMinZ < testBox.globalCenter.z + testBox.depthRadius)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_72318_a(Vector3d vec) {
        return this.func_186668_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Optional<Vector3d> func_216365_b(Vector3d vecA, Vector3d vecB) {
        Point3D start = new Point3D(vecA.field_72450_a, vecA.field_72448_b, vecA.field_72449_c);
        Point3D end = new Point3D(vecB.field_72450_a, vecB.field_72448_b, vecB.field_72449_c);
        BoundingBoxHitResult intersection = null;
        for (BoundingBox testBox : this.getBoxes()) {
            BoundingBoxHitResult testIntersection = testBox.getIntersection(start, end);
            if (testIntersection == null || intersection != null && !start.isFirstCloserThanSecond(testIntersection.position, intersection.position)) continue;
            intersection = testIntersection;
        }
        if (intersection != null) {
            return Optional.of(new Vector3d(intersection.position.x, intersection.position.y, intersection.position.z));
        }
        return Optional.empty();
    }

    public Vector3d getCollision(Vector3d movement, AxisAlignedBB testBox) {
        double x = movement.field_72450_a != 0.0 ? this.calculateXOffset(testBox, movement.field_72450_a) : 0.0;
        double y = movement.field_72448_b != 0.0 ? this.calculateYOffset(testBox, movement.field_72448_b) : 0.0;
        double z = movement.field_72449_c != 0.0 ? this.calculateZOffset(testBox, movement.field_72449_c) : 0.0;
        return new Vector3d(x, y, z);
    }

    private double calculateXOffset(AxisAlignedBB box, double offset) {
        for (BoundingBox testBox : this.getBoxes()) {
            double collisionDepth;
            if (!(box.field_72337_e > testBox.globalCenter.y - testBox.heightRadius) || !(box.field_72338_b < testBox.globalCenter.y + testBox.heightRadius) || !(box.field_72334_f > testBox.globalCenter.z - testBox.depthRadius) || !(box.field_72339_c < testBox.globalCenter.z + testBox.depthRadius)) continue;
            if (offset > 0.0) {
                collisionDepth = testBox.globalCenter.x - testBox.widthRadius - box.field_72336_d;
                if (!(collisionDepth >= 0.0) || !(collisionDepth < offset)) continue;
                offset = collisionDepth;
                continue;
            }
            if (!(offset < 0.0) || !((collisionDepth = testBox.globalCenter.x + testBox.widthRadius - box.field_72340_a) <= 0.0) || !(collisionDepth > offset)) continue;
            offset = collisionDepth;
        }
        return offset;
    }

    private double calculateYOffset(AxisAlignedBB box, double offset) {
        for (BoundingBox testBox : this.getBoxes()) {
            double collisionDepth;
            if (!(box.field_72336_d > testBox.globalCenter.x - testBox.widthRadius) || !(box.field_72340_a < testBox.globalCenter.x + testBox.widthRadius) || !(box.field_72334_f > testBox.globalCenter.z - testBox.depthRadius) || !(box.field_72339_c < testBox.globalCenter.z + testBox.depthRadius)) continue;
            if (offset > 0.0) {
                collisionDepth = testBox.globalCenter.y - testBox.heightRadius - box.field_72337_e;
                if (!(collisionDepth >= 0.0) || !(collisionDepth < offset)) continue;
                offset = collisionDepth;
                continue;
            }
            if (!(offset < 0.0) || !((collisionDepth = testBox.globalCenter.y + testBox.heightRadius - box.field_72338_b) <= 0.0) || !(collisionDepth > offset)) continue;
            offset = collisionDepth;
        }
        return offset;
    }

    private double calculateZOffset(AxisAlignedBB box, double offset) {
        for (BoundingBox testBox : this.getBoxes()) {
            double collisionDepth;
            if (!(box.field_72336_d > testBox.globalCenter.x - testBox.widthRadius) || !(box.field_72340_a < testBox.globalCenter.x + testBox.widthRadius) || !(box.field_72337_e > testBox.globalCenter.y - testBox.heightRadius) || !(box.field_72338_b < testBox.globalCenter.y + testBox.heightRadius)) continue;
            if (offset > 0.0) {
                collisionDepth = testBox.globalCenter.z - testBox.depthRadius - box.field_72334_f;
                if (!(collisionDepth >= 0.0) || !(collisionDepth < offset)) continue;
                offset = collisionDepth;
                continue;
            }
            if (!(offset < 0.0) || !((collisionDepth = testBox.globalCenter.z + testBox.depthRadius - box.field_72339_c) <= 0.0) || !(collisionDepth > offset)) continue;
            offset = collisionDepth;
        }
        return offset;
    }
}

