/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import mcinterface1165.ABuilderEntityBase;
import mcinterface1165.BuilderEntityExisting;
import mcinterface1165.BuilderEntityLinkedSeat;
import mcinterface1165.BuilderEntityRenderForwarder;
import mcinterface1165.WrapperItemStack;
import mcinterface1165.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IInterfaceRender;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.GIFParser;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.LightType;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class InterfaceRender
implements IInterfaceRender {
    private static final Map<String, ResourceLocation> onlineTextures = new HashMap<String, ResourceLocation>();
    private static final Map<String, GIFParser.ParsedGIF> animatedGIFs = new HashMap<String, GIFParser.ParsedGIF>();
    private static final Map<GIFParser.ParsedGIF, Map<GIFParser.GIFImageFrame, ResourceLocation>> animatedGIFFrames = new LinkedHashMap<GIFParser.ParsedGIF, Map<GIFParser.GIFImageFrame, ResourceLocation>>();
    private static final List<GUIComponentItem> stacksToRender = new ArrayList<GUIComponentItem>();
    private static final Map<String, RenderType> renderTypes = new HashMap<String, RenderType>();
    private static final Map<RenderableData, BufferData> buffers = new HashMap<RenderableData, BufferData>();
    private static final Map<RenderType, List<RenderData>> queuedRenders = new HashMap<RenderType, List<RenderData>>();
    private static final ConcurrentLinkedQueue<BufferData> removedRenders = new ConcurrentLinkedQueue();
    private static RenderState.TextureState MISSING_STATE;
    private static RenderState.TextureState BLOCK_STATE;
    private static MatrixStack matrixStack;
    private static IRenderTypeBuffer renderBuffer;
    public static Point3D renderCameraOffset;
    private static boolean renderingGUI;
    private static float[] matrixConvertArray;
    private static final RenderState.TransparencyState PROPER_TRANSLUCENT_TRANSPARENCY;
    private static final RenderState.TransparencyState BRIGHTNESS_TRANSPARENCY;

    @Override
    public float[] getBlockBreakTexture(AWrapperWorld world, Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        BlockState state = ((WrapperWorld)world).world.func_180495_p(pos);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().getTexture(state, ((WrapperWorld)world).world, pos);
        return new float[]{sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h()};
    }

    @Override
    public float[] getDefaultBlockTexture(String name) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_229356_a_(AtlasTexture.field_110575_b).func_195424_a(new ResourceLocation(name.replace(":", ":blocks/")));
        return new float[]{sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h()};
    }

    @Override
    public InputStream getTextureStream(String name) {
        try {
            String domain = name.substring("/assets/".length(), name.indexOf("/", "/assets/".length()));
            String location = name.substring("/assets/".length() + domain.length() + 1);
            return Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(domain, location)).func_199027_b();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void renderItemModel(GUIComponentItem component) {
        stacksToRender.add(component);
    }

    @Override
    public void renderVertices(RenderableData data, boolean changedSinceLastRender) {
        matrixStack.func_227860_a_();
        Matrix4f matrix4f = InterfaceRender.convertMatrix4f(data.transform);
        MatrixStack.Entry stackEntry = matrixStack.func_227866_c_();
        stackEntry.func_227870_a_().func_226595_a_(matrix4f);
        if (data.vertexObject.isLines) {
            IVertexBuilder buffer = renderBuffer.getBuffer(RenderType.func_228659_m_());
            while (data.vertexObject.vertices.hasRemaining()) {
                buffer.func_227888_a_(stackEntry.func_227870_a_(), data.vertexObject.vertices.get(), data.vertexObject.vertices.get(), data.vertexObject.vertices.get());
                buffer.func_227885_a_(data.color.red, data.color.green, data.color.blue, data.alpha);
                buffer.func_181675_d();
            }
            data.vertexObject.vertices.rewind();
        } else {
            String typeID = data.texture + data.isTranslucent + (Object)((Object)data.lightingMode) + data.enableBrightBlending;
            if (data.vertexObject.cacheVertices && !renderingGUI) {
                List<RenderData> renders;
                RenderType renderType = renderTypes.computeIfAbsent(typeID, k -> CustomRenderType.func_228633_a_((String)"mts_entity", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)0x200000, (boolean)true, (boolean)data.isTranslucent, (RenderType.State)CustomRenderType.createForObject(data).func_228728_a_(false)));
                BufferData buffer = buffers.computeIfAbsent(data, k -> new BufferData(renderType, data));
                if (changedSinceLastRender) {
                    buffer.builder.func_178965_a();
                    buffer.isReady = false;
                }
                if (!buffer.isReady) {
                    int index = 0;
                    buffer.builder.func_181668_a(7, renderType.func_228663_p_());
                    while (data.vertexObject.vertices.hasRemaining()) {
                        float normalX = data.vertexObject.vertices.get();
                        float normalY = data.vertexObject.vertices.get();
                        float normalZ = data.vertexObject.vertices.get();
                        float texU = data.vertexObject.vertices.get();
                        float texV = data.vertexObject.vertices.get();
                        float posX = data.vertexObject.vertices.get();
                        float posY = data.vertexObject.vertices.get();
                        float posZ = data.vertexObject.vertices.get();
                        do {
                            buffer.builder.func_225588_a_(posX, posY, posZ, data.color.red, data.color.green, data.color.blue, data.alpha, texU, texV, OverlayTexture.field_229196_a_, data.worldLightValue, normalX, normalY, normalZ);
                        } while (++index == 3);
                        if (index != 4) continue;
                        index = 0;
                    }
                    buffer.isReady = true;
                    buffer.builder.func_178977_d();
                    buffer.buffer.func_227875_a_(buffer.builder);
                    data.vertexObject.vertices.rewind();
                }
                if ((renders = queuedRenders.get(renderType)) == null) {
                    renders = new ArrayList<RenderData>();
                    queuedRenders.put(renderType, renders);
                }
                renders.add(new RenderData(stackEntry.func_227870_a_(), buffer.buffer));
            } else {
                RenderType renderType = renderTypes.computeIfAbsent(typeID, k -> CustomRenderType.func_228633_a_((String)"mts_entity", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)data.isTranslucent, (RenderType.State)CustomRenderType.createForObject(data).func_228728_a_(false)));
                IVertexBuilder buffer = renderBuffer.getBuffer(renderType);
                int index = 0;
                while (data.vertexObject.vertices.hasRemaining()) {
                    float normalX = data.vertexObject.vertices.get();
                    float normalY = data.vertexObject.vertices.get();
                    float normalZ = data.vertexObject.vertices.get();
                    float texU = data.vertexObject.vertices.get();
                    float texV = data.vertexObject.vertices.get();
                    float posX = data.vertexObject.vertices.get();
                    float posY = data.vertexObject.vertices.get();
                    float posZ = data.vertexObject.vertices.get();
                    do {
                        buffer.func_227888_a_(stackEntry.func_227870_a_(), posX, posY, posZ);
                        buffer.func_227885_a_(data.color.red, data.color.green, data.color.blue, data.alpha);
                        buffer.func_225583_a_(texU, texV);
                        buffer.func_227891_b_(OverlayTexture.field_229196_a_);
                        buffer.func_227886_a_(data.worldLightValue);
                        buffer.func_227887_a_(stackEntry.func_227872_b_(), normalX, normalY, normalZ);
                        buffer.func_181675_d();
                    } while (++index == 3);
                    if (index != 4) continue;
                    index = 0;
                }
                data.vertexObject.vertices.rewind();
            }
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public void deleteVertices(RenderableData data) {
        BufferData buffer;
        if (data.vertexObject.cacheVertices && (buffer = buffers.remove(data)) != null) {
            removedRenders.add(buffer);
        }
    }

    @Override
    public int getLightingAtPosition(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        return LightTexture.func_228451_a_((int)Minecraft.func_71410_x().field_71441_e.func_226658_a_(LightType.BLOCK, pos), (int)Minecraft.func_71410_x().field_71441_e.func_226658_a_(LightType.SKY, pos));
    }

    @Override
    public boolean shouldRenderBoundingBoxes() {
        return Minecraft.func_71410_x().func_175598_ae().func_178634_b();
    }

    @Override
    public boolean bindURLTexture(String textureURL, InputStream stream) {
        if (stream != null) {
            try {
                NativeImage image = NativeImage.func_211679_a((NativeImage.PixelFormat)NativeImage.PixelFormat.RGB, (InputStream)stream);
                DynamicTexture texture = new DynamicTexture(image);
                ResourceLocation textureLocation = Minecraft.func_71410_x().field_71446_o.func_110578_a("mts-url", texture);
                onlineTextures.put(textureURL, textureLocation);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        onlineTextures.put(textureURL, null);
        return true;
    }

    @Override
    public boolean bindURLGIF(String textureURL, GIFParser.ParsedGIF gif) {
        HashMap<GIFParser.GIFImageFrame, ResourceLocation> gifFrameIndexes = new HashMap<GIFParser.GIFImageFrame, ResourceLocation>();
        for (GIFParser.GIFImageFrame frame : gif.frames.values()) {
            try {
                BufferedImage frameBuffer = frame.getImage();
                ByteArrayOutputStream frameArrayStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)frameBuffer, "gif", frameArrayStream);
                ByteArrayInputStream frameStream = new ByteArrayInputStream(frameArrayStream.toByteArray());
                NativeImage image = NativeImage.func_211679_a((NativeImage.PixelFormat)NativeImage.PixelFormat.RGB, (InputStream)frameStream);
                DynamicTexture texture = new DynamicTexture(image);
                ResourceLocation textureLocation = Minecraft.func_71410_x().field_71446_o.func_110578_a("mts-gif", texture);
                gifFrameIndexes.put(frame, textureLocation);
            }
            catch (Exception e) {
                return false;
            }
        }
        animatedGIFs.put(textureURL, gif);
        animatedGIFFrames.put(gif, gifFrameIndexes);
        return true;
    }

    private static RenderState.TextureState getTexture(String textureLocation) {
        if (MISSING_STATE == null) {
            MISSING_STATE = new RenderState.TextureState(new ResourceLocation("mts:textures/rendering/missing.png"), false, false);
            BLOCK_STATE = new RenderState.TextureState(PlayerContainer.field_226615_c_, false, false);
        }
        if (animatedGIFs.containsKey(textureLocation)) {
            GIFParser.ParsedGIF parsedGIF = animatedGIFs.get(textureLocation);
            return new RenderState.TextureState(animatedGIFFrames.get(parsedGIF).get(parsedGIF.getCurrentFrame()), false, false);
        }
        if (onlineTextures.containsKey(textureLocation)) {
            ResourceLocation onlineTexture = onlineTextures.get(textureLocation);
            return onlineTexture != null ? new RenderState.TextureState(onlineTextures.get(textureLocation), false, false) : MISSING_STATE;
        }
        if (textureLocation.equals("GLOBAL")) {
            return BLOCK_STATE;
        }
        String formattedLocation = textureLocation;
        if (textureLocation.contains(":")) {
            formattedLocation = "/assets/" + textureLocation.replace(":", "/");
        }
        if (InterfaceManager.coreInterface.getPackResource(formattedLocation) != null) {
            String domain = formattedLocation.substring("/assets/".length(), formattedLocation.indexOf("/", "/assets/".length()));
            String location = formattedLocation.substring("/assets/".length() + domain.length() + 1);
            return new RenderState.TextureState(new ResourceLocation(domain, location), false, false);
        }
        InterfaceManager.coreInterface.logError("Could not find texture: " + formattedLocation + " Reverting to fallback texture.");
        return MISSING_STATE;
    }

    protected static void renderGUI(MatrixStack stack, int mouseX, int mouseY, int screenWidth, int screenHeight, float partialTicks, boolean updateGUIs) {
        matrixStack = stack;
        matrixStack.func_227860_a_();
        renderingGUI = true;
        IRenderTypeBuffer.Impl guiBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        renderBuffer = guiBuffer;
        matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
        int displayGUIIndex = 0;
        for (AGUIBase gui : AGUIBase.activeGUIs) {
            if (updateGUIs || gui.components.isEmpty()) {
                gui.setupComponentsInit(screenWidth, screenHeight);
            }
            matrixStack.func_227860_a_();
            if (gui.capturesPlayer()) {
                matrixStack.func_227861_a_(0.0, 0.0, 250.0);
            } else {
                matrixStack.func_227861_a_(0.0, 0.0, (double)(-500 + 250 * displayGUIIndex++));
            }
            gui.render(mouseX, mouseY, false, partialTicks);
            guiBuffer.func_228461_a_();
            RenderSystem.enableBlend();
            gui.render(mouseX, mouseY, true, partialTicks);
            guiBuffer.func_228461_a_();
            RenderSystem.disableBlend();
            matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
            for (GUIComponentItem component : stacksToRender) {
                if ((WrapperItemStack)component.stackToRender == null) continue;
                float zOffset = Minecraft.func_71410_x().func_175599_af().field_77023_b;
                Minecraft.func_71410_x().func_175599_af().field_77023_b = (float)(200.0 + component.translation.z - 100.0);
                if ((double)component.scale != 1.0) {
                    RenderSystem.pushMatrix();
                    RenderSystem.scalef((float)component.scale, (float)component.scale, (float)1.0f);
                    Minecraft.func_71410_x().func_175599_af().func_175042_a(((WrapperItemStack)component.stackToRender).stack, (int)(component.translation.x / (double)component.scale), (int)(-component.translation.y / (double)component.scale) + 1);
                    RenderSystem.popMatrix();
                } else {
                    Minecraft.func_71410_x().func_175599_af().func_175042_a(((WrapperItemStack)component.stackToRender).stack, (int)component.translation.x, (int)(-component.translation.y));
                }
                Minecraft.func_71410_x().func_175599_af().field_77023_b = zOffset;
            }
            stacksToRender.clear();
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        renderingGUI = false;
    }

    protected static Matrix4f convertMatrix4f(TransformationMatrix transform) {
        InterfaceRender.matrixConvertArray[0] = (float)transform.m00;
        InterfaceRender.matrixConvertArray[1] = (float)transform.m01;
        InterfaceRender.matrixConvertArray[2] = (float)transform.m02;
        InterfaceRender.matrixConvertArray[3] = (float)transform.m03;
        InterfaceRender.matrixConvertArray[4] = (float)transform.m10;
        InterfaceRender.matrixConvertArray[5] = (float)transform.m11;
        InterfaceRender.matrixConvertArray[6] = (float)transform.m12;
        InterfaceRender.matrixConvertArray[7] = (float)transform.m13;
        InterfaceRender.matrixConvertArray[8] = (float)transform.m20;
        InterfaceRender.matrixConvertArray[9] = (float)transform.m21;
        InterfaceRender.matrixConvertArray[10] = (float)transform.m22;
        InterfaceRender.matrixConvertArray[11] = (float)transform.m23;
        InterfaceRender.matrixConvertArray[12] = (float)transform.m30;
        InterfaceRender.matrixConvertArray[13] = (float)transform.m31;
        InterfaceRender.matrixConvertArray[14] = (float)transform.m32;
        InterfaceRender.matrixConvertArray[15] = (float)transform.m33;
        return new Matrix4f(matrixConvertArray);
    }

    public static void registerRenderer(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)BuilderEntityRenderForwarder.E_TYPE4.get()), manager -> new EntityRenderer<BuilderEntityRenderForwarder>(manager){

            public ResourceLocation getTextureLocation(BuilderEntityRenderForwarder builder) {
                return null;
            }

            public boolean shouldRender(BuilderEntityRenderForwarder builder, ClippingHelper camera, double camX, double camY, double camZ) {
                return true;
            }

            public void render(BuilderEntityRenderForwarder builder, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int packedLight) {
                if (builder.playerFollowing == Minecraft.func_71410_x().field_71439_g && !((Boolean)ConfigSystem.settings.general.forceRenderLastSolid.value).booleanValue()) {
                    renderCameraOffset.set(MathHelper.func_219803_d((double)partialTicks, (double)builder.field_70142_S, (double)builder.func_226277_ct_()), MathHelper.func_219803_d((double)partialTicks, (double)builder.field_70137_T, (double)builder.func_226278_cu_()), MathHelper.func_219803_d((double)partialTicks, (double)builder.field_70136_U, (double)builder.func_226281_cx_()));
                    InterfaceRender.doRenderCall(stack, buffer, false, partialTicks);
                }
            }
        });
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)BuilderEntityExisting.E_TYPE2.get()), manager -> new BlankRender(manager));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)BuilderEntityLinkedSeat.E_TYPE3.get()), manager -> new BlankRender(manager));
    }

    public static void doRenderCall(MatrixStack stack, IRenderTypeBuffer buffer, boolean blendingEnabled, float partialTicks) {
        matrixStack = stack;
        renderBuffer = buffer;
        AWrapperWorld world = InterfaceManager.clientInterface.getClientWorld();
        ConcurrentLinkedQueue allEntities = world.renderableEntities;
        if (allEntities != null) {
            world.beginProfiling("MTSRendering_Setup", true);
            for (AEntityC_Renderable entity : allEntities) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(entity.position.x - InterfaceRender.renderCameraOffset.x, entity.position.y - InterfaceRender.renderCameraOffset.y, entity.position.z - InterfaceRender.renderCameraOffset.z);
                entity.render(blendingEnabled, partialTicks);
                matrixStack.func_227865_b_();
            }
            if (renderBuffer instanceof IRenderTypeBuffer.Impl) {
                ((IRenderTypeBuffer.Impl)renderBuffer).func_228461_a_();
            }
            world.beginProfiling("MTSRendering_Execution", false);
            InterfaceRender.renderBuffers();
            world.endProfiling();
        }
    }

    private static void renderBuffers() {
        for (Map.Entry<RenderType, List<RenderData>> renderEntry : queuedRenders.entrySet()) {
            RenderType renderType = renderEntry.getKey();
            List<RenderData> datas = renderEntry.getValue();
            if (datas.isEmpty()) continue;
            renderType.func_228547_a_();
            for (RenderData data : datas) {
                data.buffer.func_177359_a();
                renderType.func_228663_p_().func_227892_a_(0L);
                data.buffer.func_227874_a_(data.matrix, 7);
            }
            renderType.func_228663_p_().func_227895_d_();
            renderType.func_228549_b_();
            datas.clear();
        }
        VertexBuffer.func_177361_b();
        if (!removedRenders.isEmpty()) {
            removedRenders.forEach(render -> render.buffer.close());
            removedRenders.clear();
        }
    }

    static {
        renderCameraOffset = new Point3D();
        matrixConvertArray = new float[16];
        PROPER_TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("proper_translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
        });
        BRIGHTNESS_TRANSPARENCY = new RenderState.TransparencyState("brightness_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
        });
    }

    private static class BufferData {
        final BufferBuilder builder;
        final VertexBuffer buffer;
        boolean isReady;

        private BufferData() {
            this.builder = null;
            this.buffer = null;
        }

        private BufferData(RenderType type, RenderableData data) {
            int vertices = data.vertexObject.vertices.limit() / 8;
            vertices = (vertices / 3 + 1) * 4;
            this.builder = new BufferBuilder(type.func_228663_p_().func_181719_f() * vertices);
            this.buffer = new VertexBuffer(type.func_228663_p_());
        }
    }

    private static class RenderData {
        private final Matrix4f matrix;
        private final VertexBuffer buffer;

        private RenderData(Matrix4f matrix, VertexBuffer buffer) {
            this.matrix = new Matrix4f(matrix);
            this.buffer = buffer;
        }
    }

    private static class BlankRender<T extends ABuilderEntityBase>
    extends EntityRenderer<T> {
        protected BlankRender(EntityRendererManager p_i46179_1_) {
            super(p_i46179_1_);
        }

        public ResourceLocation getTextureLocation(T pEntity) {
            return null;
        }

        public boolean shouldRender(T builder, ClippingHelper camera, double camX, double camY, double camZ) {
            return false;
        }
    }

    private static class CustomRenderType
    extends RenderType {
        private CustomRenderType(String name, VertexFormat fmt, int glMode, int size, boolean doCrumbling, boolean depthSorting, Runnable onEnable, Runnable onDisable) {
            super(name, fmt, glMode, size, doCrumbling, depthSorting, onEnable, onDisable);
            throw new IllegalStateException("This class must not be instantiated, this is only here to gain access to the rendering constants.");
        }

        private static RenderType.State.Builder createForObject(RenderableData data) {
            RenderType.State.Builder stateBuilder = RenderType.State.func_228694_a_();
            stateBuilder.func_228724_a_(InterfaceRender.getTexture(data.texture));
            stateBuilder.func_228726_a_(data.enableBrightBlending ? BRIGHTNESS_TRANSPARENCY : (data.isTranslucent ? PROPER_TRANSLUCENT_TRANSPARENCY : RenderType.field_228510_b_));
            stateBuilder.func_228716_a_(data.lightingMode.disableTextureShadows ? field_228533_y_ : field_228532_x_);
            stateBuilder.func_228723_a_(field_228520_l_);
            stateBuilder.func_228713_a_(field_228517_i_);
            stateBuilder.func_228719_a_(data.lightingMode.disableWorldLighting ? field_228529_u_ : field_228528_t_);
            stateBuilder.func_228722_a_(field_228531_w_);
            return stateBuilder;
        }
    }
}

