/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcinterface1165.PacketEntityCSHandshakeClient;
import mcinterface1165.PacketEntityCSHandshakeServer;
import mcinterface1165.WrapperNBT;
import mcinterface1165.WrapperPlayer;
import mcinterface1165.WrapperWorld;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IInterfacePacket;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketBase;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

class InterfacePacket
implements IInterfacePacket {
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("mts", "main"), () -> "1", "1"::equals, "1"::equals);
    private static final BiMap<Byte, Class<? extends APacketBase>> packetMappings = HashBiMap.create();

    InterfacePacket() {
    }

    public static void init() {
        byte packetIndex;
        network.registerMessage(0, WrapperPacket.class, WrapperPacket::toBytes, WrapperPacket::fromBytes, WrapperPacket::handle);
        byte by = packetIndex = 0;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by, PacketEntityCSHandshakeClient.class);
        byte by2 = packetIndex;
        packetIndex = (byte)(packetIndex + 1);
        InterfaceManager.packetInterface.registerPacket(by2, PacketEntityCSHandshakeServer.class);
        APacketBase.initPackets(packetIndex);
    }

    @Override
    public void registerPacket(byte packetIndex, Class<? extends APacketBase> packetClass) {
        packetMappings.put((Object)packetIndex, packetClass);
    }

    @Override
    public byte getPacketIndex(APacketBase packet) {
        return (Byte)packetMappings.inverse().get(packet.getClass());
    }

    @Override
    public void sendToServer(APacketBase packet) {
        network.sendToServer((Object)new WrapperPacket(packet));
    }

    @Override
    public void sendToAllClients(APacketBase packet) {
        network.send(PacketDistributor.ALL.noArg(), (Object)new WrapperPacket(packet));
    }

    @Override
    public void sendToPlayer(APacketBase packet, IWrapperPlayer player) {
        network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)((WrapperPlayer)player).player), (Object)new WrapperPacket(packet));
    }

    private static AWrapperWorld getServerWorld(Supplier<NetworkEvent.Context> ctx) {
        return WrapperWorld.getWrapperFor(ctx.get().getSender().field_70170_p);
    }

    @Override
    public void writeDataToBuffer(IWrapperNBT data, ByteBuf buf) {
        ((PacketBuffer)buf).func_150786_a(((WrapperNBT)data).tag);
    }

    @Override
    public WrapperNBT readDataFromBuffer(ByteBuf buf) {
        return new WrapperNBT(((PacketBuffer)buf).func_150793_b());
    }

    public static class WrapperPacket {
        private APacketBase packet;

        public WrapperPacket() {
        }

        public WrapperPacket(APacketBase packet) {
            this.packet = packet;
        }

        public static WrapperPacket fromBytes(PacketBuffer buf) {
            byte packetIndex = buf.readByte();
            try {
                Class packetClass = (Class)packetMappings.get((Object)packetIndex);
                return new WrapperPacket((APacketBase)packetClass.getConstructor(ByteBuf.class).newInstance(buf));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IndexOutOfBoundsException("Was asked to create packet of index " + packetIndex + " but we haven't registered that one yet!");
            }
        }

        public static void toBytes(WrapperPacket message, PacketBuffer buf) {
            message.packet.writeToBuffer((ByteBuf)buf);
        }

        public static void handle(WrapperPacket message, Supplier<NetworkEvent.Context> ctx) {
            if (message.packet.runOnMainThread()) {
                ctx.get().enqueueWork(() -> {
                    AWrapperWorld world = ((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER ? InterfacePacket.getServerWorld(ctx) : InterfaceManager.clientInterface.getClientWorld();
                    if (world != null) {
                        message.packet.handle(world);
                    }
                });
            } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                message.packet.handle(InterfacePacket.getServerWorld(ctx));
            } else {
                message.packet.handle(InterfaceManager.clientInterface.getClientWorld());
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

