/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mcinterface1165.ABuilderEntityBase;
import mcinterface1165.BuilderBlock;
import mcinterface1165.BuilderCreativeTab;
import mcinterface1165.BuilderEntityExisting;
import mcinterface1165.BuilderEntityLinkedSeat;
import mcinterface1165.BuilderEntityRenderForwarder;
import mcinterface1165.BuilderItem;
import mcinterface1165.BuilderTileEntity;
import mcinterface1165.BuilderTileEntityEnergyCharger;
import mcinterface1165.BuilderTileEntityFluidTank;
import mcinterface1165.BuilderTileEntityInventoryContainer;
import mcinterface1165.InterfaceClient;
import mcinterface1165.InterfaceCore;
import mcinterface1165.InterfaceEventsModelLoader;
import mcinterface1165.InterfaceInput;
import mcinterface1165.InterfacePacket;
import mcinterface1165.InterfaceRender;
import mcinterface1165.InterfaceSound;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityEnergyCharger;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityInventoryProvider;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemBlock;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.items.components.IItemFood;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mts")
public class InterfaceLoader {
    public static final String MODID = "mts";
    public static final String MODNAME = "Immersive Vehicles (MTS)";
    public static final String MODVER = "22.17.0";
    public static final Logger LOGGER = LogManager.getLogger((String)InterfaceManager.coreModID);
    private final String gameDirectory = FMLPaths.GAMEDIR.get().toFile().getAbsolutePath();

    public InterfaceLoader() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onPostConstruction);
    }

    /*
     * WARNING - void declaration
     */
    public void init(FMLConstructModEvent event) {
        void var6_11;
        BuilderItem.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BuilderBlock.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BuilderTileEntity.TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ABuilderEntityBase.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        boolean isClient = FMLEnvironment.dist.isClient();
        if (isClient) {
            new InterfaceManager(MODID, this.gameDirectory, new InterfaceCore(), new InterfacePacket(), new InterfaceClient(), new InterfaceInput(), new InterfaceSound(), new InterfaceRender());
            FMLJavaModLoadingContext.get().getModEventBus().addListener(InterfaceRender::registerRenderer);
        } else {
            new InterfaceManager(MODID, this.gameDirectory, new InterfaceCore(), new InterfacePacket(), null, null, null, null);
        }
        InterfaceManager.coreInterface.logError("Welcome to MTS VERSION: 22.17.0");
        ConfigSystem.loadFromDisk(new File(this.gameDirectory, "config"), isClient);
        ArrayList<File> packDirectories = new ArrayList<File>();
        File modDirectory = new File(this.gameDirectory, "mods");
        if (modDirectory.exists()) {
            packDirectories.add(modDirectory);
            PackParser.addDefaultItems();
            PackParser.parsePacks(packDirectories);
        } else {
            InterfaceManager.coreInterface.logError("Could not find mods directory!  Game directory is confirmed to: " + this.gameDirectory);
        }
        for (String string : PackParser.getAllPackIDs()) {
            for (AItemPack<?> item : PackParser.getAllItemsForPack(string, true)) {
                boolean hideOnCreativeTab;
                if (!item.autoGenerate()) continue;
                Item.Properties itemProperties = new Item.Properties();
                boolean bl = hideOnCreativeTab = ((AJSONItem)item.definition).general.hideOnCreativeTab || item instanceof AItemSubTyped && ((AItemSubTyped)item).subDefinition.hideOnCreativeTab;
                if (!(hideOnCreativeTab || ((AJSONItem)item.definition).packID.equals(InterfaceManager.coreModID) && ((AJSONItem)item.definition).systemName.contains("invisible"))) {
                    String tabID = item.getCreativeTabID();
                    if (!BuilderCreativeTab.createdTabs.containsKey(tabID)) {
                        JSONPack packConfiguration = PackParser.getPackConfiguration(tabID);
                        AItemPack<?> tabItem = packConfiguration.packItem != null ? (AItemPack<?>)PackParser.getItem(packConfiguration.packID, packConfiguration.packItem) : null;
                        BuilderCreativeTab.createdTabs.put(tabID, new BuilderCreativeTab(packConfiguration.packName, tabItem));
                    }
                    itemProperties.func_200916_a((ItemGroup)BuilderCreativeTab.createdTabs.get(tabID));
                }
                itemProperties.func_200917_a(item.getStackSize());
                if (item instanceof ItemItem && ((JSONItem)((ItemItem)item).definition).food != null) {
                    IItemFood food = (IItemFood)((Object)item);
                    itemProperties.func_221540_a(new Food.Builder().func_221456_a(food.getHungerAmount()).func_221454_a(food.getSaturationAmount()).func_221453_d());
                }
                new BuilderItem(itemProperties, item);
            }
        }
        LanguageSystem.init();
        for (Map.Entry entry : BuilderItem.itemMap.entrySet()) {
            AItemPack aItemPack = (AItemPack)entry.getKey();
            BuilderItem mcItem = (BuilderItem)entry.getValue();
            BuilderItem.ITEMS.register(aItemPack.getRegistrationName(), () -> mcItem);
            if (((AJSONItem)aItemPack.definition).general.oreDict == null) continue;
            String lowerCaseOre = ((AJSONItem)aItemPack.definition).general.oreDict.toLowerCase(Locale.ROOT);
            List<BuilderItem> items = InterfaceCore.taggedItems.get(lowerCaseOre);
            if (items == null) {
                items = new ArrayList<BuilderItem>();
                InterfaceCore.taggedItems.put(lowerCaseOre, items);
            }
            items.add(mcItem);
        }
        ArrayList<ABlockBase> blocksRegistred = new ArrayList<ABlockBase>();
        for (AItemBase aItemBase : BuilderItem.itemMap.keySet()) {
            ABlockBase itemBlockBlock;
            if (!(aItemBase instanceof IItemBlock) || blocksRegistred.contains(itemBlockBlock = ((IItemBlock)((Object)aItemBase)).getBlock())) continue;
            BuilderBlock wrapper = new BuilderBlock(itemBlockBlock);
            String name = itemBlockBlock.getClass().getSimpleName().substring("Block".length()).toLowerCase(Locale.ROOT);
            BuilderBlock.BLOCKS.register(name, () -> wrapper);
            BuilderBlock.blockMap.put(itemBlockBlock, wrapper);
            blocksRegistred.add(itemBlockBlock);
        }
        boolean bl = false;
        while (var6_11 < BlockCollision.blockInstances.size()) {
            BlockCollision blockCollision = BlockCollision.blockInstances.get((int)var6_11);
            BuilderBlock wrapper = new BuilderBlock(blockCollision);
            String name = blockCollision.getClass().getSimpleName().substring("Block".length()).toLowerCase(Locale.ROOT) + (int)var6_11;
            BuilderBlock.BLOCKS.register(name, () -> wrapper);
            BuilderBlock.blockMap.put(blockCollision, wrapper);
            ++var6_11;
        }
        if (isClient) {
            InterfaceEventsModelLoader.init();
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList inventoryBlocks = new ArrayList();
        ArrayList chargerBlocks = new ArrayList();
        BuilderBlock.blockMap.values().forEach(builder -> {
            if (builder.block instanceof ABlockBaseTileEntity) {
                if (ITileEntityFluidTankProvider.class.isAssignableFrom(((ABlockBaseTileEntity)builder.block).getTileEntityClass())) {
                    fluidBlocks.add(builder);
                } else if (ITileEntityInventoryProvider.class.isAssignableFrom(((ABlockBaseTileEntity)builder.block).getTileEntityClass())) {
                    inventoryBlocks.add(builder);
                } else if (ITileEntityEnergyCharger.class.isAssignableFrom(((ABlockBaseTileEntity)builder.block).getTileEntityClass())) {
                    chargerBlocks.add(builder);
                } else {
                    normalBlocks.add(builder);
                }
            }
        });
        BuilderTileEntity.TE_TYPE = BuilderTileEntity.TILE_ENTITIES.register("builder_base", () -> TileEntityType.Builder.func_223042_a(BuilderTileEntity::new, (Block[])normalBlocks.toArray(new BuilderBlock[0])).func_206865_a(null));
        BuilderTileEntityFluidTank.TE_TYPE2 = BuilderTileEntity.TILE_ENTITIES.register("builder_fluidtank", () -> TileEntityType.Builder.func_223042_a(BuilderTileEntityFluidTank::new, (Block[])fluidBlocks.toArray(new BuilderBlock[0])).func_206865_a(null));
        BuilderTileEntityInventoryContainer.TE_TYPE2 = BuilderTileEntity.TILE_ENTITIES.register("builder_inventory", () -> TileEntityType.Builder.func_223042_a(BuilderTileEntityInventoryContainer::new, (Block[])inventoryBlocks.toArray(new BuilderBlock[0])).func_206865_a(null));
        BuilderTileEntityEnergyCharger.TE_TYPE2 = BuilderTileEntity.TILE_ENTITIES.register("builder_charger", () -> TileEntityType.Builder.func_223042_a(BuilderTileEntityEnergyCharger::new, (Block[])chargerBlocks.toArray(new BuilderBlock[0])).func_206865_a(null));
        BuilderEntityExisting.E_TYPE2 = ABuilderEntityBase.ENTITIES.register("builder_existing", () -> EntityType.Builder.func_220322_a(BuilderEntityExisting::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.05f, 0.05f).func_233606_a_(512).func_233608_b_(5).func_206830_a("builder_existing"));
        BuilderEntityLinkedSeat.E_TYPE3 = ABuilderEntityBase.ENTITIES.register("builder_seat", () -> EntityType.Builder.func_220322_a(BuilderEntityLinkedSeat::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.05f, 0.05f).func_233606_a_(512).func_233608_b_(5).func_206830_a("builder_seat"));
        BuilderEntityRenderForwarder.E_TYPE4 = ABuilderEntityBase.ENTITIES.register("builder_rendering", () -> EntityType.Builder.func_220322_a(BuilderEntityRenderForwarder::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.05f, 0.05f).func_233606_a_(512).func_233608_b_(5).func_206830_a("builder_rendering"));
        for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
            if (!(packItem instanceof IItemEntityProvider)) continue;
            ((IItemEntityProvider)((Object)packItem)).registerEntities(BuilderEntityExisting.entityMap);
        }
        InterfacePacket.init();
        if (isClient) {
            InterfaceManager.inputInterface.initConfigKey();
            ConfigSystem.saveToDisk();
        }
    }

    public void onPostConstruction(FMLLoadCompleteEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            LanguageSystem.populateNames();
            ConfigSystem.settings.fuel.lastLoadedFluids = InterfaceManager.clientInterface.getAllFluidNames();
            ConfigSystem.saveToDisk();
        }
    }
}

