/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mcinterface1165.WrapperItemStack;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.packloading.PackParser;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class InterfaceJEI
implements IModPlugin {
    private static final List<BenchRecipeCategory> benchCategories = new ArrayList<BenchRecipeCategory>();

    public ResourceLocation getPluginUid() {
        return new ResourceLocation(InterfaceManager.coreModID, "main");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        benchCategories.clear();
        for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
            if (!(packItem instanceof ItemDecor)) continue;
            ItemDecor benchItem = (ItemDecor)packItem;
            if (((JSONDecor)benchItem.definition).decor.crafting == null) continue;
            ArrayList<PackRecipeWrapper> benchRecipes = new ArrayList<PackRecipeWrapper>();
            for (AItemPack<?> packItemToTest : PackParser.getAllPackItems()) {
                int i;
                if (!packItemToTest.isBenchValid(((JSONDecor)benchItem.definition).decor.crafting)) continue;
                for (i = 0; i < ((AJSONItem)packItemToTest.definition).general.materialLists.size(); ++i) {
                    benchRecipes.add(new PackRecipeWrapper(packItemToTest, i, false));
                }
                if (((AJSONItem)packItemToTest.definition).general.repairMaterialLists == null) continue;
                for (i = 0; i < ((AJSONItem)packItemToTest.definition).general.repairMaterialLists.size(); ++i) {
                    benchRecipes.add(new PackRecipeWrapper(packItemToTest, i, true));
                }
            }
            benchCategories.add(new BenchRecipeCategory(benchItem, benchRecipes, registry.getJeiHelpers().getGuiHelper()));
        }
        registry.addRecipeCategories(benchCategories.toArray(new IRecipeCategory[benchCategories.size()]));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (BenchRecipeCategory benchCategory : benchCategories) {
            registration.addRecipes((Collection)benchCategory.benchRecipes, benchCategory.getUid());
        }
    }

    private static class PackRecipeWrapper {
        private final AItemPack<?> packItem;
        private final int recipeIndex;
        private final boolean forRepair;

        private PackRecipeWrapper(AItemPack<?> packItem, int recipeIndex, boolean forRepair) {
            this.packItem = packItem;
            this.recipeIndex = recipeIndex;
            this.forRepair = forRepair;
        }
    }

    private static class BenchRecipeCategory
    implements IRecipeCategory<PackRecipeWrapper> {
        private final ItemDecor benchItem;
        private final List<PackRecipeWrapper> benchRecipes;
        private final IDrawable background;
        private final IDrawable icon;

        private BenchRecipeCategory(ItemDecor benchItem, List<PackRecipeWrapper> benchRecipes, IGuiHelper guiHelper) {
            this.benchItem = benchItem;
            this.benchRecipes = benchRecipes;
            this.background = guiHelper.createDrawable(new ResourceLocation(InterfaceManager.coreModID, "textures/guis/jei_crafting.png"), 0, 0, 134, 97);
            this.icon = guiHelper.createDrawableIngredient((Object)((WrapperItemStack)benchItem.getNewStack(null)).stack);
        }

        public Class<PackRecipeWrapper> getRecipeClass() {
            return PackRecipeWrapper.class;
        }

        public ResourceLocation getUid() {
            return new ResourceLocation(InterfaceManager.coreModID, this.benchItem.getRegistrationName());
        }

        public String getTitle() {
            return this.benchItem.getItemName();
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setIngredients(PackRecipeWrapper recipe, IIngredients ingredients) {
            List<PackMaterialComponent> components = PackMaterialComponent.parseFromJSON(recipe.packItem, recipe.recipeIndex, true, true, recipe.forRepair, true);
            if (components != null) {
                ArrayList inputs = new ArrayList();
                for (PackMaterialComponent component : components) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (IWrapperItemStack stack : component.possibleItems) {
                        stacks.add(((WrapperItemStack)stack).stack);
                    }
                    inputs.add(stacks);
                }
                ingredients.setInputLists(VanillaTypes.ITEM, inputs);
                ingredients.setOutput(VanillaTypes.ITEM, (Object)((WrapperItemStack)((PackRecipeWrapper)recipe).packItem.getNewStack(null)).stack);
            }
        }

        public void setRecipe(IRecipeLayout recipeLayout, PackRecipeWrapper recipeWrapper, IIngredients ingredients) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.init(0, false, 58, 70);
            guiItemStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
            List inputs = ingredients.getInputs(VanillaTypes.ITEM);
            int numRows = 3;
            int numCols = 7;
            for (int i = 0; i < inputs.size() && i < 21; ++i) {
                int xOffset = 5 + 17 * (i % 7);
                int yOffset = 5 + 17 * (i / 7);
                guiItemStacks.init(i + 1, true, xOffset, yOffset);
                guiItemStacks.set(i + 1, (List)inputs.get(i));
            }
        }
    }
}

