/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.EntityManager;
import minecrafttransportsimulator.guis.instances.GUIConfig;
import minecrafttransportsimulator.jsondefs.JSONConfigClient;
import minecrafttransportsimulator.mcinterface.IInterfaceInput;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InterfaceInput
implements IInterfaceInput {
    private static KeyBinding configKey;
    private static KeyBinding importKey;
    private static int lastScrollValue;
    private static boolean runningJoystickThread;
    private static boolean runningClassicMode;
    private static boolean joystickLoadingAttempted;
    private static boolean joystickEnabled;
    private static boolean joystickBlocked;
    private static boolean joystickInhibited;
    private static final Map<String, Integer> joystickNameCounters;
    private static final Map<String, Integer> joystickMap;
    private static final Map<String, Integer> joystickAxisCounts;
    private static final Map<String, Integer> joystickHatCounts;
    private static final Map<String, Integer> joystickButtonCounts;
    private static final Map<String, Integer> joystickComponentCounts;
    private static final Map<String, Controller> classicJoystickMap;

    @Override
    public int getKeysetID() {
        return 16;
    }

    @Override
    public void initConfigKey() {
        configKey = new KeyBinding(LanguageSystem.GUI_MASTERCONFIG.getCurrentValue(), 80, "Immersive Vehicles (MTS)");
        ClientRegistry.registerKeyBinding((KeyBinding)configKey);
        importKey = new KeyBinding(LanguageSystem.GUI_IMPORT.getCurrentValue(), -1, "Immersive Vehicles (MTS)");
        ClientRegistry.registerKeyBinding((KeyBinding)importKey);
    }

    @Override
    public void initJoysticks() {
        if (!runningJoystickThread) {
            runningJoystickThread = true;
            joystickBlocked = true;
            Thread joystickThread = new Thread(() -> {
                try {
                    joystickNameCounters.clear();
                    if (runningClassicMode) {
                        classicJoystickMap.clear();
                        for (Controller joystick : ControllerEnvironment.getDefaultEnvironment().getControllers()) {
                            joystickEnabled = true;
                            if (joystick.getType() == null || joystick.getType().equals(Controller.Type.MOUSE) || joystick.getType().equals(Controller.Type.KEYBOARD) || joystick.getName() == null || joystick.getComponents().length == 0) continue;
                            String joystickName = joystick.getName();
                            if (!joystickNameCounters.containsKey(joystickName)) {
                                joystickNameCounters.put(joystickName, 0);
                            }
                            classicJoystickMap.put(joystickName + "_" + joystickNameCounters.get(joystickName), joystick);
                            joystickNameCounters.put(joystickName, joystickNameCounters.get(joystickName) + 1);
                        }
                    } else {
                        joystickMap.clear();
                        joystickAxisCounts.clear();
                        joystickHatCounts.clear();
                        joystickButtonCounts.clear();
                        joystickComponentCounts.clear();
                        for (int i = 0; i < 15; ++i) {
                            joystickEnabled = true;
                            if (GLFW.glfwGetJoystickName((int)i) == null || GLFW.glfwGetJoystickAxes((int)i).limit() <= 0 || GLFW.glfwGetJoystickButtons((int)i).limit() <= 0) continue;
                            String joystickName = GLFW.glfwGetJoystickName((int)i);
                            if (!joystickNameCounters.containsKey(joystickName)) {
                                joystickNameCounters.put(joystickName, 0);
                            }
                            String joystickID = joystickName + "_" + joystickNameCounters.get(joystickName);
                            joystickMap.put(joystickID, i);
                            joystickNameCounters.put(joystickName, joystickNameCounters.get(joystickName) + 1);
                            joystickAxisCounts.put(joystickID, GLFW.glfwGetJoystickAxes((int)i).limit());
                            joystickHatCounts.put(joystickID, GLFW.glfwGetJoystickHats((int)i).limit());
                            joystickButtonCounts.put(joystickID, GLFW.glfwGetJoystickButtons((int)i).limit());
                            joystickComponentCounts.put(joystickID, joystickAxisCounts.get(joystickID) + joystickHatCounts.get(joystickID) + joystickButtonCounts.get(joystickID));
                        }
                    }
                    Iterator<Map.Entry<String, JSONConfigClient.ConfigJoystick>> iterator = ConfigSystem.client.controls.joystick.entrySet().iterator();
                    while (iterator.hasNext()) {
                        try {
                            Map.Entry<String, JSONConfigClient.ConfigJoystick> controllerEntry = iterator.next();
                            ControlSystem.ControlsJoystick control = ControlSystem.ControlsJoystick.valueOf(controllerEntry.getKey().toUpperCase(Locale.ROOT));
                            JSONConfigClient.ConfigJoystick config = controllerEntry.getValue();
                            if (runningClassicMode) {
                                if (!classicJoystickMap.containsKey(config.joystickName) || classicJoystickMap.get(config.joystickName).getComponents().length > config.buttonIndex) continue;
                                iterator.remove();
                                InterfaceManager.coreInterface.logError("Removed classic joystick with too low count.  Had " + classicJoystickMap.get(config.joystickName).getComponents().length + " requested " + config.buttonIndex);
                                continue;
                            }
                            if (!joystickMap.containsKey(config.joystickName)) continue;
                            if (control.isAxis) {
                                if (joystickAxisCounts.get(config.joystickName) > config.buttonIndex) continue;
                                iterator.remove();
                                InterfaceManager.coreInterface.logError("Removed joystick with too low axis count.  Had " + joystickAxisCounts.get(config.joystickName) + " requested " + config.buttonIndex);
                                continue;
                            }
                            if (joystickComponentCounts.get(config.joystickName) > config.buttonIndex) continue;
                            iterator.remove();
                            InterfaceManager.coreInterface.logError("Removed joystick with too low button count.  Had " + joystickComponentCounts.get(config.joystickName) + " requested " + config.buttonIndex);
                        }
                        catch (Exception e) {
                            iterator.remove();
                        }
                    }
                    joystickBlocked = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    InterfaceManager.coreInterface.logError(e.getMessage());
                    for (StackTraceElement s : e.getStackTrace()) {
                        InterfaceManager.coreInterface.logError(s.toString());
                    }
                }
                runningJoystickThread = false;
            });
            joystickThread.start();
        }
    }

    @Override
    public String getNameForKeyCode(int keyCode) {
        return InputMappings.func_197954_a((int)keyCode, (int)0).func_237520_d_().getString();
    }

    @Override
    public int getKeyCodeForName(String name) {
        switch (name) {
            case "RSHIFT": {
                return InputMappings.func_197955_a((String)"key.keyboard.right.shift").func_197937_c();
            }
            case "PRIOR": {
                return InputMappings.func_197955_a((String)"key.keyboard.page.up").func_197937_c();
            }
            case "NEXT": {
                return InputMappings.func_197955_a((String)"key.keyboard.page.down").func_197937_c();
            }
            case "SCROLL": {
                return InputMappings.func_197955_a((String)"key.keyboard.scroll.lock").func_197937_c();
            }
        }
        if (name.contains("NUMPAD")) {
            return InputMappings.func_197955_a((String)("key.keyboard.keypad." + name.substring(name.length() - 1))).func_197937_c();
        }
        return InputMappings.func_197955_a((String)("key.keyboard." + name.toLowerCase(Locale.ROOT))).func_197937_c();
    }

    @Override
    public boolean isKeyPressed(int keyCode) {
        return GLFW.glfwGetKey((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keyCode) == 1;
    }

    @Override
    public void setGUIControls(boolean enabled) {
    }

    @Override
    public boolean isJoystickSupportEnabled() {
        return joystickEnabled;
    }

    @Override
    public boolean isJoystickSupportBlocked() {
        return joystickBlocked;
    }

    @Override
    public boolean isJoystickPresent(String joystickName) {
        return !joystickInhibited && runningClassicMode ? classicJoystickMap.containsKey(joystickName) : joystickMap.containsKey(joystickName);
    }

    @Override
    public List<String> getAllJoystickNames() {
        return new ArrayList<String>(runningClassicMode ? classicJoystickMap.keySet() : joystickMap.keySet());
    }

    @Override
    public int getJoystickComponentCount(String joystickName) {
        return runningClassicMode ? classicJoystickMap.get(joystickName).getComponents().length : joystickComponentCounts.get(joystickName);
    }

    @Override
    public String getJoystickComponentName(String joystickName, int index) {
        if (runningClassicMode) {
            return classicJoystickMap.get(joystickName).getComponents()[index].getName();
        }
        if (this.isJoystickComponentAxis(joystickName, index)) {
            return "Axis: " + String.valueOf(index);
        }
        if (index < joystickAxisCounts.get(joystickName) + joystickHatCounts.get(joystickName)) {
            return "Hat: " + String.valueOf(index - joystickAxisCounts.get(joystickName));
        }
        return "Button: " + String.valueOf(index - joystickAxisCounts.get(joystickName) - joystickHatCounts.get(joystickName));
    }

    @Override
    public boolean isJoystickComponentAxis(String joystickName, int index) {
        return runningClassicMode ? classicJoystickMap.get(joystickName).getComponents()[index].isAnalog() : GLFW.glfwGetJoystickAxes((int)joystickMap.get(joystickName)).limit() > index;
    }

    @Override
    public float getJoystickAxisValue(String joystickName, int index) {
        if (runningClassicMode) {
            if (classicJoystickMap.containsKey(joystickName)) {
                classicJoystickMap.get(joystickName).poll();
                return classicJoystickMap.get(joystickName).getComponents()[index].getPollData();
            }
            return 0.0f;
        }
        if (joystickMap.containsKey(joystickName)) {
            if (this.isJoystickComponentAxis(joystickName, index)) {
                return GLFW.glfwGetJoystickAxes((int)joystickMap.get(joystickName)).get(index);
            }
            if (index < joystickAxisCounts.get(joystickName) + joystickHatCounts.get(joystickName)) {
                switch (GLFW.glfwGetJoystickHats((int)joystickMap.get(joystickName)).get(index - joystickAxisCounts.get(joystickName))) {
                    case 1: {
                        return 0.25f;
                    }
                    case 8: {
                        return 0.5f;
                    }
                    case 4: {
                        return 0.75f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                }
                return 1.0f;
            }
            return GLFW.glfwGetJoystickButtons((int)joystickMap.get(joystickName)).get(index - joystickAxisCounts.get(joystickName) - joystickHatCounts.get(joystickName)) == 1 ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean getJoystickButtonValue(String joystickName, int index) {
        if (runningClassicMode) {
            if (classicJoystickMap.containsKey(joystickName)) {
                classicJoystickMap.get(joystickName).poll();
                return classicJoystickMap.get(joystickName).getComponents()[index].getPollData() > 0.0f;
            }
            return false;
        }
        if (joystickMap.containsKey(joystickName)) {
            return GLFW.glfwGetJoystickButtons((int)joystickMap.get(joystickName)).get(index - joystickAxisCounts.get(joystickName) - joystickHatCounts.get(joystickName)) == 1;
        }
        return false;
    }

    @Override
    public void inhibitJoysticks(boolean inhibited) {
        joystickInhibited = inhibited;
    }

    @Override
    public int getTrackedMouseWheel() {
        int returnValue = lastScrollValue;
        lastScrollValue = 0;
        return returnValue;
    }

    @Override
    public boolean isLeftMouseButtonDown() {
        return Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d();
    }

    @Override
    public boolean isRightMouseButtonDown() {
        return Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d();
    }

    @SubscribeEvent
    public static void onIVKeyInput(InputEvent.KeyInputEvent event) {
        if (runningClassicMode ^ (Boolean)ConfigSystem.client.controlSettings.classicJystk.value) {
            runningClassicMode = (Boolean)ConfigSystem.client.controlSettings.classicJystk.value;
            joystickLoadingAttempted = false;
        }
        if (!joystickLoadingAttempted) {
            InterfaceManager.inputInterface.initJoysticks();
            joystickLoadingAttempted = true;
        }
        if (configKey.func_151470_d() && !InterfaceManager.clientInterface.isGUIOpen()) {
            new GUIConfig();
        } else if (((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue() && importKey.func_151470_d()) {
            EntityManager.doImports(() -> InterfaceManager.clientInterface.getClientPlayer().displayChatMessage(LanguageSystem.SYSTEM_DEBUG, JSONParser.importAllJSONs(true)));
        }
    }

    @SubscribeEvent
    public static void onIVMouseScroll(GuiScreenEvent.MouseScrollEvent.Post event) {
        if (InterfaceManager.clientInterface.isGUIOpen()) {
            lastScrollValue = (int)event.getScrollDelta();
            event.setCanceled(true);
        }
    }

    static {
        runningJoystickThread = false;
        runningClassicMode = false;
        joystickLoadingAttempted = false;
        joystickEnabled = false;
        joystickBlocked = false;
        joystickInhibited = false;
        joystickNameCounters = new HashMap<String, Integer>();
        joystickMap = new LinkedHashMap<String, Integer>();
        joystickAxisCounts = new LinkedHashMap<String, Integer>();
        joystickHatCounts = new LinkedHashMap<String, Integer>();
        joystickButtonCounts = new LinkedHashMap<String, Integer>();
        joystickComponentCounts = new LinkedHashMap<String, Integer>();
        classicJoystickMap = new LinkedHashMap<String, Controller>();
    }
}

