/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.packloading.PackResourceLoader;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;

public class InterfaceEventsModelLoader {
    public static List<PackResourcePack> packPacks = new ArrayList<PackResourcePack>();

    public static void init() {
        PackParser.getAllPackIDs().forEach(packID -> packPacks.add(new PackResourcePack((String)packID)));
    }

    public static class PackResourcePack
    implements IResourcePack {
        private final String domain;
        private final Set<String> domains;

        private PackResourcePack(String domain) {
            this.domain = domain;
            this.domains = new HashSet<String>();
            this.domains.add(domain);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public InputStream func_195761_a(ResourcePackType type, ResourceLocation location) throws IOException {
            InputStream stream;
            String rawPackInfo = location.func_110623_a();
            if (rawPackInfo.endsWith(".json")) {
                String strippedSuffix = rawPackInfo.substring(0, rawPackInfo.lastIndexOf("."));
                if (!strippedSuffix.contains(".")) {
                    stream = InterfaceManager.coreInterface.getPackResource("/assets/" + this.domain + "/" + rawPackInfo);
                    if (stream != null) return stream;
                    if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                    InterfaceManager.coreInterface.logError("Could not find JSON-specified file: " + rawPackInfo);
                    throw new FileNotFoundException(rawPackInfo);
                }
                String resourcePath = "";
                String itemTexturePath = "";
                String combinedPackInfo = strippedSuffix.substring("models/item/".length());
                try {
                    String packID = combinedPackInfo.substring(0, combinedPackInfo.indexOf("."));
                    String systemName = combinedPackInfo.substring(combinedPackInfo.indexOf(".") + 1);
                    Object packItem = PackParser.getItem(packID, systemName);
                    resourcePath = PackResourceLoader.getPackResource(((AItemPack)packItem).definition, PackResourceLoader.ResourceType.ITEM_JSON, systemName);
                    stream = InterfaceManager.coreInterface.getPackResource(resourcePath);
                    if (stream != null) return stream;
                    itemTexturePath = PackResourceLoader.getPackResource(((AItemPack)packItem).definition, PackResourceLoader.ResourceType.ITEM_PNG, systemName);
                    itemTexturePath = itemTexturePath.substring(("/assets/" + packID + "/").length());
                    itemTexturePath = itemTexturePath.substring(0, itemTexturePath.length() - ".png".length());
                    itemTexturePath = packID + ":" + itemTexturePath;
                    String fakeJSON = "{\"parent\":\"mts:item/basic\",\"textures\":{\"layer0\": \"" + itemTexturePath + "\"}}";
                    return new ByteArrayInputStream(fakeJSON.getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                    InterfaceManager.coreInterface.logError("Could not parse out item JSON from: " + rawPackInfo + "  Looked for JSON at:" + resourcePath + (itemTexturePath.isEmpty() ? ", with fallback at:" + itemTexturePath : ", but could not find it."));
                    throw new FileNotFoundException(rawPackInfo);
                }
            }
            try {
                Object packItem;
                boolean isItemPNG = rawPackInfo.contains("/items/") || rawPackInfo.contains("_item");
                String combinedPackInfo = rawPackInfo;
                combinedPackInfo = combinedPackInfo.substring("textures/".length(), combinedPackInfo.length() - ".png".length());
                String packID = this.domain;
                String systemName = combinedPackInfo.substring(combinedPackInfo.lastIndexOf(47) + 1);
                if (systemName.endsWith("_item")) {
                    systemName = systemName.substring(0, systemName.length() - "_item".length());
                }
                if ((packItem = PackParser.getItem(packID, systemName)) != null) {
                    String streamLocation = PackResourceLoader.getPackResource(((AItemPack)packItem).definition, isItemPNG ? PackResourceLoader.ResourceType.ITEM_PNG : PackResourceLoader.ResourceType.PNG, systemName);
                    stream = InterfaceManager.coreInterface.getPackResource(streamLocation);
                    if (stream != null) return stream;
                    if (isItemPNG) {
                        String streamJSONLocation = "/assets/" + packID + "/" + rawPackInfo;
                        stream = InterfaceManager.coreInterface.getPackResource(streamJSONLocation);
                        if (stream != null) return stream;
                        if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                        if (streamLocation != null) {
                            InterfaceManager.coreInterface.logError("Could not find item PNG at specified location: " + streamLocation + "  Or potential JSON location: " + streamJSONLocation);
                            throw new FileNotFoundException(rawPackInfo);
                        } else {
                            InterfaceManager.coreInterface.logError("Could not find JSON PNG: " + streamJSONLocation);
                        }
                        throw new FileNotFoundException(rawPackInfo);
                    }
                    if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                    InterfaceManager.coreInterface.logError("Could not find OBJ PNG: " + streamLocation);
                    throw new FileNotFoundException(rawPackInfo);
                }
                String streamLocation = "/assets/" + this.domain + "/" + rawPackInfo;
                stream = InterfaceManager.coreInterface.getPackResource(streamLocation);
                if (stream != null) return stream;
                if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                InterfaceManager.coreInterface.logError("Couldn't find...whatever this is: " + streamLocation);
                throw new FileNotFoundException(rawPackInfo);
            }
            catch (Exception e) {
                if (e instanceof FileNotFoundException) {
                    throw e;
                }
                if ((Boolean)ConfigSystem.settings.general.devMode.value == false) throw new FileNotFoundException(rawPackInfo);
                InterfaceManager.coreInterface.logError("Could not parse which item PNG to get from: " + rawPackInfo);
                throw new FileNotFoundException(rawPackInfo);
            }
        }

        public boolean func_195764_b(ResourcePackType type, ResourceLocation location) {
            return this.domains.contains(location.func_110624_b()) && !location.func_110623_a().contains("blockstates") && !location.func_110623_a().contains("armatures") && !location.func_110623_a().contains("mcmeta") && (location.func_110623_a().endsWith(".json") && !location.func_110623_a().equals("sounds.json") || location.func_110623_a().endsWith(".png"));
        }

        public Set<String> func_195759_a(ResourcePackType pType) {
            return this.domains;
        }

        public <T> T func_195760_a(IMetadataSectionSerializer<T> pDeserializer) {
            return null;
        }

        public String func_195762_a() {
            return this.domain + "_pack";
        }

        public void close() {
        }

        public InputStream func_195763_b(String pFileName) throws IOException {
            if (!pFileName.contains("/") && !pFileName.contains("\\")) {
                return this.func_195761_a(ResourcePackType.CLIENT_RESOURCES, new ResourceLocation(this.domain, pFileName));
            }
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }

        public Collection<ResourceLocation> func_225637_a_(ResourcePackType pType, String pNamespace, String pPath, int pMaxDepth, Predicate<String> pFilter) {
            return new ArrayList<ResourceLocation>();
        }
    }
}

