/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import mcinterface1165.InterfaceRender;
import mcinterface1165.WrapperEntity;
import mcinterface1165.WrapperPlayer;
import mcinterface1165.mixin.client.RenderInfoInvokerMixin;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InterfaceEventsEntityRendering {
    private static boolean needToPopMatrix = false;
    private static ItemStack heldStackHolder = null;
    private static final Point3D entityScale = new Point3D();
    private static final RotationMatrix riderBodyOrientation = new RotationMatrix();
    private static float riderStoredHeadRot;
    private static float riderStoredHeadRotO;
    private static final TransformationMatrix riderTotalTransformation;
    public static final Point3D cameraAdjustedPosition;
    public static final RotationMatrix cameraAdjustedOrientation;
    public static boolean adjustedCamera;
    private static PlayerEntity mcPlayer;
    private static int lastScreenWidth;
    private static int lastScreenHeight;
    private static float lastRiderPitch;
    private static float lastRiderPrevPitch;

    @SubscribeEvent
    public static void onIVCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        ActiveRenderInfo info = event.getInfo();
        if (info.func_216773_g() instanceof PlayerEntity) {
            mcPlayer = (PlayerEntity)info.func_216773_g();
            WrapperPlayer player = WrapperPlayer.getWrapperFor(mcPlayer);
            cameraAdjustedPosition.set(0.0, 0.0, 0.0);
            cameraAdjustedOrientation.setToZero();
            float partialTicks = (float)event.getRenderPartialTicks();
            adjustedCamera = false;
            if (CameraSystem.adjustCamera(player, cameraAdjustedPosition, cameraAdjustedOrientation, partialTicks)) {
                cameraAdjustedOrientation.convertToAngles();
                if (InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.THIRD_PERSON_INVERTED) {
                    event.setRoll((float)(-InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.z));
                    event.setPitch((float)(-InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.x));
                    event.setYaw((float)(-InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.y + 180.0));
                } else {
                    event.setRoll((float)InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.z);
                    event.setPitch((float)InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.x);
                    event.setYaw((float)(-InterfaceEventsEntityRendering.cameraAdjustedOrientation.angles.y));
                }
                ((RenderInfoInvokerMixin)info).invoke_setPosition(InterfaceEventsEntityRendering.cameraAdjustedPosition.x, InterfaceEventsEntityRendering.cameraAdjustedPosition.y, InterfaceEventsEntityRendering.cameraAdjustedPosition.z);
                adjustedCamera = true;
            }
        }
    }

    @SubscribeEvent
    public static void onIVRenderOverlayPre(RenderGameOverlayEvent.Pre event) {
        IWrapperPlayer player;
        AEntityB_Existing ridingEntity;
        if ((event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS || event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) && CameraSystem.customCameraOverlay != null) {
            event.setCanceled(true);
            return;
        }
        if ((event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR || event.getType() == RenderGameOverlayEvent.ElementType.FOOD || event.getType() == RenderGameOverlayEvent.ElementType.HEALTH || event.getType() == RenderGameOverlayEvent.ElementType.ARMOR || event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE) && (InterfaceManager.clientInterface.getCameraMode() == CameraSystem.CameraMode.FIRST_PERSON ? (Boolean)ConfigSystem.client.renderingSettings.renderHUD_1P.value : (Boolean)ConfigSystem.client.renderingSettings.renderHUD_3P.value).booleanValue() && (ridingEntity = (player = InterfaceManager.clientInterface.getClientPlayer()).getEntityRiding()) instanceof PartSeat && ((PartSeat)ridingEntity).placementDefinition.isController) {
            event.setCanceled(true);
            return;
        }
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CHAT)) {
            boolean updateGUIs;
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            long displaySize = InterfaceManager.clientInterface.getPackedDisplaySize();
            int screenWidth = (int)(displaySize >> 32);
            int screenHeight = (int)displaySize;
            double[] xPos = new double[1];
            double[] yPos = new double[1];
            GLFW.glfwGetCursorPos((long)window.func_198092_i(), (double[])xPos, (double[])yPos);
            int mouseX = (int)(xPos[0] * (double)screenWidth / (double)window.func_198105_m());
            int mouseY = (int)(yPos[0] * (double)screenHeight / (double)window.func_198083_n());
            float partialTicks = event.getPartialTicks();
            boolean bl = updateGUIs = screenWidth != lastScreenWidth || screenHeight != lastScreenHeight;
            if (updateGUIs) {
                lastScreenWidth = screenWidth;
                lastScreenHeight = screenHeight;
            }
            InterfaceRender.renderGUI(event.getMatrixStack(), mouseX, mouseY, screenWidth, screenHeight, partialTicks, updateGUIs);
        }
    }

    @SubscribeEvent
    public static void onIVRenderLivingPre(RenderLivingEvent.Pre event) {
        EntityPlayerGun gunEntity;
        LivingEntity entity = event.getEntity();
        WrapperEntity entityWrapper = WrapperEntity.getWrapperFor((Entity)entity);
        AEntityB_Existing ridingEntity = entityWrapper.getEntityRiding();
        if (ridingEntity != null) {
            event.getMatrixStack().func_227860_a_();
            ridingEntity.getInterpolatedOrientation(riderBodyOrientation, event.getPartialRenderTick());
            riderBodyOrientation.convertToAngles();
            if (ridingEntity instanceof PartSeat) {
                PartSeat seat = (PartSeat)ridingEntity;
                entityScale.set(seat.riderScale);
                if (((JSONPart)seat.definition).seat.playerScale != null) {
                    entityScale.multiply(((JSONPart)seat.definition).seat.playerScale);
                }
                if (seat.placementDefinition.playerScale != null) {
                    entityScale.multiply(seat.placementDefinition.playerScale);
                }
            } else {
                entityScale.set(1.0, 1.0, 1.0);
            }
            riderStoredHeadRot = entity.field_70759_as;
            riderStoredHeadRotO = entity.field_70758_at;
            lastRiderPitch = entity.field_70125_A;
            lastRiderPrevPitch = entity.field_70127_C;
            entity.field_70758_at = entity.field_70759_as = (float)(-ridingEntity.riderRelativeOrientation.convertToAngles().y);
            entity.field_70127_C = entity.field_70125_A = (float)ridingEntity.riderRelativeOrientation.angles.x;
            entity.field_70761_aq = 0.0f;
            entity.field_70760_ar = 0.0f;
            ClientPlayerEntity cameraEntity = Minecraft.func_71410_x().field_71439_g;
            if (cameraEntity != null) {
                Vector3d cameraEntityPos = cameraEntity.func_213303_ch();
                Vector3d entityPos = entity.func_213303_ch();
                new Point3D(entity.field_70169_q - cameraEntity.field_70169_q + (entityPos.field_72450_a - entity.field_70169_q - (cameraEntityPos.field_72450_a - cameraEntity.field_70169_q)) * (double)event.getPartialRenderTick(), entity.field_70167_r - cameraEntity.field_70167_r + (entityPos.field_72448_b - entity.field_70167_r - (cameraEntityPos.field_72448_b - cameraEntity.field_70167_r)) * (double)event.getPartialRenderTick(), entity.field_70166_s - cameraEntity.field_70166_s + (entityPos.field_72449_c - entity.field_70166_s - (cameraEntityPos.field_72449_c - cameraEntity.field_70166_s)) * (double)event.getPartialRenderTick());
                riderTotalTransformation.resetTransforms();
                riderTotalTransformation.applyTranslation(0.0, -entityWrapper.getSeatOffset(), 0.0);
                riderTotalTransformation.applyRotation(riderBodyOrientation);
                riderTotalTransformation.applyScaling(entityScale);
                riderTotalTransformation.applyTranslation(0.0, entityWrapper.getSeatOffset(), 0.0);
                event.getMatrixStack().func_227866_c_().func_227870_a_().func_226595_a_(InterfaceRender.convertMatrix4f(riderTotalTransformation));
            }
            needToPopMatrix = true;
        }
        if (entity instanceof PlayerEntity && (gunEntity = EntityPlayerGun.playerClientGuns.get(entity.func_110124_au())) != null && gunEntity.activeGun != null) {
            PlayerEntity player = (PlayerEntity)entity;
            heldStackHolder = player.func_184614_ca();
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public static void onIVRenderLivingPost(RenderLivingEvent.Post event) {
        if (needToPopMatrix) {
            event.getMatrixStack().func_227865_b_();
            LivingEntity entity = event.getEntity();
            entity.field_70759_as = riderStoredHeadRot;
            entity.field_70758_at = riderStoredHeadRotO;
            entity.field_70125_A = lastRiderPitch;
            entity.field_70127_C = lastRiderPrevPitch;
            needToPopMatrix = false;
        }
        if (heldStackHolder != null) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldStackHolder);
            heldStackHolder = null;
        }
    }

    @SubscribeEvent
    public static void onIVRenderHand(RenderHandEvent event) {
        EntityPlayerGun entity = EntityPlayerGun.playerClientGuns.get(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        if (entity != null && entity.activeGun != null || CameraSystem.activeCamera != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onIVRenderArm(RenderArmEvent event) {
        EntityPlayerGun entity = EntityPlayerGun.playerClientGuns.get(Minecraft.func_71410_x().field_71439_g.func_110124_au());
        if (entity != null && entity.activeGun != null || CameraSystem.activeCamera != null) {
            event.setCanceled(true);
        }
    }

    static {
        riderTotalTransformation = new TransformationMatrix();
        cameraAdjustedPosition = new Point3D();
        cameraAdjustedOrientation = new RotationMatrix();
    }
}

