/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import mcinterface1165.BuilderItem;
import mcinterface1165.InterfaceLoader;
import mcinterface1165.WrapperItemStack;
import mcinterface1165.WrapperNBT;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.mcinterface.IInterfaceCore;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

class InterfaceCore
implements IInterfaceCore {
    protected static final Map<String, List<BuilderItem>> taggedItems = new HashMap<String, List<BuilderItem>>();

    InterfaceCore() {
    }

    @Override
    public boolean isGameFlattened() {
        return true;
    }

    @Override
    public boolean isModPresent(String modID) {
        return ModList.get().isLoaded(modID);
    }

    @Override
    public boolean isFluidValid(String fluidID) {
        return ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(fluidID));
    }

    @Override
    public String getModName(String modID) {
        return ((ModContainer)ModList.get().getModContainerById(modID).get()).getModInfo().getDisplayName();
    }

    @Override
    public InputStream getPackResource(String resource) {
        InputStream stream;
        int assetsIndexEnd = resource.indexOf("assets/") + "assets/".length();
        int modIDEnd = resource.indexOf("/", assetsIndexEnd + 1);
        String modID = resource.substring(assetsIndexEnd, modIDEnd);
        Optional optional = ModList.get().getModContainerById(modID);
        if (optional.isPresent() && (stream = ((ModContainer)optional.get()).getMod().getClass().getResourceAsStream(resource)) != null) {
            return stream;
        }
        return Blocks.field_150350_a.getClass().getResourceAsStream(resource);
    }

    @Override
    public void logError(String message) {
        InterfaceLoader.LOGGER.error("MTSERROR: " + message);
    }

    @Override
    public IWrapperNBT getNewNBTWrapper() {
        return new WrapperNBT();
    }

    @Override
    public IWrapperItemStack getAutoGeneratedStack(AItemBase item, IWrapperNBT data) {
        WrapperItemStack newStack = new WrapperItemStack(new ItemStack((IItemProvider)BuilderItem.itemMap.get(item)));
        newStack.setData(data);
        return newStack;
    }

    @Override
    public IWrapperItemStack getStackForProperties(String name, int meta, int qty) {
        Item item = (Item)Registry.field_212630_s.func_82594_a(ResourceLocation.func_208304_a((String)name));
        if (item != null) {
            return new WrapperItemStack(new ItemStack((IItemProvider)item, qty));
        }
        return new WrapperItemStack(ItemStack.field_190927_a.func_77946_l());
    }

    @Override
    public String getStackItemName(IWrapperItemStack stack) {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)((WrapperItemStack)stack).stack.func_77973_b()).toString();
    }

    @Override
    public boolean isOredictMatch(IWrapperItemStack stackA, IWrapperItemStack stackB) {
        return ((WrapperItemStack)stackA).stack.func_77969_a(((WrapperItemStack)stackB).stack);
    }

    @Override
    public List<IWrapperItemStack> getOredictMaterials(String oreName, int stackSize) {
        String lowerCaseOre = oreName.toLowerCase(Locale.ROOT);
        ArrayList<IWrapperItemStack> stacks = new ArrayList<IWrapperItemStack>();
        ITag tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("minecraft", lowerCaseOre));
        if (tag == null) {
            tag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation("forge", lowerCaseOre));
        }
        if (tag == null) {
            List<BuilderItem> items = taggedItems.get(lowerCaseOre);
            if (items != null) {
                items.forEach(item -> stacks.add(new WrapperItemStack(new ItemStack((IItemProvider)item, stackSize))));
            }
        } else {
            tag.func_230236_b_().forEach(item -> stacks.add(new WrapperItemStack(new ItemStack((IItemProvider)item, stackSize))));
        }
        return stacks;
    }
}

