/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcinterface1165.BuilderGUI;
import mcinterface1165.WrapperItemStack;
import mcinterface1165.WrapperPlayer;
import mcinterface1165.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.instances.GUIPackMissing;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IInterfaceClient;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InterfaceClient
implements IInterfaceClient {
    private static CameraSystem.CameraMode actualCameraMode;
    private static CameraSystem.CameraMode cameraModeRequest;
    private static int ticksToCullingWarning;
    private static final Point3D mutablePosition;

    @Override
    public boolean isGamePaused() {
        return Minecraft.func_71410_x().func_147113_T();
    }

    @Override
    public String getLanguageName() {
        if (Minecraft.func_71410_x().func_135016_M() != null) {
            return Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode();
        }
        return "en_us";
    }

    @Override
    public List<String> getAllLanguages() {
        ArrayList<String> list = new ArrayList<String>();
        Minecraft.func_71410_x().func_135016_M().func_135040_d().forEach(language -> list.add(language.getCode()));
        return list;
    }

    @Override
    public String getFluidName(String fluidID) {
        for (Map.Entry fluidEntry : ForgeRegistries.FLUIDS.getEntries()) {
            if (!((RegistryKey)fluidEntry.getKey()).func_240901_a_().func_110623_a().equals(fluidID)) continue;
            return new TranslationTextComponent(((Fluid)fluidEntry.getValue()).getAttributes().getTranslationKey()).getString();
        }
        return "INVALID";
    }

    @Override
    public Map<String, String> getAllFluidNames() {
        HashMap<String, String> fluidIDsToNames = new HashMap<String, String>();
        for (Fluid fluid : ForgeRegistries.FLUIDS.getValues()) {
            fluidIDsToNames.put(fluid.getRegistryName().func_110623_a(), new FluidStack(fluid, 1).getDisplayName().getString());
        }
        return fluidIDsToNames;
    }

    @Override
    public boolean isChatOpen() {
        return Minecraft.func_71410_x().field_71462_r instanceof ChatScreen;
    }

    @Override
    public boolean isGUIOpen() {
        return Minecraft.func_71410_x().field_71462_r != null;
    }

    @Override
    public CameraSystem.CameraMode getCameraMode() {
        return actualCameraMode;
    }

    @Override
    public void setCameraMode(CameraSystem.CameraMode mode) {
        cameraModeRequest = mode;
    }

    @Override
    public int getCameraDefaultZoom() {
        return 0;
    }

    @Override
    public long getPackedDisplaySize() {
        return (long)Minecraft.func_71410_x().func_228018_at_().func_198107_o() << 32 | (long)Minecraft.func_71410_x().func_228018_at_().func_198087_p() & 0xFFFFFFFFL;
    }

    @Override
    public float getFOV() {
        return (float)Minecraft.func_71410_x().field_71474_y.field_74334_X;
    }

    @Override
    public void setFOV(float setting) {
        Minecraft.func_71410_x().field_71474_y.field_74334_X = setting;
    }

    @Override
    public float getMouseSensitivity() {
        return (float)Minecraft.func_71410_x().field_71474_y.field_74341_c;
    }

    @Override
    public void setMouseSensitivity(float setting) {
        Minecraft.func_71410_x().field_71474_y.field_74341_c = setting;
    }

    @Override
    public void closeGUI() {
        Minecraft.func_71410_x().func_147108_a(null);
    }

    @Override
    public void setActiveGUI(AGUIBase gui) {
        Minecraft.func_71410_x().func_147108_a((Screen)new BuilderGUI(gui));
    }

    @Override
    public WrapperWorld getClientWorld() {
        return WrapperWorld.getWrapperFor((World)Minecraft.func_71410_x().field_71441_e);
    }

    @Override
    public WrapperPlayer getClientPlayer() {
        return WrapperPlayer.getWrapperFor((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public Point3D getCameraPosition() {
        Vector3d cameraOffset = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        mutablePosition.set(cameraOffset.field_72450_a, cameraOffset.field_72448_b, cameraOffset.field_72449_c);
        return mutablePosition;
    }

    @Override
    public void playBlockBreakSound(Point3D position) {
        BlockPos pos = new BlockPos(position.x, position.y, position.z);
        if (!Minecraft.func_71410_x().field_71441_e.func_175623_d(pos)) {
            SoundType soundType = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos).func_177230_c().getSoundType(Minecraft.func_71410_x().field_71441_e.func_180495_p(pos), (IWorldReader)Minecraft.func_71410_x().field_71439_g.field_70170_p, pos, null);
            Minecraft.func_71410_x().field_71441_e.func_184133_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, pos, soundType.func_185845_c(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
        }
    }

    @Override
    public List<String> getTooltipLines(IWrapperItemStack stack) {
        ArrayList<String> tooltipText = new ArrayList<String>();
        List tooltipLines = ((WrapperItemStack)stack).stack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int i = 0; i < tooltipLines.size(); ++i) {
            ITextComponent component = (ITextComponent)tooltipLines.get(i);
            Style style = component.func_150256_b();
            String stringToAdd = "";
            if (style.func_150223_b()) {
                stringToAdd = stringToAdd + 275;
            }
            if (style.func_150242_c()) {
                stringToAdd = stringToAdd + 278;
            }
            if (style.func_150234_e()) {
                stringToAdd = stringToAdd + 277;
            }
            if (style.func_150236_d()) {
                stringToAdd = stringToAdd + 276;
            }
            if (style.func_150233_f()) {
                stringToAdd = stringToAdd + 274;
            }
            if (style.func_240711_a_() != null) {
                TextFormatting legacyColor = null;
                for (TextFormatting format : TextFormatting.values()) {
                    if (!format.func_96302_c() || !style.func_240711_a_().equals((Object)Color.func_240744_a_((TextFormatting)format))) continue;
                    legacyColor = format;
                    break;
                }
                if (legacyColor != null) {
                    stringToAdd = stringToAdd + '\u00a7' + Integer.toHexString(legacyColor.ordinal());
                }
            }
            tooltipText.add(stringToAdd + ((ITextComponent)tooltipLines.get(i)).getString());
        }
        return tooltipText;
    }

    @SubscribeEvent
    public static void onIVClientTick(TickEvent.ClientTickEvent event) {
        AWrapperWorld world;
        IWrapperPlayer player = InterfaceManager.clientInterface.getClientPlayer();
        if (!InterfaceManager.clientInterface.isGamePaused() && player != null && (world = InterfaceManager.clientInterface.getClientWorld()) != null) {
            if (event.phase.equals((Object)TickEvent.Phase.START)) {
                world.tickAll(true);
                ((WrapperWorld)world).world.func_72966_v();
                if (!player.isSpectator()) {
                    ControlSystem.controlGlobal(player);
                    if (((WrapperPlayer)player).player.field_70173_aa % 100 == 0 && !InterfaceManager.clientInterface.isGUIOpen() && !PackParser.arePacksPresent()) {
                        new GUIPackMissing();
                    }
                }
                if (((Boolean)ConfigSystem.settings.general.performModCompatFunctions.value).booleanValue() && ticksToCullingWarning > 0 && --ticksToCullingWarning == 0) {
                    if (InterfaceManager.coreInterface.isModPresent("entityculling")) {
                        player.displayChatMessage(LanguageSystem.SYSTEM_DEBUG, "IV HAS DETECTED THAT ENTITY CULLING MOD IS PRESENT.  THIS MOD CULLS ALL IV VEHICLES UNLESS \"mts:builder_existing\", \"mts:builder_rendering\", AND \"mts:builder_seat\" ARE ADDED TO THE WHITELIST.");
                    }
                    if (InterfaceManager.coreInterface.isModPresent("modernfix")) {
                        player.displayChatMessage(LanguageSystem.SYSTEM_DEBUG, "IV HAS DETECTED THAT MODERNFIX MOD IS PRESENT.  IF DYNAMIC RESOURCES IS SET TO TRUE IV ITEMS WILL NOT RENDER PROPERLY.");
                    }
                }
            } else {
                world.tickAll(false);
                if (cameraModeRequest != null) {
                    switch (cameraModeRequest) {
                        case FIRST_PERSON: {
                            Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
                            break;
                        }
                        case THIRD_PERSON: {
                            Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.THIRD_PERSON_BACK);
                            break;
                        }
                        case THIRD_PERSON_INVERTED: {
                            Minecraft.func_71410_x().field_71474_y.func_243229_a(PointOfView.THIRD_PERSON_FRONT);
                        }
                    }
                    cameraModeRequest = null;
                }
                PointOfView cameraModeEnum = Minecraft.func_71410_x().field_71474_y.func_243230_g();
                switch (cameraModeEnum) {
                    case FIRST_PERSON: {
                        actualCameraMode = CameraSystem.CameraMode.FIRST_PERSON;
                        break;
                    }
                    case THIRD_PERSON_BACK: {
                        actualCameraMode = CameraSystem.CameraMode.THIRD_PERSON;
                        break;
                    }
                    case THIRD_PERSON_FRONT: {
                        actualCameraMode = CameraSystem.CameraMode.THIRD_PERSON_INVERTED;
                    }
                }
            }
        }
    }

    static {
        ticksToCullingWarning = 200;
        mutablePosition = new Point3D();
    }
}

