/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import mcinterface1165.BuilderTileEntity;
import mcinterface1165.WrapperItemStack;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityInventoryProvider;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BuilderTileEntityInventoryContainer
extends BuilderTileEntity
implements IItemHandler {
    protected static RegistryObject<TileEntityType<BuilderTileEntityInventoryContainer>> TE_TYPE2;
    private EntityInventoryContainer inventory;

    public BuilderTileEntityInventoryContainer() {
        super((TileEntityType)TE_TYPE2.get());
    }

    @Override
    protected void setTileEntity(ATileEntityBase<?> tile) {
        super.setTileEntity(tile);
        this.inventory = ((ITileEntityInventoryProvider)((Object)tile)).getInventory();
    }

    public int getSlots() {
        return this.inventory.getSize();
    }

    public ItemStack getStackInSlot(int index) {
        return ((WrapperItemStack)this.inventory.getStack((int)index)).stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.func_190916_E() < amount) {
            amount = stack.func_190916_E();
        }
        ItemStack extracted = stack.func_77946_l();
        extracted.func_190920_e(amount);
        if (!simulate) {
            stack.func_190920_e(stack.func_190916_E() - amount);
            this.inventory.setStack(new WrapperItemStack(stack), slot);
        }
        return extracted;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int amount;
        ItemStack existingStack = this.getStackInSlot(slot);
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existingStack) && (amount = existingStack.func_77976_d() - existingStack.func_190916_E()) != 0) {
            if (amount > stack.func_190916_E()) {
                amount = stack.func_190916_E();
            }
            ItemStack remainderStack = stack.func_77946_l();
            remainderStack.func_190920_e(remainderStack.func_190916_E() - amount);
            if (!simulate) {
                existingStack.func_190920_e(existingStack.func_190916_E() + amount);
                this.inventory.setStack(new WrapperItemStack(existingStack), slot);
            }
            return remainderStack;
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == Direction.UP || facing == Direction.DOWN)) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }
}

