/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import javax.annotation.Nonnull;
import mcinterface1165.BuilderTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityFluidLoader;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;

public class BuilderTileEntityFluidTank
extends BuilderTileEntity
implements IFluidTank,
IFluidHandler {
    protected static RegistryObject<TileEntityType<BuilderTileEntityFluidTank>> TE_TYPE2;
    private EntityFluidTank tank;

    public BuilderTileEntityFluidTank() {
        super((TileEntityType)TE_TYPE2.get());
    }

    @Override
    protected void setTileEntity(ATileEntityBase<?> tile) {
        super.setTileEntity(tile);
        this.tank = ((ITileEntityFluidTankProvider)((Object)tile)).getTank();
    }

    @Override
    public void func_73660_a() {
        int amountDrained;
        IFluidHandler fluidHandler;
        TileEntity teBelow;
        int currentFluidAmount;
        super.func_73660_a();
        if (this.tank != null && this.tileEntity instanceof TileEntityFluidLoader && ((TileEntityFluidLoader)this.tileEntity).isUnloader() && (currentFluidAmount = this.getFluidAmount()) > 0 && (teBelow = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) != null && (fluidHandler = (IFluidHandler)teBelow.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP).orElse(null)) != null && (amountDrained = fluidHandler.fill(this.getFluid(), IFluidHandler.FluidAction.EXECUTE)) > 0 && currentFluidAmount == this.getFluidAmount()) {
            this.drain(amountDrained, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public FluidStack getFluid() {
        if (this.tank != null && !this.tank.getFluid().isEmpty()) {
            for (ResourceLocation fluidKey : ForgeRegistries.FLUIDS.getKeys()) {
                if (!fluidKey.func_110623_a().equals(this.tank.getFluid())) continue;
                return new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidKey), (int)this.tank.getFluidLevel());
            }
        }
        return FluidStack.EMPTY;
    }

    public int getFluidAmount() {
        return (int)(this.tank != null ? this.tank.getFluidLevel() : 0.0);
    }

    public int getCapacity() {
        return this.tank != null ? this.tank.getMaxLevel() : 0;
    }

    public boolean isFluidValid(FluidStack fluid) {
        return true;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction doFill) {
        if (this.tank != null) {
            return (int)this.tank.fill(stack.getFluid().getRegistryName().func_110623_a(), stack.getAmount(), doFill == IFluidHandler.FluidAction.EXECUTE);
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        if (this.getFluidAmount() > 0) {
            return this.drain(new FluidStack(this.getFluid().getFluid(), maxDrain), doDrain);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction doDrain) {
        return new FluidStack(stack.getFluid(), (int)(this.tank != null ? this.tank.drain(stack.getFluid().getRegistryName().func_110623_a(), stack.getAmount(), doDrain == IFluidHandler.FluidAction.EXECUTE) : 0.0));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing == Direction.DOWN) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }
}

