/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import mcinterface1165.BuilderTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityEnergyCharger;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.RegistryObject;

public class BuilderTileEntityEnergyCharger
extends BuilderTileEntity
implements IEnergyStorage {
    protected static RegistryObject<TileEntityType<BuilderTileEntityEnergyCharger>> TE_TYPE2;
    private ITileEntityEnergyCharger charger;
    private static final int MAX_BUFFER = 1000;
    private int buffer;

    public BuilderTileEntityEnergyCharger() {
        super((TileEntityType)TE_TYPE2.get());
    }

    @Override
    protected void setTileEntity(ATileEntityBase<?> tile) {
        super.setTileEntity(tile);
        this.charger = (ITileEntityEnergyCharger)((Object)tile);
    }

    @Override
    public void func_73660_a() {
        int amountToCharge;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.charger != null && this.buffer > 0 && (amountToCharge = this.charger.getChargeAmount()) != 0) {
            if (amountToCharge > this.buffer) {
                amountToCharge = this.buffer;
            }
            this.charger.chargeEnergy(amountToCharge);
            this.buffer -= amountToCharge;
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.buffer == 1000) {
            return 0;
        }
        int amountToStore = 1000 - this.buffer;
        if (amountToStore > maxReceive) {
            amountToStore = maxReceive;
        }
        if (!simulate) {
            this.buffer += amountToStore;
        }
        return amountToStore;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.buffer;
    }

    public int getMaxEnergyStored() {
        return 1000;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY && facing != null) {
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }
}

