/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.util.ArrayList;
import java.util.List;
import mcinterface1165.PacketEntityCSHandshakeClient;
import mcinterface1165.PacketEntityCSHandshakeServer;
import mcinterface1165.WrapperNBT;
import mcinterface1165.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BuilderTileEntity
extends TileEntity
implements ITickableTileEntity {
    protected static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"mts");
    protected static RegistryObject<TileEntityType<BuilderTileEntity>> TE_TYPE;
    protected ATileEntityBase<?> tileEntity;
    private boolean needDataFromServer = true;
    protected CompoundNBT lastLoadedNBT;
    protected boolean loadFromSavedNBT;
    protected boolean loadedFromSavedNBT;
    protected final List<IWrapperPlayer> playersRequestingData = new ArrayList<IWrapperPlayer>();

    public BuilderTileEntity() {
        this((TileEntityType)TE_TYPE.get());
    }

    public BuilderTileEntity(TileEntityType<?> teType) {
        super(teType);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            if (this.tileEntity == null && !this.loadedFromSavedNBT) {
                if (this.lastLoadedNBT != null && !this.field_145850_b.field_72995_K) {
                    this.loadFromSavedNBT = true;
                }
                if (this.loadFromSavedNBT && this.field_145850_b.func_195588_v(this.field_174879_c)) {
                    try {
                        WrapperWorld worldWrapper = WrapperWorld.getWrapperFor(this.field_145850_b);
                        Point3D position = new Point3D(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                        ABlockBaseTileEntity block = (ABlockBaseTileEntity)worldWrapper.getBlock(position);
                        WrapperNBT data = new WrapperNBT(this.lastLoadedNBT);
                        this.setTileEntity(block.createTileEntity(worldWrapper, position, null, (AItemSubTyped)data.getPackItem(), data));
                        this.tileEntity.world.addEntity(this.tileEntity);
                        this.loadedFromSavedNBT = true;
                        this.lastLoadedNBT = null;
                    }
                    catch (Exception e) {
                        InterfaceManager.coreInterface.logError("Failed to load tile entity on builder from saved NBT.  Did a pack change?");
                        InterfaceManager.coreInterface.logError(e.getMessage());
                        this.field_145850_b.func_217377_a(this.field_174879_c, false);
                    }
                }
            }
            if (this.field_145850_b.field_72995_K) {
                if (this.needDataFromServer) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityCSHandshakeClient(InterfaceManager.clientInterface.getClientPlayer(), this));
                    this.needDataFromServer = false;
                }
            } else if (!this.playersRequestingData.isEmpty()) {
                for (IWrapperPlayer player : this.playersRequestingData) {
                    IWrapperNBT data = InterfaceManager.coreInterface.getNewNBTWrapper();
                    this.func_189515_b(((WrapperNBT)data).tag);
                    player.sendPacket(new PacketEntityCSHandshakeServer(this, data));
                }
                this.playersRequestingData.clear();
            }
        }
    }

    protected void setTileEntity(ATileEntityBase<?> tile) {
        this.tileEntity = tile;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.tileEntity != null) {
            this.tileEntity.remove();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.tileEntity != null && this.tileEntity.isValid) {
            this.func_145843_s();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.lastLoadedNBT = tag;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.tileEntity != null) {
            this.tileEntity.save(new WrapperNBT(tag));
        } else if (this.lastLoadedNBT != null) {
            tag = this.lastLoadedNBT;
        }
        return tag;
    }
}

