/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcinterface1165.BuilderCreativeTab;
import mcinterface1165.BuilderTileEntity;
import mcinterface1165.IBuilderItemInterface;
import mcinterface1165.WrapperNBT;
import mcinterface1165.WrapperPlayer;
import mcinterface1165.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.IItemFood;
import minecrafttransportsimulator.items.instances.ItemItem;
import minecrafttransportsimulator.items.instances.ItemPartGun;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BuilderItem
extends Item
implements IBuilderItemInterface {
    protected static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mts");
    protected static final Map<AItemBase, BuilderItem> itemMap = new LinkedHashMap<AItemBase, BuilderItem>();
    private final AItemBase item;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public BuilderItem(Item.Properties properties, AItemBase item) {
        super(properties);
        if (this.field_77701_a != null) {
            ((BuilderCreativeTab)this.field_77701_a).addItem(item, this);
        }
        this.item = item;
        itemMap.put(item, this);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (item instanceof ItemItem && ((JSONItem)((ItemItem)item).definition).weapon != null) {
            ItemItem weapon = (ItemItem)item;
            if (((JSONItem)weapon.definition).weapon.attackDamage != 0.0) {
                builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", ((JSONItem)weapon.definition).weapon.attackDamage - 1.0, AttributeModifier.Operation.ADDITION));
            }
            if (((JSONItem)weapon.definition).weapon.attackCooldown != 0.0) {
                builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 20.0 / ((JSONItem)weapon.definition).weapon.attackCooldown - 4.0, AttributeModifier.Operation.ADDITION));
            }
        }
        this.defaultModifiers = builder.build();
    }

    @Override
    public AItemBase getWrappedItem() {
        return this.item;
    }

    protected String func_195935_o() {
        return this.item.getItemName();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltipLines, ITooltipFlag flagIn) {
        ArrayList<String> textLines = new ArrayList<String>();
        if (stack.func_77942_o()) {
            this.item.addTooltipLines(textLines, new WrapperNBT(stack.func_77978_p()));
        } else {
            this.item.addTooltipLines(textLines, InterfaceManager.coreInterface.getNewNBTWrapper());
        }
        textLines.forEach(line -> tooltipLines.add((ITextComponent)new StringTextComponent(line)));
    }

    public int func_77626_a(ItemStack stack) {
        return this.item instanceof IItemFood ? ((IItemFood)((Object)this.item)).getTimeToEat() : 0;
    }

    public UseAction func_77661_b(ItemStack stack) {
        IItemFood food;
        if (this.item instanceof IItemFood && (food = (IItemFood)((Object)this.item)).getTimeToEat() > 0) {
            return food.isDrink() ? UseAction.DRINK : UseAction.EAT;
        }
        return UseAction.NONE;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.MAINHAND ? this.defaultModifiers : super.func_111205_h(slot);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_221531_n() == Hand.MAIN_HAND) {
            ActionResultType result;
            ActionResultType actionResultType = result = this.item.onBlockClicked(WrapperWorld.getWrapperFor(context.func_195991_k()), WrapperPlayer.getWrapperFor(context.func_195999_j()), new Point3D(context.func_195995_a().func_177958_n(), context.func_195995_a().func_177956_o(), context.func_195995_a().func_177952_p()), ABlockBase.Axis.valueOf(context.func_196000_l().name())) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
            if (result == ActionResultType.FAIL && context.func_195999_j().func_213453_ef()) {
                TileEntity tile;
                if (!context.func_195991_k().field_72995_K && (tile = context.func_195991_k().func_175625_s(context.func_195995_a())) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
                    return ((BuilderTileEntity)tile).tileEntity.interact(WrapperPlayer.getWrapperFor(context.func_195999_j())) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
                }
                return ActionResultType.FAIL;
            }
            return result;
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            if (this.item instanceof IItemFood && ((IItemFood)((Object)this.item)).getTimeToEat() > 0 && player.func_71043_e(true) || this.item instanceof ItemPartGun && ((JSONPart)((ItemPartGun)this.item).definition).gun.handHeld) {
                player.func_184598_c(hand);
            }
            return this.item.onUsed(WrapperWorld.getWrapperFor(world), WrapperPlayer.getWrapperFor(player)) ? ActionResult.func_226248_a_((Object)player.func_184586_b(hand)) : ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entityLiving) {
        if (this.item instanceof IItemFood) {
            if (entityLiving instanceof PlayerEntity) {
                IItemFood food = (IItemFood)((Object)this.item);
                PlayerEntity player = (PlayerEntity)entityLiving;
                player.func_71024_bL().func_75122_a(food.getHungerAmount(), food.getSaturationAmount());
                List<JSONPotionEffect> effects = food.getEffects();
                if (!world.field_72995_K && effects != null) {
                    for (JSONPotionEffect effect : effects) {
                        Potion potion = Potion.func_185168_a((String)effect.name);
                        if (potion != null) {
                            potion.func_185170_a().forEach(mcEffect -> entityLiving.func_195064_c(new EffectInstance(mcEffect.func_188419_a(), effect.duration, effect.amplifier, false, true)));
                            continue;
                        }
                        throw new NullPointerException("Potion " + effect.name + " does not exist.");
                    }
                }
                world.func_184148_a(player, player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)player, stack);
                }
            }
            stack.func_190918_g(1);
        }
        return stack;
    }

    public boolean func_195938_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        return this.item.canBreakBlocks();
    }
}

