/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mcinterface1165.ABuilderEntityBase;
import mcinterface1165.WrapperAABBCollective;
import mcinterface1165.WrapperNBT;
import mcinterface1165.WrapperPlayer;
import mcinterface1165.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BuilderEntityExisting
extends ABuilderEntityBase {
    public static RegistryObject<EntityType<BuilderEntityExisting>> E_TYPE2;
    private EntitySize mutableDims = new EntitySize(1.0f, 1.0f, false);
    protected static final Map<String, IItemEntityProvider.IItemEntityFactory> entityMap;
    protected AEntityB_Existing entity;
    private static Point3D lastExplosionPosition;
    public WrapperAABBCollective collisionBoxes;
    private WrapperAABBCollective interactAttackBoxes;

    public BuilderEntityExisting(EntityType<? extends BuilderEntityExisting> eType, World world) {
        super(eType, world);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.entity != null) {
            if (!this.entity.isValid) {
                this.func_70106_y();
            } else {
                BlockPos pos;
                this.func_70107_b(this.entity.position.x, this.entity.position.y, this.entity.position.z);
                if (!this.field_70170_p.field_72995_K && (World.func_189509_E((BlockPos)(pos = this.func_233580_cy_())) ? this.func_213303_ch().field_72448_b < 0.0 : !this.field_70170_p.func_175723_af().func_177746_a(pos))) {
                    this.func_70106_y();
                    return;
                }
                if (this.entity instanceof AEntityE_Interactable) {
                    AEntityE_Interactable interactable = (AEntityE_Interactable)this.entity;
                    this.entity.world.beginProfiling("CollisionOverhead", true);
                    this.collisionBoxes = new WrapperAABBCollective(interactable, true);
                    this.interactAttackBoxes = new WrapperAABBCollective(interactable, false);
                    if (this.entity instanceof EntityVehicleF_Physics && interactable.ticksExisted > 1L && interactable.ticksExisted % 20L == 0L) {
                        this.mutableDims = new EntitySize((float)Math.max(interactable.encompassingBox.widthRadius * 2.0, interactable.encompassingBox.depthRadius * 2.0), (float)interactable.encompassingBox.heightRadius * 2.0f, false);
                        double maxEntityRadius = this.field_70170_p.getMaxEntityRadius();
                        if (maxEntityRadius < interactable.encompassingBox.widthRadius || maxEntityRadius < interactable.encompassingBox.heightRadius || maxEntityRadius < interactable.encompassingBox.depthRadius) {
                            maxEntityRadius = Math.max(Math.max(interactable.encompassingBox.widthRadius, interactable.encompassingBox.depthRadius), interactable.encompassingBox.heightRadius);
                            if (maxEntityRadius < 150.0) {
                                this.field_70170_p.increaseMaxEntityRadius(maxEntityRadius);
                            } else {
                                InterfaceManager.coreInterface.logError("Attempted to set the world entity max size to way too big of a number (" + maxEntityRadius + ") for " + this.entity + "  Removing entity from world as this is likely a pack error that will cause lots of TPS loss!");
                                this.func_70106_y();
                            }
                        }
                    }
                    this.entity.world.endProfiling();
                }
            }
        } else if (!this.loadedFromSavedNBT && this.loadFromSavedNBT) {
            WrapperWorld worldWrapper = WrapperWorld.getWrapperFor(this.field_70170_p);
            try {
                WrapperNBT data = new WrapperNBT(this.lastLoadedNBT);
                this.entity = entityMap.get(this.lastLoadedNBT.func_74779_i("entityid")).restoreEntityFromData(worldWrapper, data);
                if (this.entity instanceof AEntityF_Multipart) {
                    ((AEntityF_Multipart)this.entity).addPartsPostAddition(null, data);
                }
                this.entity.world.addEntity(this.entity);
                this.loadedFromSavedNBT = true;
                this.lastLoadedNBT = null;
            }
            catch (Exception e) {
                InterfaceManager.coreInterface.logError("Failed to load entity on builder from saved NBT.  Did a pack change?");
                InterfaceManager.coreInterface.logError(e.getMessage());
                this.func_70106_y();
            }
        }
    }

    public EntitySize func_213305_a(Pose pPose) {
        return this.mutableDims;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.entity != null) {
            this.entity.remove();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (((Boolean)ConfigSystem.settings.damage.allowExternalDamage.value).booleanValue() && !this.field_70170_p.field_72995_K && this.entity instanceof AEntityF_Multipart) {
            WrapperPlayer playerSource;
            AEntityF_Multipart multipart = (AEntityF_Multipart)this.entity;
            if (multipart instanceof EntityVehicleF_Physics) {
                amount = (float)((double)amount * ConfigSystem.externalDamageOverrides.overrides.get(((AJSONPartProvider)multipart.definition).packID).get(((AJSONPartProvider)multipart.definition).systemName));
            }
            Entity attacker = source.func_76364_f();
            Entity trueSource = source.func_76346_g();
            WrapperPlayer wrapperPlayer = playerSource = trueSource instanceof PlayerEntity ? WrapperPlayer.getWrapperFor((PlayerEntity)trueSource) : null;
            if (lastExplosionPosition != null && source.func_94541_c()) {
                BoundingBox explosiveBounds = new BoundingBox(lastExplosionPosition, amount, amount, amount);
                for (BoundingBox box : this.interactAttackBoxes.getBoxes()) {
                    if (!box.intersects(explosiveBounds)) continue;
                    multipart.attack(new Damage(amount, box, null, playerSource, null).setExplosive());
                }
                lastExplosionPosition = null;
            } else if (attacker != null) {
                Point3D endPosition;
                Collection<BoundingBoxHitResult> hitResults;
                Vector3d attackerMcPos = attacker.func_213303_ch();
                Point3D attackerPosition = new Point3D(attackerMcPos.field_72450_a, attackerMcPos.field_72448_b, attackerMcPos.field_72449_c);
                for (BoundingBox box : this.interactAttackBoxes.getBoxes()) {
                    if (!box.isPointInside(attackerPosition, null)) continue;
                    multipart.attack(new Damage(amount, box, null, playerSource, null));
                    return true;
                }
                Vector3d mcMovement = attacker.func_213322_ci();
                if (mcMovement.func_189985_c() != 0.0 && (hitResults = multipart.getHitBoxes(attackerPosition, endPosition = attackerPosition.copy().add(mcMovement.field_72450_a, mcMovement.field_72448_b, mcMovement.field_72449_c), new BoundingBox(attackerPosition, endPosition), false)) != null) {
                    multipart.attackProjectile(new Damage(amount, null, null, playerSource, null), null, hitResults);
                }
            }
        }
        return true;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.collisionBoxes != null ? this.collisionBoxes : super.func_174813_aQ();
    }

    public boolean func_241845_aY() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    @Override
    public CompoundNBT func_189511_e(CompoundNBT tag) {
        super.func_189511_e(tag);
        if (this.entity != null) {
            this.entity.save(new WrapperNBT(tag));
            tag.func_74778_a("entityid", this.entity.getClass().getSimpleName());
        }
        return tag;
    }

    @SubscribeEvent
    public static void onIVExplode(ExplosionEvent.Detonate event) {
        if (!event.getWorld().field_72995_K) {
            lastExplosionPosition = new Point3D(event.getExplosion().getPosition().field_72450_a, event.getExplosion().getPosition().field_72448_b, event.getExplosion().getPosition().field_72449_c);
        }
    }

    static {
        entityMap = new HashMap<String, IItemEntityProvider.IItemEntityFactory>();
    }
}

