/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1165;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcinterface1165.BuilderTileEntity;
import mcinterface1165.BuilderTileEntityEnergyCharger;
import mcinterface1165.BuilderTileEntityFluidTank;
import mcinterface1165.BuilderTileEntityInventoryContainer;
import mcinterface1165.WrapperItemStack;
import mcinterface1165.WrapperPlayer;
import mcinterface1165.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.instances.BlockCollision;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityEnergyCharger;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityInventoryProvider;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BuilderBlock
extends Block {
    protected static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"mts");
    protected static final Map<ABlockBase, BuilderBlock> blockMap = new HashMap<ABlockBase, BuilderBlock>();
    protected final ABlockBase block;

    BuilderBlock(ABlockBase block) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(block.hardness, block.blastResistance).func_226896_b_());
        this.block = block;
    }

    public boolean hasTileEntity(BlockState state) {
        return this.block instanceof ABlockBaseTileEntity;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        if (ITileEntityFluidTankProvider.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return new BuilderTileEntityFluidTank();
        }
        if (ITileEntityInventoryProvider.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return new BuilderTileEntityInventoryContainer();
        }
        if (ITileEntityEnergyCharger.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return new BuilderTileEntityEnergyCharger();
        }
        return new BuilderTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.block instanceof ABlockBaseTileEntity) {
            if (!world.func_201670_d()) {
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
                    return ((BuilderTileEntity)tile).tileEntity.interact(WrapperPlayer.getWrapperFor(player)) ? ActionResultType.CONSUME : ActionResultType.FAIL;
                }
            } else {
                return ActionResultType.CONSUME;
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        TileEntity tile;
        if (this.block instanceof ABlockBaseTileEntity && !world.func_201670_d() && (tile = world.func_175625_s(pos)) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
            ((BuilderTileEntity)tile).tileEntity.onNeighborChanged(new Point3D(facingPos.func_177958_n(), facingPos.func_177956_o(), facingPos.func_177952_p()));
        }
        return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        IWrapperItemStack stack;
        ATileEntityBase<?> tile;
        TileEntity mcTile;
        if (this.block instanceof ABlockBaseTileEntity && (mcTile = world.func_175625_s(pos)) instanceof BuilderTileEntity && (tile = ((BuilderTileEntity)mcTile).tileEntity) != null && (stack = tile.getStack()) != null) {
            return ((WrapperItemStack)stack).stack;
        }
        return super.func_185473_a(world, pos, state);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
            ArrayList<ItemStack> convertedDrops = new ArrayList<ItemStack>();
            convertedDrops.add(((WrapperItemStack)((BuilderTileEntity)tile).tileEntity.getStack()).stack);
            return convertedDrops;
        }
        return super.func_220076_a(state, builder);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        this.block.onBroken(WrapperWorld.getWrapperFor(world), new Point3D(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (this.block instanceof ABlockBaseTileEntity) {
            ATileEntityBase<?> tile;
            TileEntity mcTile = world.func_175625_s(pos);
            if (mcTile instanceof BuilderTileEntity && (tile = ((BuilderTileEntity)mcTile).tileEntity) != null) {
                return VoxelShapes.func_197881_a((AxisAlignedBB)WrapperWorld.convertWithOffset(tile.boundingBox, -pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p()));
            }
        } else if (this.block instanceof BlockCollision) {
            return VoxelShapes.func_197881_a((AxisAlignedBB)WrapperWorld.convert(((BlockCollision)this.block).blockBounds));
        }
        return VoxelShapes.func_197880_a();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.INVISIBLE;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        TileEntity tile;
        if (this.block instanceof ABlockBaseTileEntity && (tile = world.func_175625_s(pos)) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
            return (int)(((BuilderTileEntity)tile).tileEntity.getLightProvided() * 15.0f);
        }
        return super.getLightValue(state, world, pos);
    }
}

