/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.datagen;

import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.peeko32213.unusualprehistory.core.registry.UPConfiguredFeatures;
import com.peeko32213.unusualprehistory.core.registry.UPPlacedFeatures;
import com.peeko32213.unusualprehistory.datagen.AdvancementGenerator;
import com.peeko32213.unusualprehistory.datagen.BiomeTagsProvider;
import com.peeko32213.unusualprehistory.datagen.BlockTagsGenerator;
import com.peeko32213.unusualprehistory.datagen.BlockstateGenerator;
import com.peeko32213.unusualprehistory.datagen.EntityTagsGenerator;
import com.peeko32213.unusualprehistory.datagen.InstrumentTagsGenerator;
import com.peeko32213.unusualprehistory.datagen.ItemModelGenerator;
import com.peeko32213.unusualprehistory.datagen.ItemTagsGenerator;
import com.peeko32213.unusualprehistory.datagen.LanguageGenerator;
import com.peeko32213.unusualprehistory.datagen.LootGenerator;
import com.peeko32213.unusualprehistory.datagen.RecipeGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="unusualprehistory", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent evt) {
        if (evt.includeServer()) {
            DataGenerators.registerServerProviders(evt.getGenerator(), evt);
        }
        if (evt.includeClient()) {
            DataGenerators.registerClientProviders(evt.getGenerator(), evt);
        }
    }

    private static void registerClientProviders(DataGenerator generator, GatherDataEvent evt) {
        ExistingFileHelper helper = evt.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new BlockTagsGenerator(generator, helper));
    }

    private static void registerServerProviders(DataGenerator generator, GatherDataEvent evt) {
        ExistingFileHelper helper = evt.getExistingFileHelper();
        BlockTagsGenerator blockTags = new BlockTagsGenerator(generator, helper);
        HashSet set = Sets.newHashSet();
        Consumer<BlockStateGenerator> consumer = set::add;
        generator.m_236039_(true, (DataProvider)new EntityTagsGenerator(generator, helper));
        generator.m_236039_(true, (DataProvider)new RecipeGenerator(generator));
        generator.m_236039_(true, (DataProvider)new BlockstateGenerator(generator, helper));
        generator.m_236039_(true, (DataProvider)new ItemTagsGenerator(generator, blockTags, helper));
        generator.m_236039_(true, (DataProvider)new ItemModelGenerator(generator, helper));
        generator.m_236039_(true, (DataProvider)new LanguageGenerator(generator));
        generator.m_236039_(true, (DataProvider)new LootGenerator(generator));
        generator.m_236039_(true, (DataProvider)new BiomeTagsProvider(generator, helper));
        generator.m_236039_(true, (DataProvider)new InstrumentTagsGenerator(generator, helper));
        generator.m_236039_(true, (DataProvider)new AdvancementGenerator(generator, helper));
        RegistryAccess.Writable registries = RegistryAccess.m_206197_();
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registries);
        JsonCodecProvider configuredFeatureProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)helper, (String)"unusualprehistory", (RegistryOps)ops, (ResourceKey)Registry.f_122881_, DataGenerators.getConfiguredFeatures((RegistryAccess)registries));
        generator.m_236039_(true, (DataProvider)configuredFeatureProvider);
        JsonCodecProvider placedFeatureProvider = JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)helper, (String)"unusualprehistory", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, DataGenerators.getPlacedFeatures((RegistryAccess)registries));
        generator.m_236039_(true, (DataProvider)placedFeatureProvider);
    }

    public static Map<ResourceLocation, ConfiguredFeature<?, ?>> getConfiguredFeatures(RegistryAccess registries) {
        HashMap map = new HashMap();
        for (int i = 0; i < UPConfiguredFeatures.configuredFeatureList.size(); ++i) {
            ResourceLocation RL = new ResourceLocation("unusualprehistory", UPConfiguredFeatures.configuredFeatureList.get(i));
            Registry configuredFeatures = registries.m_175515_(Registry.f_122881_);
            ConfiguredFeature PF = (ConfiguredFeature)configuredFeatures.m_7745_(RL);
            map.put(RL, PF);
        }
        return map;
    }

    public static Map<ResourceLocation, PlacedFeature> getPlacedFeatures(RegistryAccess registries) {
        HashMap<ResourceLocation, PlacedFeature> map = new HashMap<ResourceLocation, PlacedFeature>();
        for (int i = 0; i < UPPlacedFeatures.placedFeatureList.size(); ++i) {
            ResourceLocation RL = new ResourceLocation("unusualprehistory", UPPlacedFeatures.placedFeatureList.get(i));
            Registry placedFeatures = registries.m_175515_(Registry.f_194567_);
            PlacedFeature PF = (PlacedFeature)placedFeatures.m_7745_(RL);
            map.put(RL, PF);
        }
        return map;
    }
}

