/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.datagen;

import com.mojang.logging.LogUtils;
import com.peeko32213.unusualprehistory.core.registry.UPBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class BlockstateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogUtils.getLogger();

    public BlockstateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "unusualprehistory", exFileHelper);
    }

    private String blockName(Block block) {
        return block.m_60589_().m_135815_();
    }

    private ResourceLocation key(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    private String getName(Block block) {
        return this.key(block).toString().replace("unusualprehistory:", "");
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("unusualprehistory", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    public void simpleBlockItem(Block block, ModelFile model) {
        ((ItemModelBuilder)this.itemModels().getBuilder(this.key(block).m_135815_())).parent(model);
    }

    protected void registerStatesAndModels() {
        this.createEgg((Block)UPBlocks.COTY_EGG.get());
        this.createEgg((Block)UPBlocks.MAJUNGA_EGG.get());
        this.createSingleEgg((Block)UPBlocks.BRACHI_EGG.get());
        this.createEgg((Block)UPBlocks.ANURO_EGG.get());
        this.createEggDefaultMedium((Block)UPBlocks.TRIKE_EGG.get());
        this.createEggDefaultMedium((Block)UPBlocks.REX_EGG.get());
        this.createCustomEgg((Block)UPBlocks.ULUGH_EGG.get(), "majunga");
        this.createCustomEgg((Block)UPBlocks.ANTARCO_EGG.get(), "majunga");
        this.createCustomEgg((Block)UPBlocks.KENTRO_EGG.get(), "majunga");
        this.createCustomEgg((Block)UPBlocks.HWACHA_EGG.get(), "majunga");
        this.createCustomEgg((Block)UPBlocks.AUSTRO_EGG.get(), "majunga");
        this.createEggDefaultSmall((Block)UPBlocks.RAPTOR_EGG.get());
        this.createEggDefaultSmall((Block)UPBlocks.PACHY_EGG.get());
        this.createSingleEgg((Block)UPBlocks.TALPANAS_EGG.get());
        this.createEggDefaultSmall((Block)UPBlocks.BARINA_EGG.get());
        this.createEggDefaultMedium((Block)UPBlocks.MEGALA_EGG.get());
        this.createFlatWaterEgg(UPBlocks.DUNK_EGGS.get());
        this.createFlatWaterEgg(UPBlocks.STETHA_EGGS.get());
        this.createFlatWaterEgg(UPBlocks.BEELZE_EGGS.get());
        this.createFlatWaterEgg(UPBlocks.AMON_EGGS.get());
        this.createFlatWaterEgg(UPBlocks.SCAU_EGGS.get());
        this.createFlatWaterEgg((Block)UPBlocks.ERYON_EGGS.get());
        this.simpleBlock(UPBlocks.PETRIFIED_WOOD.get());
        this.logBlock((RotatedPillarBlock)UPBlocks.STRIPPED_PETRIFIED_WOOD.get());
        this.simpleBlockItem((Block)UPBlocks.STRIPPED_PETRIFIED_WOOD.get(), this.existingModel(this.getName((Block)UPBlocks.STRIPPED_PETRIFIED_WOOD.get())));
        this.simpleBlock((Block)UPBlocks.POLISHED_PETRIFIED_WOOD.get());
        this.logBlock((RotatedPillarBlock)UPBlocks.PETRIFIED_WOOD_LOG.get());
        this.logBlock((RotatedPillarBlock)UPBlocks.STRIPPED_PETRIFIED_WOOD_LOG.get());
        this.trapdoorBlock((TrapDoorBlock)UPBlocks.PETRIFIED_WOOD_TRAPDOOR.get(), new ResourceLocation("unusualprehistory", "block/petrified_wood_trapdoor"), true);
        this.simpleBlock((Block)UPBlocks.PETRIFIED_WOOD_PLANKS.get());
        this.slabBlock((SlabBlock)UPBlocks.PETRIFIED_WOOD_SLAB.get(), this.resourceBlock(this.getName((Block)UPBlocks.PETRIFIED_WOOD_PLANKS.get())), new ResourceLocation("unusualprehistory", "block/petrified_planks"));
        this.slabBlock((SlabBlock)UPBlocks.POLISHED_PETRIFIED_WOOD_SLAB.get(), this.resourceBlock(this.getName((Block)UPBlocks.POLISHED_PETRIFIED_WOOD.get())), new ResourceLocation("unusualprehistory", "block/polished_petrified_wood"));
        this.stairsBlock((StairBlock)UPBlocks.PETRIFIED_WOOD_STAIRS.get(), new ResourceLocation("unusualprehistory", "block/petrified_planks"));
        this.stairsBlock((StairBlock)UPBlocks.POLISHED_PETRIFIED_WOOD_STAIRS.get(), new ResourceLocation("unusualprehistory", "block/polished_petrified_wood"));
        this.doorBlock((DoorBlock)UPBlocks.PETRIFIED_WOOD_DOOR.get(), new ResourceLocation("unusualprehistory", "block/petrified_wood_door_bottom"), new ResourceLocation("unusualprehistory", "block/petrified_wood_door_top"));
        this.pressurePlateBlock((PressurePlateBlock)UPBlocks.PETRIFIED_WOOD_PRESSURE_PLATE.get(), new ResourceLocation("unusualprehistory", "block/petrified_planks"));
        this.buttonBlock((ButtonBlock)UPBlocks.PETRIFIED_WOOD_BUTTON.get(), new ResourceLocation("unusualprehistory", "block/petrified_planks"));
        this.fenceBlock((FenceBlock)UPBlocks.PETRIFIED_WOOD_FENCE.get(), new ResourceLocation("unusualprehistory", "block/petrified_planks"));
        this.fenceGateBlock((FenceGateBlock)UPBlocks.PETRIFIED_WOOD_FENCE_GATE.get(), new ResourceLocation("unusualprehistory", "block/petrified_planks"));
        this.signBlock((StandingSignBlock)UPBlocks.PETRIFIED_WOOD_SIGN.get(), (WallSignBlock)UPBlocks.PETRIFIED_WOOD_WALL_SIGN.get(), new ResourceLocation("unusualprehistory", "block/petrified_wood_sign"));
        this.simpleBlock((Block)UPBlocks.STRIPPED_FOXXI_WOOD.get());
        this.simpleBlockItem((Block)UPBlocks.STRIPPED_FOXXI_WOOD.get(), this.existingModel(this.getName((Block)UPBlocks.STRIPPED_FOXXI_WOOD.get())));
        this.logBlock((RotatedPillarBlock)UPBlocks.FOXXI_LOG.get());
        this.simpleBlockItem((Block)UPBlocks.FOXXI_LOG.get(), this.existingModel(this.getName((Block)UPBlocks.FOXXI_LOG.get())));
        this.logBlock((RotatedPillarBlock)UPBlocks.FOXXI_WOOD.get());
        this.simpleBlockItem((Block)UPBlocks.FOXXI_WOOD.get(), this.existingModel(this.getName((Block)UPBlocks.FOXXI_WOOD.get())));
        this.logBlock((RotatedPillarBlock)UPBlocks.STRIPPED_FOXXI_LOG.get());
        this.simpleBlockItem((Block)UPBlocks.STRIPPED_FOXXI_LOG.get(), this.existingModel(this.getName((Block)UPBlocks.STRIPPED_FOXXI_LOG.get())));
        this.simpleBlock((Block)UPBlocks.FOXXI_PLANKS.get());
        this.simpleBlockItem((Block)UPBlocks.FOXXI_PLANKS.get(), this.existingModel(this.getName((Block)UPBlocks.FOXXI_PLANKS.get())));
        this.simpleBlock((Block)UPBlocks.FOXXI_LEAVES.get());
        this.simpleBlockItem((Block)UPBlocks.FOXXI_LEAVES.get(), this.existingModel(this.getName((Block)UPBlocks.FOXXI_LEAVES.get())));
        this.slabBlock((SlabBlock)UPBlocks.FOXXI_SLAB.get(), this.resourceBlock(this.getName((Block)UPBlocks.FOXXI_PLANKS.get())), new ResourceLocation("unusualprehistory", "block/foxxi_planks"));
        this.simpleBlockItem((Block)UPBlocks.FOXXI_SLAB.get(), this.existingModel(this.getName((Block)UPBlocks.FOXXI_SLAB.get())));
        this.doorBlock((DoorBlock)UPBlocks.FOXXI_DOOR.get(), new ResourceLocation("unusualprehistory", "block/foxxi_door_bottom"), new ResourceLocation("unusualprehistory", "block/foxxi_door_top"));
        this.trapdoorBlock((TrapDoorBlock)UPBlocks.FOXXI_TRAPDOOR.get(), new ResourceLocation("unusualprehistory", "block/foxxi_trapdoor"), true);
        this.stairsBlock((StairBlock)UPBlocks.FOXXI_STAIRS.get(), new ResourceLocation("unusualprehistory", "block/foxxi_planks"));
        this.simpleBlockItem((Block)UPBlocks.FOXXI_STAIRS.get(), this.existingModel(this.getName((Block)UPBlocks.FOXXI_STAIRS.get())));
        this.pressurePlateBlock((PressurePlateBlock)UPBlocks.FOXXI_PRESSURE_PLATE.get(), new ResourceLocation("unusualprehistory", "block/foxxi_planks"));
        this.simpleBlockItem((Block)UPBlocks.FOXXI_PRESSURE_PLATE.get(), this.existingModel(this.getName((Block)UPBlocks.FOXXI_PRESSURE_PLATE.get())));
        this.buttonBlock((ButtonBlock)UPBlocks.FOXXI_BUTTON.get(), new ResourceLocation("unusualprehistory", "block/foxxi_planks"));
        this.fenceBlock((FenceBlock)UPBlocks.FOXXI_FENCE.get(), new ResourceLocation("unusualprehistory", "block/foxxi_planks"));
        this.fenceGateBlock((FenceGateBlock)UPBlocks.FOXXI_FENCE_GATE.get(), new ResourceLocation("unusualprehistory", "block/foxxi_planks"));
        this.signBlock((StandingSignBlock)UPBlocks.FOXXI_SIGN.get(), (WallSignBlock)UPBlocks.FOXXI_WALL_SIGN.get(), new ResourceLocation("unusualprehistory", "block/foxxi_sign"));
        this.logBlock((RotatedPillarBlock)UPBlocks.STRIPPED_DRYO_WOOD.get());
        this.simpleBlockItem((Block)UPBlocks.STRIPPED_DRYO_WOOD.get(), this.existingModel(this.getName((Block)UPBlocks.STRIPPED_DRYO_WOOD.get())));
        this.logBlock((RotatedPillarBlock)UPBlocks.DRYO_LOG.get());
        this.simpleBlockItem((Block)UPBlocks.DRYO_LOG.get(), this.existingModel(this.getName((Block)UPBlocks.DRYO_LOG.get())));
        this.logBlock((RotatedPillarBlock)UPBlocks.DRYO_WOOD.get());
        this.simpleBlockItem((Block)UPBlocks.DRYO_WOOD.get(), this.existingModel(this.getName((Block)UPBlocks.DRYO_WOOD.get())));
        this.logBlock((RotatedPillarBlock)UPBlocks.STRIPPED_DRYO_LOG.get());
        this.simpleBlockItem((Block)UPBlocks.STRIPPED_DRYO_LOG.get(), this.existingModel(this.getName((Block)UPBlocks.STRIPPED_DRYO_LOG.get())));
        this.simpleBlock((Block)UPBlocks.DRYO_PLANKS.get());
        this.simpleBlockItem((Block)UPBlocks.DRYO_PLANKS.get(), this.existingModel(this.getName((Block)UPBlocks.DRYO_PLANKS.get())));
        this.simpleBlock((Block)UPBlocks.DRYO_LEAVES.get());
        this.simpleBlockItem((Block)UPBlocks.DRYO_LEAVES.get(), this.existingModel(this.getName((Block)UPBlocks.DRYO_LEAVES.get())));
        this.slabBlock((SlabBlock)UPBlocks.DRYO_SLAB.get(), this.resourceBlock(this.getName((Block)UPBlocks.DRYO_PLANKS.get())), new ResourceLocation("unusualprehistory", "block/dryo_planks"));
        this.simpleBlockItem((Block)UPBlocks.DRYO_SLAB.get(), this.existingModel(this.getName((Block)UPBlocks.DRYO_SLAB.get())));
        this.doorBlock((DoorBlock)UPBlocks.DRYO_DOOR.get(), new ResourceLocation("unusualprehistory", "block/dryo_door_bottom"), new ResourceLocation("unusualprehistory", "block/dryo_door_top"));
        this.trapdoorBlock((TrapDoorBlock)UPBlocks.DRYO_TRAPDOOR.get(), new ResourceLocation("unusualprehistory", "block/dryo_trapdoor"), true);
        this.stairsBlock((StairBlock)UPBlocks.DRYO_STAIRS.get(), new ResourceLocation("unusualprehistory", "block/dryo_planks"));
        this.simpleBlockItem((Block)UPBlocks.DRYO_STAIRS.get(), this.existingModel(this.getName((Block)UPBlocks.DRYO_STAIRS.get())));
        this.pressurePlateBlock((PressurePlateBlock)UPBlocks.DRYO_PRESSURE_PLATE.get(), new ResourceLocation("unusualprehistory", "block/dryo_planks"));
        this.simpleBlockItem((Block)UPBlocks.DRYO_PRESSURE_PLATE.get(), this.existingModel(this.getName((Block)UPBlocks.DRYO_PRESSURE_PLATE.get())));
        this.buttonBlock((ButtonBlock)UPBlocks.DRYO_BUTTON.get(), new ResourceLocation("unusualprehistory", "block/dryo_planks"));
        this.fenceBlock((FenceBlock)UPBlocks.DRYO_FENCE.get(), new ResourceLocation("unusualprehistory", "block/dryo_planks"));
        this.fenceGateBlock((FenceGateBlock)UPBlocks.DRYO_FENCE_GATE.get(), new ResourceLocation("unusualprehistory", "block/dryo_planks"));
        this.signBlock((StandingSignBlock)UPBlocks.DRYO_SIGN.get(), (WallSignBlock)UPBlocks.DRYO_WALL_SIGN.get(), new ResourceLocation("unusualprehistory", "block/dryo_sign"));
        this.simpleBlock((Block)UPBlocks.ASPHALT.get());
        this.simpleBlock((Block)UPBlocks.STONE_OPAL_FOSSIL.get());
        this.simpleBlock((Block)UPBlocks.DEEPSLATE_OPAL_FOSSIL.get());
        this.simpleBlock((Block)UPBlocks.STONE_TAR_FOSSIL.get());
        this.simpleBlock((Block)UPBlocks.DEEPSLATE_TAR_FOSSIL.get());
        this.simpleBlock((Block)UPBlocks.PERMAFROST.get());
        this.simpleBlock((Block)UPBlocks.PERMAFROST_FOSSIL.get());
    }

    public void createEgg(Block block) {
        this.createEgg(block, "");
        this.createEgg(block, "two_");
        this.createEgg(block, "three_");
        this.createEgg(block, "four_");
        this.eggBlockVariantY(block);
        this.singleTex(block);
    }

    public void createCustomEgg(Block block, String modifier) {
        this.createCustomEgg(block, "", modifier);
        this.createCustomEgg(block, "two_", modifier);
        this.createCustomEgg(block, "three_", modifier);
        this.createCustomEgg(block, "four_", modifier);
        this.eggBlockVariantY(block);
        this.singleTex(block);
    }

    public void createEggDefaultSmall(Block block) {
        this.createEggDefaultSmall(block, "");
        this.createEggDefaultSmall(block, "two_");
        this.createEggDefaultSmall(block, "three_");
        this.createEggDefaultSmall(block, "four_");
        this.eggBlockVariantY(block);
        this.singleTex(block);
    }

    public void createEggDefaultMedium(Block block) {
        this.createEggDefaultMedium(block, "");
        this.createEggDefaultMedium(block, "two_");
        this.createEggDefaultMedium(block, "three_");
        this.createEggDefaultMedium(block, "four_");
        this.eggBlockVariantY(block);
        this.singleTex(block);
    }

    public void createEggDefaultLarge(Block block) {
        this.createEggDefaultLarge(block, "");
        this.eggBlockSingleVariantY(block);
        this.singleTex(block);
    }

    public void createSingleEgg(Block block) {
        this.createSingleEgg(block, "");
        this.createSlightltyCrackedSingleEgg(block, "");
        this.createVeryCrackedSingleEgg(block, "");
        this.eggBlockSingleVariantY(block);
        this.singleTex(block);
    }

    public void createFlatWaterEgg(Block block) {
        this.createFlatWaterEgg(block, "");
        this.flatWaterEgg(block);
        this.singleTexWaterEgg(block);
    }

    private void eggBlockVariantY(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int eggs = (Integer)state.m_61143_((Property)BlockStateProperties.f_61415_);
            int hatch = (Integer)state.m_61143_((Property)BlockStateProperties.f_61416_);
            return this.createVariants(this.existingModel(this.createEggModel((Integer)eggs, hatch, block)));
        }, new Property[0]);
    }

    private void eggBlockSingleVariantY(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int eggs = (Integer)state.m_61143_((Property)BlockStateProperties.f_61415_);
            int hatch = (Integer)state.m_61143_((Property)BlockStateProperties.f_61416_);
            return this.createVariants(this.existingModel(this.createEggModelSingle((Integer)eggs, hatch, block)));
        }, new Property[0]);
    }

    private void eggBlock(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int eggs = (Integer)state.m_61143_((Property)BlockStateProperties.f_61415_);
            int hatch = (Integer)state.m_61143_((Property)BlockStateProperties.f_61416_);
            return ConfiguredModel.builder().modelFile(this.existingModel(this.createEggModel((Integer)eggs, hatch, block))).build();
        }, new Property[0]);
    }

    private void eggBlockSingle(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int eggs = (Integer)state.m_61143_((Property)BlockStateProperties.f_61415_);
            int hatch = (Integer)state.m_61143_((Property)BlockStateProperties.f_61416_);
            return ConfiguredModel.builder().modelFile(this.existingModel(this.createEggModelSingle((Integer)eggs, hatch, block))).build();
        }, new Property[0]);
    }

    private void flatWaterEgg(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.existingModel("eggs/" + this.getName(block))).build(), new Property[0]);
    }

    private ConfiguredModel[] createVariants(ModelFile model) {
        ArrayList<ConfiguredModel> activeModels = new ArrayList<ConfiguredModel>();
        for (ModelFile modelFile : Arrays.asList(model)) {
            activeModels.add(new ConfiguredModel(modelFile, 0, 0, false));
            activeModels.add(new ConfiguredModel(modelFile, 0, 90, false));
            activeModels.add(new ConfiguredModel(modelFile, 0, 180, false));
            activeModels.add(new ConfiguredModel(modelFile, 0, 270, false));
        }
        return Arrays.copyOfRange(activeModels.toArray(new ConfiguredModel[0]), 0, 4);
    }

    public void createEgg(Block block, String modifier) {
        this.createSingleEgg(block, modifier);
        this.createSlightltyCrackedSingleEgg(block, modifier);
        this.createVeryCrackedSingleEgg(block, modifier);
    }

    public void createCustomEgg(Block block, String modifier, String modifier2) {
        this.createSingleEggDefault(block, modifier, modifier2);
        this.createSlightltyCrackedSingleEggDefault(block, modifier, modifier2);
        this.createVeryCrackedSingleEggDefault(block, modifier, modifier2);
    }

    public void createEggDefaultSmall(Block block, String modifier) {
        this.createSingleEggDefault(block, modifier, "small");
        this.createSlightltyCrackedSingleEggDefault(block, modifier, "small");
        this.createVeryCrackedSingleEggDefault(block, modifier, "small");
    }

    public void createEggDefaultMedium(Block block, String modifier) {
        this.createSingleEggDefault(block, modifier, "medium");
        this.createSlightltyCrackedSingleEggDefault(block, modifier, "medium");
        this.createVeryCrackedSingleEggDefault(block, modifier, "medium");
    }

    public void createEggDefaultLarge(Block block, String modifier) {
        this.createSingleEggDefault(block, modifier, "large");
        this.createSlightltyCrackedSingleEggDefault(block, modifier, "large");
        this.createVeryCrackedSingleEggDefault(block, modifier, "large");
    }

    public ResourceLocation blockTextureEggs(Block block) {
        ResourceLocation name = this.key(block);
        return new ResourceLocation(name.m_135827_(), "block/eggs/" + name.m_135815_());
    }

    public ModelFile createFlatWaterEgg(Block block, String modifier) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + baseName.replace("unusualprehistory:", ""), new ResourceLocation("unusualprehistory", "block/template_eggs/template_flat_water_egg"), this.blockTextureEggs(block));
    }

    public ModelFile createSingleEgg(Block block, String modifier) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + baseName.replace("unusualprehistory:", ""), new ResourceLocation("unusualprehistory", "block/template_eggs/template_" + modifier + baseName), this.blockTextureEggs(block));
    }

    public ModelFile createSlightltyCrackedSingleEgg(Block block, String modifier) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + "slightly_cracked_" + baseName.replace("unusualprehistory:", ""), new ResourceLocation("unusualprehistory", "block/template_eggs/template_" + baseName), new ResourceLocation("unusualprehistory", "block/eggs/" + this.getName(block) + "_slightly_cracked"));
    }

    public ModelFile createVeryCrackedSingleEgg(Block block, String modifier) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + "very_cracked_" + baseName.replace("unusualprehistory:", ""), new ResourceLocation("unusualprehistory", "block/template_eggs/template_" + baseName), new ResourceLocation("unusualprehistory", "block/eggs/" + this.getName(block) + "_very_cracked"));
    }

    public ModelFile createSingleEggDefault(Block block, String modifier, String modifier2) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + baseName.replace("unusualprehistory:", ""), new ResourceLocation("unusualprehistory", "block/template_eggs/template_" + modifier + modifier2 + "_eggs"), this.blockTextureEggs(block));
    }

    public ModelFile createSlightltyCrackedSingleEggDefault(Block block, String modifier, String modifier2) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + "slightly_cracked_" + baseName.replace("unusualprehistory:", ""), new ResourceLocation("unusualprehistory", "block/template_eggs/template_" + modifier + modifier2 + "_eggs"), new ResourceLocation("unusualprehistory", "block/eggs/" + this.getName(block) + "_slightly_cracked"));
    }

    public ModelFile createVeryCrackedSingleEggDefault(Block block, String modifier, String modifier2) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + "very_cracked_" + baseName.replace("unusualprehistory:", ""), new ResourceLocation("unusualprehistory", "block/template_eggs/template_" + modifier + modifier2 + "_eggs"), new ResourceLocation("unusualprehistory", "block/eggs/" + this.getName(block) + "_very_cracked"));
    }

    private String createEggModel(Integer pEgg, Integer pVariantId, Block block) {
        return switch (pVariantId) {
            case 0 -> this.createEggModel((int)pEgg, "", this.key(block).toString());
            case 1 -> this.createEggModel((int)pEgg, "slightly_cracked_", this.key(block).toString());
            case 2 -> this.createEggModel((int)pEgg, "very_cracked_", this.key(block).toString());
            default -> throw new UnsupportedOperationException();
        };
    }

    private String createEggModelSingle(Integer pEgg, Integer pVariantId, Block block) {
        return switch (pVariantId) {
            case 0 -> this.createEggModelSingle((int)pEgg, "", this.key(block).toString());
            case 1 -> this.createEggModelSingle((int)pEgg, "slightly_cracked_", this.key(block).toString());
            case 2 -> this.createEggModelSingle((int)pEgg, "very_cracked_", this.key(block).toString());
            default -> throw new UnsupportedOperationException();
        };
    }

    private String createEggModel(int pHatchAmount, String pVariantName, String baseName) {
        return switch (pHatchAmount) {
            case 1 -> "eggs/" + pVariantName + baseName.replace("unusualprehistory:", "");
            case 2 -> "eggs/two_" + pVariantName + baseName.replace("unusualprehistory:", "");
            case 3 -> "eggs/three_" + pVariantName + baseName.replace("unusualprehistory:", "");
            case 4 -> "eggs/four_" + pVariantName + baseName.replace("unusualprehistory:", "");
            default -> throw new UnsupportedOperationException();
        };
    }

    private String createEggModelSingle(int pHatchAmount, String pVariantName, String baseName) {
        String s = "eggs/" + pVariantName + baseName.replace("unusualprehistory:", "");
        return switch (pHatchAmount) {
            case 1 -> s;
            case 2 -> s;
            case 3 -> s;
            case 4 -> s;
            default -> throw new UnsupportedOperationException();
        };
    }

    private BlockModelBuilder singleTex(Block block) {
        return this.generated(this.getName(block), new ResourceLocation("unusualprehistory", "item/" + this.getName(block).replace("eggs", "egg")));
    }

    private BlockModelBuilder singleTexWaterEgg(Block block) {
        return this.generated(this.getName(block), new ResourceLocation("unusualprehistory", "item/" + this.getName(block)));
    }

    private BlockModelBuilder generated(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("item/" + name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    public String m_6055_() {
        return "Block States: unusualprehistory";
    }
}

