/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.core.events;

import com.peeko32213.unusualprehistory.common.data.AnalyzerRecipeJsonManager;
import com.peeko32213.unusualprehistory.common.data.EncyclopediaCodec;
import com.peeko32213.unusualprehistory.common.data.EncyclopediaJsonManager;
import com.peeko32213.unusualprehistory.common.data.ItemWeightedPairCodec;
import com.peeko32213.unusualprehistory.common.data.LootFruitCodec;
import com.peeko32213.unusualprehistory.common.data.LootFruitJsonManager;
import com.peeko32213.unusualprehistory.common.entity.EntityDunkleosteus;
import com.peeko32213.unusualprehistory.common.entity.EntityHwachavenator;
import com.peeko32213.unusualprehistory.common.entity.IHatchableEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityTameableBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.common.message.AnalyzerRecipeS2C;
import com.peeko32213.unusualprehistory.common.message.EncyclopediaRootPageS2C;
import com.peeko32213.unusualprehistory.common.message.EncyclopediaS2C;
import com.peeko32213.unusualprehistory.common.message.LootFruitPacketS2C;
import com.peeko32213.unusualprehistory.common.message.LootFruitTierPacketS2C;
import com.peeko32213.unusualprehistory.core.registry.UPEffects;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPMessages;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="unusualprehistory", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEvents {
    @SubscribeEvent
    public static void onRegisterReloadListeners(ServerStartedEvent event) {
        try {
            AnalyzerRecipeJsonManager.populateRecipeMap((Level)event.getServer().m_129880_(Level.f_46428_));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void sendMapPackets(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public static void synchDataPack(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        List playerList = event.getPlayerList().m_11314_();
        Map<Integer, List<LootFruitCodec>> lootFruitsTier = LootFruitJsonManager.getTierTrades();
        Map<Item, List<LootFruitCodec>> lootFruits = LootFruitJsonManager.getTrades();
        Map<Item, List<ItemWeightedPairCodec>> analyzerRecipes = AnalyzerRecipeJsonManager.getRecipes();
        Map<ResourceLocation, EncyclopediaCodec> encyclopediaEntries = EncyclopediaJsonManager.getEncyclopediaEntries();
        EncyclopediaCodec rootPage = EncyclopediaJsonManager.getRootPage();
        if (player != null) {
            UPMessages.sendToPlayer(new LootFruitTierPacketS2C(lootFruitsTier), player);
            UPMessages.sendToPlayer(new LootFruitPacketS2C(lootFruits), player);
            UPMessages.sendToPlayer(new AnalyzerRecipeS2C(analyzerRecipes), player);
            UPMessages.sendToPlayer(new EncyclopediaS2C(encyclopediaEntries), player);
            UPMessages.sendToPlayer(new EncyclopediaRootPageS2C(rootPage), player);
        }
        if (playerList != null && !playerList.isEmpty()) {
            for (ServerPlayer player1 : playerList) {
                ServerLevel serverLevel = (ServerLevel)player1.f_19853_;
                if (AnalyzerRecipeJsonManager.getRecipes().isEmpty()) {
                    AnalyzerRecipeJsonManager.populateRecipeMap((Level)serverLevel);
                }
                Map<Item, List<ItemWeightedPairCodec>> analyzerRecipesReload = AnalyzerRecipeJsonManager.getRecipes();
                UPMessages.sendToPlayer(new LootFruitTierPacketS2C(lootFruitsTier), player1);
                UPMessages.sendToPlayer(new LootFruitPacketS2C(lootFruits), player1);
                UPMessages.sendToPlayer(new AnalyzerRecipeS2C(analyzerRecipesReload), player1);
                UPMessages.sendToPlayer(new EncyclopediaS2C(encyclopediaEntries), player1);
                UPMessages.sendToPlayer(new EncyclopediaRootPageS2C(rootPage), player1);
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new AnalyzerRecipeJsonManager());
        event.addListener((PreparableReloadListener)new LootFruitJsonManager());
        event.addListener((PreparableReloadListener)new EncyclopediaJsonManager());
    }

    @SubscribeEvent
    public void onLootLevelEvent(LootingLevelEvent event) {
        DamageSource src = event.getDamageSource();
        if (src != null && src.m_7639_() instanceof EntityDunkleosteus) {
            event.setLootingLevel(event.getLootingLevel() + 3);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        LivingEntity living;
        Entity entity;
        if (!event.getEntity().m_21211_().m_41619_() && event.getSource() != null && event.getSource().m_7639_() != null && event.getEntity().m_21211_().m_41720_() == UPItems.TRIKE_SHIELD.get() && (entity = event.getSource().m_7639_()) instanceof LivingEntity && !(living = (LivingEntity)entity).m_21255_()) {
            boolean flag = false;
            if (living.m_20270_((Entity)event.getEntity()) <= 4.0f && !living.m_21023_(MobEffects.f_19597_)) {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 1));
                boolean bl = true;
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack itemStack = living.m_21120_(InteractionHand.MAIN_HAND);
            if (!itemStack.m_41782_()) {
                return;
            }
            CompoundTag tag = itemStack.m_41783_();
            if (tag == null || !tag.m_128441_("megalania_damage")) {
                return;
            }
            int count = tag.m_128451_("megalania_damage");
            float amount = event.getAmount();
            amount = (float)((double)amount * 0.75);
            LivingEntity entity2 = event.getEntity();
            int hpReduction = 0;
            if (entity2.m_21023_((MobEffect)UPEffects.HEALTH_REDUCTION.get())) {
                hpReduction = entity2.m_21124_((MobEffect)UPEffects.HEALTH_REDUCTION.get()).m_19564_() + 1;
            }
            MobEffectInstance mobEffectInstance = new MobEffectInstance((MobEffect)UPEffects.HEALTH_REDUCTION.get(), 120, hpReduction);
            entity2.m_7292_(mobEffectInstance);
            event.setAmount(amount);
            tag.m_128405_("megalania_damage", --count);
            if (count <= 0) {
                tag.m_128473_("megalania_damage");
            }
            itemStack.m_41751_(tag);
        }
    }

    @SubscribeEvent
    public static void renderMegalaniaPoisonToolTip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("megalania_damage")) {
            return;
        }
        int amount = tag.m_128451_("megalania_damage");
        MutableComponent component = Component.m_237110_((String)"unusualprehistory.megalania_damage", (Object[])new Object[]{amount}).m_130940_(ChatFormatting.DARK_GREEN).m_130940_(ChatFormatting.ITALIC);
        List toolTip = event.getToolTip();
        event.getToolTip().add(component);
    }

    @SubscribeEvent
    public void preventClick(LivingDeathEvent event) {
        IHatchableEntity dinosaurAnimal;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof EntityDunkleosteus) {
            EntityDunkleosteus dunkleosteus = (EntityDunkleosteus)entity;
            dunkleosteus.killed();
        }
        if ((entity = event.getSource().m_7639_()) instanceof EntityBaseDinosaurAnimal) {
            dinosaurAnimal = (EntityBaseDinosaurAnimal)entity;
            ((EntityBaseDinosaurAnimal)dinosaurAnimal).killed();
        }
        if ((entity = event.getSource().m_7639_()) instanceof EntityTameableBaseDinosaurAnimal) {
            dinosaurAnimal = (EntityTameableBaseDinosaurAnimal)entity;
            ((EntityTameableBaseDinosaurAnimal)dinosaurAnimal).killed();
        }
        if ((entity = event.getSource().m_7639_()) instanceof EntityHwachavenator) {
            dinosaurAnimal = (EntityHwachavenator)entity;
            ((EntityHwachavenator)dinosaurAnimal).killed();
        }
    }

    @SubscribeEvent
    public void axeOneHitWoodDestroy(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntity() != null && !event.getLevel().f_46443_) {
            boolean giveDrops;
            Player player = event.getEntity();
            ServerLevel serverLevel = (ServerLevel)event.getLevel();
            ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!itemStack.m_150930_((Item)UPItems.HANDMADE_BATTLEAXE.get())) {
                return;
            }
            BlockPos pos = event.getPos();
            BlockState state = serverLevel.m_8055_(pos);
            RandomSource randomSource = serverLevel.f_46441_;
            boolean bl = giveDrops = randomSource.m_188503_(100) < 10;
            if (state.m_204336_(BlockTags.f_144280_)) {
                if (!giveDrops) {
                    serverLevel.m_46961_(pos, false);
                } else {
                    serverLevel.m_46961_(pos, true);
                }
            }
        }
    }

    @SubscribeEvent
    public void clubExtraDamage(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack itemStack = living.m_21120_(InteractionHand.MAIN_HAND);
            if (!itemStack.m_150930_((Item)UPItems.HANDMADE_CLUB.get())) {
                return;
            }
            float extraDamageMultp = 1.0f - living.m_21207_();
            float damage = event.getAmount();
            event.setAmount(damage *= extraDamageMultp);
        }
    }

    @SubscribeEvent
    public void spearThrust(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getEntity() != null) {
            Player player = event.getEntity();
            ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (!itemStack.m_150930_((Item)UPItems.HANDMADE_SPEAR.get()) || player.m_21255_()) {
                return;
            }
            if (player.m_36335_().m_41519_(itemStack.m_41720_())) {
                return;
            }
            Vec3 vec3 = player.m_20184_();
            Vec3 vec32 = new Vec3(3.0, 1.0, 3.0).m_82559_(player.m_20154_());
            player.m_20256_(vec32);
            player.f_19864_ = true;
            player.m_36335_().m_41524_(itemStack.m_41720_(), 60);
        }
    }

    @SubscribeEvent
    public void spearFallDamageAttack(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player.f_19853_.f_46443_) {
            return;
        }
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel serverLevel = (ServerLevel)serverPlayer.f_19853_;
            ItemStack itemStack = serverPlayer.m_21120_(InteractionHand.MAIN_HAND);
            if (!itemStack.m_150930_((Item)UPItems.HANDMADE_SPEAR.get()) || serverPlayer.f_19789_ < 4.0f) {
                return;
            }
            if (serverPlayer.m_36335_().m_41519_(itemStack.m_41720_())) {
                return;
            }
            BlockPos blockPos = serverPlayer.m_20097_();
            if (!serverLevel.m_8055_(blockPos).m_60795_()) {
                RandomSource randomSource = serverLevel.f_46441_;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 50, randomSource.m_188583_() * 1.0, 0.1, randomSource.m_188583_() * 1.0, 0.2);
                List entities = serverLevel.m_6443_(LivingEntity.class, serverPlayer.m_20191_().m_82400_(4.0), e -> !e.m_7306_((Entity)serverPlayer));
                for (LivingEntity entity : entities) {
                    entity.m_6469_(DamageSource.m_19344_((Player)serverPlayer), serverPlayer.f_19789_);
                }
            }
        }
    }

    @SubscribeEvent
    public void preventClick(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getEntity().m_21023_((MobEffect)UPEffects.PREVENT_CLICK.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void preventClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntity().m_21023_((MobEffect)UPEffects.PREVENT_CLICK.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void preventClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity().m_21023_((MobEffect)UPEffects.PREVENT_CLICK.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void preventClick(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getEntity().m_21023_((MobEffect)UPEffects.PREVENT_CLICK.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void preventClick(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity().m_21023_((MobEffect)UPEffects.PREVENT_CLICK.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void preventInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity().m_21023_((MobEffect)UPEffects.PREVENT_CLICK.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void preventDamage(AttackEntityEvent event) {
        if (event.getEntity().m_21023_((MobEffect)UPEffects.PREVENT_CLICK.get())) {
            event.setCanceled(true);
        }
    }
}

