/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.screen;

import com.peeko32213.unusualprehistory.common.block.entity.CultivatorBlockEntity;
import com.peeko32213.unusualprehistory.common.screen.slot.UPResultSlot;
import com.peeko32213.unusualprehistory.core.registry.UPBlocks;
import com.peeko32213.unusualprehistory.core.registry.UPMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class CultivatorMenu
extends AbstractContainerMenu {
    private final CultivatorBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 4;

    public CultivatorMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(5));
    }

    public CultivatorMenu(int pContainerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)UPMenuTypes.CULTIVATOR_MENU.get(), pContainerId);
        CultivatorMenu.m_38869_((Container)inv, (int)4);
        this.blockEntity = (CultivatorBlockEntity)entity;
        this.level = inv.f_35978_.f_19853_;
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 33, 31));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 80, 64));
            this.m_38897_((Slot)new UPResultSlot((IItemHandler)handler, 2, 128, 31));
            this.m_38897_((Slot)new UPResultSlot((IItemHandler)handler, 3, 152, 64));
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress(int scale) {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        if (progress == 0 || maxProgress == 0) {
            return 0;
        }
        return Mth.m_14167_((float)((float)scale * (float)progress / (float)maxProgress));
    }

    public int getScaledFuel(int scale) {
        int fuel = this.data.m_6413_(2);
        int maxFuel = this.data.m_6413_(3);
        if (fuel == 0 || maxFuel == 0) {
            return 0;
        }
        return Mth.m_14167_((float)((float)scale * (float)fuel / (float)maxFuel));
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 40, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 40) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return CultivatorMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)UPBlocks.CULTIVATOR.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

