/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.item.armor.shedscale;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.peeko32213.unusualprehistory.common.item.armor.material.UPArmorMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ItemShedscaleArmor
extends GeoArmorItem
implements IAnimatable {
    private static final Map<MobEffect, MobEffect> TO_CHANGE_MAP = new HashMap<MobEffect, MobEffect>(){
        {
            this.put(MobEffects.f_19614_, MobEffects.f_19605_);
            this.put(MobEffects.f_19597_, MobEffects.f_19596_);
            this.put(MobEffects.f_19599_, MobEffects.f_19598_);
            this.put(MobEffects.f_19602_, MobEffects.f_19601_);
            this.put(MobEffects.f_19604_, MobEffects.f_19611_);
            this.put(MobEffects.f_19612_, MobEffects.f_19618_);
            this.put(MobEffects.f_19610_, MobEffects.f_19611_);
            this.put(MobEffects.f_19615_, MobEffects.f_19605_);
            this.put(MobEffects.f_19620_, MobEffects.f_19591_);
            this.put(MobEffects.f_19590_, MobEffects.f_19621_);
        }
    };
    private static final UUID[] SWIM_SPEED_MOD_UUID = new UUID[]{UUID.fromString("480d87c2-2f0a-11ee-be56-0242ac120002"), UUID.fromString("480d8ad8-2f0a-11ee-be56-0242ac120002"), UUID.fromString("480d8c36-2f0a-11ee-be56-0242ac120002"), UUID.fromString("480d8da8-2f0a-11ee-be56-0242ac120002")};
    protected final EquipmentSlot f_40377_;
    private final int defense;
    private final float toughness;
    protected final float f_40378_;
    protected final ArmorMaterial f_40379_;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public ItemShedscaleArmor(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builder, double swimSpeed) {
        super(materialIn, slot, builder);
        ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
        this.f_40379_ = materialIn;
        this.f_40377_ = slot;
        this.defense = materialIn.m_7365_(slot);
        this.toughness = materialIn.m_6651_();
        this.f_40378_ = materialIn.m_6649_();
        UUID uuid = SWIM_SPEED_MOD_UUID[slot.m_20749_()];
        attributeBuilder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.defense, AttributeModifier.Operation.ADDITION));
        attributeBuilder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        attributeBuilder.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(uuid, "Swim Speed Mod", swimSpeed, AttributeModifier.Operation.ADDITION));
        if (this.f_40378_ > 0.0f) {
            attributeBuilder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        }
        this.defaultModifiers = attributeBuilder.build();
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        if (this.hasFullSuitOfArmorOn(player) && this.hasCorrectArmorOn(UPArmorMaterial.SHEDSCALE, player)) {
            this.giveEffect(player);
        }
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack breastplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !breastplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        for (ItemStack armorStack : player.m_150109_().f_35975_) {
            if (armorStack.m_41720_() instanceof ItemShedscaleArmor) continue;
            return false;
        }
        ItemShedscaleArmor boots = (ItemShedscaleArmor)player.m_150109_().m_36052_(0).m_41720_();
        ItemShedscaleArmor leggings = (ItemShedscaleArmor)player.m_150109_().m_36052_(1).m_41720_();
        ItemShedscaleArmor breastplate = (ItemShedscaleArmor)player.m_150109_().m_36052_(2).m_41720_();
        ItemShedscaleArmor helmet = (ItemShedscaleArmor)player.m_150109_().m_36052_(3).m_41720_();
        return helmet.m_40401_() == material && breastplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
    }

    private boolean giveEffect(Player player) {
        ArrayList mobEffectInstances = new ArrayList(player.m_21220_());
        HashMap<MobEffect, MobEffectInstance> modifiedEffects = new HashMap<MobEffect, MobEffectInstance>();
        boolean hasGivenEffect = false;
        for (MobEffectInstance mobEffectInstance : mobEffectInstances) {
            MobEffect effect = mobEffectInstance.m_19544_();
            if (TO_CHANGE_MAP.containsKey(effect)) {
                MobEffect givenEffect = TO_CHANGE_MAP.get(effect);
                int duration = mobEffectInstance.m_19557_();
                int amplifier = mobEffectInstance.m_19564_();
                MobEffectInstance toGiveInstance = new MobEffectInstance(givenEffect, duration, amplifier);
                modifiedEffects.put(givenEffect, toGiveInstance);
                hasGivenEffect = true;
                continue;
            }
            modifiedEffects.put(effect, mobEffectInstance);
        }
        player.m_21219_();
        for (MobEffectInstance modifiedEffect : modifiedEffects.values()) {
            player.m_7292_(modifiedEffect);
        }
        return hasGivenEffect;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == this.f_40377_ ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
    }
}

