/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.item.armor;

import com.peeko32213.unusualprehistory.common.entity.msc.baby.EntityBabyMegatherium;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class ItemSlothPouchArmor
extends GeoArmorItem
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private int tameTime;

    public ItemSlothPouchArmor(ArmorMaterial material, EquipmentSlot slot, int tameTime, Item.Properties settings) {
        super(material, slot, settings);
        this.tameTime = tameTime;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128441_("megatherium") && pHand == InteractionHand.MAIN_HAND) {
            if (!pLevel.f_46443_) {
                EntityBabyMegatherium babyMegatherium = (EntityBabyMegatherium)((EntityType)UPEntities.BABY_MEGATHERIUM.get()).m_20615_(pLevel);
                babyMegatherium.deserializeNBT(tag.m_128469_("megatherium"));
                babyMegatherium.m_146884_(pPlayer.m_20182_());
                if (tag.m_128471_("tamed") && !babyMegatherium.m_21824_()) {
                    babyMegatherium.m_21828_(pPlayer);
                }
                babyMegatherium.m_146762_(-24000);
                babyMegatherium.m_20084_(UUID.randomUUID());
                pLevel.m_7967_((Entity)babyMegatherium);
            }
            ItemStack itemStack1 = ((Item)UPItems.DINO_POUCH.get()).m_7968_();
            ItemStack itemstack2 = ItemUtils.m_41813_((ItemStack)stack, (Player)pPlayer, (ItemStack)itemStack1);
            return InteractionResultHolder.m_19092_((Object)itemstack2, (boolean)pLevel.m_5776_());
        }
        if (!pPlayer.m_6144_()) {
            return super.m_7203_(pLevel, pPlayer, pHand);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        CompoundTag tag;
        if (pLevel.f_46443_ || pSlotId != EquipmentSlot.CHEST.m_20749_()) {
            return;
        }
        if (!(pStack.m_41782_() && pStack.m_41783_() != null && pStack.m_41783_().m_128441_("megatherium") && pStack.m_41783_().m_128441_("gameTime"))) {
            this.addTag(pStack, pLevel);
        }
        if ((tag = pStack.m_41783_()).m_128441_("gameTime") && tag.m_128441_("megatherium")) {
            long checkTime;
            long currentTime = pLevel.m_46467_();
            long timeToCheck = tag.m_128454_("gameTime");
            if (timeToCheck < (checkTime = currentTime - (long)this.tameTime)) {
                tag.m_128379_("tamed", true);
            }
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public ItemStack addTag(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41783_();
        EntityBabyMegatherium entityBabyMegatherium = (EntityBabyMegatherium)((EntityType)UPEntities.BABY_MEGATHERIUM.get()).m_20615_(level);
        tag.m_128365_("megatherium", (Tag)entityBabyMegatherium.serializeNBT());
        tag.m_128379_("tamed", entityBabyMegatherium.m_21824_());
        long currentTime = level.m_46467_();
        tag.m_128356_("gameTime", currentTime);
        stack.m_41751_(tag);
        return stack;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag tag = pStack.m_41783_();
        if (tag.m_128441_("gameTime") && tag.m_128441_("megatherium")) {
            long timeToCheck;
            long currentTime = pLevel.m_46467_();
            int minutesLeft = (int)Math.ceil((float)((long)this.tameTime - (currentTime - (timeToCheck = tag.m_128454_("gameTime")))) * 0.05f / 60.0f);
            if (minutesLeft < 0) {
                minutesLeft = 0;
            }
            if (tag.m_128471_("tamed")) {
                MutableComponent component = Component.m_237110_((String)"unusualprehistory.megatherium_baby.tame_tooltip", (Object[])new Object[]{tag.m_128471_("tamed")}).m_130940_(ChatFormatting.AQUA);
                pTooltipComponents.add((Component)component);
            } else {
                MutableComponent component = Component.m_237110_((String)"unusualprehistory.megatherium_baby.minutes_tooltip", (Object[])new Object[]{minutesLeft}).m_130940_(ChatFormatting.AQUA);
                pTooltipComponents.add((Component)component);
            }
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
    }
}

