/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.item;

import com.peeko32213.unusualprehistory.common.entity.EntityBarinasuchus;
import com.peeko32213.unusualprehistory.core.registry.UPAdvancementTriggerRegistry;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class MusicalTameItem
extends Item {
    private Supplier<? extends EntityType<?>> toTame;
    private TagKey<Instrument> instrument;

    public MusicalTameItem(Item.Properties pProperties, Supplier<? extends EntityType<?>> toTame, TagKey<Instrument> instrument) {
        super(pProperties);
        this.toTame = toTame;
        this.instrument = instrument;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Optional<Holder<Instrument>> optional = this.getInstrument(itemstack);
        if (optional.isPresent()) {
            Instrument instrument = (Instrument)optional.get().m_203334_();
            pPlayer.m_6672_(pHand);
            MusicalTameItem.play(pLevel, pPlayer, instrument);
            pPlayer.m_36335_().m_41524_((Item)this, instrument.f_220080_());
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_6787_(CreativeModeTab pCategory, NonNullList<ItemStack> pItems) {
        if (this.m_220152_(pCategory)) {
            for (Holder holder : Registry.f_235738_.m_206058_(this.instrument)) {
                pItems.add((Object)MusicalTameItem.create((Item)UPItems.BARINA_WHISTLE.get(), (Holder<Instrument>)holder));
            }
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        Optional optional = this.getInstrument(pStack).flatMap(Holder::m_203543_);
        if (optional.isPresent()) {
            MutableComponent mutablecomponent = Component.m_237115_((String)Util.m_137492_((String)"instrument", (ResourceLocation)((ResourceKey)optional.get()).m_135782_()));
            pTooltipComponents.add((Component)mutablecomponent.m_130940_(ChatFormatting.GRAY));
        }
    }

    public static ItemStack create(Item pItem, Holder<Instrument> pInstrument) {
        ItemStack itemstack = new ItemStack((ItemLike)pItem);
        MusicalTameItem.setSoundVariantId(itemstack, pInstrument);
        return itemstack;
    }

    private static void setSoundVariantId(ItemStack pStack, Holder<Instrument> pSoundVariantId) {
        CompoundTag compoundtag = pStack.m_41784_();
        compoundtag.m_128359_("instrument", ((ResourceKey)pSoundVariantId.m_203543_().orElseThrow(() -> new IllegalStateException("Invalid instrument"))).m_135782_().toString());
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pLivingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pLivingEntity;
            int i = this.m_8105_(pStack) - pTimeCharged;
            if (i < 80) {
                player.m_213846_((Component)Component.m_237115_((String)"unusualprehistory.musical_tame.too_early").m_130940_(ChatFormatting.GRAY));
                return;
            }
            LivingEntity toTame = (LivingEntity)this.toTame.get().m_20615_(pLevel);
            List toTameList = pLevel.m_6443_(TamableAnimal.class, player.m_20191_().m_82400_(10.0), EntitySelector.f_20406_.and(entity -> entity.m_6095_() == toTame.m_6095_() && !((TamableAnimal)entity).m_21824_()));
            toTameList.sort(Comparator.comparingDouble(arg_0 -> ((ServerPlayer)player).m_20280_(arg_0)));
            if (!toTameList.isEmpty()) {
                ((TamableAnimal)toTameList.get(0)).m_21828_((Player)player);
                MutableComponent mutableComponent = Component.m_237115_((String)toTame.m_6095_().m_20675_()).m_130940_(ChatFormatting.GOLD);
                if (((TamableAnimal)toTameList.get(0)).m_21824_()) {
                    if (toTameList.get(0) instanceof EntityBarinasuchus) {
                        UPAdvancementTriggerRegistry.BARINA_TRIGGER.trigger(player, this.m_7968_());
                    }
                    player.m_213846_((Component)Component.m_237110_((String)"unusualprehistory.musical_tame.tame", (Object[])new Object[]{mutableComponent}).m_130940_(ChatFormatting.GREEN));
                } else {
                    player.m_213846_((Component)Component.m_237110_((String)"unusualprehistory.musical_tame.fail_tame", (Object[])new Object[]{mutableComponent}).m_130940_(ChatFormatting.RED));
                }
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"unusualprehistory.musical_tame.no_entity_found").m_130940_(ChatFormatting.GRAY));
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    public int m_8105_(ItemStack pStack) {
        Optional<Holder<Instrument>> optional = this.getInstrument(pStack);
        return optional.isPresent() ? ((Instrument)optional.get().m_203334_()).f_220080_() : 100;
    }

    private Optional<Holder<Instrument>> getInstrument(ItemStack pStack) {
        ResourceLocation resourcelocation;
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag != null && (resourcelocation = ResourceLocation.m_135820_((String)compoundtag.m_128461_("instrument"))) != null) {
            return Registry.f_235738_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_235737_, (ResourceLocation)resourcelocation));
        }
        Iterator iterator = Registry.f_235738_.m_206058_(this.instrument).iterator();
        return iterator.hasNext() ? Optional.of((Holder)iterator.next()) : Optional.empty();
    }

    private static void play(Level pLevel, Player pPlayer, Instrument pInstrument) {
        SoundEvent soundevent = pInstrument.f_220079_();
        float f = pInstrument.f_220081_() / 16.0f;
        pLevel.m_6269_(pPlayer, (Entity)pPlayer, soundevent, SoundSource.RECORDS, f, 1.0f);
        pLevel.m_214171_(GameEvent.f_223696_, pPlayer.m_20182_(), GameEvent.Context.m_223717_((Entity)pPlayer));
    }
}

