/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.util.dino;

import com.google.common.collect.ImmutableList;
import com.peeko32213.unusualprehistory.UnusualPrehistory;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public abstract class EntityWorldSpawnable
extends LivingEntity
implements IAnimatable {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityWorldSpawnable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> WIDTH_SCALE = SynchedEntityData.m_135353_(EntityWorldSpawnable.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HEIGHT_SCALE = SynchedEntityData.m_135353_(EntityWorldSpawnable.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final ResourceLocation MAMMOTH_LOOT = UnusualPrehistory.prefix("entities/iceberg/mammoth");
    public static final ResourceLocation SMILODON_LOOT = UnusualPrehistory.prefix("entities/iceberg/smilodon");
    public static final ResourceLocation ERYON_LOOT = UnusualPrehistory.prefix("entities/iceberg/eryon");
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final Logger LOGGER = LogManager.getLogger();
    private boolean hasGivenDna;
    private boolean canGiveItems;
    private int itemCount;
    private int currentDrop;

    public EntityWorldSpawnable(EntityType<? extends LivingEntity> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    protected abstract ItemStack getDnaItem();

    protected abstract int dropCount();

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (itemStack.m_41619_() && pHand == InteractionHand.MAIN_HAND) {
            if (!this.hasGivenDna) {
                ItemStack dna = this.getDnaItem();
                if (!dna.m_41619_() && !this.f_19853_.f_46443_) {
                    this.m_5552_(dna, 1.0f);
                    this.hasGivenDna = true;
                }
            } else if (this.dropCount() > 0 && ++this.currentDrop < this.dropCount()) {
                this.itemDrop();
            } else {
                this.m_216990_(SoundEvents.f_12424_);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        return super.m_6096_(pPlayer, pHand);
    }

    protected abstract ResourceLocation getDeadLootTable();

    public void itemDrop() {
        ItemStack drop = this.getSoundForDrop();
        if (!drop.m_41619_() && !this.f_19853_.f_46443_) {
            this.m_5552_(drop, 1.0f);
        }
    }

    protected ItemStack getSoundForDrop() {
        ItemStack lootItem = this.getItemFromLootTable();
        if (lootItem.m_41720_() == UPItems.FROZEN_FOSSIL.get() || lootItem.m_41720_() == UPItems.SMILODON_EMBRYO.get()) {
            this.m_5496_(SoundEvents.f_144245_, 1.0f, 1.0f);
        } else {
            this.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
        }
        return lootItem;
    }

    public ItemStack getItemFromLootTable() {
        LootContext.Builder lootcontext$builder;
        if (this.f_19853_.m_7654_() == null) {
            return ItemStack.f_41583_;
        }
        LootTable loottable = this.f_19853_.m_7654_().m_129898_().m_79217_(this.getDeadLootTable());
        ObjectListIterator objectListIterator = loottable.m_230922_((lootcontext$builder = this.m_7771_(false, DamageSource.f_19318_)).m_78975_(LootContextParamSets.f_81415_)).iterator();
        if (objectListIterator.hasNext()) {
            ItemStack itemstack = (ItemStack)objectListIterator.next();
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (HEIGHT_SCALE.equals(pKey) || WIDTH_SCALE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.hasGivenDna = compound.m_128471_("hasGivenDna");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hasGivenDna", this.hasGivenDna);
    }

    public Iterable<ItemStack> m_6168_() {
        return ImmutableList.of();
    }

    public ItemStack m_6844_(EquipmentSlot p_21127_) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot p_21036_, ItemStack p_21037_) {
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (source == DamageSource.f_19310_ || source == DamageSource.f_19318_) {
            return false;
        }
        return false;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_5789_() {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    protected abstract String getFrozenState();

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getFrozenState() != null) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.getFrozenState()));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

