/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.util.dino;

import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.common.entity.EntityTyrannosaurusRex;
import com.peeko32213.unusualprehistory.common.entity.IBookEntity;
import com.peeko32213.unusualprehistory.common.entity.IHatchableEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public abstract class EntityBaseAquaticAnimal
extends WaterAnimal
implements IAnimatable,
IBookEntity,
IHatchableEntity {
    private static final EntityDataAccessor<Boolean> HUNGRY = SynchedEntityData.m_135353_(EntityBaseAquaticAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TIME_TILL_HUNGRY = SynchedEntityData.m_135353_(EntityBaseAquaticAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(EntityBaseAquaticAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PASSIVE = SynchedEntityData.m_135353_(EntityBaseAquaticAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BOOK = SynchedEntityData.m_135353_(EntityBaseAquaticAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityBaseAquaticAnimal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int lastTimeSinceHungry;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public EntityBaseAquaticAnimal(EntityType<? extends WaterAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21342_ = new MoveHelperController(this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        if (this.hasAvoidEntity()) {
            this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, EntityTyrannosaurusRex.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        }
        if (this.hasTargets()) {
            this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, false, false, entity -> entity.m_6095_().m_204039_(this.getTargetTag())){

                public boolean m_8036_() {
                    return ((EntityBaseDinosaurAnimal)this.f_26135_).isHungry() && super.m_8036_();
                }
            });
        }
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_20069_() && this.m_20184_().m_82556_() > 0.03) {
            Vec3 vec3 = this.m_20252_(0.0f);
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 360))) * 0.3f;
            float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 360))) * 0.3f;
        }
        if (!this.canGetHungry()) {
            return;
        }
        if (!this.isHungry() && this.lastTimeSinceHungry < this.getTimeTillHungry()) {
            ++this.lastTimeSinceHungry;
        }
        if (this.lastTimeSinceHungry >= this.getTimeTillHungry()) {
            this.setHungry(true);
            this.lastTimeSinceHungry = 0;
        }
    }

    public void killed(ServerLevel world, LivingEntity entity) {
        this.m_5634_(this.getKillHealAmount());
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (prev && this.m_6162_()) {
            return false;
        }
        return prev;
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            this.m_5496_(this.getAttackSound(), 0.1f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        int i;
        if (pFallDistance > 1.0f) {
            this.m_5496_(SoundEvents.f_11980_, 0.4f, 1.0f);
        }
        if ((i = this.m_5639_(pFallDistance, pMultiplier)) <= 0) {
            return false;
        }
        this.m_6469_(pSource, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(pSource, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HUNGRY, (Object)true);
        this.f_19804_.m_135372_(TIME_TILL_HUNGRY, (Object)0);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
        this.f_19804_.m_135372_(PASSIVE, (Object)0);
        this.f_19804_.m_135372_(FROM_BOOK, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsHungry", this.isHungry());
        compound.m_128405_("TimeTillHungry", this.getTimeTillHungry());
        compound.m_128379_("Saddle", this.isSaddled());
        compound.m_128405_("PassiveTicks", this.getPassiveTicks());
        compound.m_128405_("variant", this.getVariant());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHungry(compound.m_128471_("IsHungry"));
        this.setTimeTillHungry(compound.m_128451_("TimeTillHungry"));
        this.setSaddled(compound.m_128471_("Saddle"));
        this.setPassiveTicks(compound.m_128451_("PassiveTicks"));
        this.setVariant(compound.m_128451_("variant"));
    }

    public boolean isHungry() {
        return (Boolean)this.f_19804_.m_135370_(HUNGRY);
    }

    public void setHungry(boolean hungry) {
        this.f_19804_.m_135381_(HUNGRY, (Object)hungry);
    }

    public int getTimeTillHungry() {
        return (Integer)this.f_19804_.m_135370_(TIME_TILL_HUNGRY);
    }

    public void setTimeTillHungry(int ticks) {
        this.f_19804_.m_135381_(TIME_TILL_HUNGRY, (Object)ticks);
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public int getPassiveTicks() {
        return (Integer)this.f_19804_.m_135370_(PASSIVE);
    }

    public boolean isFromBook() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOOK);
    }

    public void setIsFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }

    public void setPassiveTicks(int passiveTicks) {
        this.f_19804_.m_135381_(PASSIVE, (Object)passiveTicks);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_8077_();
    }

    public boolean m_6785_(double d) {
        return !this.m_8077_();
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void determineVariant(int variantChange) {
    }

    @Override
    public void setFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason != MobSpawnType.BUCKET) {
            this.determineVariant(this.f_19796_.m_188503_(100));
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected abstract SoundEvent getAttackSound();

    protected abstract int getKillHealAmount();

    protected abstract boolean canGetHungry();

    protected abstract boolean hasTargets();

    protected abstract boolean hasAvoidEntity();

    protected abstract boolean hasCustomNavigation();

    protected abstract boolean hasMakeStuckInBlock();

    protected abstract boolean customMakeStuckInBlockCheck(BlockState var1);

    protected abstract TagKey<EntityType<?>> getTargetTag();

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static boolean checkSurfaceWaterDinoSpawnRules(EntityType<? extends WaterAnimal> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_) && (Boolean)UnusualPrehistoryConfig.DINO_NATURAL_SPAWNING.get() != false;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityBaseAquaticAnimal dolphin;

        public MoveHelperController(EntityBaseAquaticAnimal dolphinIn) {
            super((Mob)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void m_8126_() {
            if (this.dolphin.m_20069_()) {
                this.dolphin.m_20256_(this.dolphin.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.dolphin.m_21573_().m_26571_()) {
                double d2;
                double d1;
                double d0 = this.f_24975_ - this.dolphin.m_20185_();
                double d3 = d0 * d0 + (d1 = this.f_24976_ - this.dolphin.m_20186_()) * d1 + (d2 = this.f_24977_ - this.dolphin.m_20189_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                } else {
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.m_146922_(this.m_24991_(this.dolphin.m_146908_(), f, 10.0f));
                    this.dolphin.f_20883_ = this.dolphin.m_146908_();
                    this.dolphin.f_20885_ = this.dolphin.m_146908_();
                    float f1 = (float)(this.f_24978_ * this.dolphin.m_21133_(Attributes.f_22279_));
                    if (this.dolphin.m_20069_()) {
                        this.dolphin.m_7910_(f1 * 0.02f);
                        float f2 = -((float)(Mth.m_14136_((double)d1, (double)Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.m_146926_(this.m_24991_(this.dolphin.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(this.dolphin.m_146909_() * ((float)Math.PI / 180)));
                        float f4 = Mth.m_14031_((float)(this.dolphin.m_146909_() * ((float)Math.PI / 180)));
                        this.dolphin.f_20902_ = f3 * f1;
                        this.dolphin.f_20901_ = -f4 * f1;
                    } else {
                        this.dolphin.m_7910_(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.m_7910_(0.0f);
                this.dolphin.m_21570_(0.0f);
                this.dolphin.m_21567_(0.0f);
                this.dolphin.m_21564_(0.0f);
            }
        }
    }
}

