/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.util;

import com.peeko32213.unusualprehistory.common.data.LootFruitCodec;
import com.peeko32213.unusualprehistory.common.data.LootFruitJsonManager;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPBlocks;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;

public class TradeGoal
extends Goal {
    private static final TargetingConditions TRADE_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    private final TargetingConditions targetingConditions;
    protected final EntityBaseDinosaurAnimal mob;
    private final Ingredient items;
    @Nullable
    protected Player player;

    public TradeGoal(EntityBaseDinosaurAnimal pMob, Ingredient pItems) {
        this.mob = pMob;
        this.items = pItems;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TRADE_TARGETING.m_148354_().m_26888_(this::shouldTrade);
    }

    private boolean shouldTrade(LivingEntity p_148139_) {
        return this.items.test(p_148139_.m_21205_()) || this.items.test(p_148139_.m_21206_());
    }

    public boolean m_8036_() {
        if (this.mob.getTradingCooldownTimer() > 0 || this.mob.m_20071_() || this.items == null) {
            return false;
        }
        this.player = this.mob.f_19853_.m_45946_(this.targetingConditions, (LivingEntity)this.mob);
        return this.player != null;
    }

    public boolean m_8045_() {
        if (this.mob.getTradingCooldownTimer() > 0 || this.mob.m_20071_()) {
            return false;
        }
        this.player = this.mob.f_19853_.m_45946_(this.targetingConditions, (LivingEntity)this.mob);
        return this.player != null;
    }

    public void m_8056_() {
        this.mob.setIsTrading(true);
        super.m_8056_();
    }

    public void m_8037_() {
        super.m_8037_();
        Item item = this.player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        List<LootFruitCodec> lootFruits = LootFruitJsonManager.getLoot(item, null);
        if (lootFruits == null) {
            return;
        }
        if (!lootFruits.isEmpty()) {
            ItemStack lootFruit = new ItemStack((ItemLike)UPBlocks.FRUIT_LOOT_BOX.get());
            CompoundTag lootFruitTag = lootFruit.m_41784_();
            int color = lootFruits.get(0).getColor().m_131265_();
            int modelData = lootFruits.get(0).getCustomModelData();
            lootFruitTag.m_128359_("translationKey", lootFruits.get(0).getTranslationKey());
            lootFruitTag.m_128405_("color", color);
            lootFruitTag.m_128365_("tradeItem", (Tag)item.m_7968_().serializeNBT());
            lootFruitTag.m_128405_("CustomModelData", modelData);
            lootFruit.m_41751_(lootFruitTag);
            this.mob.m_21008_(InteractionHand.MAIN_HAND, lootFruit);
            if (this.mob.getTradingAndGottenItem()) {
                double d0 = this.player.m_20185_() - this.mob.m_20185_();
                double d1 = this.player.m_20186_() - this.mob.m_20186_();
                double d2 = this.player.m_20189_() - this.mob.m_20189_();
                Vec3 vec3 = new Vec3(d0, d1, d2);
                vec3.m_82542_(0.5, 0.5, 0.5);
                this.mob.m_5496_((SoundEvent)UPSounds.GIGANTO_TRADE.get(), 1.0f, 1.0f);
                ItemEntity lootFruitEntity = new ItemEntity(this.mob.f_19853_, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), lootFruit, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
                this.player.m_21120_(InteractionHand.MAIN_HAND).m_41774_(1);
                this.mob.f_19853_.m_7967_((Entity)lootFruitEntity);
                this.mob.setTradingAndGottenItem(false);
                this.mob.setTradingCooldownTimer(this.mob.TRADING_COOLDOWN);
                this.m_8041_();
            }
        }
    }

    public void m_8041_() {
        this.mob.setIsTrading(false);
        this.mob.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        super.m_8041_();
    }
}

