/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.unused;

import com.google.common.collect.Lists;
import com.peeko32213.unusualprehistory.common.entity.msc.util.MammothMeleeAttackGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class EntityMammothOld
extends EntityBaseDinosaurAnimal
implements ContainerListener {
    private static final EntityDataAccessor<Boolean> IS_TRUNKING = SynchedEntityData.m_135353_(EntityMammothOld.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_HOLDING = SynchedEntityData.m_135353_(EntityMammothOld.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> HOLD_ITEM = SynchedEntityData.m_135353_(EntityMammothOld.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public float prevFeedProgress;
    public float feedProgress;
    private Ingredient temptationItems;
    public SimpleContainer mammothInventory;
    private final UUID WEAPON_MODIFIER = UUID.fromString("82aefff6-1451-11ee-be56-0242ac120002");
    public static final Predicate<Player> VALID_PLAYERS = player -> player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)UPItems.TYRANTS_CROWN.get());
    private int resetLeaderCooldown = 100;
    private LivingEntity leader;
    private int packSize = 1;

    public EntityMammothOld(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.initMammothInventory();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22285_, 3.0).m_22268_(Attributes.f_22278_, 8.5);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new MammothMeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MammothTrunkIdleGoal(this));
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (pPlayer.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)UPItems.TYRANTS_CROWN.get())) {
            if (itemStack.m_150930_(Items.f_42574_) && pPlayer.m_7655_() == InteractionHand.MAIN_HAND) {
                this.m_5907_();
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_204117_(UPTags.MAMMOTH_WEAPONS)) {
                this.giveWeapon(itemStack);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private void initMammothInventory() {
        SimpleContainer animalchest = this.mammothInventory;
        int size = 1;
        this.mammothInventory = new SimpleContainer(size){

            public boolean m_6542_(Player player) {
                return EntityMammothOld.this.m_6084_() && !EntityMammothOld.this.f_19817_;
            }
        };
        this.mammothInventory.m_19164_((ContainerListener)this);
        if (animalchest != null) {
            int i = Math.min(animalchest.m_6643_(), this.mammothInventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.mammothInventory.m_6836_(j, itemstack.m_41777_());
            }
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.mammothInventory != null) {
            for (int i = 0; i < this.mammothInventory.m_6643_(); ++i) {
                this.m_19983_(this.mammothInventory.m_8020_(i));
            }
            this.mammothInventory.m_6211_();
            this.m_21051_(Attributes.f_22281_).m_22120_(this.WEAPON_MODIFIER);
            this.setIsHolding(false);
            this.setHoldItemStack(ItemStack.f_41583_);
        }
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTags.f_13143_)}));
        }
        return this.temptationItems;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_TRUNKING, (Object)false);
        this.f_19804_.m_135372_(IS_HOLDING, (Object)false);
        this.f_19804_.m_135372_(HOLD_ITEM, (Object)ItemStack.f_41583_);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.mammothInventory != null) {
            ListTag nbttaglist = compound.m_128437_("Items", 10);
            this.initMammothInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag CompoundNBT = nbttaglist.m_128728_(i);
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)CompoundNBT.m_128469_("Item"));
                this.mammothInventory.m_6836_(j, itemStack);
                this.setHoldItemStack(itemStack);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("holding", this.isHolding());
        if (this.mammothInventory != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.mammothInventory.m_6643_(); ++i) {
                ItemStack itemstack = this.mammothInventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.m_128344_("Slot", (byte)i);
                CompoundNBT.m_128365_("Item", (Tag)itemstack.serializeNBT());
                nbttaglist.add((Object)CompoundNBT);
            }
            compound.m_128365_("Items", (Tag)nbttaglist);
        }
    }

    public BlockPos m_21534_() {
        return this.leader == null ? super.m_21534_() : this.leader.m_20097_();
    }

    public boolean m_21536_() {
        return this.isFollower();
    }

    public boolean isTrunking() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRUNKING);
    }

    public void setTrunking(boolean isPecking) {
        this.f_19804_.m_135381_(IS_TRUNKING, (Object)isPecking);
    }

    public boolean isHolding() {
        return (Boolean)this.f_19804_.m_135370_(IS_HOLDING);
    }

    public void setIsHolding(boolean isHolding) {
        this.f_19804_.m_135381_(IS_HOLDING, (Object)isHolding);
    }

    public ItemStack getHoldItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(HOLD_ITEM);
    }

    public void setHoldItemStack(ItemStack itemStack) {
        this.f_19804_.m_135381_(HOLD_ITEM, (Object)itemStack);
    }

    public void giveWeapon(ItemStack itemStack) {
        if (this.mammothInventory != null && this.mammothInventory.m_19173_(itemStack).m_41619_() && !this.isHolding()) {
            this.mammothInventory.m_19173_(itemStack);
            this.setIsHolding(true);
            this.setHoldItemStack(itemStack);
            Collection modifiers = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_);
            if (!modifiers.isEmpty()) {
                double damage = ((AttributeModifier)modifiers.stream().toList().get(0)).m_22218_();
                AttributeModifier attributeModifier = new AttributeModifier(this.WEAPON_MODIFIER, "attack_damage_mod", damage, AttributeModifier.Operation.ADDITION);
                this.m_21051_(Attributes.f_22281_).m_22118_(attributeModifier);
            }
            return;
        }
        if (this.mammothInventory != null && !this.mammothInventory.m_19173_(itemStack).m_41619_() || this.isHolding()) {
            this.m_5907_();
            return;
        }
    }

    public void m_5757_(Container pContainer) {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.resetLeaderCooldown > 0) {
                --this.resetLeaderCooldown;
            } else {
                this.resetLeaderCooldown = 200 + this.m_217043_().m_188503_(200);
                this.lookForPlayerLeader();
            }
        }
        if (this.m_5448_() != null && this.isValidLeader(this.m_5448_())) {
            this.m_6710_(null);
        }
        if (!(this.m_5448_() == null || this.isValidLeader(this.m_5448_()) || !this.m_5448_().m_6084_() || this.m_21188_() != null && this.m_21188_().m_6084_())) {
            this.m_6703_(this.m_5448_());
        }
        LivingEntity playerTarget = null;
        if (this.leader instanceof Player && ((playerTarget = this.leader.m_21214_()) == null || !playerTarget.m_6084_() || playerTarget instanceof EntityMammothOld)) {
            playerTarget = this.leader.m_21188_();
        }
        if (playerTarget != null && playerTarget.m_6084_() && !(playerTarget instanceof EntityMammothOld)) {
            this.m_6710_(playerTarget);
        }
    }

    private void lookForPlayerLeader() {
        if (!(this.leader instanceof Player)) {
            float range = 10.0f;
            List playerList = this.f_19853_.m_6443_(Player.class, this.m_20191_().m_82377_((double)range, (double)range, (double)range), VALID_PLAYERS);
            Player closestPlayer = null;
            for (Player player : playerList) {
                if (closestPlayer != null && !(player.m_20270_((Entity)this) < closestPlayer.m_20270_((Entity)this))) continue;
                closestPlayer = player;
            }
            if (closestPlayer != null) {
                this.stopFollowing();
                this.startFollowing((LivingEntity)closestPlayer);
            }
        }
    }

    public boolean isValidLeader(LivingEntity leader) {
        if (leader instanceof Player) {
            if (this.m_21188_() != null && this.m_21188_().equals((Object)leader)) {
                return false;
            }
            return leader.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)UPItems.TYRANTS_CROWN.get());
        }
        return leader.m_6084_() && leader instanceof EntityMammothOld;
    }

    public boolean isFollower() {
        return this.leader != null && this.isValidLeader(this.leader);
    }

    public LivingEntity startFollowing(LivingEntity leader) {
        this.leader = leader;
        if (leader instanceof EntityMammothOld) {
            ((EntityMammothOld)leader).addFollower();
        }
        return leader;
    }

    public void stopFollowing() {
        if (this.leader instanceof EntityMammothOld) {
            ((EntityMammothOld)this.leader).removeFollower();
        }
        this.leader = null;
    }

    private void addFollower() {
        ++this.packSize;
    }

    private void removeFollower() {
        --this.packSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.packSize < this.getMaxPackSize() && this.isValidLeader((LivingEntity)this);
    }

    public boolean hasFollowers() {
        return this.packSize > 1;
    }

    public void addFollowers(Stream<EntityMammothOld> p_27534_) {
        p_27534_.limit(this.getMaxPackSize() - this.packSize).filter(p_27538_ -> p_27538_ != this).forEach(p_27536_ -> p_27536_.startFollowing((LivingEntity)this));
    }

    public int m_5792_() {
        return 6;
    }

    public int getMaxPackSize() {
        return this.m_5792_();
    }

    public boolean inRangeOfLeader() {
        return (double)this.m_20270_((Entity)this.leader) <= 60.0;
    }

    public boolean hasLeader() {
        return this.leader != null;
    }

    public LivingEntity getLeader() {
        return this.leader;
    }

    public boolean wantsToAttack(LivingEntity pTarget, LivingEntity pOwner) {
        return true;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            double speed = 1.0;
            if (this.leader instanceof Player) {
                speed = 2.0;
                if (this.m_20270_((Entity)this.leader) > 24.0f) {
                    speed = 2.5;
                }
            }
            if (this.m_20270_((Entity)this.leader) > 6.0f && this.m_21573_().m_26571_()) {
                this.m_21573_().m_5624_((Entity)this.leader, speed);
            }
        }
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.MAMMOTH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.MAMMOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.MAMMOTH_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)UPSounds.MAJUNGA_STEP.get(), 0.1f, 1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.mammoth.move"));
            event.getController().setAnimationSpeed(1.5);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().loop("animation.mammoth.idle"));
        event.getController().setAnimationSpeed(1.0);
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState trunkPredicate(AnimationEvent<E> event) {
        if (this.isTrunking() && !this.isHolding()) {
            event.getController().setAnimation(new AnimationBuilder().playOnce("animation.mammoth.idle_trunk"));
            return PlayState.CONTINUE;
        }
        if (this.isHolding()) {
            event.getController().setAnimation(new AnimationBuilder().playOnce("animation.mammoth.trunk_hold"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(new AnimationController((IAnimatable)this, "eatController", 5.0f, this::trunkPredicate));
        data.addAnimationController(controller);
    }

    public class MammothTrunkIdleGoal
    extends Goal {
        private final EntityMammothOld mammoth;

        public MammothTrunkIdleGoal(EntityMammothOld mammoth) {
            this.mammoth = mammoth;
        }

        public boolean m_8036_() {
            return this.mammoth.m_20096_() && this.mammoth.m_217043_().m_188503_(100) == 0;
        }

        public void m_8037_() {
            this.mammoth.setTrunking(true);
            if (this.mammoth.m_217043_().m_188503_(100) <= 25) {
                this.mammoth.setTrunking(false);
            }
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }
}

