/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.projectile;

import com.mojang.logging.LogUtils;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class ThrowableFallingBlockEntity
extends ThrowableProjectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private BlockState blockState = Blocks.f_49992_.m_49966_();
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    @Nullable
    public CompoundTag blockData;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(FallingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public ThrowableFallingBlockEntity(EntityType<? extends ThrowableFallingBlockEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    private ThrowableFallingBlockEntity(Level pLevel, double pX, double pY, double pZ, BlockState pState) {
        this((EntityType<? extends ThrowableFallingBlockEntity>)((EntityType)UPEntities.THROWABLE_FALLING_BLOCK.get()), pLevel);
        this.blockState = pState;
        this.f_19850_ = true;
        this.m_6034_(pX, pY, pZ);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
        this.setStartPos(this.m_20183_());
    }

    public static ThrowableFallingBlockEntity fall(Level pLevel, BlockPos pPos, BlockState pBlockState) {
        ThrowableFallingBlockEntity fallingblockentity = new ThrowableFallingBlockEntity(pLevel, (double)pPos.m_123341_() + 0.5, pPos.m_123342_(), (double)pPos.m_123343_() + 0.5, pBlockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)pBlockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)) : pBlockState);
        pLevel.m_7731_(pPos, pBlockState.m_60819_().m_76188_(), 3);
        pLevel.m_7967_((Entity)fallingblockentity);
        return fallingblockentity;
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6097_() {
        return true;
    }

    public void setStartPos(BlockPos pStartPos) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)pStartPos);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        pResult.m_82443_().m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), 10.0f);
    }

    protected void m_6532_(HitResult pResult) {
        if (pResult.m_6662_() == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)pResult);
        }
    }

    protected boolean m_5603_(Entity pTarget) {
        return true;
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        RandomSource random1 = this.f_19853_.f_46441_;
        for (int i = 0; i < 10; ++i) {
            double d0 = random1.m_188583_() * 0.02;
            double d1 = random1.m_188583_() * 0.02;
            double d2 = random1.m_188583_() * 0.02;
            double d3 = 10.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        super.m_6469_(damagesource, amount);
        if (!this.f_19853_.f_46443_ && damagesource.m_7639_() != null) {
            Vec3 vec3d = damagesource.m_7639_().m_20154_();
            this.m_6686_(vec3d.m_7096_(), vec3d.m_7098_(), vec3d.m_7094_(), 1.5f, 0.1f);
            this.m_5602_(damagesource.m_7640_());
            return true;
        }
        return false;
    }

    public void m_8119_() {
        if (this.blockState.m_60795_()) {
            this.m_146870_();
        } else {
            BlockPos blockpos;
            Block block = this.blockState.m_60734_();
            ++this.time;
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            HitResult hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
            boolean flagHit = false;
            if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                blockpos = ((BlockHitResult)hitresult).m_82425_();
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                this.m_8060_((BlockHitResult)hitresult);
                if (blockstate.m_60713_(Blocks.f_50142_)) {
                    this.m_20221_(blockpos);
                    flagHit = true;
                } else if (blockstate.m_60713_(Blocks.f_50446_)) {
                    BlockEntity blockentity = this.f_19853_.m_7702_(blockpos);
                    if (blockentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                        TheEndGatewayBlockEntity.m_155828_((Level)this.f_19853_, (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
                    }
                    flagHit = true;
                }
            }
            if (hitresult.m_6662_() != HitResult.Type.MISS && !flagHit && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            if (!this.f_19853_.f_46443_) {
                BlockHitResult blockhitresult;
                blockpos = this.m_20183_();
                boolean flag = this.blockState.m_60734_() instanceof ConcretePowderBlock;
                boolean flag1 = flag && this.blockState.canBeHydrated((BlockGetter)this.f_19853_, blockpos, this.f_19853_.m_6425_(blockpos), blockpos);
                double d0 = this.m_20184_().m_82556_();
                if (flag && d0 > 1.0 && (blockhitresult = this.f_19853_.m_45547_(new ClipContext(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).m_6662_() != HitResult.Type.MISS && this.blockState.canBeHydrated((BlockGetter)this.f_19853_, blockpos, this.f_19853_.m_6425_(blockhitresult.m_82425_()), blockhitresult.m_82425_())) {
                    blockpos = blockhitresult.m_82425_();
                    flag1 = true;
                }
                if (!this.f_19861_ && !flag1) {
                    if (!(this.f_19853_.f_46443_ || (this.time <= 100 || blockpos.m_123342_() > this.f_19853_.m_141937_() && blockpos.m_123342_() <= this.f_19853_.m_151558_()) && this.time <= 600)) {
                        if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19998_((ItemLike)block);
                        }
                        this.m_146870_();
                    }
                } else {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    if (!blockstate.m_60713_(Blocks.f_50110_)) {
                        if (!this.cancelDrop) {
                            boolean flag4;
                            boolean flag2 = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, blockpos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
                            boolean flag3 = FallingBlock.m_53241_((BlockState)this.f_19853_.m_8055_(blockpos.m_7495_())) && (!flag || !flag1);
                            boolean bl = flag4 = this.blockState.m_60710_((LevelReader)this.f_19853_, blockpos) && !flag3;
                            if (flag2 && flag4) {
                                if (this.blockState.m_61138_((Property)BlockStateProperties.f_61362_) && this.f_19853_.m_6425_(blockpos).m_76152_() == Fluids.f_76193_) {
                                    this.blockState = (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                                }
                                if (this.f_19853_.m_7731_(blockpos, this.blockState, 3)) {
                                    BlockEntity blockentity;
                                    ((ServerLevel)this.f_19853_).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.f_19853_.m_8055_(blockpos)));
                                    this.m_146870_();
                                    if (this.blockData != null && this.blockState.m_155947_() && (blockentity = this.f_19853_.m_7702_(blockpos)) != null) {
                                        CompoundTag compoundtag = blockentity.m_187482_();
                                        for (String s : this.blockData.m_128431_()) {
                                            compoundtag.m_128365_(s, this.blockData.m_128423_(s).m_6426_());
                                        }
                                        try {
                                            blockentity.m_142466_(compoundtag);
                                        }
                                        catch (Exception exception) {
                                            LOGGER.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        blockentity.m_6596_();
                                    }
                                } else if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.m_146870_();
                                    this.callOnBrokenAfterFall(block, blockpos);
                                    this.m_19998_((ItemLike)block);
                                }
                            } else {
                                this.m_146870_();
                                if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.callOnBrokenAfterFall(block, blockpos);
                                    this.m_19998_((ItemLike)block);
                                }
                            }
                        } else {
                            this.m_146870_();
                            this.callOnBrokenAfterFall(block, blockpos);
                        }
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }

    public void callOnBrokenAfterFall(Block pBlock, BlockPos pPos) {
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        DamageSource damagesource;
        Predicate predicate;
        if (!this.hurtEntities) {
            return false;
        }
        int i = Mth.m_14167_((float)(pFallDistance - 1.0f));
        if (i < 0) {
            return false;
        }
        if (this.blockState.m_60734_() instanceof Fallable) {
            Fallable fallable = (Fallable)this.blockState.m_60734_();
            predicate = fallable.m_142398_();
            damagesource = fallable.m_142088_();
        } else {
            predicate = EntitySelector.f_20408_;
            damagesource = DamageSource.f_19322_;
        }
        float f = Math.min(Mth.m_14143_((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
        this.f_19853_.m_6249_((Entity)this, this.m_20191_(), predicate).forEach(p_149649_ -> p_149649_.m_6469_(damagesource, f));
        boolean flag = this.blockState.m_204336_(BlockTags.f_13033_);
        if (flag && f > 0.0f && this.f_19796_.m_188501_() < 0.05f + (float)i * 0.05f) {
            BlockState blockstate = AnvilBlock.m_48824_((BlockState)this.blockState);
            if (blockstate == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = blockstate;
            }
        }
        return false;
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        pCompound.m_128405_("Time", this.time);
        pCompound.m_128379_("DropItem", this.dropItem);
        pCompound.m_128379_("HurtEntities", this.hurtEntities);
        pCompound.m_128350_("FallHurtAmount", this.fallDamagePerDistance);
        pCompound.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            pCompound.m_128365_("TileEntityData", (Tag)this.blockData);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        this.blockState = NbtUtils.m_129241_((CompoundTag)pCompound.m_128469_("BlockState"));
        this.time = pCompound.m_128451_("Time");
        if (pCompound.m_128425_("HurtEntities", 99)) {
            this.hurtEntities = pCompound.m_128471_("HurtEntities");
            this.fallDamagePerDistance = pCompound.m_128457_("FallHurtAmount");
            this.fallDamageMax = pCompound.m_128451_("FallHurtMax");
        } else if (this.blockState.m_204336_(BlockTags.f_13033_)) {
            this.hurtEntities = true;
        }
        if (pCompound.m_128425_("DropItem", 99)) {
            this.dropItem = pCompound.m_128471_("DropItem");
        }
        if (pCompound.m_128425_("TileEntityData", 10)) {
            this.blockData = pCompound.m_128469_("TileEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
    }

    public void setHurtsEntities(float pFallDamagePerDistance, int pFallDamageMax) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = pFallDamagePerDistance;
        this.fallDamageMax = pFallDamageMax;
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7976_(CrashReportCategory pCategory) {
        super.m_7976_(pCategory);
        pCategory.m_128159_("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_6127_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        this.blockState = Block.m_49803_((int)pPacket.m_131509_());
        this.f_19850_ = true;
        double d0 = pPacket.m_131500_();
        double d1 = pPacket.m_131501_();
        double d2 = pPacket.m_131502_();
        this.m_6034_(d0, d1, d2);
        this.setStartPos(this.m_20183_());
    }

    protected float m_7139_() {
        return 0.0f;
    }
}

