/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity.msc.projectile;

import com.peeko32213.unusualprehistory.common.entity.msc.util.ranged.BetterAbstractHurtingProjectile;
import com.peeko32213.unusualprehistory.common.entity.msc.util.ranged.RangedMeleeMob;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class EntityAmberShot
extends BetterAbstractHurtingProjectile
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    protected int timeInAir;
    protected boolean inAir;
    private int ticksInAir;
    private float directHitDamage = 3.0f;

    public EntityAmberShot(EntityType<? extends EntityAmberShot> p_i50160_1_, Level p_i50160_2_) {
        super(p_i50160_1_, p_i50160_2_);
    }

    public EntityAmberShot(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, float directHitDamage) {
        super((EntityType<? extends BetterAbstractHurtingProjectile>)((EntityType)UPEntities.AMBER_SHOT.get()), shooter, accelX, accelY, accelZ, worldIn);
        this.directHitDamage = directHitDamage;
    }

    public EntityAmberShot(Level worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super((EntityType<? extends BetterAbstractHurtingProjectile>)((EntityType)UPEntities.AMBER_SHOT.get()), x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.ticksInAir = 0;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("life", (short)this.ticksInAir);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksInAir = compound.m_128448_("life");
    }

    public void setDirectHitDamage(float directHitDamage) {
        this.directHitDamage = directHitDamage;
    }

    @Override
    public void m_8119_() {
        Entity entity = this.m_37282_();
        if (this.f_19853_.f_46443_ || (entity == null || entity.m_6084_()) && this.f_19853_.m_46805_(this.m_20183_())) {
            super.m_8119_();
            HitResult raytraceresult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.m_6532_(raytraceresult);
            }
            this.m_20101_();
            Vec3 vector3d = this.m_20184_();
            double d0 = this.m_20185_() + vector3d.f_82479_;
            double d1 = this.m_20186_() + vector3d.f_82480_;
            double d2 = this.m_20189_() + vector3d.f_82481_;
            ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
            float f = this.getInertia();
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123779_, d0 - vector3d.f_82479_ * 0.25, d1 - vector3d.f_82480_ * 0.25, d2 - vector3d.f_82481_ * 0.25, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
                }
                f = 0.8f;
            }
            this.m_20256_(vector3d.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_((double)f));
            this.m_6034_(d0, d1, d2);
        } else {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_20068_() {
        return !this.m_20069_();
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        super.m_5790_(p_213868_1_);
        if (!this.f_19853_.f_46443_) {
            Entity entity = p_213868_1_.m_82443_();
            Entity entity1 = this.m_37282_();
            if (!(entity instanceof RangedMeleeMob)) {
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)((LivingEntity)entity1)), this.directHitDamage);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (entity1 instanceof LivingEntity && !(entity instanceof RangedMeleeMob)) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().loop("animation.amber_shot.move"));
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

