/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.google.common.collect.Maps;
import com.peeko32213.unusualprehistory.common.entity.IAttackEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.util.BabyPanicGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomFollower;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRideGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.TameableFollowOwner;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityTameableBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPEffects;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class EntityUlughbegsaurus
extends EntityTameableBaseDinosaurAnimal
implements CustomFollower,
IAttackEntity {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityUlughbegsaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> BLUE = SynchedEntityData.m_135353_(EntityUlughbegsaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> YELLOW = SynchedEntityData.m_135353_(EntityUlughbegsaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WHITE = SynchedEntityData.m_135353_(EntityUlughbegsaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ORANGE = SynchedEntityData.m_135353_(EntityUlughbegsaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BROWN = SynchedEntityData.m_135353_(EntityUlughbegsaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(EntityUlughbegsaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(EntityUlughbegsaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> EATING_TIME = SynchedEntityData.m_135353_(EntityUlughbegsaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<DyeColor, float[]> COLORARRAY_BY_COLOR = Maps.newEnumMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(p_29868_ -> p_29868_, EntityUlughbegsaurus::createSheepColor)));
    private int attackCooldown;
    public static final int ATTACK_COOLDOWN = 30;
    private boolean hasBlueAttributes = false;
    private boolean hasYellowAttributes = false;
    private boolean hasWhiteAttributes = false;
    private boolean hasOrangeAttributes = false;
    public float prevSitProgress;
    public float prevEatProgress;
    public float eatProgress;
    public float sitProgress;
    private static final double DELTA_Y_FOR_COLLISION = 0.5;
    private static final float ROTATION_MULTIPLIER = 0.5f;
    private static final float MOVEMENT_SPEED_MULTIPLIER = 1.5f;

    public EntityUlughbegsaurus(EntityType<? extends EntityTameableBaseDinosaurAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.2f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, 0.6);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false));
        this.f_21345_.m_25352_(2, (Goal)new IMeleeAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(1, (Goal)new CustomRideGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34){

            @Override
            public boolean m_8036_() {
                Vec3 vec3d;
                if (this.f_25725_.m_20160_()) {
                    return false;
                }
                if (!this.f_25731_) {
                    if (this.f_25725_.m_21216_() >= 100) {
                        return false;
                    }
                    if (((EntityUlughbegsaurus)this.f_25725_).isHungry() ? this.f_25725_.m_217043_().m_188503_(60) != 0 : this.f_25725_.m_217043_().m_188503_(30) != 0) {
                        return false;
                    }
                }
                if ((vec3d = this.m_7037_()) == null) {
                    return false;
                }
                this.f_25726_ = vec3d.f_82479_;
                this.f_25727_ = vec3d.f_82480_;
                this.f_25728_ = vec3d.f_82481_;
                this.f_25731_ = false;
                return true;
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new TameableFollowOwner(this, 1.2, 5.0f, 2.0f, false));
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)UPSounds.MAJUNGA_STEP.get(), 0.1f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.ULUGH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.ULUGH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.ULUGH_DEATH.get();
    }

    public boolean isYellowFood(ItemStack stack) {
        return stack.m_204117_(UPTags.YELLOW_ULUGH_FOOD);
    }

    public boolean isBlueFood(ItemStack stack) {
        return stack.m_204117_(UPTags.BLUE_ULUGH_FOOD);
    }

    public boolean isWhiteFood(ItemStack stack) {
        return stack.m_204117_(UPTags.WHITE_ULUGH_FOOD);
    }

    public boolean isOrangeFood(ItemStack stack) {
        return stack.m_204117_(UPTags.ORANGE_ULUGH_FOOD);
    }

    public boolean isEating() {
        return this.getEatingTime() > 0;
    }

    public int getEatingTime() {
        return (Integer)this.f_19804_.m_135370_(EATING_TIME);
    }

    public void setEatingTime(int shaking) {
        this.f_19804_.m_135381_(EATING_TIME, (Object)shaking);
    }

    @Override
    public boolean m_7327_(Entity target) {
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        boolean shouldHurt = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage);
        if (shouldHurt) {
            if (knockback > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (target instanceof LivingEntity && this.isYellow()) {
                ((LivingEntity)target).m_147207_(new MobEffectInstance((MobEffect)UPEffects.PREVENT_CLICK.get(), 200), (Entity)this);
            }
            this.m_19970_((LivingEntity)this, target);
            this.m_21335_(target);
        }
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        return shouldHurt;
    }

    @Override
    public void performAttack() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.setSwinging(true);
        for (Entity entity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(2.0))) {
            EntityUlughbegsaurus ulughbegsaurus;
            if (this.hasSwung() || !this.isSaddled() || !this.m_21824_() || !this.m_217005_() || entity instanceof EntityUlughbegsaurus && (ulughbegsaurus = (EntityUlughbegsaurus)entity).m_21824_() || entity.m_7306_(this.m_6688_())) continue;
            if (this.isOrange()) {
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 12.0f);
                continue;
            }
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 8.0f);
        }
    }

    @Override
    public void afterAttack() {
        this.f_19853_.m_7605_((Entity)this, (byte)5);
        this.setSwinging(false);
    }

    @Override
    public int getMaxAttackCooldown() {
        return 30;
    }

    @Override
    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    @Override
    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (this.isYellow() && this.isYellowFood(itemstack) && !this.m_21824_()) {
            if (!this.f_19853_.f_46443_) {
                int size = itemstack.m_41613_();
                this.m_21828_(player);
                itemstack.m_41774_(size);
                this.setEatingTime(50 + this.f_19796_.m_188503_(30));
            }
            this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.isBlue() && this.isBlueFood(itemstack) && !this.m_21824_()) {
            if (!this.f_19853_.f_46443_) {
                int size = itemstack.m_41613_();
                this.m_21828_(player);
                itemstack.m_41774_(size);
                this.setEatingTime(50 + this.f_19796_.m_188503_(30));
            }
            this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.isOrange() && this.isOrangeFood(itemstack) && !this.m_21824_()) {
            if (!this.f_19853_.f_46443_) {
                int size = itemstack.m_41613_();
                this.m_21828_(player);
                itemstack.m_41774_(size);
                this.setEatingTime(50 + this.f_19796_.m_188503_(30));
            }
            this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.isWhite() && this.isWhiteFood(itemstack) && !this.m_21824_()) {
            if (!this.f_19853_.f_46443_) {
                int size = itemstack.m_41613_();
                this.m_21828_(player);
                itemstack.m_41774_(size);
                this.setEatingTime(50 + this.f_19796_.m_188503_(30));
            }
            this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.isBrown() && this.isBrownFood(itemstack) && !this.m_21824_()) {
            if (!this.f_19853_.f_46443_) {
                int size = itemstack.m_41613_();
                this.m_21828_(player);
                itemstack.m_41774_(size);
                this.setEatingTime(50 + this.f_19796_.m_188503_(30));
            }
            this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            boolean sit;
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.f_19853_.f_46443_) {
                    this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == Items.f_42450_ && !this.isSaddled()) {
                this.m_142075_(player, hand, itemstack);
                this.setSaddled(true);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == Items.f_42574_ && this.isSaddled()) {
                this.setSaddled(false);
                this.m_19998_((ItemLike)Items.f_42450_);
                return InteractionResult.SUCCESS;
            }
            if (!player.m_6144_() && !this.m_6162_() && this.isSaddled()) {
                if (!this.f_19853_.f_46443_) {
                    player.m_20329_((Entity)this);
                }
                return InteractionResult.SUCCESS;
            }
            this.setCommand((this.getCommand() + 1) % 3);
            if (this.getCommand() == 3) {
                this.setCommand(0);
            }
            player.m_5661_((Component)Component.m_237110_((String)("entity.unusualprehistory.all.command_" + this.getCommand()), (Object[])new Object[]{this.m_7755_()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                this.m_21839_(true);
                return InteractionResult.SUCCESS;
            }
            this.m_21839_(false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6898_(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return item.m_41472_() && pStack.getFoodProperties((LivingEntity)this).m_38746_();
    }

    public SoundEvent m_7866_(ItemStack p_28540_) {
        return SoundEvents.f_11912_;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Blue", this.isBlue());
        compound.m_128379_("Yellow", this.isYellow());
        compound.m_128379_("White", this.isWhite());
        compound.m_128379_("Orange", this.isOrange());
        compound.m_128379_("Saddle", this.isSaddled());
        compound.m_128379_("Brown", this.isBrown());
        compound.m_128405_("TrikeCommand", this.getCommand());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBlue(compound.m_128471_("Blue"));
        this.setYellow(compound.m_128471_("Yellow"));
        this.setWhite(compound.m_128471_("White"));
        this.setOrange(compound.m_128471_("Orange"));
        this.setBrown(compound.m_128471_("Brown"));
        this.setSaddled(compound.m_128471_("Saddle"));
        this.setCommand(compound.m_128451_("TrikeCommand"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EATING_TIME, (Object)0);
        this.f_19804_.m_135372_(BLUE, (Object)false);
        this.f_19804_.m_135372_(YELLOW, (Object)false);
        this.f_19804_.m_135372_(WHITE, (Object)false);
        this.f_19804_.m_135372_(ORANGE, (Object)false);
        this.f_19804_.m_135372_(BROWN, (Object)false);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
    }

    public boolean isBrownFood(ItemStack stack) {
        return stack.m_204117_(UPTags.BROWN_ULUGH_FOOD);
    }

    @Override
    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    @Override
    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    @Override
    @javax.annotation.Nullable
    public Entity m_6688_() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player)) continue;
            return (Player)passenger;
        }
        return null;
    }

    public void m_7332_(Entity passenger) {
        float ySin = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float yCos = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        passenger.m_6034_(this.m_20185_() + (double)(0.5f * ySin), this.m_20186_() + this.m_6048_() + passenger.m_6049_() + (double)0.4f, this.m_20189_() - (double)(0.5f * yCos));
    }

    public double m_6048_() {
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            return 2.1;
        }
        if (this.m_20069_()) {
            return 0.535;
        }
        return 2.35;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.m_21827_() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.m_21827_() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isEating() && this.eatProgress < 5.0f) {
            this.eatProgress += 1.0f;
        }
        if (!this.isEating() && this.eatProgress > 0.0f) {
            this.eatProgress -= 1.0f;
        }
        if (this.isEating()) {
            this.setEatingTime(this.getEatingTime() - 1);
            this.m_21573_().m_26573_();
        }
        if (this.getCommand() == 2 && !this.m_20160_()) {
            this.m_21839_(true);
        } else {
            this.m_21839_(false);
        }
    }

    public void m_7023_(Vec3 destination) {
        LivingEntity passenger = (LivingEntity)this.m_6688_();
        if (this.m_20160_() && passenger != null) {
            double delta = 0.5;
            this.m_146922_(passenger.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(passenger.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            float f = (float)((double)passenger.f_20900_ * 0.5);
            float f1 = passenger.f_20902_;
            if (f1 <= 0.0f) {
                f1 = (float)((double)f1 * 0.25);
            }
            this.m_7910_((float)(this.m_21133_(Attributes.f_22279_) * 1.5));
            super.m_7023_(new Vec3((double)f, destination.f_82480_, (double)f1));
        } else {
            super.m_7023_(destination);
        }
    }

    public float getStepHeight() {
        return 1.2f;
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_21826_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return entityIn.m_7306_((Entity)this);
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
    }

    public boolean isBlue() {
        return (Boolean)this.f_19804_.m_135370_(BLUE);
    }

    public void setBlue(boolean green) {
        boolean prev = this.isBlue();
        if (!prev && green) {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.3);
            this.m_21153_(30.0f);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
        }
        this.m_5634_(this.m_21233_());
        this.f_19804_.m_135381_(BLUE, (Object)green);
    }

    public boolean isYellow() {
        return (Boolean)this.f_19804_.m_135370_(YELLOW);
    }

    public void setYellow(boolean green) {
        boolean prev = this.isYellow();
        if (!prev && green) {
            this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
            this.m_21153_(25.0f);
        } else {
            this.m_21051_(Attributes.f_22281_).m_22100_(8.0);
        }
        this.m_5634_(this.m_21233_());
        this.f_19804_.m_135381_(YELLOW, (Object)green);
    }

    public boolean isWhite() {
        return (Boolean)this.f_19804_.m_135370_(WHITE);
    }

    public void setWhite(boolean green) {
        boolean prev = this.isWhite();
        if (!prev && green) {
            this.m_21051_(Attributes.f_22276_).m_22100_(50.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(4.0);
            this.m_21153_(25.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(40.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(8.0);
        }
        this.m_5634_(this.m_21233_());
        this.f_19804_.m_135381_(WHITE, (Object)green);
    }

    public boolean isOrange() {
        return (Boolean)this.f_19804_.m_135370_(ORANGE);
    }

    public void setOrange(boolean green) {
        boolean prev = this.isOrange();
        if (!prev && green) {
            this.m_21051_(Attributes.f_22281_).m_22100_(12.0);
            this.m_21153_(25.0f);
        } else {
            this.m_21051_(Attributes.f_22281_).m_22100_(8.0);
        }
        this.m_5634_(this.m_21233_());
        this.f_19804_.m_135381_(ORANGE, (Object)green);
    }

    public boolean isBrown() {
        return (Boolean)this.f_19804_.m_135370_(BROWN);
    }

    public void setBrown(boolean green) {
        boolean prev = this.isBrown();
        if (!prev && green) {
            this.m_21051_(Attributes.f_22278_).m_22100_(10.0);
            this.m_21051_(Attributes.f_22285_).m_22100_(10.0);
            this.m_21051_(Attributes.f_22284_).m_22100_(10.0);
            this.m_21153_(25.0f);
        } else {
            this.m_21051_(Attributes.f_22278_).m_22100_(0.6);
            this.m_21051_(Attributes.f_22285_).m_22100_(0.0);
            this.m_21051_(Attributes.f_22284_).m_22100_(0.0);
        }
        this.m_5634_(this.m_21233_());
        this.f_19804_.m_135381_(BROWN, (Object)green);
    }

    @Override
    public void determineVariant(int variantChange) {
        if (variantChange <= 30) {
            this.setWhite(true);
            this.setVariant(1);
        } else if (variantChange <= 40 && variantChange > 30) {
            this.setYellow(true);
            this.setVariant(2);
        } else if (variantChange <= 60 && variantChange > 40) {
            this.setOrange(true);
            this.setVariant(3);
        } else if (variantChange <= 80 && variantChange > 60) {
            this.setBrown(true);
            this.setVariant(4);
        } else {
            this.setBlue(true);
            this.setVariant(0);
        }
    }

    @Override
    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnDataIn, @javax.annotation.Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        int variantChange = this.f_19796_.m_216339_(0, 100);
        this.determineVariant(variantChange);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected SoundEvent getAttackSound() {
        return (SoundEvent)UPSounds.ULUGH_BITE.get();
    }

    @Override
    protected int getKillHealAmount() {
        return 5;
    }

    @Override
    protected boolean canGetHungry() {
        return true;
    }

    @Override
    protected boolean hasTargets() {
        return true;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return true;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return UPTags.RAPTOR_TARGETS;
    }

    private void attack(LivingEntity entity) {
        entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 5.0f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        this.m_21839_(false);
        if (entity != null && this.m_21824_() && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    public static float[] getColorArray(DyeColor pDyeColor) {
        return COLORARRAY_BY_COLOR.get(pDyeColor);
    }

    private static float[] createSheepColor(DyeColor p_29866_) {
        if (p_29866_ == DyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = p_29866_.m_41068_();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.2);
        } else {
            this.m_6858_(false);
        }
        super.m_8024_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_21825_() && !this.m_20069_()) {
            if (this.m_20142_() || !this.m_20197_().isEmpty()) {
                event.getController().setAnimation(new AnimationBuilder().loop("animation.ulugh.sprint"));
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().loop("animation.ulugh.walk"));
                event.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
        }
        if (this.m_21825_() && !this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.ulugh.sitting"));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.ulugh.swim"));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.ulugh.idle"));
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState eatPredicate(AnimationEvent<E> event) {
        if (this.getEatingTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.ulugh.eating"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState attackPredicate(AnimationEvent<E> event) {
        if (this.isSwinging() && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().playOnce("animation.ulugh.bite"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(new AnimationController((IAnimatable)this, "eatController", 5.0f, this::eatPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 0.0f, this::attackPredicate));
        data.addAnimationController(controller);
    }

    class IMeleeAttackGoal
    extends MeleeAttackGoal {
        public IMeleeAttackGoal() {
            super((PathfinderMob)EntityUlughbegsaurus.this, 1.6, true);
        }

        protected double m_6639_(LivingEntity p_25556_) {
            return this.f_25540_.m_20205_() * 2.0f * this.f_25540_.m_20205_() * 0.66f + p_25556_.m_20205_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                ((EntityUlughbegsaurus)this.f_25540_).setHungry(false);
                ((EntityUlughbegsaurus)this.f_25540_).attack(enemy);
                ((EntityUlughbegsaurus)this.f_25540_).setTimeTillHungry(this.f_25540_.m_217043_().m_188503_(300) + 300);
            }
        }
    }
}

