/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.HitboxHelper;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPEffects;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class EntityTyrannosaurusRex
extends EntityBaseDinosaurAnimal {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EntityTyrannosaurusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMBAT_STATE = SynchedEntityData.m_135353_(EntityTyrannosaurusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(EntityTyrannosaurusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> EEPY = SynchedEntityData.m_135353_(EntityTyrannosaurusRex.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int timeUntilDrops;
    private int passiveFor;
    private int shakeCooldown;
    private int stunnedTick;

    public EntityTyrannosaurusRex(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.timeUntilDrops = this.f_19796_.m_188503_(12000) + 24000;
        this.passiveFor = 0;
        this.shakeCooldown = 0;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 10.5).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RexMeleeAttackGoal(this, 2.0, true){

            @Override
            public boolean m_8036_() {
                return !EntityTyrannosaurusRex.this.m_6162_() && EntityTyrannosaurusRex.this.passiveFor == 0 && EntityTyrannosaurusRex.this.f_19853_.m_46791_() != Difficulty.PEACEFUL && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return !EntityTyrannosaurusRex.this.hasEepy() && EntityTyrannosaurusRex.this.passiveFor == 0 && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, false, false, entity -> entity.m_6095_().m_204039_(UPTags.REX_TARGETS)){

            public boolean m_8036_() {
                return !EntityTyrannosaurusRex.this.hasEepy() && EntityTyrannosaurusRex.this.passiveFor == 0 && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (item == UPItems.ADORNED_STAFF.get() && this.hasEepy()) {
            itemstack.m_41622_(5, (LivingEntity)player, p_29822_ -> p_29822_.m_21190_(hand));
            if (!this.f_19853_.f_46443_) {
                this.m_5634_(200.0f);
                this.m_6710_(null);
                this.setEepy(false);
                this.passiveFor = 1000000000 + this.f_19796_.m_188503_(1000000000);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_6573_(Player p_21418_) {
        return this.hasEepy();
    }

    @Override
    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (this.hasEepy()) {
            return false;
        }
        return prev;
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 50;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return true;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    public void setEepy(boolean eepy) {
        this.f_19804_.m_135381_(EEPY, (Object)eepy);
    }

    public boolean hasEepy() {
        return (Boolean)this.f_19804_.m_135370_(EEPY);
    }

    public boolean shouldBeEepy() {
        return this.m_21223_() <= this.m_21233_() / 15.0f;
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.shouldBeEepy()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("StunTick", this.stunnedTick);
        compound.m_128379_("Eepy", this.hasEepy());
        compound.m_128405_("PassiveFor", this.passiveFor);
        compound.m_128405_("DropTime", this.timeUntilDrops);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.stunnedTick = compound.m_128451_("StunTick");
        this.setEepy(compound.m_128471_("Eepy"));
        this.passiveFor = compound.m_128451_("PassiveFor");
        if (compound.m_128441_("SpitTime")) {
            this.timeUntilDrops = compound.m_128451_("DropTime");
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(COMBAT_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
        this.f_19804_.m_135372_(EEPY, (Object)false);
    }

    public void m_7822_(byte pId) {
        if (pId == 39) {
            this.stunnedTick = 60;
        } else {
            super.m_7822_(pId);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.shouldBeEepy()) {
            this.setEepy(true);
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.passiveFor > 0 && --this.timeUntilDrops <= 0) {
            this.m_20000_((ItemLike)UPItems.REX_TOOTH.get(), 4);
            this.m_20000_((ItemLike)UPItems.REX_SCALE.get(), 9);
            this.timeUntilDrops = this.f_19796_.m_188503_(12000) + 24000;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_6069_() && !this.m_20069_() && this.shakeCooldown <= 0 && ((Boolean)UnusualPrehistoryConfig.SCREEN_SHAKE_REX.get()).booleanValue()) {
            double rexShakeRange = (Double)UnusualPrehistoryConfig.SCREEN_SHAKE_REX_RANGE.get();
            int rexShakeAmp = (Integer)UnusualPrehistoryConfig.SCREEN_SHAKE_REX_AMPLIFIER.get();
            float rexMoveSoundVolume = ((Float)UnusualPrehistoryConfig.REX_SOUND_VOLUME.get()).floatValue();
            List list = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(rexShakeRange));
            for (LivingEntity e : list) {
                if (e instanceof EntityTyrannosaurusRex || !e.m_6084_()) continue;
                e.m_7292_(new MobEffectInstance((MobEffect)UPEffects.SCREEN_SHAKE.get(), 20, rexShakeAmp, false, false, false));
                this.m_5496_((SoundEvent)UPSounds.REX_STEP.get(), rexMoveSoundVolume, 0.7f);
            }
            this.shakeCooldown = 30;
        }
        --this.shakeCooldown;
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            this.m_6858_(this.m_21566_().m_24999_() >= 1.5);
        } else {
            this.m_6858_(false);
        }
        super.m_8024_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.shouldBeEepy()) {
            this.stunnedTick = 60;
            this.f_19853_.m_7605_((Entity)this, (byte)39);
            this.setEepy(true);
            this.m_21561_(false);
            this.m_6710_(null);
        }
        if (this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) && this.m_20142_()) {
            boolean flag = false;
            AABB axisalignedbb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)axisalignedbb.f_82288_), (int)Mth.m_14107_((double)axisalignedbb.f_82289_), (int)Mth.m_14107_((double)axisalignedbb.f_82290_), (int)Mth.m_14107_((double)axisalignedbb.f_82291_), (int)Mth.m_14107_((double)axisalignedbb.f_82292_), (int)Mth.m_14107_((double)axisalignedbb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (!blockstate.m_204336_(UPTags.TRIKE_BREAKABLES)) continue;
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    @Override
    public boolean m_8023_() {
        return super.m_8023_() || this.m_8077_();
    }

    @Override
    public boolean m_6785_(double d) {
        return !this.m_8077_();
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)anim);
    }

    public int getCombatState() {
        return (Integer)this.f_19804_.m_135370_(COMBAT_STATE);
    }

    public void setCombatState(int anim) {
        this.f_19804_.m_135381_(COMBAT_STATE, (Object)anim);
    }

    public int getEntityState() {
        return (Integer)this.f_19804_.m_135370_(ENTITY_STATE);
    }

    public void setEntityState(int anim) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)anim);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19315_ || source == DamageSource.f_19319_ || source == DamageSource.f_19310_ || source == DamageSource.f_19322_ || source == DamageSource.f_19314_ || source.m_19360_() || super.m_6673_(source);
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    public boolean m_7301_(MobEffectInstance p_33809_) {
        if (p_33809_.m_19544_() == MobEffects.f_19613_) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, p_33809_);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(p_33809_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.REX_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.REX_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.REX_DEATH.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        int animState = this.getAnimationState();
        switch (animState) {
            case 21: {
                event.getController().setAnimation(new AnimationBuilder().playOnce("rex.bite"));
                break;
            }
            case 22: {
                event.getController().setAnimation(new AnimationBuilder().playOnce("rex.whip"));
                break;
            }
            case 23: {
                event.getController().setAnimation(new AnimationBuilder().playOnce("rex.stompl"));
                break;
            }
            case 24: {
                event.getController().setAnimation(new AnimationBuilder().playOnce("rex.stompr"));
                break;
            }
            default: {
                if (this.hasEepy()) {
                    event.getController().setAnimation(new AnimationBuilder().loop("rex.eepy"));
                    event.getController().setAnimationSpeed(1.0);
                    return PlayState.CONTINUE;
                }
                if (this.m_20069_()) {
                    event.getController().setAnimation(new AnimationBuilder().loop("rex.swim"));
                    event.getController().setAnimationSpeed(1.0);
                    return PlayState.CONTINUE;
                }
                if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_6069_() && !this.m_20069_()) {
                    if (this.m_20142_()) {
                        event.getController().setAnimation(new AnimationBuilder().loop("rex.charge"));
                        event.getController().setAnimationSpeed(1.0);
                        return PlayState.CONTINUE;
                    }
                    event.getController().setAnimation(new AnimationBuilder().loop("rex.walk"));
                    event.getController().setAnimationSpeed(1.0);
                    return PlayState.CONTINUE;
                }
                if (this.m_20069_()) break;
                event.getController().setAnimation(new AnimationBuilder().loop("rex.idle"));
                event.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(1.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(controller);
    }

    static class RexMeleeAttackGoal
    extends Goal {
        protected final EntityTyrannosaurusRex mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int animTime = 0;

        public RexMeleeAttackGoal(EntityTyrannosaurusRex p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.f_19853_.m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.setAnimationState(0);
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            switch (animState) {
                case 21: {
                    this.tickBiteAttack();
                    break;
                }
                case 22: {
                    this.tickWhipAttack();
                    break;
                }
                case 23: {
                    this.tickStompAttack();
                    break;
                }
                case 24: {
                    this.tickStompAttack();
                    break;
                }
                default: {
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            if (distance <= reach && this.ticksUntilNextAttack <= 0) {
                int r = this.mob.m_217043_().m_188503_(2048);
                if (r <= 600) {
                    this.mob.setAnimationState(21);
                } else if (r > 600 && r <= 800) {
                    this.mob.setAnimationState(22);
                } else if (r > 800 && r <= 1400) {
                    this.mob.setAnimationState(23);
                } else {
                    this.mob.setAnimationState(24);
                }
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= (double)1.8f * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickBiteAttack() {
            ++this.animTime;
            if (this.animTime >= 6 && this.animTime < 9) {
                this.preformBiteAttack();
            }
            if (this.animTime >= 9) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickWhipAttack() {
            ++this.animTime;
            if (this.animTime >= 15 && this.animTime < 18) {
                this.preformWhipAttack();
            }
            if (this.animTime >= 16) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickStompAttack() {
            ++this.animTime;
            if (this.animTime >= 25 && this.animTime < 30) {
                this.preformStompAttack();
            }
            if (this.animTime >= 30) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void preformBiteAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.REX_BITE.get(), 1.0f, 1.0f);
            HitboxHelper.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 10.0f, 0.1f, (PathfinderMob)this.mob, pos, 5.0, -1.5707963267948966, 1.5707963267948966, -1.0, 3.0);
        }

        protected void preformWhipAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.REX_TAIL_SWIPE.get(), 1.0f, 1.0f);
            HitboxHelper.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 10.0f, 2.0f, (PathfinderMob)this.mob, pos, 8.0, -1.5707963267948966, 1.5707963267948966, -1.0, 3.0);
        }

        protected void preformStompAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.REX_STOMP_ATTACK.get(), 1.9f, 1.9f);
            HitboxHelper.LargeAttack(DamageSource.m_19370_((LivingEntity)this.mob), 25.0f, 2.5f, (PathfinderMob)this.mob, pos, 7.0, -1.5707963267948966, 1.5707963267948966, -1.0, 3.0);
            if (this.mob.shakeCooldown <= 0 && ((Boolean)UnusualPrehistoryConfig.SCREEN_SHAKE_REX.get()).booleanValue()) {
                double rexShakeRange = (Double)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI_RANGE.get();
                List list = this.mob.f_19853_.m_45976_(LivingEntity.class, this.mob.m_20191_().m_82400_(rexShakeRange));
                for (LivingEntity e : list) {
                    if (e instanceof EntityTyrannosaurusRex || !e.m_6084_()) continue;
                    e.m_7292_(new MobEffectInstance((MobEffect)UPEffects.SCREEN_SHAKE.get(), 10, 3, false, false, false));
                }
                this.mob.shakeCooldown = 100;
            }
            --this.mob.shakeCooldown;
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 0;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 5;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 1.8f + p_179512_1_.m_20205_();
        }
    }
}

