/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.google.common.collect.Lists;
import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.common.entity.EntityBrachiosaurus;
import com.peeko32213.unusualprehistory.common.entity.msc.util.HitboxHelper;
import com.peeko32213.unusualprehistory.common.entity.msc.util.NearestTargetAI;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPEffects;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class EntityParaceratherium
extends EntityBaseDinosaurAnimal {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EntityParaceratherium.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMBAT_STATE = SynchedEntityData.m_135353_(EntityParaceratherium.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(EntityParaceratherium.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Ingredient temptationItems;
    private int shakeCooldown = 0;
    private float shakeAnim;
    private float shakeAnimO;

    public EntityParaceratherium(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22279_, 0.13).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22285_, 6.0).m_22268_(Attributes.f_22278_, 10.5);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ParacerMeleeAttackGoal(this, 1.8f, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestTargetAI((Mob)this, LivingEntity.class, 110, false, true, null){

            public boolean m_8036_() {
                return !EntityParaceratherium.this.m_6162_() && EntityParaceratherium.this.f_19853_.m_46791_() != Difficulty.PEACEFUL && super.m_8036_();
            }
        });
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTags.f_13143_)}));
        }
        return this.temptationItems;
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_7306_((Entity)this);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_6069_() && !this.m_20069_() && this.shakeCooldown <= 0 && ((Boolean)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI.get()).booleanValue()) {
            double brachiShakeRange = (Double)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI_RANGE.get();
            int brachiShakeAmp = (Integer)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI_AMPLIFIER.get();
            float brachiMoveSoundVolume = ((Float)UnusualPrehistoryConfig.BRACHI_SOUND_VOLUME.get()).floatValue();
            List list = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(brachiShakeRange));
            for (LivingEntity e : list) {
                if (e instanceof EntityBrachiosaurus || !e.m_6084_()) continue;
                e.m_7292_(new MobEffectInstance((MobEffect)UPEffects.SCREEN_SHAKE.get(), 20, brachiShakeAmp, false, false, false));
                this.m_5496_((SoundEvent)UPSounds.BRACHI_STEP.get(), brachiMoveSoundVolume, 0.4f);
            }
            this.shakeCooldown = 40;
        }
        if (this.m_6084_()) {
            this.shakeAnimO = this.shakeAnim;
            this.shakeAnim += 0.05f;
            if (this.shakeAnimO >= 2.0f) {
                this.shakeAnimO = 0.0f;
                this.shakeAnim = 0.0f;
            }
            float f = (float)this.m_20186_();
            int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
            Vec3 vec3 = this.m_20184_();
            for (int j = 0; j < i; ++j) {
                float f1 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.4f;
                float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.4f;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)f + (double)this.m_20206_() * 0.85, this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.PARACER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.PARACER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.PARACER_DEATH.get();
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)anim);
    }

    public int getCombatState() {
        return (Integer)this.f_19804_.m_135370_(COMBAT_STATE);
    }

    public void setCombatState(int anim) {
        this.f_19804_.m_135381_(COMBAT_STATE, (Object)anim);
    }

    public int getEntityState() {
        return (Integer)this.f_19804_.m_135370_(ENTITY_STATE);
    }

    public void setEntityState(int anim) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)anim);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(COMBAT_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        int animState = this.getAnimationState();
        switch (animState) {
            case 21: {
                event.getController().setAnimation(new AnimationBuilder().playOnce("animation.paraceratherium.attack"));
                break;
            }
            default: {
                if (!(event.getLimbSwingAmount() > -0.06f && event.getLimbSwingAmount() < 0.06f || this.m_6069_())) {
                    event.getController().setAnimation(new AnimationBuilder().loop("animation.paraceratherium.move"));
                    event.getController().setAnimationSpeed(1.5);
                    return PlayState.CONTINUE;
                }
                if (this.m_20069_()) {
                    event.getController().setAnimation(new AnimationBuilder().loop("animation.paraceratherium.swim"));
                    event.getController().setAnimationSpeed(1.0);
                    return PlayState.CONTINUE;
                }
                if (this.m_20069_() || this.m_6069_()) break;
                event.getController().setAnimation(new AnimationBuilder().loop("animation.paraceratherium.idle"));
                event.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(controller);
    }

    static class ParacerMeleeAttackGoal
    extends Goal {
        protected final EntityParaceratherium mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int animTime = 0;
        Vec3 slamOffSet = new Vec3(1.0, 0.0, 0.0);

        public ParacerMeleeAttackGoal(EntityParaceratherium p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.f_19853_.m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            Vec3 aim = this.mob.m_20154_();
            Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
            switch (animState) {
                case 21: {
                    this.tickStompAttack();
                    break;
                }
                default: {
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            int r;
            if (distance <= reach && this.ticksUntilNextAttack <= 0 && (r = this.mob.m_217043_().m_188503_(2048)) <= 600) {
                this.mob.setAnimationState(21);
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= (double)1.8f * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickStompAttack() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.preformStompAttack();
            }
            if (this.animTime >= 9) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void preformStompAttack() {
            this.mob.m_20256_(this.mob.m_20184_().m_82490_(0.0));
            HitboxHelper.PivotedPolyHitCheck((LivingEntity)this.mob, this.slamOffSet, 6.0, 6.0, 6.0, (ServerLevel)this.mob.m_9236_(), 25.0f, DamageSource.m_19370_((LivingEntity)this.mob), 2.0f, true);
            if (this.mob.shakeCooldown <= 0 && ((Boolean)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI.get()).booleanValue()) {
                double brachiShakeRange = (Double)UnusualPrehistoryConfig.SCREEN_SHAKE_BRACHI_RANGE.get();
                List list = this.mob.f_19853_.m_45976_(LivingEntity.class, this.mob.m_20191_().m_82400_(brachiShakeRange));
                for (LivingEntity e : list) {
                    if (e instanceof EntityBrachiosaurus || !e.m_6084_()) continue;
                    e.m_7292_(new MobEffectInstance((MobEffect)UPEffects.SCREEN_SHAKE.get(), 50, 6, false, false, false));
                    this.mob.m_5496_((SoundEvent)UPSounds.PARACER_STOMP.get(), 2.0f, 0.4f);
                }
                this.mob.shakeCooldown = 10;
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 0;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 5;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 1.8f + p_179512_1_.m_20205_();
        }
    }
}

