/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.common.entity.msc.part.EntityPalaeophisPart;
import com.peeko32213.unusualprehistory.common.entity.msc.part.PalaeophisPartIndex;
import com.peeko32213.unusualprehistory.common.entity.msc.util.HitboxHelper;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseAquaticAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPEntities;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class EntityPalaeophis
extends EntityBaseAquaticAnimal
implements IAnimatable,
IAnimationTickable {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EntityPalaeophis.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMBAT_STATE = SynchedEntityData.m_135353_(EntityPalaeophis.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(EntityPalaeophis.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(EntityPalaeophis.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CHILD_ID = SynchedEntityData.m_135353_(EntityPalaeophis.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHEDDING_TIME = SynchedEntityData.m_135353_(EntityPalaeophis.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public final float[] ringBuffer = new float[64];
    public int ringBufferIndex = -1;
    private int sheddingCooldown = 0;
    private EntityPalaeophisPart[] parts;
    private float prevStrangleProgress = 0.0f;
    private float strangleProgress = 0.0f;
    private int strangleTimer = 0;
    private int shedCooldown = 0;
    private int feedings = 0;
    private boolean isLandNavigator;
    private int swimTimer = -1000;
    private int passiveFor = 0;

    public EntityPalaeophis(EntityType<? extends EntityBaseAquaticAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.f_21342_ = new MoveHelperController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22277_, 12.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DunkMeleeAttackGoal(this, 2.0, true));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42581_, Items.f_42582_}), false));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
    }

    @Override
    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public void m_6138_() {
        List entities = this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82363_(0.2, 0.0, 0.2));
        entities.stream().filter(entity -> !(entity instanceof EntityPalaeophisPart) && entity.m_6094_()).forEach(entity -> entity.m_7334_((Entity)this));
    }

    @Override
    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (prev && (this.m_21188_() == null || !this.m_21188_().m_20148_().equals(entity.m_20148_()))) {
            return false;
        }
        return prev;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected PathNavigation m_6037_(Level p_27480_) {
        return new WaterBoundPathNavigation((Mob)this, p_27480_);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.PALAEO_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.PALAEO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.PALAEO_DEATH.get();
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(COMBAT_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_ID, (Object)-1);
        this.f_19804_.m_135372_(SHEDDING_TIME, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getChildId() != null) {
            compound.m_128362_("ChildUUID", this.getChildId());
        }
        compound.m_128405_("ShedTime", this.getSheddingTime());
        compound.m_128405_("ShedCooldown", this.sheddingCooldown);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("ChildUUID")) {
            this.setChildId(compound.m_128342_("ChildUUID"));
        }
        this.setSheddingTime(compound.m_128451_("ShedTime"));
        this.sheddingCooldown = compound.m_128451_("SheddingCooldown");
    }

    public int getSheddingTime() {
        return (Integer)this.f_19804_.m_135370_(SHEDDING_TIME);
    }

    public void setSheddingTime(int shedtime) {
        this.f_19804_.m_135381_(SHEDDING_TIME, (Object)shedtime);
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.f_19853_.f_46443_) {
            return ((ServerLevel)this.f_19853_).m_8791_(id);
        }
        return null;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.ringBufferIndex < 0) {
            for (int i = 0; i < this.ringBuffer.length; ++i) {
                this.ringBuffer[i] = this.m_146908_();
            }
        }
        ++this.ringBufferIndex;
        if (this.ringBufferIndex == this.ringBuffer.length) {
            this.ringBufferIndex = 0;
        }
        this.ringBuffer[this.ringBufferIndex] = this.m_146908_();
        if (!this.f_19853_.f_46443_) {
            float reqRot;
            float prevReqRot;
            int i;
            int segments = 15;
            Entity child = this.getChild();
            if (child == null) {
                IAnimatable partParent = this;
                this.parts = new EntityPalaeophisPart[15];
                PalaeophisPartIndex partIndex = PalaeophisPartIndex.HEAD;
                Vec3 prevPos = this.m_20182_();
                for (i = 0; i < 15; ++i) {
                    prevReqRot = this.calcPartRotation(i) + this.getYawForPart(i);
                    reqRot = this.calcPartRotation(i + 1) + this.getYawForPart(i);
                    EntityPalaeophisPart part = new EntityPalaeophisPart((EntityType)UPEntities.PALAEOPHIS_PART.get(), (LivingEntity)this);
                    part.setParent((Entity)partParent);
                    part.copyDataFrom(this);
                    part.setBodyIndex(i);
                    part.setPartType(PalaeophisPartIndex.sizeAt(1 + i));
                    if (partParent == this) {
                        this.setChildId(part.m_20148_());
                        this.f_19804_.m_135381_(CHILD_ID, (Object)part.m_19879_());
                    }
                    if (partParent instanceof EntityPalaeophisPart) {
                        ((EntityPalaeophisPart)partParent).setChildId(part.m_20148_());
                    }
                    part.m_146884_(part.tickMultipartPosition(this.m_19879_(), partIndex, prevPos, this.m_146909_(), prevReqRot, reqRot, true));
                    partParent = part;
                    this.f_19853_.m_7967_((Entity)part);
                    this.parts[i] = part;
                    partIndex = part.getPartType();
                    prevPos = part.m_20182_();
                }
            }
            if (this.shouldReplaceParts() && this.getChild() instanceof EntityPalaeophisPart) {
                this.parts = new EntityPalaeophisPart[15];
                this.parts[0] = (EntityPalaeophisPart)this.getChild();
                this.f_19804_.m_135381_(CHILD_ID, (Object)this.parts[0].m_19879_());
                for (int i2 = 1; i2 < this.parts.length && this.parts[i2 - 1].getChild() instanceof EntityPalaeophisPart; ++i2) {
                    this.parts[i2] = (EntityPalaeophisPart)this.parts[i2 - 1].getChild();
                }
            }
            PalaeophisPartIndex partIndex = PalaeophisPartIndex.HEAD;
            Vec3 prev = this.m_20182_();
            float xRot = this.m_146909_();
            for (i = 0; i < 15; ++i) {
                if (this.parts[i] == null) continue;
                prevReqRot = this.calcPartRotation(i) + this.getYawForPart(i);
                reqRot = this.calcPartRotation(i + 1) + this.getYawForPart(i);
                this.parts[i].setStrangleProgress(this.strangleProgress);
                this.parts[i].copyDataFrom(this);
                prev = this.parts[i].tickMultipartPosition(this.m_19879_(), partIndex, prev, xRot, prevReqRot, reqRot, true);
                partIndex = this.parts[i].getPartType();
                xRot = this.parts[i].m_146909_();
            }
            this.swimTimer = this.m_20069_() ? Math.max(this.swimTimer + 1, 0) : Math.min(this.swimTimer - 1, 0);
        }
        if (this.sheddingCooldown >= 0) {
            --this.sheddingCooldown;
        }
        if (this.getSheddingTime() >= 0) {
            int shedTime = this.getSheddingTime();
            this.setSheddingTime(shedTime - 1);
            if (shedTime == 0) {
                this.sheddingCooldown = this.m_217043_().m_188503_(6000) + 1500;
            }
            return;
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.getSheddingTime() < 0 && this.sheddingCooldown < 0) {
            this.m_20000_((ItemLike)UPItems.PALAEO_SKIN.get(), 1);
            this.setSheddingTime(this.m_217043_().m_188503_(1000) + 1500);
        }
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    private float calcPartRotation(int i) {
        float f = 1.0f - this.strangleProgress * 0.2f;
        float strangleIntensity = (float)((double)Mth.m_14036_((float)(this.strangleTimer * 3), (float)0.0f, (float)100.0f) * (1.0 + (double)0.2f * Math.sin(0.15f * (float)this.strangleTimer)));
        float snakeSway = 25.0f;
        return (float)((double)snakeSway * -Math.sin(this.f_19787_ * 3.0f - (float)i)) * f + this.strangleProgress * 0.2f * (float)i * strangleIntensity;
    }

    public boolean m_7337_(Entity pEntity) {
        return true;
    }

    private boolean shouldReplaceParts() {
        if (this.parts == null || this.parts[0] == null) {
            return true;
        }
        for (int i = 0; i < 7; ++i) {
            if (this.parts[i] != null) continue;
            return true;
        }
        return false;
    }

    private float getYawForPart(int i) {
        return this.getRingBuffer(4 + i * 2, 1.0f);
    }

    public float getRingBuffer(int bufferOffset, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - bufferOffset & 0x3F;
        int j = this.ringBufferIndex - bufferOffset - 1 & 0x3F;
        float d0 = this.ringBuffer[i];
        float d1 = this.ringBuffer[j] - d0;
        return Mth.m_14177_((float)(d0 + d1 * partialTicks));
    }

    public boolean isShedding() {
        return this.getSheddingTime() >= 0;
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        int animState = this.getAnimationState();
        switch (animState) {
            case 21: {
                event.getController().setAnimation(new AnimationBuilder().playOnce("animation.palaophis_head.bite"));
                break;
            }
            default: {
                if (!(event.getLimbSwingAmount() > -0.06f) || !(event.getLimbSwingAmount() < 0.06f)) {
                    event.getController().setAnimation(new AnimationBuilder().loop("animation.palaophis_head.idle_tounge"));
                    event.getController().setAnimationSpeed(0.6);
                    return PlayState.CONTINUE;
                }
                if (!this.m_20069_()) {
                    event.getController().setAnimation(new AnimationBuilder().loop("animation.palaophis_head.idle_tounge"));
                    event.getController().setAnimationSpeed(0.3);
                    return PlayState.CONTINUE;
                }
                event.getController().setAnimation(new AnimationBuilder().loop("animation.palaophis_head.idle_tounge"));
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate);
        data.addAnimationController(controller);
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean m_8023_() {
        return super.m_8023_() || this.m_8077_();
    }

    @Override
    public boolean m_6785_(double d) {
        return !this.m_8077_();
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    public boolean m_213824_() {
        return true;
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)anim);
    }

    public int getCombatState() {
        return (Integer)this.f_19804_.m_135370_(COMBAT_STATE);
    }

    public void setCombatState(int anim) {
        this.f_19804_.m_135381_(COMBAT_STATE, (Object)anim);
    }

    public int getEntityState() {
        return (Integer)this.f_19804_.m_135370_(ENTITY_STATE);
    }

    public void setEntityState(int anim) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)anim);
    }

    public void killed() {
        this.m_5634_(15.0f);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28134_, DifficultyInstance p_28135_, MobSpawnType p_28136_, @Nullable SpawnGroupData p_28137_, @Nullable CompoundTag p_28138_) {
        p_28137_ = super.m_6518_(p_28134_, p_28135_, p_28136_, p_28137_, p_28138_);
        ServerLevel level = p_28134_.m_6018_();
        if (level instanceof ServerLevel) {
            this.m_21530_();
        }
        return p_28137_;
    }

    public static boolean checkSurfaceWaterDinoSpawnRules(EntityType<? extends WaterAnimal> pWaterAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_) && (Boolean)UnusualPrehistoryConfig.DINO_NATURAL_SPAWNING.get() != false;
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityPalaeophis dolphin;

        public MoveHelperController(EntityPalaeophis dolphinIn) {
            super((Mob)dolphinIn);
            this.dolphin = dolphinIn;
        }

        public void m_8126_() {
            if (this.dolphin.m_20069_()) {
                this.dolphin.m_20256_(this.dolphin.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.dolphin.m_21573_().m_26571_()) {
                double d2;
                double d1;
                double d0 = this.f_24975_ - this.dolphin.m_20185_();
                double d3 = d0 * d0 + (d1 = this.f_24976_ - this.dolphin.m_20186_()) * d1 + (d2 = this.f_24977_ - this.dolphin.m_20189_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.f_24974_.m_21564_(0.0f);
                } else {
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.m_146922_(this.m_24991_(this.dolphin.m_146908_(), f, 10.0f));
                    this.dolphin.f_20883_ = this.dolphin.m_146908_();
                    this.dolphin.f_20885_ = this.dolphin.m_146908_();
                    float f1 = (float)(this.f_24978_ * this.dolphin.m_21133_(Attributes.f_22279_));
                    if (this.dolphin.m_20069_() || this.dolphin.m_20077_()) {
                        this.dolphin.m_7910_(f1 * 0.02f);
                        float f2 = -((float)(Mth.m_14136_((double)d1, (double)Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.m_20256_(this.dolphin.m_20184_().m_82520_(0.0, (double)this.dolphin.m_6113_() * d1 * 0.6, 0.0));
                        this.dolphin.m_146926_(this.m_24991_(this.dolphin.m_146909_(), f2, 1.0f));
                        float f3 = Mth.m_14089_((float)(this.dolphin.m_146909_() * ((float)Math.PI / 180)));
                        float f4 = Mth.m_14031_((float)(this.dolphin.m_146909_() * ((float)Math.PI / 180)));
                        this.dolphin.f_20902_ = f3 * f1;
                        this.dolphin.f_20901_ = -f4 * f1;
                    } else {
                        this.dolphin.m_7910_(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.m_7910_(0.0f);
                this.dolphin.m_21570_(0.0f);
                this.dolphin.m_21567_(0.0f);
                this.dolphin.m_21564_(0.0f);
            }
        }
    }

    static class DunkMeleeAttackGoal
    extends Goal {
        protected final EntityPalaeophis mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int animTime = 0;

        public DunkMeleeAttackGoal(EntityPalaeophis p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i;
            this.lastCanUseCheck = i = this.mob.f_19853_.m_46467_();
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            Vec3 aim = this.mob.m_20154_();
            Vec2 aim2d = new Vec2((float)(aim.f_82479_ / (1.0 - Math.abs(aim.f_82480_))), (float)(aim.f_82481_ / (1.0 - Math.abs(aim.f_82480_))));
            switch (animState) {
                case 21: {
                    this.tickBiteAttack();
                    break;
                }
                default: {
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            int r;
            if (distance <= reach && this.ticksUntilNextAttack <= 0 && (r = this.mob.m_217043_().m_188503_(2048)) <= 600) {
                this.mob.setAnimationState(21);
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= (double)1.8f * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickBiteAttack() {
            ++this.animTime;
            if (this.animTime == 4) {
                this.preformBiteAttack();
            }
            if (this.animTime >= 8) {
                this.animTime = 0;
                if (this.getRangeCheck()) {
                    this.mob.setAnimationState(22);
                } else {
                    this.mob.setAnimationState(0);
                    this.resetAttackCooldown();
                    this.ticksUntilNextPathRecalculation = 0;
                }
            }
        }

        protected void preformBiteAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.PALAEO_BITE.get(), 0.1f, 1.0f);
            HitboxHelper.LargeAttackWithTargetCheck(DamageSource.m_19370_((LivingEntity)this.mob), 10.0f, 0.2f, (PathfinderMob)this.mob, pos, 5.0, -1.5707963267948966, 1.5707963267948966, -1.0, 3.0);
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 0;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 5;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 1.8f + p_179512_1_.m_20205_();
        }
    }
}

