/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.google.common.collect.Lists;
import com.peeko32213.unusualprehistory.common.entity.IAttackEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomFollower;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRideGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.EatLeavesGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.TameableFollowOwner;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityTameableBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class EntityMegatherium
extends EntityTameableBaseDinosaurAnimal
implements CustomFollower,
IAttackEntity {
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(EntityMegatherium.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(EntityMegatherium.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(EntityMegatherium.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Ingredient temptationItems;
    private int eatingTime;
    private int attackCooldown;
    public static final int ATTACK_COOLDOWN = 30;

    public EntityMegatherium(EntityType<? extends EntityTameableBaseDinosaurAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22279_, 0.16).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22285_, 3.0).m_22268_(Attributes.f_22278_, 3.5);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new EatLeavesGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(1, (Goal)new CustomRideGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new TameableFollowOwner(this, 1.2, 5.0f, 2.0f, false));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34));
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTags.f_13143_)}));
        }
        return this.temptationItems;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EATING, (Object)false);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(EATING, (Object)eating);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (!this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            this.setEating(true);
        }
        if (this.isEating()) {
            ++this.eatingTime;
            if (!this.m_21205_().m_204117_(ItemTags.f_13143_)) {
                for (int i = 0; i < 3; ++i) {
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_21120_(InteractionHand.MAIN_HAND)), this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_()) - (double)this.m_20205_() * 0.5, this.m_20186_() + (double)(this.m_20206_() * 0.5f) + (double)(this.f_19796_.m_188501_() * this.m_20206_() * 0.5f), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_()) - (double)this.m_20205_() * 0.5, d0, d1, d2);
                }
            }
            if (this.eatingTime % 5 == 0) {
                this.m_146850_(GameEvent.f_157806_);
                this.m_5496_(SoundEvents.f_12181_, this.m_6121_(), this.m_6100_());
            }
            if (this.eatingTime > 100) {
                this.setEating(false);
                this.eatingTime = 0;
            }
        }
    }

    public void m_7332_(Entity passenger) {
        float ySin = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float yCos = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        if (!this.m_21825_()) {
            passenger.m_6034_(this.m_20185_() + (double)(0.5f * ySin), this.m_20186_() + this.m_6048_() + passenger.m_6049_() + (double)0.4f, this.m_20189_() - (double)(0.5f * yCos));
            return;
        }
        passenger.m_6034_(this.m_20185_() + (double)(0.5f * ySin), this.m_20186_() + this.m_6048_() + passenger.m_6049_() - 1.0, this.m_20189_() - (double)(0.5f * yCos));
    }

    public double m_6048_() {
        if (this.m_20069_()) {
            return 0.99;
        }
        return 2.6;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_((Item)UPItems.ENCYLOPEDIA.get())) {
            InteractionResult interactionResult = itemstack.m_41647_(player, (LivingEntity)this, hand);
        }
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.f_46443_ && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
            } else if (itemstack.m_41720_() == Items.f_42450_ && !this.isSaddled()) {
                this.m_142075_(player, hand, itemstack);
                this.setSaddled(true);
            } else if (itemstack.m_41720_() == Items.f_42574_ && this.isSaddled()) {
                this.setSaddled(false);
                this.m_19998_((ItemLike)Items.f_42450_);
            } else if (!player.m_6144_() && !this.m_6162_() && this.isSaddled() && !this.m_21825_()) {
                player.m_20329_((Entity)this);
            } else {
                boolean sit;
                this.setCommand((this.getCommand() + 1) % 3);
                if (this.getCommand() == 3) {
                    this.setCommand(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)("entity.unusualprehistory.all.command_" + this.getCommand()), (Object[])new Object[]{this.m_7755_()}), true);
                boolean bl = sit = this.getCommand() == 2;
                if (sit) {
                    this.m_21839_(true);
                } else {
                    this.m_21839_(false);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }

    @Override
    public void performAttack() {
        if (!this.f_19853_.f_46443_) {
            this.setSwinging(true);
            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double radius = this.m_20205_();
            double extraX = radius * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * (double)Mth.m_14089_((float)angle);
            BlockPos targetPos = new BlockPos(this.m_20185_() + extraX, this.m_20186_(), this.m_20189_() + extraZ);
            if (((Player)this.m_6688_()).m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42421_)) {
                targetPos = targetPos.m_7918_(0, -1, 0);
            }
            if (((Player)this.m_6688_()).m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42384_)) {
                targetPos = targetPos.m_7918_(0, 1, 0);
            }
            for (int x = -2; x < 2; ++x) {
                for (int z = -2; z < 2; ++z) {
                    for (int y = 0; y < 5; ++y) {
                        if (!serverLevel.m_8055_(targetPos.m_7918_(x, y, z)).m_204336_(UPTags.MEGATHERIUM_MINEABLES)) continue;
                        serverLevel.m_46961_(targetPos.m_7918_(x, y, z), true);
                    }
                }
            }
        }
    }

    @Override
    public void afterAttack() {
        this.f_19853_.m_7605_((Entity)this, (byte)5);
        this.setSwinging(false);
    }

    @Override
    public int getMaxAttackCooldown() {
        return 30;
    }

    @Override
    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    @Override
    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public float getStepHeight() {
        return 1.2f;
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)UPSounds.MAJUNGA_STEP.get(), 0.1f, 1.0f);
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_21826_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return entityIn.m_7306_((Entity)this);
    }

    public void m_7023_(Vec3 pos) {
        if (this.m_6084_()) {
            LivingEntity livingentity = (LivingEntity)this.m_6688_();
            if (this.m_20160_() && livingentity != null) {
                double d0 = 0.08;
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.m_7910_(0.1f);
                super.m_7023_(new Vec3((double)f, pos.f_82480_, (double)f1));
            } else {
                super.m_7023_(pos);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Saddle", this.isSaddled());
        compound.m_128405_("TrikeCommand", this.getCommand());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSaddled(compound.m_128471_("Saddle"));
        this.setCommand(compound.m_128451_("TrikeCommand"));
    }

    @Override
    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    @Override
    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.MEGATHER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.MEGATHER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.MEGATHER_DEATH.get();
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_20069_() && !this.m_21825_() && !this.m_6069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.megatherium.move"));
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.megatherium.swim"));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_21825_() && !this.m_20069_() && !this.m_6069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.megatherium.sitting"));
            return PlayState.CONTINUE;
        }
        if (!this.m_20069_() && !this.m_6069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.megatherium.idle"));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState eatPredicate(AnimationEvent<E> event) {
        if (this.isEating() && !this.m_21825_() && !this.m_6069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.megatherium.eating"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState diggingPredicate(AnimationEvent<E> event) {
        if (this.isSwinging() && event.getController().getAnimationState().equals((Object)AnimationState.Stopped) && !this.m_21825_()) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().playOnce("animation.megatherium.digging"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(new AnimationController((IAnimatable)this, "attackController", 2.0f, this::diggingPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "eatController", 5.0f, this::eatPredicate));
        data.addAnimationController(controller);
    }
}

