/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.HitboxHelper;
import com.peeko32213.unusualprehistory.common.entity.msc.util.SleepRandomLookAroundGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPEffects;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class EntityMegalania
extends EntityBaseDinosaurAnimal {
    private static final EntityDataAccessor<Integer> COMBAT_STATE = SynchedEntityData.m_135353_(EntityMegalania.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(EntityMegalania.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EntityMegalania.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ASLEEP = SynchedEntityData.m_135353_(EntityMegalania.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Ingredient temptationItems;
    private float sleepProgress = 0.0f;
    private float prevSleepProgress = 0.0f;
    private int stunnedTick;

    public EntityMegalania(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22279_, 0.16).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22278_, 3.5);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MegaMeleeAttackGoal(this, 1.6f, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, false, false, entity -> entity.m_6095_().m_204039_(UPTags.MEGALANIA_TARGETS)));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean m_8036_() {
                EntityMegalania entityMegalania;
                Mob mob = this.f_25512_;
                if (mob instanceof EntityMegalania && (entityMegalania = (EntityMegalania)mob).isAsleep()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new SleepRandomLookAroundGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 100, true, false, this::isAngryAt));
    }

    public boolean isAngryAt(LivingEntity p_21675_) {
        return this.m_6779_(p_21675_);
    }

    @Override
    public boolean m_6779_(LivingEntity entity) {
        boolean prev = super.m_6779_(entity);
        if (prev && this.m_6162_() || this.isAsleep()) {
            return false;
        }
        if (entity.m_7306_((Entity)this)) {
            return false;
        }
        return prev;
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_7306_((Entity)this);
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.isAsleep()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            this.m_21563_().m_24964_(this.m_20182_().m_82520_(2.0, 0.0, 2.0));
            vec3d = Vec3.f_82478_;
        }
        super.m_7023_(vec3d);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.setAsleep(false);
        return super.m_6469_(source, amount);
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 10;
    }

    @Override
    protected boolean canGetHungry() {
        return true;
    }

    @Override
    protected boolean hasTargets() {
        return true;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return UPTags.MEGALANIA_TARGETS;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (itemStack.m_204117_(Tags.Items.TOOLS)) {
            CompoundTag compoundTag = itemStack.m_41783_();
            compoundTag.m_128405_("megalania_damage", 30);
            itemStack.m_41751_(compoundTag);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean isHotBiome() {
        if (this.m_21525_()) {
            return false;
        }
        if (this.f_19853_.m_46472_() == Level.f_46429_) {
            return true;
        }
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        return ((Biome)this.f_19853_.m_204166_(new BlockPos(i, 0, k)).m_203334_()).m_198910_(new BlockPos(i, j, k));
    }

    public boolean isColdBiome() {
        if (this.m_21525_()) {
            return false;
        }
        if (this.f_19853_.m_46472_() == Level.f_46429_) {
            return false;
        }
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        return ((Biome)this.f_19853_.m_204166_(new BlockPos(i, 0, k)).m_203334_()).m_198904_(new BlockPos(i, j, k));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(COMBAT_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
        this.f_19804_.m_135372_(ASLEEP, (Object)false);
    }

    public boolean isAsleep() {
        return (Boolean)this.f_19804_.m_135370_(ASLEEP);
    }

    public void setAsleep(boolean isAsleep) {
        this.f_19804_.m_135381_(ASLEEP, (Object)isAsleep);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsAsleep", this.isAsleep());
        compound.m_128405_("StunTick", this.stunnedTick);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAsleep(compound.m_128471_("IsAsleep"));
        this.stunnedTick = compound.m_128451_("StunTick");
    }

    public void m_7822_(byte pId) {
        if (pId == 39) {
            this.stunnedTick = 60;
        } else {
            super.m_7822_(pId);
        }
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE);
    }

    public void setAnimationState(int anim) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)anim);
    }

    public int getCombatState() {
        return (Integer)this.f_19804_.m_135370_(COMBAT_STATE);
    }

    public void setCombatState(int anim) {
        this.f_19804_.m_135381_(COMBAT_STATE, (Object)anim);
    }

    public int getEntityState() {
        return (Integer)this.f_19804_.m_135370_(ENTITY_STATE);
    }

    public void setEntityState(int anim) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)anim);
    }

    private void setColdVariant() {
        this.setVariant(1);
    }

    private void setHotVariant() {
        this.setVariant(2);
    }

    private void setNetherVariant() {
        this.setVariant(3);
    }

    private void setNormalVariant() {
        this.setVariant(0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isAsleep() && this.sleepProgress < 1.0f) {
            this.sleepProgress = Math.min(this.sleepProgress + 0.2f, 1.0f);
            this.stunnedTick = 60;
        }
        if (!this.isAsleep() && this.sleepProgress > 0.0f) {
            this.sleepProgress = Math.max(this.sleepProgress - 0.2f, 0.0f);
        }
        if (this.isAsleep()) {
            this.m_21563_().m_24964_(this.m_20182_().m_82520_(2.0, 0.0, 2.0));
        }
        if (!this.f_19853_.f_46443_) {
            if (this.isHotBiome() && !this.m_20071_()) {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.2);
                this.setAsleep(false);
            }
            if (this.isColdBiome() && !this.m_20071_()) {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.13);
                this.setAsleep(true);
                this.stunnedTick = 60;
            } else {
                this.m_21051_(Attributes.f_22279_).m_22100_(0.16);
            }
        }
    }

    public float getSleepProgress(float partialTick) {
        return this.prevSleepProgress + (this.sleepProgress - this.prevSleepProgress) * partialTick;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficultyInstance, spawnType, spawnGroupData, tag);
        if (levelAccessor.m_6018_().m_46472_() == Level.f_46429_) {
            this.setNetherVariant();
            return data;
        }
        if (this.isHotBiome()) {
            this.setHotVariant();
        } else if (this.isColdBiome()) {
            this.setColdVariant();
        } else {
            this.setNormalVariant();
        }
        return data;
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)UPSounds.MAJUNGA_STEP.get(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.MEGALANIA_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.MEGALANIA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.MEGALANIA_DEATH.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        int animState = this.getAnimationState();
        switch (animState) {
            case 21: {
                event.getController().setAnimation(new AnimationBuilder().playOnce("animation.megalania.bite"));
                break;
            }
            case 22: {
                event.getController().setAnimation(new AnimationBuilder().playOnce("animation.megalania.claw_swipe"));
                break;
            }
            case 23: {
                event.getController().setAnimation(new AnimationBuilder().playOnce("animation.megalania.tail_whip"));
                break;
            }
            default: {
                if (this.m_20184_().m_165925_() > 1.0E-6 && !this.isAsleep() && !this.m_6069_()) {
                    if (this.m_20142_() || !this.m_20197_().isEmpty() && !this.m_6069_()) {
                        event.getController().setAnimation(new AnimationBuilder().loop("animation.megalania.sprint"));
                        return PlayState.CONTINUE;
                    }
                    if (event.isMoving() && !this.isAsleep() && !this.m_6069_()) {
                        event.getController().setAnimation(new AnimationBuilder().loop("animation.megalania.walk"));
                        return PlayState.CONTINUE;
                    }
                }
                if (this.m_20069_()) {
                    event.getController().setAnimation(new AnimationBuilder().loop("animation.megalania.swim"));
                    event.getController().setAnimationSpeed(1.0);
                    return PlayState.CONTINUE;
                }
                if (this.isAsleep() && !this.m_6069_()) {
                    event.getController().setAnimation(new AnimationBuilder().loop("animation.megalania.resting"));
                    return PlayState.CONTINUE;
                }
                event.getController().setAnimation(new AnimationBuilder().loop("animation.megalania.idle"));
                return PlayState.CONTINUE;
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(controller);
    }

    static class MegaMeleeAttackGoal
    extends Goal {
        protected final EntityMegalania mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private long lastCanUseCheck;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;
        private int animTime = 0;
        Vec3 biteOffSet = new Vec3(2.0, 0.0, 0.0);
        Vec3 clawOffSet = new Vec3(2.0, 0.0, 0.0);
        Vec3 whipOffSet = new Vec3(0.0, -0.3, 4.0);

        public MegaMeleeAttackGoal(EntityMegalania p_i1636_1_, double p_i1636_2_, boolean p_i1636_4_) {
            this.mob = p_i1636_1_;
            this.speedModifier = p_i1636_2_;
            this.followingTargetEvenIfNotSeen = p_i1636_4_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.f_19853_.m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
            this.animTime = 0;
            this.mob.setAnimationState(0);
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.setAnimationState(0);
                this.mob.m_6710_(null);
            }
            this.mob.setAnimationState(0);
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            double distance = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            double reach = this.getAttackReachSqr(target);
            int animState = this.mob.getAnimationState();
            switch (animState) {
                case 21: {
                    this.tickBiteAttack();
                    break;
                }
                case 22: {
                    this.tickClawAttack();
                    break;
                }
                case 23: {
                    this.tickWhipAttack();
                    break;
                }
                default: {
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    this.doMovement(target, distance);
                    this.checkForCloseRangeAttack(distance, reach);
                }
            }
        }

        protected void doMovement(LivingEntity livingentity, Double d0) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingentity.m_20185_();
                this.pathedTargetY = livingentity.m_20186_();
                this.pathedTargetZ = livingentity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
            }
        }

        protected void checkForCloseRangeAttack(double distance, double reach) {
            if (distance <= reach && this.ticksUntilNextAttack <= 0) {
                int r = this.mob.m_217043_().m_188503_(2048);
                if (r <= 600) {
                    this.mob.setAnimationState(21);
                } else if (r > 600 && r <= 800) {
                    this.mob.setAnimationState(22);
                } else {
                    this.mob.setAnimationState(23);
                }
            }
        }

        protected boolean getRangeCheck() {
            return this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_()) <= (double)1.8f * this.getAttackReachSqr(this.mob.m_5448_());
        }

        protected void tickBiteAttack() {
            ++this.animTime;
            if (this.animTime == 5) {
                this.preformBiteAttack();
            }
            if (this.animTime >= 9) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickClawAttack() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.preformClawAttack();
            }
            if (this.animTime >= 9) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void tickWhipAttack() {
            ++this.animTime;
            this.mob.m_21573_().m_26573_();
            if (this.animTime == 5) {
                this.preformWhipAttack();
            }
            if (this.animTime >= 15) {
                this.animTime = 0;
                this.mob.setAnimationState(0);
                this.resetAttackCooldown();
                this.ticksUntilNextPathRecalculation = 0;
            }
        }

        protected void preformBiteAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.PALAEO_BITE.get(), 1.0f, 1.0f);
            HitboxHelper.PivotedPolyHitCheck((LivingEntity)this.mob, this.biteOffSet, 3.0, 2.0, 2.0, (ServerLevel)this.mob.m_9236_(), 5.0f, DamageSource.m_19370_((LivingEntity)this.mob), 0.5f, false);
            List list = this.mob.f_19853_.m_45976_(LivingEntity.class, this.mob.m_20191_().m_82400_(1.0));
            for (LivingEntity e : list) {
                if (e instanceof EntityMegalania || !e.m_6084_()) continue;
                e.m_7292_(new MobEffectInstance((MobEffect)UPEffects.HEALTH_REDUCTION.get(), 400, 1, false, true, true));
            }
        }

        protected void preformClawAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_(SoundEvents.f_12317_, 1.0f, 1.0f);
            HitboxHelper.PivotedPolyHitCheck((LivingEntity)this.mob, this.clawOffSet, 2.0, 2.0, 2.0, (ServerLevel)this.mob.m_9236_(), 8.0f, DamageSource.m_19370_((LivingEntity)this.mob), 0.5f, true);
        }

        protected void preformWhipAttack() {
            Vec3 pos = this.mob.m_20182_();
            this.mob.m_5496_((SoundEvent)UPSounds.REX_TAIL_SWIPE.get(), 1.0f, 1.0f);
            HitboxHelper.PivotedPolyHitCheck((LivingEntity)this.mob, this.whipOffSet, 5.0, 1.0, 5.0, (ServerLevel)this.mob.m_9236_(), 6.0f, DamageSource.m_19370_((LivingEntity)this.mob), 1.1f, false);
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = 3;
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return 5;
        }

        protected double getAttackReachSqr(LivingEntity p_179512_1_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 1.8f + p_179512_1_.m_20205_();
        }
    }
}

