/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.google.common.collect.Lists;
import com.peeko32213.unusualprehistory.common.entity.msc.util.MammothMeleeAttackGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPItems;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class EntityMammoth
extends EntityBaseDinosaurAnimal
implements Shearable,
IForgeShearable,
ContainerListener {
    public static final ResourceLocation MAMMOTH_LOOT = new ResourceLocation("unusualprehistory", "gameplay/mammoth_loot");
    private static final EntityDataAccessor<Boolean> IS_TRUNKING = SynchedEntityData.m_135353_(EntityMammoth.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> HOLD_ITEM = SynchedEntityData.m_135353_(EntityMammoth.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private Ingredient temptationItems;
    public SimpleContainer mammothInventory;
    private int dirtyCooldown;

    public EntityMammoth(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.initMammothInventory();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22285_, 3.0).m_22268_(Attributes.f_22278_, 8.5);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new MammothMeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MammothTrunkIdleGoal(this));
    }

    private void initMammothInventory() {
        SimpleContainer animalchest = this.mammothInventory;
        int size = 1;
        this.mammothInventory = new SimpleContainer(size){

            public boolean m_6542_(Player player) {
                return EntityMammoth.this.m_6084_() && !EntityMammoth.this.f_19817_;
            }
        };
        this.mammothInventory.m_19164_((ContainerListener)this);
        if (animalchest != null) {
            int i = Math.min(animalchest.m_6643_(), this.mammothInventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalchest.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.mammothInventory.m_6836_(j, itemstack.m_41777_());
            }
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.mammothInventory != null) {
            for (int i = 0; i < this.mammothInventory.m_6643_(); ++i) {
                this.m_19983_(this.mammothInventory.m_8020_(i));
            }
            this.mammothInventory.m_6211_();
            this.setHoldItemStack(ItemStack.f_41583_);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (this.m_6220_() && pPlayer.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)UPItems.TYRANTS_CROWN.get()) && itemStack.m_204117_(Tags.Items.SHEARS)) {
            this.m_5851_(SoundSource.PLAYERS);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_7306_((Entity)this);
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTags.f_13143_)}));
        }
        return this.temptationItems;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_TRUNKING, (Object)false);
        this.f_19804_.m_135372_(HOLD_ITEM, (Object)ItemStack.f_41583_);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.mammothInventory != null) {
            ListTag nbttaglist = compound.m_128437_("Items", 10);
            this.initMammothInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag CompoundNBT = nbttaglist.m_128728_(i);
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)CompoundNBT.m_128469_("Item"));
                this.mammothInventory.m_6836_(j, itemStack);
                this.setHoldItemStack(itemStack);
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.mammothInventory != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.mammothInventory.m_6643_(); ++i) {
                ItemStack itemstack = this.mammothInventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.m_128344_("Slot", (byte)i);
                CompoundNBT.m_128365_("Item", (Tag)itemstack.serializeNBT());
                nbttaglist.add((Object)CompoundNBT);
            }
            compound.m_128365_("Items", (Tag)nbttaglist);
        }
    }

    public boolean isTrunking() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRUNKING);
    }

    public void setTrunking(boolean isPecking) {
        this.f_19804_.m_135381_(IS_TRUNKING, (Object)isPecking);
    }

    public ItemStack getHoldItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(HOLD_ITEM);
    }

    public void setHoldItemStack(ItemStack itemStack) {
        this.f_19804_.m_135381_(HOLD_ITEM, (Object)itemStack);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.dirtyCooldown-- < 0 && this.mammothInventory.m_7983_() && !this.f_19853_.f_46443_) {
            List<ItemStack> itemStack = EntityMammoth.getShearLoot(this);
            if (!itemStack.isEmpty()) {
                ItemStack item = itemStack.get(this.f_19796_.m_188503_(itemStack.size()));
                item.m_41764_(this.f_19796_.m_216339_(0, 3));
                this.mammothInventory.m_19173_(item);
                this.dirtyCooldown = this.f_19796_.m_216339_(6000, 12000);
                this.setHoldItemStack(item);
            } else {
                this.dirtyCooldown = this.f_19796_.m_188503_(100);
            }
        }
    }

    public void m_5851_(SoundSource category) {
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12344_, category, 1.0f, 1.0f);
        this.m_146850_(GameEvent.f_223708_);
        if (!this.f_19853_.m_5776_() && this.mammothInventory != null && !this.mammothInventory.m_7983_()) {
            List<ItemStack> lootList = Collections.singletonList(this.mammothInventory.m_8020_(0));
            for (ItemStack stack : lootList) {
                ItemEntity e = this.m_19983_(stack.m_41777_());
                e.f_19812_ = true;
            }
            this.mammothInventory.m_6211_();
            this.setHoldItemStack(ItemStack.f_41583_);
        }
    }

    private static List<ItemStack> getShearLoot(EntityMammoth mammoth) {
        if (!mammoth.f_19853_.f_46443_) {
            LootTable loottable = mammoth.f_19853_.m_7654_().m_129898_().m_79217_(MAMMOTH_LOOT);
            return loottable.m_230922_(new LootContext.Builder((ServerLevel)mammoth.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)mammoth).m_230911_(mammoth.f_19853_.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)mammoth.m_20182_()).m_78975_(LootContextParamSets.f_81411_));
        }
        return Collections.emptyList();
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.m_6220_();
    }

    public void m_5757_(Container pContainer) {
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        if (this.mammothInventory != null && !this.mammothInventory.m_7983_() && this.m_6220_() && player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)UPItems.TYRANTS_CROWN.get()) && item.m_204117_(Tags.Items.SHEARS)) {
            level.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
            this.m_146852_(GameEvent.f_157781_, (Entity)player);
            if (!level.f_46443_) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                items.add(this.mammothInventory.m_8020_(0));
                this.mammothInventory.m_6211_();
                this.setHoldItemStack(ItemStack.f_41583_);
                return items;
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.MAMMOTH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.MAMMOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.MAMMOTH_DEATH.get();
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)UPSounds.MAJUNGA_STEP.get(), 0.1f, 1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.mammoth.swim"));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6 && !this.m_6069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.mammoth.move"));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().loop("animation.mammoth.idle"));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState trunkPredicate(AnimationEvent<E> event) {
        if (this.isTrunking() && !this.m_6069_()) {
            event.getController().setAnimation(new AnimationBuilder().playOnce("animation.mammoth.idle_trunk"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(new AnimationController((IAnimatable)this, "eatController", 5.0f, this::trunkPredicate));
        data.addAnimationController(controller);
    }

    public class MammothTrunkIdleGoal
    extends Goal {
        private final EntityMammoth mammoth;

        public MammothTrunkIdleGoal(EntityMammoth mammoth) {
            this.mammoth = mammoth;
        }

        public boolean m_8036_() {
            return this.mammoth.m_20096_() && this.mammoth.m_217043_().m_188503_(100) == 0;
        }

        public void m_8037_() {
            this.mammoth.setTrunking(true);
            if (this.mammoth.m_217043_().m_188503_(100) <= 25) {
                this.mammoth.setTrunking(false);
            }
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }
}

