/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.entity.IAttackEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.projectile.EntityHwachaSpike;
import com.peeko32213.unusualprehistory.common.entity.msc.util.BabyPanicGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomFollower;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRideGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.TameableFollowOwner;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityTameableBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class EntityHwachavenator
extends EntityTameableBaseDinosaurAnimal
implements RangedAttackMob,
CustomFollower,
IAttackEntity {
    private static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.m_135353_(EntityHwachavenator.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(EntityHwachavenator.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(EntityHwachavenator.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Logger LOGGER = LogManager.getLogger();
    public float shootProgress;
    public float sitProgress;
    public int soundTimer = 0;
    private int attackCooldown;
    public static final int ATTACK_COOLDOWN = 30;

    public EntityHwachavenator(EntityType<? extends EntityTameableBaseDinosaurAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22278_, 1.3).m_22268_(Attributes.f_22279_, (double)0.17f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new BabyPanicGoal((PathfinderMob)this, 2.0));
        if (!this.m_217005_()) {
            this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.0, 1, 20.0f));
        }
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new CustomRandomStrollGoal((PathfinderMob)this, 30, 1.0, 100, 34));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new CustomRideGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(2, (Goal)new TameableFollowOwner(this, 1.2, 5.0f, 2.0f, false));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOTING, (Object)false);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("isShooting", this.isShooting());
        pCompound.m_128379_("Saddle", this.isSaddled());
        pCompound.m_128405_("HwachaCommand", this.getCommand());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsShooting(pCompound.m_128471_("isShooting"));
        this.setSaddled(pCompound.m_128471_("Saddle"));
        this.setCommand(pCompound.m_128451_("HwachaCommand"));
    }

    @Override
    @javax.annotation.Nullable
    public Entity m_6688_() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player)) continue;
            return (Player)passenger;
        }
        return null;
    }

    public void m_7332_(Entity passenger) {
        float ySin = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float yCos = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        if (!this.m_21825_()) {
            passenger.m_6034_(this.m_20185_() + (double)(0.5f * ySin), this.m_20186_() + this.m_6048_() + passenger.m_6049_() + (double)0.4f, this.m_20189_() - (double)(0.5f * yCos));
            return;
        }
        passenger.m_6034_(this.m_20185_() + (double)(0.5f * ySin), this.m_20186_() + this.m_6048_() + passenger.m_6049_() - 1.0, this.m_20189_() - (double)(0.5f * yCos));
    }

    public double m_6048_() {
        if (this.m_20069_()) {
            return -0.5;
        }
        return 2.0;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.HWACHA_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.HWACHA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.HWACHA_DEATH.get();
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_21826_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return entityIn.m_7306_((Entity)this);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.FAIL;
        }
        if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_5634_(6.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6898_(itemstack) && !this.m_21824_()) {
            if (this.f_19796_.m_188499_()) {
                this.m_21828_(player);
            }
            itemstack.m_41774_(1);
            this.m_19998_((ItemLike)Items.f_42399_);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            boolean sit;
            if (this.m_6898_(itemstack)) {
                this.m_142075_(player, hand, itemstack);
                this.m_19998_((ItemLike)Items.f_42399_);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == Items.f_42450_ && !this.isSaddled()) {
                this.m_142075_(player, hand, itemstack);
                this.setSaddled(true);
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41720_() == Items.f_42574_ && this.isSaddled()) {
                this.setSaddled(false);
                this.m_19998_((ItemLike)Items.f_42450_);
                return InteractionResult.SUCCESS;
            }
            if (this.isHealingFood(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (!player.m_6144_() && !this.m_6162_() && this.isSaddled()) {
                if (!this.f_19853_.f_46443_) {
                    player.m_20329_((Entity)this);
                    player.m_213846_((Component)Component.m_237115_((String)"dinosaur.start_riding.attack_key").m_130940_(ChatFormatting.WHITE));
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.f_19853_.f_46443_) {
                this.setCommand(this.getCommand() + 1);
            }
            if (this.getCommand() >= 3 && !this.f_19853_.f_46443_) {
                this.setCommand(0);
            }
            player.m_5661_((Component)Component.m_237110_((String)("entity.unusualprehistory.all.command_" + this.getCommand()), (Object[])new Object[]{this.m_7755_()}), true);
            boolean bl = sit = this.getCommand() == 2;
            if (sit) {
                if (!this.f_19853_.f_46443_) {
                    this.m_21837_(true);
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.f_19853_.f_46443_) {
                this.m_21839_(false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_20329_(Entity pVehicle) {
        return super.m_20329_(pVehicle);
    }

    public boolean isHealingFood(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return item.m_41472_() && pStack.getFoodProperties((LivingEntity)this).m_38746_();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(UPTags.HWACHA_FOOD);
    }

    @Override
    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    @Override
    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
    }

    public boolean isShooting() {
        return (Boolean)this.f_19804_.m_135370_(SHOOTING);
    }

    public void setIsShooting(boolean shooting) {
        this.f_19804_.m_135381_(SHOOTING, (Object)shooting);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.soundTimer > 0) {
            --this.soundTimer;
        }
        if (this.isShooting() && this.shootProgress < 50.0f && !this.m_217005_()) {
            this.spit(this.m_5448_());
            this.m_21573_().m_26573_();
            this.shootProgress += 1.0f;
            return;
        }
        if (this.isShooting() && this.shootProgress < 50.0f && this.m_217005_()) {
            this.spitNoTarget();
            this.m_21573_().m_26573_();
            this.shootProgress += 1.0f;
            return;
        }
        if (this.m_21827_() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.m_21827_() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.getCommand() == 2 && !this.m_20160_()) {
            this.m_21839_(true);
        } else {
            this.m_21839_(false);
        }
        this.shootProgress = 0.0f;
        this.setIsShooting(false);
    }

    @Override
    public void performAttack() {
        this.setIsShooting(true);
    }

    @Override
    public void afterAttack() {
        this.setIsShooting(false);
        this.soundTimer = 0;
        ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(UPSounds.HWACHA_SHOOT.getId(), SoundSource.NEUTRAL);
        ServerPlayer serverPlayer = (ServerPlayer)this.m_6688_();
        serverPlayer.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
    }

    @Override
    public int getMaxAttackCooldown() {
        return 30;
    }

    @Override
    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    @Override
    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        this.m_21839_(false);
        if (entity != null && this.m_21824_() && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 3.0f;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7023_(Vec3 pos) {
        if (this.m_6084_()) {
            LivingEntity livingentity = (LivingEntity)this.m_6688_();
            if ((this.isShooting() || this.m_21825_()) && livingentity != null) {
                this.m_146922_(livingentity.m_146908_());
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(livingentity.m_146908_(), livingentity.m_146909_());
                this.f_20883_ = livingentity.m_146908_();
                this.f_20885_ = livingentity.f_20885_;
                return;
            }
            if (this.m_20160_() && livingentity != null) {
                double d0 = 0.08;
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.m_7910_(0.3f);
                super.m_7023_(new Vec3((double)f, pos.f_82480_, (double)f1));
                if (this.isShooting() && this.m_20160_()) {
                    this.m_7910_(0.0f);
                }
            } else {
                super.m_7023_(pos);
            }
        }
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_((SoundEvent)UPSounds.MAJUNGA_STEP.get(), 0.1f, 1.0f);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public void killed() {
        super.killed();
        this.setIsShooting(false);
        this.shootProgress = 0.0f;
    }

    public void spit(LivingEntity target) {
        if (target == null) {
            return;
        }
        this.m_21391_((Entity)target, 100.0f, 100.0f);
        for (int i = 0; i < 2 + this.f_19796_.m_188503_(2); ++i) {
            EntityHwachaSpike llamaspitentity = new EntityHwachaSpike(this.f_19853_, this);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20186_() - llamaspitentity.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2))) * 0.2f;
            llamaspitentity.shoot(d0, d1, d2, 2.0f, 4.0f);
            this.playShootSound();
            this.f_19853_.m_7967_((Entity)llamaspitentity);
        }
    }

    public void spitNoTarget() {
        int MAX_SHOTS = 2;
        int MIN_SHOTS = 2;
        int VIEW_VECTOR_SCALE = 15;
        int NO_SPIKE_ZONE_INFLATE = 2;
        int MESSAGE_TIMER_LIMIT = 6000;
        int MAX_DISTANCE = 320;
        boolean messageTimer = false;
        for (int i = 0; i < 2 + this.f_19796_.m_188503_(2); ++i) {
            try {
                if (this.f_19853_.f_46443_) {
                    return;
                }
                EntityHwachaSpike llamaspitentity = new EntityHwachaSpike(this.f_19853_, this);
                Player player = (Player)this.m_6688_();
                if (player == null) {
                    return;
                }
                BlockPos blockPlayerIsLookingAt = this.f_19853_.m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_(320.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
                Optional<Entity> entity = this.getEntityHitResult(320);
                BlockPos blockpos = blockPlayerIsLookingAt;
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                if (entity.isPresent()) {
                    Entity entity1 = entity.get();
                    BlockPos blockPosEntity = entity.get().m_20097_();
                    Vec3 eyePosition = entity1.m_146892_();
                    BlockPos blockPos = new BlockPos(eyePosition.f_82479_, eyePosition.f_82480_, eyePosition.f_82481_);
                    d0 = (double)blockPos.m_123341_() - this.m_20185_();
                    d1 = (double)blockPos.m_123342_() - this.m_20186_();
                    d2 = (double)blockPos.m_123343_() - this.m_20189_();
                }
                if (blockpos != null) {
                    AABB aabb = player.m_20191_().m_82400_(2.0);
                    if (aabb.m_82390_(Vec3.m_82512_((Vec3i)blockpos))) {
                        player.m_5661_((Component)Component.m_237115_((String)"hwachavenator.shooting_too_close.message").m_130940_(ChatFormatting.RED), true);
                        return;
                    }
                    d0 = (double)blockpos.m_123341_() - this.m_20185_();
                    d1 = (double)blockpos.m_123342_() - this.m_20186_();
                    d2 = (double)blockpos.m_123343_() - this.m_20189_();
                }
                if (d0 == 0.0 && d1 == 0.0 && d2 == 0.0 && !messageTimer) {
                    player.m_5661_((Component)Component.m_237115_((String)"hwachavenator.fail_shoot.message").m_130940_(ChatFormatting.RED), true);
                    return;
                }
                this.playShootSound();
                llamaspitentity.shoot(d0, d1, d2, 2.0f, 0.0f);
                this.f_19853_.m_7967_((Entity)llamaspitentity);
                continue;
            }
            catch (NullPointerException exception) {
                LOGGER.error("Something went wrong shooting a spike due to: {}", (Object)exception.getMessage());
            }
        }
    }

    private void playShootSound() {
        if (this.soundTimer <= 0) {
            this.m_5496_((SoundEvent)UPSounds.HWACHA_SHOOT.get(), this.m_6121_(), (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f);
            this.soundTimer = 80;
        }
    }

    protected Optional<Entity> getEntityHitResult(int range) {
        Vec3 vec3 = this.m_146892_();
        Vec3 vec31 = this.m_20252_(1.0f);
        Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * (double)range, vec31.f_82480_ * (double)range, vec31.f_82481_ * (double)range);
        float f = 1.0f;
        AABB aabb = this.m_20191_().m_82369_(vec31.m_82490_((double)range)).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)this, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, p_234237_ -> !p_234237_.m_5833_() && p_234237_.m_6087_(), (double)range);
        if (entityhitresult == null) {
            return Optional.empty();
        }
        return Optional.of(entityhitresult.m_82443_());
    }

    protected static BlockHitResult getEntityPOVHitResult(Level p_41436_, Entity p_41437_, ClipContext.Fluid p_41438_) {
        float f = p_41437_.m_146909_();
        float f1 = p_41437_.m_146908_();
        Vec3 vec3 = p_41437_.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = 35.0;
        Vec3 vec31 = vec3.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return p_41436_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, p_41438_, p_41437_));
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 5;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return true;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return UPTags.RAPTOR_TARGETS;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public void m_6504_(LivingEntity p_30762_, float p_30763_) {
        if (!this.m_217005_()) {
            this.setIsShooting(true);
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && !this.isShooting() && !this.m_21825_() && !this.m_20069_()) {
            if (this.m_20142_() || !this.m_20197_().isEmpty()) {
                event.getController().setAnimation(new AnimationBuilder().loop("animation.hwacha.sprinting"));
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().loop("animation.hwacha.walk"));
                event.getController().setAnimationSpeed(1.0);
                return PlayState.CONTINUE;
            }
        }
        if (this.isShooting() && !this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.hwacha.turret_firing"));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_() && !this.isShooting()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.hwacha.sitting"));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (this.m_20069_() && !this.isShooting() && !this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.hwacha.swim"));
            event.getController().setAnimationSpeed(1.0);
            return PlayState.CONTINUE;
        }
        if (!this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.hwacha.idle"));
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        data.addAnimationController(controller);
    }

    @Override
    public boolean shouldFollow() {
        return this.getCommand() == 1;
    }
}

