/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.google.common.collect.Lists;
import com.peeko32213.unusualprehistory.common.entity.msc.util.dino.EntityBaseDinosaurAnimal;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class EntityEryon
extends EntityBaseDinosaurAnimal
implements IAnimatable {
    private static final EntityDataAccessor<Optional<BlockPos>> FEEDING_POS = SynchedEntityData.m_135353_(EntityEryon.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> FEEDING_TIME = SynchedEntityData.m_135353_(EntityEryon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final ResourceLocation ERYON_REWARD = new ResourceLocation("unusualprehistory", "gameplay/eryon_reward");
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityEryon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private Ingredient temptationItems;
    public float prevFeedProgress;
    public float feedProgress;

    public EntityEryon(EntityType<? extends EntityBaseDinosaurAnimal> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(), false));
        this.f_21345_.m_25352_(5, (Goal)new DigSandGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.ERYON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.ERYON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.ERYON_DEATH.get();
    }

    public static String getVariantName(int variant) {
        if (variant == 1) {
            return "blue";
        }
        return "normal";
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
    }

    @Override
    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    @Override
    protected SoundEvent getAttackSound() {
        return null;
    }

    @Override
    protected int getKillHealAmount() {
        return 0;
    }

    @Override
    protected boolean canGetHungry() {
        return false;
    }

    @Override
    protected boolean hasTargets() {
        return false;
    }

    @Override
    protected boolean hasAvoidEntity() {
        return false;
    }

    @Override
    protected boolean hasCustomNavigation() {
        return false;
    }

    @Override
    protected boolean hasMakeStuckInBlock() {
        return false;
    }

    @Override
    protected boolean customMakeStuckInBlockCheck(BlockState blockState) {
        return false;
    }

    @Override
    protected TagKey<EntityType<?>> getTargetTag() {
        return null;
    }

    @Override
    public boolean m_6785_(double d) {
        return !this.m_8077_();
    }

    @Override
    public boolean m_8023_() {
        return super.m_8023_() || this.m_8077_();
    }

    @Override
    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28134_, DifficultyInstance p_28135_, MobSpawnType p_28136_, @javax.annotation.Nullable SpawnGroupData p_28137_, @javax.annotation.Nullable CompoundTag p_28138_) {
        p_28137_ = super.m_6518_(p_28134_, p_28135_, p_28136_, p_28137_, p_28138_);
        ServerLevel level = p_28134_.m_6018_();
        this.m_21530_();
        float variantChange = this.m_217043_().m_188501_();
        if ((double)variantChange <= 0.001) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        return p_28137_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return !stack.m_41619_() && this.getTemptationItems().test(stack);
    }

    private Ingredient getTemptationItems() {
        if (this.temptationItems == null) {
            this.temptationItems = Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_204132_((TagKey)ItemTags.f_13156_)}));
        }
        return this.temptationItems;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FEEDING_TIME, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FEEDING_POS, Optional.empty());
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getFeedingTime() {
        return (Integer)this.f_19804_.m_135370_(FEEDING_TIME);
    }

    public void setFeedingTime(int feedingTime) {
        this.f_19804_.m_135381_(FEEDING_TIME, (Object)feedingTime);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevFeedProgress = this.feedProgress;
        if (this.getFeedingTime() > 0 && this.feedProgress < 5.0f) {
            this.feedProgress += 1.0f;
        }
        if (this.getFeedingTime() <= 0 && this.feedProgress > 0.0f) {
            this.feedProgress -= 1.0f;
        }
    }

    private boolean canSeeBlock(BlockPos destinationBlock) {
        Vec3 Vector3d = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 blockVec = Vec3.m_82512_((Vec3i)destinationBlock);
        BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(Vector3d, blockVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return result.m_82425_().equals((Object)destinationBlock);
    }

    private static List<ItemStack> getDigLoot(EntityEryon crab) {
        LootTable loottable = crab.f_19853_.m_7654_().m_129898_().m_79217_(ERYON_REWARD);
        return loottable.m_230922_(new LootContext.Builder((ServerLevel)crab.f_19853_).m_78972_(LootContextParams.f_81455_, (Object)crab).m_230911_(crab.f_19853_.f_46441_).m_78975_(LootContextParamSets.f_81417_));
    }

    public boolean m_6040_() {
        return true;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_165925_() > 1.0E-6) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.eryon.walk"));
            event.getController().setAnimationSpeed(1.5);
        } else {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.eryon.idle"));
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState eatPredicate(AnimationEvent<E> event) {
        if (this.getFeedingTime() > 0) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.eryon.dig"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "eatController", 5.0f, this::eatPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    private class DigSandGoal
    extends Goal {
        private final int searchLength;
        private final int verticalSearchRange;
        protected BlockPos destinationBlock;
        private EntityEryon crab;
        private int runDelay = 70;
        private int maxFeedTime = 200;
        private final int MAX_TIME = 6000;
        private int timer = 0;
        private int cooldownTime;

        private DigSandGoal(EntityEryon crab) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.crab = crab;
            this.searchLength = 16;
            this.verticalSearchRange = 6;
        }

        public boolean m_8045_() {
            return this.destinationBlock != null && this.isDigBlock(this.crab.f_19853_, this.destinationBlock.m_122032_()) && this.isCloseToMoss(16.0) && this.timer <= 6000 && this.cooldownTime <= 0;
        }

        public boolean isCloseToMoss(double dist) {
            return this.destinationBlock == null || this.crab.m_20238_(Vec3.m_82512_((Vec3i)this.destinationBlock)) < dist * dist;
        }

        public boolean m_8036_() {
            if (--this.runDelay > 0 || --this.cooldownTime > 0) {
                return false;
            }
            this.runDelay = 200 + this.crab.f_19796_.m_188503_(150);
            return this.searchForDestination();
        }

        public void m_8056_() {
            this.maxFeedTime = 60 + EntityEryon.this.f_19796_.m_188503_(60);
        }

        public void m_8037_() {
            Vec3 vec;
            if (this.destinationBlock == null) {
                this.m_8041_();
            }
            if ((vec = Vec3.m_82512_((Vec3i)this.destinationBlock)) != null) {
                ++this.timer;
                double dist = this.crab.m_20183_().m_203198_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                if (dist > 2.0) {
                    this.crab.m_21573_().m_26519_(vec.f_82479_ - 0.5, vec.f_82480_ + 1.0, vec.f_82481_ - 0.5, 1.0);
                } else if (this.crab.m_20238_(vec) <= 2.0) {
                    this.crab.f_19804_.m_135381_(FEEDING_POS, Optional.of(this.destinationBlock));
                    Vec3 face = vec.m_82546_(this.crab.m_20182_());
                    this.crab.m_20256_(this.crab.m_20184_().m_82549_(face.m_82541_().m_82490_((double)0.1f)));
                    this.crab.setFeedingTime(this.crab.getFeedingTime() + 1);
                    this.crab.m_5496_(SoundEvents.f_12331_, this.crab.m_6121_(), this.crab.m_6100_());
                    if (this.crab.getFeedingTime() > this.maxFeedTime) {
                        List<ItemStack> lootList;
                        if (EntityEryon.this.f_19796_.m_188503_(1) == 0 && (lootList = EntityEryon.getDigLoot(this.crab)).size() > 0) {
                            for (ItemStack stack : lootList) {
                                ItemEntity e = this.crab.m_19983_(stack.m_41777_());
                                e.f_19812_ = true;
                                e.m_20256_(e.m_20184_().m_82542_(0.2, 0.2, 0.2));
                            }
                        }
                        this.m_8041_();
                    } else {
                        BlockPos feedingPos = ((Optional)this.crab.f_19804_.m_135370_(FEEDING_POS)).orElse(null);
                        double d0 = face.m_165924_();
                        this.crab.m_146926_((float)(-Mth.m_14136_((double)face.f_82480_, (double)d0) * 57.2957763671875));
                        this.crab.m_146922_((float)Mth.m_14136_((double)face.f_82481_, (double)face.f_82479_) * 57.295776f - 90.0f);
                        this.crab.f_20883_ = this.crab.m_146908_();
                        this.crab.f_20885_ = this.crab.m_146908_();
                        BlockState state = EntityEryon.this.f_19853_.m_8055_(feedingPos);
                        if (EntityEryon.this.f_19796_.m_188503_(2) == 0 && !state.m_60795_()) {
                            Vec3 mouth = new Vec3(0.0, (double)(this.crab.m_20206_() * 0.5f), (double)-0.2f).m_82496_(this.crab.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.crab.m_146908_() * ((float)Math.PI / 180));
                            for (int i = 0; i < 4 + EntityEryon.this.f_19796_.m_188503_(2); ++i) {
                                double motX = this.crab.f_19796_.m_188583_() * 0.02;
                                double motY = 0.1f + EntityEryon.this.f_19796_.m_188501_() * 0.2f;
                                double motZ = this.crab.f_19796_.m_188583_() * 0.02;
                                ((ServerLevel)EntityEryon.this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.crab.m_20185_() - mouth.f_82479_, this.crab.m_20186_() + mouth.f_82480_, this.crab.m_20189_() - mouth.f_82481_, 1, motX, motY, motZ, 0.1);
                            }
                        }
                    }
                } else {
                    this.crab.f_19804_.m_135381_(FEEDING_POS, Optional.empty());
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.crab.f_19804_.m_135381_(FEEDING_POS, Optional.empty());
            this.crab.setFeedingTime(0);
            this.cooldownTime = 3000;
        }

        protected boolean searchForDestination() {
            int lvt_1_1_ = this.searchLength;
            int lvt_2_1_ = this.verticalSearchRange;
            BlockPos lvt_3_1_ = this.crab.m_20183_();
            BlockPos.MutableBlockPos lvt_4_1_ = new BlockPos.MutableBlockPos();
            for (int lvt_5_1_ = -8; lvt_5_1_ <= 2; ++lvt_5_1_) {
                for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_1_1_; ++lvt_6_1_) {
                    int lvt_7_1_ = 0;
                    while (lvt_7_1_ <= lvt_6_1_) {
                        int lvt_8_1_;
                        int n = lvt_8_1_ = lvt_7_1_ < lvt_6_1_ && lvt_7_1_ > -lvt_6_1_ ? lvt_6_1_ : 0;
                        while (lvt_8_1_ <= lvt_6_1_) {
                            lvt_4_1_.m_122154_((Vec3i)lvt_3_1_, lvt_7_1_, lvt_5_1_ - 1, lvt_8_1_);
                            if (this.isDigBlock(this.crab.f_19853_, lvt_4_1_) && this.crab.canSeeBlock((BlockPos)lvt_4_1_)) {
                                this.destinationBlock = lvt_4_1_;
                                return true;
                            }
                            lvt_8_1_ = lvt_8_1_ > 0 ? -lvt_8_1_ : 1 - lvt_8_1_;
                        }
                        lvt_7_1_ = lvt_7_1_ > 0 ? -lvt_7_1_ : 1 - lvt_7_1_;
                    }
                }
            }
            return false;
        }

        private boolean isDigBlock(Level world, BlockPos.MutableBlockPos pos) {
            return world.m_8055_((BlockPos)pos).m_204336_(UPTags.ERYON_DIGGABLES);
        }
    }
}

