/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.entity;

import com.peeko32213.unusualprehistory.common.config.UnusualPrehistoryConfig;
import com.peeko32213.unusualprehistory.common.entity.IBookEntity;
import com.peeko32213.unusualprehistory.common.entity.msc.projectile.EntityAmberShot;
import com.peeko32213.unusualprehistory.common.entity.msc.util.CustomRandomStrollGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.ranged.AttackSound;
import com.peeko32213.unusualprehistory.common.entity.msc.util.ranged.CustomAbstractRangedAttack;
import com.peeko32213.unusualprehistory.common.entity.msc.util.ranged.CustomRangedAttackGoal;
import com.peeko32213.unusualprehistory.common.entity.msc.util.ranged.RangedMeleeMob;
import com.peeko32213.unusualprehistory.core.registry.UPSounds;
import com.peeko32213.unusualprehistory.core.registry.UPTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class EntityEncrusted
extends RangedMeleeMob
implements IAnimatable,
IBookEntity {
    private static final EntityDataAccessor<Boolean> SPITTING = SynchedEntityData.m_135353_(EntityEncrusted.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BOOK = SynchedEntityData.m_135353_(EntityEncrusted.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public EntityEncrusted(EntityType<? extends RangedMeleeMob> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 25.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new CustomRangedAttackGoal(this, new RangedAttack(this).setProjectileOriginOffset(0.8, 0.4, 0.8).setDamage(5.0f).setSound((SoundEvent)UPSounds.ENCRUSTED_SPIT.get(), 1.0f, 1.0f), 1.1));
        this.f_21345_.m_25352_(2, (Goal)new IMeleeAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new CustomRandomStrollGoal(this, 30, 1.0, 100, 34));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, false, false, entity -> entity.m_6095_().m_204039_(UPTags.ENCRUSTED_TARGETS)));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    public void setFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            this.m_5496_((SoundEvent)UPSounds.ENCRUSTED_MELEE.get(), 0.1f, 1.0f);
            return true;
        }
        return false;
    }

    public void killed(ServerLevel world, LivingEntity entity) {
        this.m_5634_(10.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UPSounds.ENCRUSTED_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)UPSounds.ENCRUSTED_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UPSounds.ENCRUSTED_DEATH.get();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_8077_();
    }

    public boolean m_6785_(double d) {
        return !this.m_8077_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28134_, DifficultyInstance p_28135_, MobSpawnType p_28136_, @Nullable SpawnGroupData p_28137_, @Nullable CompoundTag p_28138_) {
        p_28137_ = super.m_6518_(p_28134_, p_28135_, p_28136_, p_28137_, p_28138_);
        ServerLevel level = p_28134_.m_6018_();
        if (level instanceof ServerLevel) {
            this.m_21530_();
        }
        return p_28137_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BOOK, (Object)false);
    }

    public boolean isFromBook() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOOK);
    }

    public void setIsFromBook(boolean fromBook) {
        this.f_19804_.m_135381_(FROM_BOOK, (Object)fromBook);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.isFromBook()) {
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            if (this.m_5912_()) {
                event.getController().setAnimation(new AnimationBuilder().loop("animation.encrusted.sprint"));
                event.getController().setAnimationSpeed(1.0);
            } else {
                event.getController().setAnimation(new AnimationBuilder().loop("animation.encrusted.walk"));
                event.getController().setAnimationSpeed(1.0);
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.encrusted.idle"));
            event.getController().setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState predicate1(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 1 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.encrusted.attack"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState predicate2(AnimationEvent<E> event) {
        if (!((Integer)this.f_19804_.m_135370_(STATE) != 2 || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
            event.getController().setAnimation(new AnimationBuilder().loop("animation.encrusted.shoot"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        AnimationController controller1 = new AnimationController((IAnimatable)this, "controller1", 0.0f, this::predicate1);
        AnimationController controller2 = new AnimationController((IAnimatable)this, "controller2", 0.0f, this::predicate2);
        data.addAnimationController(controller);
        data.addAnimationController(controller1);
        data.addAnimationController(controller2);
    }

    public static boolean checkSurfaceDinoSpawnRules(EntityType<? extends EntityEncrusted> p_186238_, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource p_186242_) {
        return level.m_8055_(pos.m_7495_()).m_204336_(UPTags.DINO_NATURAL_SPAWNABLE) && (Boolean)UnusualPrehistoryConfig.DINO_NATURAL_SPAWNING.get() != false;
    }

    public static class RangedAttack
    extends CustomAbstractRangedAttack {
        public RangedAttack(RangedMeleeMob parentEntity, double xOffSetModifier, double entityHeightFraction, double zOffSetModifier, float damage) {
            super(parentEntity, xOffSetModifier, entityHeightFraction, zOffSetModifier, damage);
        }

        public RangedAttack(RangedMeleeMob parentEntity) {
            super(parentEntity);
        }

        @Override
        public AttackSound getDefaultAttackSound() {
            return new AttackSound((SoundEvent)UPSounds.ENCRUSTED_SPIT.get(), 1.0f, 1.0f);
        }

        @Override
        public Projectile getProjectile(Level world, double d2, double d3, double d4) {
            return new EntityAmberShot(world, (LivingEntity)this.parentEntity, d2, d3, d4, this.damage);
        }
    }

    class IMeleeAttackGoal
    extends MeleeAttackGoal {
        public IMeleeAttackGoal() {
            super((PathfinderMob)EntityEncrusted.this, 1.6, true);
        }

        protected double m_6639_(LivingEntity p_25556_) {
            return this.f_25540_.m_20205_() * 2.0f * this.f_25540_.m_20205_() * 0.9f + p_25556_.m_20205_();
        }
    }
}

