/*
 * Decompiled with CFR 0.152.
 */
package com.peeko32213.unusualprehistory.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;

public class ItemWeightedPairCodec {
    public static Codec<ItemWeightedPairCodec> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Registry.f_122827_.m_194605_().fieldOf("item").forGetter(i -> i.item), (App)Codec.INT.fieldOf("weight").forGetter(w -> w.weight), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(a -> a.amount)).apply((Applicative)inst, ItemWeightedPairCodec::new));
    private Item item;
    private int weight;
    private int amount;

    public ItemWeightedPairCodec(Item item, int weight, int amount) {
        this.item = item;
        this.weight = weight;
        this.amount = amount;
    }

    public int getWeight() {
        return this.weight;
    }

    public Item getItem() {
        return this.item;
    }

    public int getAmount() {
        return this.amount;
    }

    public static <T> Map<T, List<ItemWeightedPairCodec>> convertToMap(Map<T, List<ItemWeightedPairCodec>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(itemWeightedPairCodec -> new ItemWeightedPairCodec(itemWeightedPairCodec.getItem(), itemWeightedPairCodec.getWeight(), itemWeightedPairCodec.getAmount())).collect(Collectors.toList())));
    }

    public static <T> Map<T, List<ItemWeightedPairCodec>> convertFromMap(Map<T, List<ItemWeightedPairCodec>> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(itemWeightedPair -> new ItemWeightedPairCodec(itemWeightedPair.getItem(), itemWeightedPair.getWeight(), itemWeightedPair.getAmount())).collect(Collectors.toList())));
    }
}

